% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_addresses}
\alias{ec2_describe_addresses}
\title{Describes the specified Elastic IP addresses or all of your Elastic IP
addresses}
\usage{
ec2_describe_addresses(
  Filters = NULL,
  PublicIps = NULL,
  AllocationIds = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Filters}{One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{allocation-id} - [EC2-VPC] The allocation ID for the address.
\item \code{association-id} - [EC2-VPC] The association ID for the address.
\item \code{domain} - Indicates whether the address is for use in EC2-Classic
(\code{standard}) or in a VPC (\code{vpc}).
\item \code{instance-id} - The ID of the instance the address is associated
with, if any.
\item \code{network-border-group} - A unique set of Availability Zones, Local
Zones, or Wavelength Zones from where Amazon Web Services advertises
IP addresses.
\item \code{network-interface-id} - [EC2-VPC] The ID of the network interface
that the address is associated with, if any.
\item \code{network-interface-owner-id} - The Amazon Web Services account ID of
the owner.
\item \code{private-ip-address} - [EC2-VPC] The private IP address associated
with the Elastic IP address.
\item \code{public-ip} - The Elastic IP address, or the carrier IP address.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{PublicIps}{One or more Elastic IP addresses.

Default: Describes all your Elastic IP addresses.}

\item{AllocationIds}{[EC2-VPC] Information about the allocation IDs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified Elastic IP addresses or all of your Elastic IP addresses.

See \url{https://paws-r.github.io/docs/ec2/describe_addresses.html} for full documentation.
}
\keyword{internal}
