% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_network_interface_permission}
\alias{ec2_create_network_interface_permission}
\title{Grants an Amazon Web Services-authorized account permission to attach
the specified network interface to an instance in their account}
\usage{
ec2_create_network_interface_permission(
  NetworkInterfaceId,
  AwsAccountId = NULL,
  AwsService = NULL,
  Permission,
  DryRun = NULL
)
}
\arguments{
\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{AwsAccountId}{The Amazon Web Services account ID.}

\item{AwsService}{The Amazon Web Service. Currently not supported.}

\item{Permission}{[required] The type of permission to grant.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an instance in their account.

See \url{https://paws-r.github.io/docs/ec2/create_network_interface_permission.html} for full documentation.
}
\keyword{internal}
