% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_network_insights_path}
\alias{ec2_create_network_insights_path}
\title{Creates a path to analyze for reachability}
\usage{
ec2_create_network_insights_path(
  SourceIp = NULL,
  DestinationIp = NULL,
  Source,
  Destination,
  Protocol,
  DestinationPort = NULL,
  TagSpecifications = NULL,
  DryRun = NULL,
  ClientToken
)
}
\arguments{
\item{SourceIp}{The IP address of the Amazon Web Services resource that is the source of
the path.}

\item{DestinationIp}{The IP address of the Amazon Web Services resource that is the
destination of the path.}

\item{Source}{[required] The Amazon Web Services resource that is the source of the path.}

\item{Destination}{[required] The Amazon Web Services resource that is the destination of the path.}

\item{Protocol}{[required] The protocol.}

\item{DestinationPort}{The destination port.}

\item{TagSpecifications}{The tags to add to the path.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}
}
\description{
Creates a path to analyze for reachability.

See \url{https://paws-r.github.io/docs/ec2/create_network_insights_path.html} for full documentation.
}
\keyword{internal}
