% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_flow_logs}
\alias{ec2_create_flow_logs}
\title{Creates one or more flow logs to capture information about IP traffic
for a specific network interface, subnet, or VPC}
\usage{
ec2_create_flow_logs(
  DryRun = NULL,
  ClientToken = NULL,
  DeliverLogsPermissionArn = NULL,
  LogGroupName = NULL,
  ResourceIds,
  ResourceType,
  TrafficType = NULL,
  LogDestinationType = NULL,
  LogDestination = NULL,
  LogFormat = NULL,
  TagSpecifications = NULL,
  MaxAggregationInterval = NULL,
  DestinationOptions = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.}

\item{DeliverLogsPermissionArn}{The ARN for the IAM role that permits Amazon EC2 to publish flow logs to
a CloudWatch Logs log group in your account.

If you specify \code{LogDestinationType} as \code{s3}, do not specify
\code{DeliverLogsPermissionArn} or \code{LogGroupName}.}

\item{LogGroupName}{The name of a new or existing CloudWatch Logs log group where Amazon EC2
publishes your flow logs.

If you specify \code{LogDestinationType} as \code{s3}, do not specify
\code{DeliverLogsPermissionArn} or \code{LogGroupName}.}

\item{ResourceIds}{[required] The ID of the subnet, network interface, or VPC for which you want to
create a flow log.

Constraints: Maximum of 1000 resources}

\item{ResourceType}{[required] The type of resource for which to create the flow log. For example, if
you specified a VPC ID for the \code{ResourceId} property, specify \code{VPC} for
this property.}

\item{TrafficType}{The type of traffic to log. You can log traffic that the resource
accepts or rejects, or all traffic.}

\item{LogDestinationType}{The type of destination to which the flow log data is to be published.
Flow log data can be published to CloudWatch Logs or Amazon S3. To
publish flow log data to CloudWatch Logs, specify \code{cloud-watch-logs}. To
publish flow log data to Amazon S3, specify \code{s3}.

If you specify \code{LogDestinationType} as \code{s3}, do not specify
\code{DeliverLogsPermissionArn} or \code{LogGroupName}.

Default: \code{cloud-watch-logs}}

\item{LogDestination}{The destination to which the flow log data is to be published. Flow log
data can be published to a CloudWatch Logs log group or an Amazon S3
bucket. The value specified for this parameter depends on the value
specified for \code{LogDestinationType}.

If \code{LogDestinationType} is not specified or \code{cloud-watch-logs}, specify
the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For
example, to publish to a log group called \code{my-logs}, specify
\code{arn:aws:logs:us-east-1:123456789012:log-group:my-logs}. Alternatively,
use \code{LogGroupName} instead.

If LogDestinationType is \code{s3}, specify the ARN of the Amazon S3 bucket.
You can also specify a subfolder in the bucket. To specify a subfolder
in the bucket, use the following ARN format:
\verb{bucket_ARN/subfolder_name/}. For example, to specify a subfolder named
\code{my-logs} in a bucket named \code{my-bucket}, use the following ARN:
\verb{arn:aws:s3:::my-bucket/my-logs/}. You cannot use \code{AWSLogs} as a
subfolder name. This is a reserved term.}

\item{LogFormat}{The fields to include in the flow log record, in the order in which they
should appear. For a list of available fields, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records}{Flow log records}.
If you omit this parameter, the flow log is created using the default
format. If you specify this parameter, you must specify at least one
field.

Specify the fields using the \verb{$\{field-id\}} format, separated by spaces.
For the CLI, surround this parameter value with single quotes on Linux
or double quotes on Windows.}

\item{TagSpecifications}{The tags to apply to the flow logs.}

\item{MaxAggregationInterval}{The maximum interval of time during which a flow of packets is captured
and aggregated into a flow log record. You can specify 60 seconds (1
minute) or 600 seconds (10 minutes).

When a network interface is attached to a \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances}{Nitro-based instance},
the aggregation interval is always 60 seconds or less, regardless of the
value that you specify.

Default: 600}

\item{DestinationOptions}{The destination options.}
}
\description{
Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet, or VPC.

See \url{https://paws-r.github.io/docs/ec2/create_flow_logs.html} for full documentation.
}
\keyword{internal}
