% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_get_lambda_function_recommendations}
\alias{computeoptimizer_get_lambda_function_recommendations}
\title{Returns Lambda function recommendations}
\usage{
computeoptimizer_get_lambda_function_recommendations(
  functionArns = NULL,
  accountIds = NULL,
  filters = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{functionArns}{The Amazon Resource Name (ARN) of the functions for which to return
recommendations.

You can specify a qualified or unqualified ARN. If you specify an
unqualified ARN without a function version suffix, Compute Optimizer
will return recommendations for the latest (\verb{$LATEST}) version of the
function. If you specify a qualified ARN with a version suffix, Compute
Optimizer will return recommendations for the specified function
version. For more information about using function versions, see \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using}{Using versions}
in the \emph{Lambda Developer Guide}.}

\item{accountIds}{The ID of the Amazon Web Services account for which to return function
recommendations.

If your account is the management account of an organization, use this
parameter to specify the member account for which you want to return
function recommendations.

Only one account ID can be specified per request.}

\item{filters}{An array of objects to specify a filter that returns a more specific
list of function recommendations.}

\item{nextToken}{The token to advance to the next page of function recommendations.}

\item{maxResults}{The maximum number of function recommendations to return with a single
request.

To retrieve the remaining results, make another request with the
returned \code{nextToken} value.}
}
\description{
Returns Lambda function recommendations.

See \url{https://paws-r.github.io/docs/computeoptimizer/get_lambda_function_recommendations.html} for full documentation.
}
\keyword{internal}
