% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_create_configuration_template}
\alias{elasticbeanstalk_create_configuration_template}
\title{Creates an AWS Elastic Beanstalk configuration template, associated with
a specific Elastic Beanstalk application}
\usage{
elasticbeanstalk_create_configuration_template(ApplicationName,
  TemplateName, SolutionStackName, PlatformArn, SourceConfiguration,
  EnvironmentId, Description, OptionSettings, Tags)
}
\arguments{
\item{ApplicationName}{[required] The name of the Elastic Beanstalk application to associate with this
configuration template.}

\item{TemplateName}{[required] The name of the configuration template.

Constraint: This name must be unique per application.}

\item{SolutionStackName}{The name of an Elastic Beanstalk solution stack (platform version) that
this configuration uses. For example,
\verb{64bit Amazon Linux 2013.09 running Tomcat 7 Java 7}. A solution stack
specifies the operating system, runtime, and application server for a
configuration template. It also determines the set of configuration
options as well as the possible and default values. For more
information, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html}{Supported Platforms}
in the \emph{AWS Elastic Beanstalk Developer Guide}.

You must specify \code{SolutionStackName} if you don\'t specify
\code{PlatformArn}, \code{EnvironmentId}, or \code{SourceConfiguration}.

Use the
\href{https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html}{\code{ListAvailableSolutionStacks}}
API to obtain a list of available solution stacks.}

\item{PlatformArn}{The Amazon Resource Name (ARN) of the custom platform. For more
information, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html}{Custom Platforms}
in the \emph{AWS Elastic Beanstalk Developer Guide}.

If you specify \code{PlatformArn}, then don\'t specify \code{SolutionStackName}.}

\item{SourceConfiguration}{An Elastic Beanstalk configuration template to base this one on. If
specified, Elastic Beanstalk uses the configuration values from the
specified configuration template to create a new configuration.

Values specified in \code{OptionSettings} override any values obtained from
the \code{SourceConfiguration}.

You must specify \code{SourceConfiguration} if you don\'t specify
\code{PlatformArn}, \code{EnvironmentId}, or \code{SolutionStackName}.

Constraint: If both solution stack name and source configuration are
specified, the solution stack of the source configuration template must
match the specified solution stack name.}

\item{EnvironmentId}{The ID of an environment whose settings you want to use to create the
configuration template. You must specify \code{EnvironmentId} if you don\'t
specify \code{PlatformArn}, \code{SolutionStackName}, or \code{SourceConfiguration}.}

\item{Description}{An optional description for this configuration.}

\item{OptionSettings}{Option values for the Elastic Beanstalk configuration, such as the
instance type. If specified, these values override the values obtained
from the solution stack or the source configuration template. For a
complete list of Elastic Beanstalk configuration options, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html}{Option Values}
in the \emph{AWS Elastic Beanstalk Developer Guide}.}

\item{Tags}{Specifies the tags applied to the configuration template.}
}
\description{
Creates an AWS Elastic Beanstalk configuration template, associated with
a specific Elastic Beanstalk application. You define application
configuration settings in a configuration template. You can then use the
configuration template to deploy different versions of the application
with the same configuration settings.
}
\details{
Templates aren\'t associated with any environment. The \code{EnvironmentName}
response element is always \code{null}.

Related Topics
\itemize{
\item DescribeConfigurationOptions
\item DescribeConfigurationSettings
\item ListAvailableSolutionStacks
}
}
\section{Request syntax}{
\preformatted{svc$create_configuration_template(
  ApplicationName = "string",
  TemplateName = "string",
  SolutionStackName = "string",
  PlatformArn = "string",
  SourceConfiguration = list(
    ApplicationName = "string",
    TemplateName = "string"
  ),
  EnvironmentId = "string",
  Description = "string",
  OptionSettings = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string",
      Value = "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following operation creates a configuration template named my-app-v1
# from the settings applied to an environment with the id e-rpqsewtp2j:
svc$create_configuration_template(
  ApplicationName = "my-app",
  EnvironmentId = "e-rpqsewtp2j",
  TemplateName = "my-app-v1"
)
}

}
\keyword{internal}
