% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_register_job_definition}
\alias{batch_register_job_definition}
\title{Registers an AWS Batch job definition}
\usage{
batch_register_job_definition(jobDefinitionName, type, parameters,
  containerProperties, nodeProperties, retryStrategy, timeout)
}
\arguments{
\item{jobDefinitionName}{[required] The name of the job definition to register. Up to 128 letters (uppercase
and lowercase), numbers, hyphens, and underscores are allowed.}

\item{type}{[required] The type of job definition.}

\item{parameters}{Default parameter substitution placeholders to set in the job
definition. Parameters are specified as a key-value pair mapping.
Parameters in a \code{SubmitJob} request override any corresponding parameter
defaults from the job definition.}

\item{containerProperties}{An object with various properties specific to single-node
container-based jobs. If the job definition\'s \code{type} parameter is
\code{container}, then you must specify either \code{containerProperties} or
\code{nodeProperties}.}

\item{nodeProperties}{An object with various properties specific to multi-node parallel jobs.
If you specify node properties for a job, it becomes a multi-node
parallel job. For more information, see \href{https://docs.aws.amazon.com/batch/latest/userguide/multi-node-parallel-jobs.html}{Multi-node Parallel Jobs}
in the \emph{AWS Batch User Guide}. If the job definition\'s \code{type} parameter
is \code{container}, then you must specify either \code{containerProperties} or
\code{nodeProperties}.}

\item{retryStrategy}{The retry strategy to use for failed jobs that are submitted with this
job definition. Any retry strategy that is specified during a SubmitJob
operation overrides the retry strategy defined here. If a job is
terminated due to a timeout, it is not retried.}

\item{timeout}{The timeout configuration for jobs that are submitted with this job
definition, after which AWS Batch terminates your jobs if they have not
finished. If a job is terminated due to a timeout, it is not retried.
The minimum value for the timeout is 60 seconds. Any timeout
configuration that is specified during a SubmitJob operation overrides
the timeout configuration defined here. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html}{Job Timeouts}
in the \emph{Amazon Elastic Container Service Developer Guide}.}
}
\description{
Registers an AWS Batch job definition.
}
\section{Request syntax}{
\preformatted{svc$register_job_definition(
  jobDefinitionName = "string",
  type = "container"|"multinode",
  parameters = list(
    "string"
  ),
  containerProperties = list(
    image = "string",
    vcpus = 123,
    memory = 123,
    command = list(
      "string"
    ),
    jobRoleArn = "string",
    volumes = list(
      list(
        host = list(
          sourcePath = "string"
        ),
        name = "string"
      )
    ),
    environment = list(
      list(
        name = "string",
        value = "string"
      )
    ),
    mountPoints = list(
      list(
        containerPath = "string",
        readOnly = TRUE|FALSE,
        sourceVolume = "string"
      )
    ),
    readonlyRootFilesystem = TRUE|FALSE,
    privileged = TRUE|FALSE,
    ulimits = list(
      list(
        hardLimit = 123,
        name = "string",
        softLimit = 123
      )
    ),
    user = "string",
    instanceType = "string",
    resourceRequirements = list(
      list(
        value = "string",
        type = "GPU"
      )
    ),
    linuxParameters = list(
      devices = list(
        list(
          hostPath = "string",
          containerPath = "string",
          permissions = list(
            "READ"|"WRITE"|"MKNOD"
          )
        )
      )
    )
  ),
  nodeProperties = list(
    numNodes = 123,
    mainNode = 123,
    nodeRangeProperties = list(
      list(
        targetNodes = "string",
        container = list(
          image = "string",
          vcpus = 123,
          memory = 123,
          command = list(
            "string"
          ),
          jobRoleArn = "string",
          volumes = list(
            list(
              host = list(
                sourcePath = "string"
              ),
              name = "string"
            )
          ),
          environment = list(
            list(
              name = "string",
              value = "string"
            )
          ),
          mountPoints = list(
            list(
              containerPath = "string",
              readOnly = TRUE|FALSE,
              sourceVolume = "string"
            )
          ),
          readonlyRootFilesystem = TRUE|FALSE,
          privileged = TRUE|FALSE,
          ulimits = list(
            list(
              hardLimit = 123,
              name = "string",
              softLimit = 123
            )
          ),
          user = "string",
          instanceType = "string",
          resourceRequirements = list(
            list(
              value = "string",
              type = "GPU"
            )
          ),
          linuxParameters = list(
            devices = list(
              list(
                hostPath = "string",
                containerPath = "string",
                permissions = list(
                  "READ"|"WRITE"|"MKNOD"
                )
              )
            )
          )
        )
      )
    )
  ),
  retryStrategy = list(
    attempts = 123
  ),
  timeout = list(
    attemptDurationSeconds = 123
  )
)
}
}

\examples{
\dontrun{
# This example registers a job definition for a simple container job.
svc$register_job_definition(
  type = "container",
  containerProperties = list(
    command = list(
      "sleep",
      "10"
    ),
    image = "busybox",
    memory = 128L,
    vcpus = 1L
  ),
  jobDefinitionName = "sleep10"
)
}

}
\keyword{internal}
