% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_volume_status}
\alias{ec2_describe_volume_status}
\title{Describes the status of the specified volumes}
\usage{
ec2_describe_volume_status(Filters, MaxResults, NextToken, VolumeIds,
  DryRun)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{action.code} - The action code for the event (for example,
\code{enable-volume-io}).
\item \code{action.description} - A description of the action.
\item \code{action.event-id} - The event ID associated with the action.
\item \code{availability-zone} - The Availability Zone of the instance.
\item \code{event.description} - A description of the event.
\item \code{event.event-id} - The event ID.
\item \code{event.event-type} - The event type (for \code{io-enabled}: \code{passed} \\|
\code{failed}; for \code{io-performance}: \code{io-performance:degraded} \\|
\code{io-performance:severely-degraded} \\| \code{io-performance:stalled}).
\item \code{event.not-after} - The latest end time for the event.
\item \code{event.not-before} - The earliest start time for the event.
\item \code{volume-status.details-name} - The cause for \code{volume-status.status}
(\code{io-enabled} \\| \code{io-performance}).
\item \code{volume-status.details-status} - The status of
\code{volume-status.details-name} (for \code{io-enabled}: \code{passed} \\|
\code{failed}; for \code{io-performance}: \code{normal} \\| \code{degraded} \\|
\code{severely-degraded} \\| \code{stalled}).
\item \code{volume-status.status} - The status of the volume (\code{ok} \\|
\code{impaired} \\| \code{warning} \\| \code{insufficient-data}).
}}

\item{MaxResults}{The maximum number of volume results returned by \code{DescribeVolumeStatus}
in paginated output. When this parameter is used, the request only
returns \code{MaxResults} results in a single page along with a \code{NextToken}
response element. The remaining results of the initial request can be
seen by sending another request with the returned \code{NextToken} value.
This value can be between 5 and 1000; if \code{MaxResults} is given a value
larger than 1000, only 1000 results are returned. If this parameter is
not used, then \code{DescribeVolumeStatus} returns all results. You cannot
specify this parameter and the volume IDs parameter in the same request.}

\item{NextToken}{The \code{NextToken} value to include in a future \code{DescribeVolumeStatus}
request. When the results of the request exceed \code{MaxResults}, this value
can be used to retrieve the next page of results. This value is \code{null}
when there are no more results to return.}

\item{VolumeIds}{The IDs of the volumes.

Default: Describes all your volumes.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the status of the specified volumes. Volume status provides
the result of the checks performed on your volumes to determine events
that can impair the performance of your volumes. The performance of a
volume can be affected if an issue occurs on the volume\'s underlying
host. If the volume\'s underlying host experiences a power outage or
system issue, after the system is restored, there could be data
inconsistencies on the volume. Volume events notify you if this occurs.
Volume actions notify you if any action needs to be taken in response to
the event.
}
\details{
The \code{DescribeVolumeStatus} operation provides the following information
about the specified volumes:

\emph{Status}: Reflects the current status of the volume. The possible values
are \code{ok}, \code{impaired} , \code{warning}, or \code{insufficient-data}. If all checks
pass, the overall status of the volume is \code{ok}. If the check fails, the
overall status is \code{impaired}. If the status is \code{insufficient-data}, then
the checks may still be taking place on your volume at the time. We
recommend that you retry the request. For more information about volume
status, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html}{Monitoring the Status of Your Volumes}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

\emph{Events}: Reflect the cause of a volume status and may require you to
take action. For example, if your volume returns an \code{impaired} status,
then the volume event might be \code{potential-data-inconsistency}. This
means that your volume has been affected by an issue with the underlying
host, has all I/O operations disabled, and may have inconsistent data.

\emph{Actions}: Reflect the actions you may have to take in response to an
event. For example, if the status of the volume is \code{impaired} and the
volume event shows \code{potential-data-inconsistency}, then the action shows
\code{enable-volume-io}. This means that you may want to enable the I/O
operations for the volume by calling the EnableVolumeIO action and then
check the volume for data consistency.

Volume status is based on the volume status checks, and does not reflect
the volume state. Therefore, volume status does not indicate volumes in
the \code{error} state (for example, when a volume is incapable of accepting
I/O.)
}
\section{Request syntax}{
\preformatted{svc$describe_volume_status(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  VolumeIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example describes the status for the volume
# `vol-1234567890abcdef0`.
\dontrun{svc$describe_volume_status(
  VolumeIds = list(
    "vol-1234567890abcdef0"
  )
)}

# This example describes the status for all volumes that are impaired. In
# this example output, there are no impaired volumes.
\dontrun{svc$describe_volume_status(
  Filters = list(
    list(
      Name = "volume-status.status",
      Values = list(
        "impaired"
      )
    )
  )
)}

}
\keyword{internal}
