% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_compose_environments}
\alias{elasticbeanstalk_compose_environments}
\title{Create or update a group of environments that each run a separate
component of a single application}
\usage{
elasticbeanstalk_compose_environments(ApplicationName, GroupName,
  VersionLabels)
}
\arguments{
\item{ApplicationName}{The name of the application to which the specified source bundles
belong.}

\item{GroupName}{The name of the group to which the target environments belong. Specify a
group name only if the environment name defined in each target
environment\'s manifest ends with a + (plus) character. See \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html}{Environment Manifest (env.yaml)}
for details.}

\item{VersionLabels}{A list of version labels, specifying one or more application source
bundles that belong to the target application. Each source bundle must
include an environment manifest that specifies the name of the
environment and the name of the solution stack to use, and optionally
can specify environment links to create.}
}
\description{
Create or update a group of environments that each run a separate
component of a single application. Takes a list of version labels that
specify application source bundles for each of the environments to
create or update. The name of each environment and other required
information must be included in the source bundles in an environment
manifest named \code{env.yaml}. See \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html}{Compose Environments}
for details.
}
\section{Request syntax}{
\preformatted{svc$compose_environments(
  ApplicationName = "string",
  GroupName = "string",
  VersionLabels = list(
    "string"
  )
)
}
}

\keyword{internal}
