% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_reject_vpc_peering_connection}
\alias{ec2_reject_vpc_peering_connection}
\title{Rejects a VPC peering connection request}
\usage{
ec2_reject_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcPeeringConnectionId}{[required] The ID of the VPC peering connection.}
}
\description{
Rejects a VPC peering connection request. The VPC peering connection
must be in the \code{pending-acceptance} state. Use the
DescribeVpcPeeringConnections request to view your outstanding VPC
peering connection requests. To delete an active VPC peering connection,
or to delete a VPC peering connection request that you initiated, use
DeleteVpcPeeringConnection.
}
\section{Request syntax}{
\preformatted{svc$reject_vpc_peering_connection(
  DryRun = TRUE|FALSE,
  VpcPeeringConnectionId = "string"
)
}
}

\keyword{internal}
