% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_delete_service}
\alias{ecs_delete_service}
\title{Deletes a specified service within a cluster}
\usage{
ecs_delete_service(cluster, service, force)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service to delete. If you do not specify a cluster, the
default cluster is assumed.}

\item{service}{[required] The name of the service to delete.}

\item{force}{If \code{true}, allows you to delete a service even if it has not been scaled
down to zero tasks. It is only necessary to use this if the service is
using the \code{REPLICA} scheduling strategy.}
}
\value{
A list with the following syntax:\preformatted{list(
  service = list(
    serviceArn = "string",
    serviceName = "string",
    clusterArn = "string",
    loadBalancers = list(
      list(
        targetGroupArn = "string",
        loadBalancerName = "string",
        containerName = "string",
        containerPort = 123
      )
    ),
    serviceRegistries = list(
      list(
        registryArn = "string",
        port = 123,
        containerName = "string",
        containerPort = 123
      )
    ),
    status = "string",
    desiredCount = 123,
    runningCount = 123,
    pendingCount = 123,
    launchType = "EC2"|"FARGATE",
    capacityProviderStrategy = list(
      list(
        capacityProvider = "string",
        weight = 123,
        base = 123
      )
    ),
    platformVersion = "string",
    taskDefinition = "string",
    deploymentConfiguration = list(
      deploymentCircuitBreaker = list(
        enable = TRUE|FALSE,
        rollback = TRUE|FALSE
      ),
      maximumPercent = 123,
      minimumHealthyPercent = 123
    ),
    taskSets = list(
      list(
        id = "string",
        taskSetArn = "string",
        serviceArn = "string",
        clusterArn = "string",
        startedBy = "string",
        externalId = "string",
        status = "string",
        taskDefinition = "string",
        computedDesiredCount = 123,
        pendingCount = 123,
        runningCount = 123,
        createdAt = as.POSIXct(
          "2015-01-01"
        ),
        updatedAt = as.POSIXct(
          "2015-01-01"
        ),
        launchType = "EC2"|"FARGATE",
        capacityProviderStrategy = list(
          list(
            capacityProvider = "string",
            weight = 123,
            base = 123
          )
        ),
        platformVersion = "string",
        networkConfiguration = list(
          awsvpcConfiguration = list(
            subnets = list(
              "string"
            ),
            securityGroups = list(
              "string"
            ),
            assignPublicIp = "ENABLED"|"DISABLED"
          )
        ),
        loadBalancers = list(
          list(
            targetGroupArn = "string",
            loadBalancerName = "string",
            containerName = "string",
            containerPort = 123
          )
        ),
        serviceRegistries = list(
          list(
            registryArn = "string",
            port = 123,
            containerName = "string",
            containerPort = 123
          )
        ),
        scale = list(
          value = 123.0,
          unit = "PERCENT"
        ),
        stabilityStatus = "STEADY_STATE"|"STABILIZING",
        stabilityStatusAt = as.POSIXct(
          "2015-01-01"
        ),
        tags = list(
          list(
            key = "string",
            value = "string"
          )
        )
      )
    ),
    deployments = list(
      list(
        id = "string",
        status = "string",
        taskDefinition = "string",
        desiredCount = 123,
        pendingCount = 123,
        runningCount = 123,
        failedTasks = 123,
        createdAt = as.POSIXct(
          "2015-01-01"
        ),
        updatedAt = as.POSIXct(
          "2015-01-01"
        ),
        capacityProviderStrategy = list(
          list(
            capacityProvider = "string",
            weight = 123,
            base = 123
          )
        ),
        launchType = "EC2"|"FARGATE",
        platformVersion = "string",
        networkConfiguration = list(
          awsvpcConfiguration = list(
            subnets = list(
              "string"
            ),
            securityGroups = list(
              "string"
            ),
            assignPublicIp = "ENABLED"|"DISABLED"
          )
        ),
        rolloutState = "COMPLETED"|"FAILED"|"IN_PROGRESS",
        rolloutStateReason = "string"
      )
    ),
    roleArn = "string",
    events = list(
      list(
        id = "string",
        createdAt = as.POSIXct(
          "2015-01-01"
        ),
        message = "string"
      )
    ),
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    placementConstraints = list(
      list(
        type = "distinctInstance"|"memberOf",
        expression = "string"
      )
    ),
    placementStrategy = list(
      list(
        type = "random"|"spread"|"binpack",
        field = "string"
      )
    ),
    networkConfiguration = list(
      awsvpcConfiguration = list(
        subnets = list(
          "string"
        ),
        securityGroups = list(
          "string"
        ),
        assignPublicIp = "ENABLED"|"DISABLED"
      )
    ),
    healthCheckGracePeriodSeconds = 123,
    schedulingStrategy = "REPLICA"|"DAEMON",
    deploymentController = list(
      type = "ECS"|"CODE_DEPLOY"|"EXTERNAL"
    ),
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    createdBy = "string",
    enableECSManagedTags = TRUE|FALSE,
    propagateTags = "TASK_DEFINITION"|"SERVICE"
  )
)
}
}
\description{
Deletes a specified service within a cluster. You can delete a service
if you have no running tasks in it and the desired task count is zero.
If the service is actively maintaining tasks, you cannot delete it, and
you must update the service to a desired task count of zero. For more
information, see \code{\link[=ecs_update_service]{update_service}}.

When you delete a service, if there are still running tasks that require
cleanup, the service status moves from \code{ACTIVE} to \code{DRAINING}, and the
service is no longer visible in the console or in the
\code{\link[=ecs_list_services]{list_services}} API operation. After all tasks have
transitioned to either \code{STOPPING} or \code{STOPPED} status, the service
status moves from \code{DRAINING} to \code{INACTIVE}. Services in the \code{DRAINING}
or \code{INACTIVE} status can still be viewed with the
\code{\link[=ecs_describe_services]{describe_services}} API operation. However, in
the future, \code{INACTIVE} services may be cleaned up and purged from Amazon
ECS record keeping, and \code{\link[=ecs_describe_services]{describe_services}}
calls on those services return a \code{ServiceNotFoundException} error.

If you attempt to create a new service with the same name as an existing
service in either \code{ACTIVE} or \code{DRAINING} status, you receive an error.
}
\section{Request syntax}{
\preformatted{svc$delete_service(
  cluster = "string",
  service = "string",
  force = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example deletes the my-http-service service. The service must have
# a desired count and running count of 0 before you can delete it.
svc$delete_service(
  service = "my-http-service"
)
}

}
\keyword{internal}
