% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_client_vpn_target_networks}
\alias{ec2_describe_client_vpn_target_networks}
\title{Describes the target networks associated with the specified Client VPN
endpoint}
\usage{
ec2_describe_client_vpn_target_networks(ClientVpnEndpointId,
  AssociationIds, MaxResults, NextToken, Filters, DryRun)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint.}

\item{AssociationIds}{The IDs of the target network associations.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the nextToken value.}

\item{NextToken}{The token to retrieve the next page of results.}

\item{Filters}{One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{association-id} - The ID of the association.
\item \code{target-network-id} - The ID of the subnet specified as the target
network.
\item \code{vpc-id} - The ID of the VPC in which the target network is located.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClientVpnTargetNetworks = list(
    list(
      AssociationId = "string",
      VpcId = "string",
      TargetNetworkId = "string",
      ClientVpnEndpointId = "string",
      Status = list(
        Code = "associating"|"associated"|"association-failed"|"disassociating"|"disassociated",
        Message = "string"
      ),
      SecurityGroups = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the target networks associated with the specified Client VPN
endpoint.
}
\section{Request syntax}{
\preformatted{svc$describe_client_vpn_target_networks(
  ClientVpnEndpointId = "string",
  AssociationIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
