% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_transit_gateway_peering_attachment}
\alias{ec2_delete_transit_gateway_peering_attachment}
\title{Deletes a transit gateway peering attachment}
\usage{
ec2_delete_transit_gateway_peering_attachment(
  TransitGatewayAttachmentId, DryRun)
}
\arguments{
\item{TransitGatewayAttachmentId}{[required] The ID of the transit gateway peering attachment.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransitGatewayPeeringAttachment = list(
    TransitGatewayAttachmentId = "string",
    RequesterTgwInfo = list(
      TransitGatewayId = "string",
      OwnerId = "string",
      Region = "string"
    ),
    AccepterTgwInfo = list(
      TransitGatewayId = "string",
      OwnerId = "string",
      Region = "string"
    ),
    Status = list(
      Code = "string",
      Message = "string"
    ),
    State = "initiating"|"initiatingRequest"|"pendingAcceptance"|"rollingBack"|"pending"|"available"|"modifying"|"deleting"|"deleted"|"failed"|"rejected"|"rejecting"|"failing",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Deletes a transit gateway peering attachment.
}
\section{Request syntax}{
\preformatted{svc$delete_transit_gateway_peering_attachment(
  TransitGatewayAttachmentId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
