% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_get_lifecycle_policy_preview}
\alias{ecr_get_lifecycle_policy_preview}
\title{Retrieves the results of the lifecycle policy preview request for the
specified repository}
\usage{
ecr_get_lifecycle_policy_preview(registryId, repositoryName, imageIds,
  nextToken, maxResults, filter)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The name of the repository.}

\item{imageIds}{The list of imageIDs to be included.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated 
\code{GetLifecyclePolicyPreviewRequest} request where \code{maxResults} was used
and the  results exceeded the value of that parameter. Pagination
continues from the end of the  previous results that returned the
\code{nextToken} value. This value is  \code{null} when there are no more results
to return. This option cannot be used when you specify images with
\code{imageIds}.}

\item{maxResults}{The maximum number of repository results returned by
\code{GetLifecyclePolicyPreviewRequest} in  paginated output. When this
parameter is used, \code{GetLifecyclePolicyPreviewRequest} only returns 
\code{maxResults} results in a single page along with a \code{nextToken}  response
element. The remaining results of the initial request can be seen by
sending  another \code{GetLifecyclePolicyPreviewRequest} request with the
returned \code{nextToken}  value. This value can be between 1 and 1000. If
this  parameter is not used, then \code{GetLifecyclePolicyPreviewRequest}
returns up to  100 results and a \code{nextToken} value, if  applicable. This
option cannot be used when you specify images with \code{imageIds}.}

\item{filter}{An optional parameter that filters results based on image tag status and
all tags, if tagged.}
}
\value{
A list with the following syntax:\preformatted{list(
  registryId = "string",
  repositoryName = "string",
  lifecyclePolicyText = "string",
  status = "IN_PROGRESS"|"COMPLETE"|"EXPIRED"|"FAILED",
  nextToken = "string",
  previewResults = list(
    list(
      imageTags = list(
        "string"
      ),
      imageDigest = "string",
      imagePushedAt = as.POSIXct(
        "2015-01-01"
      ),
      action = list(
        type = "EXPIRE"
      ),
      appliedRulePriority = 123
    )
  ),
  summary = list(
    expiringImageTotalCount = 123
  )
)
}
}
\description{
Retrieves the results of the lifecycle policy preview request for the
specified repository.
}
\section{Request syntax}{
\preformatted{svc$get_lifecycle_policy_preview(
  registryId = "string",
  repositoryName = "string",
  imageIds = list(
    list(
      imageDigest = "string",
      imageTag = "string"
    )
  ),
  nextToken = "string",
  maxResults = 123,
  filter = list(
    tagStatus = "TAGGED"|"UNTAGGED"|"ANY"
  )
)
}
}

\keyword{internal}
