% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_start_relational_database}
\alias{lightsail_start_relational_database}
\title{Starts a specific database from a stopped state in Amazon Lightsail}
\usage{
lightsail_start_relational_database(relationalDatabaseName)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of your database to start.}
}
\description{
Starts a specific database from a stopped state in Amazon Lightsail. To
restart a database, use the \verb{reboot relational database} operation.

The \verb{start relational database} operation supports tag-based access
control via resource tags applied to the resource identified by
relationalDatabaseName. For more information, see the Lightsail Dev
Guide.
}
\section{Request syntax}{
\preformatted{svc$start_relational_database(
  relationalDatabaseName = "string"
)
}
}

\keyword{internal}
