% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service_parameter_helper.R
\name{set_service_parameter}
\alias{set_service_parameter}
\alias{config}
\alias{credentials}
\alias{creds}
\title{Set service parameters}
\usage{
config(
  credentials = list(creds = list(access_key_id = "", secret_access_key = "",
    session_token = "", access_token = ""), profile = "", anonymous = FALSE),
  endpoint = "",
  region = "",
  close_connection = FALSE,
  connect_timeout = 60,
  s3_force_path_style = FALSE,
  sts_regional_endpoint = ""
)

credentials(
  creds = list(access_key_id = "", secret_access_key = "", session_token = "",
    access_token = ""),
  profile = "",
  anonymous = FALSE
)

creds(
  access_key_id = "",
  secret_access_key = "",
  session_token = "",
  access_token = ""
)
}
\arguments{
\item{credentials}{\code{credentials()} or \code{list} is same format.
\itemize{
\item{\strong{creds}:} {\code{creds()} or \code{list} in same format.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{access_token}:} {The token issued by the \code{CreateToken} API call. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
in the \verb{IAM Identity Center OIDC API Reference Guide}.}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{The complete URL to use for the constructed client.}

\item{region}{The AWS Region used in instantiating the client.}

\item{close_connection}{Immediately close all HTTP connections.}

\item{connect_timeout}{The time in seconds till a timeout exception is thrown
when attempting to make a connection. The default is 60 seconds.}

\item{s3_force_path_style}{Set this to \code{true} to force the request to use path-style
addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}

\item{sts_regional_endpoint}{Set sts regional endpoint resolver to regional or
legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}

\item{creds}{\code{creds()} or \code{list} in same format.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{access_token}:} {The token issued by the \code{CreateToken} API call. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
in the \verb{IAM Identity Center OIDC API Reference Guide}.
}}}

\item{profile}{The name of a profile to use. If not given, then the default profile is used.}

\item{anonymous}{Set anonymous credentials.}

\item{access_key_id}{AWS access key ID}

\item{secret_access_key}{AWS secret access key}

\item{session_token}{AWS temporary session token}

\item{access_token}{The token issued by the \code{CreateToken} API call. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
in the \verb{IAM Identity Center OIDC API Reference Guide}.}
}
\value{
list set of parameter variables for paws services.
}
\description{
Help functions for setting the parameters for services
}
\examples{
# set service parameter access_key_id and secret_access_key

config(credentials(creds("dummy", "secret")))

# set service parameter access_key_id and secret_access_key using using lists
config(
    credentials = list(
        creds = list(
            access_key_id = "dummy",
            secret_access_key = "secret"
        )
    )
)

}
