context("Utilities")

test_that("is_empty", {
  expect_equal(is_empty(NULL), TRUE)
  expect_equal(is_empty(""), TRUE)
  expect_equal(is_empty(NA_character_), TRUE)
  expect_equal(is_empty(NA_integer_), TRUE)
  expect_equal(is_empty(NA_real_), TRUE)
  expect_equal(is_empty(character(0)), TRUE)
  expect_equal(is_empty(logical(0)), TRUE)
  expect_equal(is_empty(numeric(0)), TRUE)
  expect_equal(is_empty(raw(0)), TRUE)
  expect_equal(is_empty(list()), TRUE)
  expect_equal(is_empty(list(list())), TRUE)
  expect_equal(is_empty(list(list(list(),list()))), TRUE)

  expect_equal(is_empty("foo"), FALSE)
  expect_equal(is_empty(123), FALSE)
  expect_equal(is_empty(TRUE), FALSE)
  expect_equal(is_empty(FALSE), FALSE)
  expect_equal(is_empty(charToRaw("foo")), FALSE)
  expect_equal(is_empty(list(1)), FALSE)
  expect_equal(is_empty(list(list(list(),list(1)))), FALSE)
})
