% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_create_key}
\alias{locationservice_create_key}
\title{Creates an API key resource in your Amazon Web Services account, which
lets you grant actions for Amazon Location resources to the API key
bearer}
\usage{
locationservice_create_key(
  Description = NULL,
  ExpireTime = NULL,
  KeyName,
  NoExpiry = NULL,
  Restrictions,
  Tags = NULL
)
}
\arguments{
\item{Description}{An optional description for the API key resource.}

\item{ExpireTime}{The optional timestamp for when the API key resource will expire in \href{https://www.iso.org/iso-8601-date-and-time-format.html}{ISO 8601} format:
\code{YYYY-MM-DDThh:mm:ss.sssZ}. One of \code{NoExpiry} or \code{ExpireTime} must be
set.}

\item{KeyName}{[required] A custom name for the API key resource.

Requirements:
\itemize{
\item Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-),
periods (.), and underscores (_).
\item Must be a unique API key name.
\item No spaces allowed. For example, \code{ExampleAPIKey}.
}}

\item{NoExpiry}{Optionally set to \code{true} to set no expiration time for the API key. One
of \code{NoExpiry} or \code{ExpireTime} must be set.}

\item{Restrictions}{[required] The API key restrictions for the API key resource.}

\item{Tags}{Applies one or more tags to the map resource. A tag is a key-value pair
that helps manage, identify, search, and filter your resources by
labelling them.

Format: \code{"key" : "value"}

Restrictions:
\itemize{
\item Maximum 50 tags per resource
\item Each resource tag must be unique with a maximum of one value.
\item Maximum key length: 128 Unicode characters in UTF-8
\item Maximum value length: 256 Unicode characters in UTF-8
\item Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
characters: + - = . _ : / @.
\item Cannot use "aws:" as a prefix for a key.
}}
}
\description{
Creates an API key resource in your Amazon Web Services account, which lets you grant actions for Amazon Location resources to the API key bearer.

See \url{https://www.paws-r-sdk.com/docs/locationservice_create_key/} for full documentation.
}
\keyword{internal}
