% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_add_permission}
\alias{sns_add_permission}
\title{Adds a statement to a topic's access control policy, granting access for
the specified AWS accounts to the specified actions}
\usage{
sns_add_permission(TopicArn, Label, AWSAccountId, ActionName)
}
\arguments{
\item{TopicArn}{[required] The ARN of the topic whose access control policy you wish to modify.}

\item{Label}{[required] A unique identifier for the new policy statement.}

\item{AWSAccountId}{[required] The AWS account IDs of the users (principals) who will be given access
to the specified actions. The users must have AWS accounts, but do not
need to be signed up for this service.}

\item{ActionName}{[required] The action you want to allow for the specified principal(s).

Valid values: Any Amazon SNS action name, for example \code{Publish}.}
}
\description{
Adds a statement to a topic\'s access control policy, granting access
for the specified AWS accounts to the specified actions.
}
\section{Request syntax}{
\preformatted{svc$add_permission(
  TopicArn = "string",
  Label = "string",
  AWSAccountId = list(
    "string"
  ),
  ActionName = list(
    "string"
  )
)
}
}

\keyword{internal}
