% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_list_users}
\alias{mq_list_users}
\title{Returns a list of all ActiveMQ users}
\usage{
mq_list_users(BrokerId, MaxResults, NextToken)
}
\arguments{
\item{BrokerId}{[required] The unique ID that Amazon MQ generates for the broker.}

\item{MaxResults}{The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.}

\item{NextToken}{The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.}
}
\description{
Returns a list of all ActiveMQ users.
}
\section{Request syntax}{
\preformatted{svc$list_users(
  BrokerId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
