% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_delete_message_batch}
\alias{sqs_delete_message_batch}
\title{Deletes up to ten messages from the specified queue}
\usage{
sqs_delete_message_batch(QueueUrl, Entries)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue from which messages are deleted.

Queue URLs and names are case-sensitive.}

\item{Entries}{[required] A list of receipt handles for the messages to be deleted.}
}
\description{
Deletes up to ten messages from the specified queue. This is a batch
version of \verb{ <a>DeleteMessage</a>.} The result of the action on each
message is reported individually in the response.

Because the batch request can result in a combination of successful and
unsuccessful actions, you should check for batch errors even when the
call returns an HTTP status code of \code{200}.

Some actions take lists of parameters. These lists are specified using
the \code{param.n} notation. Values of \code{n} are integers starting from 1. For
example, a parameter list with two elements looks like this:

\verb{&amp;AttributeName.1=first}

\verb{&amp;AttributeName.2=second}
}
\section{Request syntax}{
\preformatted{svc$delete_message_batch(
  QueueUrl = "string",
  Entries = list(
    list(
      Id = "string",
      ReceiptHandle = "string"
    )
  )
)
}
}

\keyword{internal}
