% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_change_message_visibility}
\alias{sqs_change_message_visibility}
\title{Changes the visibility timeout of a specified message in a queue to a
new value}
\usage{
sqs_change_message_visibility(QueueUrl, ReceiptHandle,
  VisibilityTimeout)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue whose message's visibility is changed.

Queue URLs and names are case-sensitive.}

\item{ReceiptHandle}{[required] The receipt handle associated with the message whose visibility timeout
is changed. This parameter is returned by the \verb{<a>ReceiveMessage</a>}
action.}

\item{VisibilityTimeout}{[required] The new value for the message's visibility timeout (in seconds). Values
range: \code{0} to \code{43200}. Maximum: 12 hours.}
}
\description{
Changes the visibility timeout of a specified message in a queue to a
new value. The default visibility timeout for a message is 30 seconds.
The minimum is 0 seconds. The maximum is 12 hours. For more information,
see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html}{Visibility Timeout}
in the \emph{Amazon Simple Queue Service Developer Guide}.

For example, you have a message with a visibility timeout of 5 minutes.
After 3 minutes, you call \code{ChangeMessageVisibility} with a timeout of 10
minutes. You can continue to call \code{ChangeMessageVisibility} to extend
the visibility timeout to the maximum allowed time. If you try to extend
the visibility timeout beyond the maximum, your request is rejected.

An Amazon SQS message has three basic states:
\enumerate{
\item Sent to a queue by a producer.
\item Received from the queue by a consumer.
\item Deleted from the queue.
}

A message is considered to be \emph{stored} after it is sent to a queue by a
producer, but not yet received from the queue by a consumer (that is,
between states 1 and 2). There is no limit to the number of stored
messages. A message is considered to be \emph{in flight} after it is received
from a queue by a consumer, but not yet deleted from the queue (that is,
between states 2 and 3). There is a limit to the number of inflight
messages.

Limits that apply to inflight messages are unrelated to the \emph{unlimited}
number of stored messages.

For most standard queues (depending on queue traffic and message
backlog), there can be a maximum of approximately 120,000 inflight
messages (received from a queue by a consumer, but not yet deleted from
the queue). If you reach this limit, Amazon SQS returns the \code{OverLimit}
error message. To avoid reaching the limit, you should delete messages
from the queue after they're processed. You can also increase the number
of queues you use to process your messages. To request a limit increase,
file a support request.

For FIFO queues, there can be a maximum of 20,000 inflight messages
(received from a queue by a consumer, but not yet deleted from the
queue). If you reach this limit, Amazon SQS returns no error messages.

If you attempt to set the \code{VisibilityTimeout} to a value greater than
the maximum time left, Amazon SQS returns an error. Amazon SQS doesn't
automatically recalculate and increase the timeout to the maximum
remaining time.

Unlike with a queue, when you change the visibility timeout for a
specific message the timeout value is applied immediately but isn't
saved in memory for that message. If you don't delete a message after it
is received, the visibility timeout for the message reverts to the
original timeout value (not to the value you set using the
\code{ChangeMessageVisibility} action) the next time the message is received.
}
\section{Request syntax}{
\preformatted{svc$change_message_visibility(
  QueueUrl = "string",
  ReceiptHandle = "string",
  VisibilityTimeout = 123
)
}
}

\keyword{internal}
