% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_update_query_suggestions_block_list}
\alias{kendra_update_query_suggestions_block_list}
\title{Updates a block list used for query suggestions for an index}
\usage{
kendra_update_query_suggestions_block_list(
  IndexId,
  Id,
  Name = NULL,
  Description = NULL,
  SourceS3Path = NULL,
  RoleArn = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index for the block list.}

\item{Id}{[required] The identifier of the block list you want to update.}

\item{Name}{A new name for the block list.}

\item{Description}{A new description for the block list.}

\item{SourceS3Path}{The S3 path where your block list text file sits in S3.

If you update your block list and provide the same path to the block
list text file in S3, then Amazon Kendra reloads the file to refresh the
block list. Amazon Kendra does not automatically refresh your block
list. You need to call the
\code{\link[=kendra_update_query_suggestions_block_list]{update_query_suggestions_block_list}}
API to refresh you block list.

If you update your block list, then Amazon Kendra asynchronously
refreshes all query suggestions with the latest content in the S3 file.
This means changes might not take effect immediately.}

\item{RoleArn}{The IAM (Identity and Access Management) role used to access the block
list text file in S3.}
}
\description{
Updates a block list used for query suggestions for an index.

See \url{https://www.paws-r-sdk.com/docs/kendra_update_query_suggestions_block_list/} for full documentation.
}
\keyword{internal}
