% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_unfiltered_table_metadata}
\alias{glue_get_unfiltered_table_metadata}
\title{Retrieves table metadata from the Data Catalog that contains unfiltered
metadata}
\usage{
glue_get_unfiltered_table_metadata(
  CatalogId,
  DatabaseName,
  Name,
  AuditContext = NULL,
  SupportedPermissionTypes
)
}
\arguments{
\item{CatalogId}{[required] The catalog ID where the table resides.}

\item{DatabaseName}{[required] (Required) Specifies the name of a database that contains the table.}

\item{Name}{[required] (Required) Specifies the name of a table for which you are requesting
metadata.}

\item{AuditContext}{A structure containing Lake Formation audit context information.}

\item{SupportedPermissionTypes}{[required] (Required) A list of supported permission types.}
}
\description{
Retrieves table metadata from the Data Catalog that contains unfiltered metadata.

See \url{https://www.paws-r-sdk.com/docs/glue_get_unfiltered_table_metadata/} for full documentation.
}
\keyword{internal}
