# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticsearchservice_service.R
NULL

#' Allows the destination domain owner to accept an inbound cross-cluster
#' search connection request
#'
#' Allows the destination domain owner to accept an inbound cross-cluster
#' search connection request.
#'
#' @usage
#' elasticsearchservice_accept_inbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId)
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the inbound connection that you want to accept.
#'
#' @section Request syntax:
#' ```
#' svc$accept_inbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_accept_inbound_cross_cluster_search_connection
elasticsearchservice_accept_inbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "AcceptInboundCrossClusterSearchConnection",
    http_method = "PUT",
    http_path = "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/accept",
    paginator = list()
  )
  input <- .elasticsearchservice$accept_inbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$accept_inbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$accept_inbound_cross_cluster_search_connection <- elasticsearchservice_accept_inbound_cross_cluster_search_connection

#' Attaches tags to an existing Elasticsearch domain
#'
#' Attaches tags to an existing Elasticsearch domain. Tags are a set of
#' case-sensitive key value pairs. An Elasticsearch domain may have up to
#' 10 tags. See [Tagging Amazon Elasticsearch Service Domains for more
#' information.](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
#'
#' @usage
#' elasticsearchservice_add_tags(ARN, TagList)
#'
#' @param ARN &#91;required&#93; Specify the `ARN` for which you want to add the tags.
#' @param TagList &#91;required&#93; List of `Tag` that need to be added for the Elasticsearch domain.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   ARN = "string",
#'   TagList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_add_tags
elasticsearchservice_add_tags <- function(ARN, TagList) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/2015-01-01/tags",
    paginator = list()
  )
  input <- .elasticsearchservice$add_tags_input(ARN = ARN, TagList = TagList)
  output <- .elasticsearchservice$add_tags_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$add_tags <- elasticsearchservice_add_tags

#' Associates a package with an Amazon ES domain
#'
#' Associates a package with an Amazon ES domain.
#'
#' @usage
#' elasticsearchservice_associate_package(PackageID, DomainName)
#'
#' @param PackageID &#91;required&#93; Internal ID of the package that you want to associate with a domain. Use
#' `DescribePackages` to find this value.
#' @param DomainName &#91;required&#93; Name of the domain that you want to associate the package with.
#'
#' @section Request syntax:
#' ```
#' svc$associate_package(
#'   PackageID = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_associate_package
elasticsearchservice_associate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "AssociatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages/associate/{PackageID}/{DomainName}",
    paginator = list()
  )
  input <- .elasticsearchservice$associate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .elasticsearchservice$associate_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$associate_package <- elasticsearchservice_associate_package

#' Cancels a scheduled service software update for an Amazon ES domain
#'
#' Cancels a scheduled service software update for an Amazon ES domain. You
#' can only perform this operation before the `AutomatedUpdateDate` and
#' when the `UpdateStatus` is in the `PENDING_UPDATE` state.
#'
#' @usage
#' elasticsearchservice_cancel_elasticsearch_service_software_update(
#'   DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to stop the latest service software
#' update on.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_elasticsearch_service_software_update(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_cancel_elasticsearch_service_software_update
elasticsearchservice_cancel_elasticsearch_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "CancelElasticsearchServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2015-01-01/es/serviceSoftwareUpdate/cancel",
    paginator = list()
  )
  input <- .elasticsearchservice$cancel_elasticsearch_service_software_update_input(DomainName = DomainName)
  output <- .elasticsearchservice$cancel_elasticsearch_service_software_update_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$cancel_elasticsearch_service_software_update <- elasticsearchservice_cancel_elasticsearch_service_software_update

#' Creates a new Elasticsearch domain
#'
#' Creates a new Elasticsearch domain. For more information, see [Creating
#' Elasticsearch
#' Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
#' in the *Amazon Elasticsearch Service Developer Guide*.
#'
#' @usage
#' elasticsearchservice_create_elasticsearch_domain(DomainName,
#'   ElasticsearchVersion, ElasticsearchClusterConfig, EBSOptions,
#'   AccessPolicies, SnapshotOptions, VPCOptions, CognitoOptions,
#'   EncryptionAtRestOptions, NodeToNodeEncryptionOptions, AdvancedOptions,
#'   LogPublishingOptions, DomainEndpointOptions, AdvancedSecurityOptions)
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain that you are creating. Domain names
#' are unique across the domains owned by an account within an AWS region.
#' Domain names must start with a lowercase letter and can contain the
#' following characters: a-z (lowercase), 0-9, and - (hyphen).
#' @param ElasticsearchVersion String of format X.Y to specify version for the Elasticsearch domain eg.
#' \"1.5\" or \"2.3\". For more information, see [Creating Elasticsearch
#' Domains](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
#' in the *Amazon Elasticsearch Service Developer Guide*.
#' @param ElasticsearchClusterConfig Configuration options for an Elasticsearch domain. Specifies the
#' instance type and number of instances in the domain cluster.
#' @param EBSOptions Options to enable, disable and specify the type and size of EBS storage
#' volumes.
#' @param AccessPolicies IAM access policy as a JSON-formatted string.
#' @param SnapshotOptions Option to set time, in UTC format, of the daily automated snapshot.
#' Default value is 0 hours.
#' @param VPCOptions Options to specify the subnets and security groups for VPC endpoint. For
#' more information, see [Creating a
#' VPC](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc)
#' in *VPC Endpoints for Amazon Elasticsearch Service Domains*
#' @param CognitoOptions Options to specify the Cognito user and identity pools for Kibana
#' authentication. For more information, see [Amazon Cognito Authentication
#' for
#' Kibana](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
#' @param EncryptionAtRestOptions Specifies the Encryption At Rest Options.
#' @param NodeToNodeEncryptionOptions Specifies the NodeToNodeEncryptionOptions.
#' @param AdvancedOptions Option to allow references to indices in an HTTP request body. Must be
#' `false` when configuring access to individual sub-resources. By default,
#' the value is `true`. See [Configuration Advanced
#' Options](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
#' for more information.
#' @param LogPublishingOptions Map of `LogType` and `LogPublishingOption`, each containing options to
#' publish a given type of Elasticsearch log.
#' @param DomainEndpointOptions Options to specify configuration that will be applied to the domain
#' endpoint.
#' @param AdvancedSecurityOptions Specifies advanced security options.
#'
#' @section Request syntax:
#' ```
#' svc$create_elasticsearch_domain(
#'   DomainName = "string",
#'   ElasticsearchVersion = "string",
#'   ElasticsearchClusterConfig = list(
#'     InstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
#'     InstanceCount = 123,
#'     DedicatedMasterEnabled = TRUE|FALSE,
#'     ZoneAwarenessEnabled = TRUE|FALSE,
#'     ZoneAwarenessConfig = list(
#'       AvailabilityZoneCount = 123
#'     ),
#'     DedicatedMasterType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
#'     DedicatedMasterCount = 123,
#'     WarmEnabled = TRUE|FALSE,
#'     WarmType = "ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch",
#'     WarmCount = 123
#'   ),
#'   EBSOptions = list(
#'     EBSEnabled = TRUE|FALSE,
#'     VolumeType = "standard"|"gp2"|"io1",
#'     VolumeSize = 123,
#'     Iops = 123
#'   ),
#'   AccessPolicies = "string",
#'   SnapshotOptions = list(
#'     AutomatedSnapshotStartHour = 123
#'   ),
#'   VPCOptions = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   CognitoOptions = list(
#'     Enabled = TRUE|FALSE,
#'     UserPoolId = "string",
#'     IdentityPoolId = "string",
#'     RoleArn = "string"
#'   ),
#'   EncryptionAtRestOptions = list(
#'     Enabled = TRUE|FALSE,
#'     KmsKeyId = "string"
#'   ),
#'   NodeToNodeEncryptionOptions = list(
#'     Enabled = TRUE|FALSE
#'   ),
#'   AdvancedOptions = list(
#'     "string"
#'   ),
#'   LogPublishingOptions = list(
#'     list(
#'       CloudWatchLogsLogGroupArn = "string",
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   DomainEndpointOptions = list(
#'     EnforceHTTPS = TRUE|FALSE,
#'     TLSSecurityPolicy = "Policy-Min-TLS-1-0-2019-07"|"Policy-Min-TLS-1-2-2019-07"
#'   ),
#'   AdvancedSecurityOptions = list(
#'     Enabled = TRUE|FALSE,
#'     InternalUserDatabaseEnabled = TRUE|FALSE,
#'     MasterUserOptions = list(
#'       MasterUserARN = "string",
#'       MasterUserName = "string",
#'       MasterUserPassword = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_create_elasticsearch_domain
elasticsearchservice_create_elasticsearch_domain <- function(DomainName, ElasticsearchVersion = NULL, ElasticsearchClusterConfig = NULL, EBSOptions = NULL, AccessPolicies = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, EncryptionAtRestOptions = NULL, NodeToNodeEncryptionOptions = NULL, AdvancedOptions = NULL, LogPublishingOptions = NULL, DomainEndpointOptions = NULL, AdvancedSecurityOptions = NULL) {
  op <- new_operation(
    name = "CreateElasticsearchDomain",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain",
    paginator = list()
  )
  input <- .elasticsearchservice$create_elasticsearch_domain_input(DomainName = DomainName, ElasticsearchVersion = ElasticsearchVersion, ElasticsearchClusterConfig = ElasticsearchClusterConfig, EBSOptions = EBSOptions, AccessPolicies = AccessPolicies, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, AdvancedOptions = AdvancedOptions, LogPublishingOptions = LogPublishingOptions, DomainEndpointOptions = DomainEndpointOptions, AdvancedSecurityOptions = AdvancedSecurityOptions)
  output <- .elasticsearchservice$create_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_elasticsearch_domain <- elasticsearchservice_create_elasticsearch_domain

#' Creates a new cross-cluster search connection from a source domain to a
#' destination domain
#'
#' Creates a new cross-cluster search connection from a source domain to a
#' destination domain.
#'
#' @usage
#' elasticsearchservice_create_outbound_cross_cluster_search_connection(
#'   SourceDomainInfo, DestinationDomainInfo, ConnectionAlias)
#'
#' @param SourceDomainInfo &#91;required&#93; Specifies the `<a>DomainInformation</a>` for the source Elasticsearch
#' domain.
#' @param DestinationDomainInfo &#91;required&#93; Specifies the `<a>DomainInformation</a>` for the destination
#' Elasticsearch domain.
#' @param ConnectionAlias &#91;required&#93; Specifies the connection alias that will be used by the customer for
#' this connection.
#'
#' @section Request syntax:
#' ```
#' svc$create_outbound_cross_cluster_search_connection(
#'   SourceDomainInfo = list(
#'     OwnerId = "string",
#'     DomainName = "string",
#'     Region = "string"
#'   ),
#'   DestinationDomainInfo = list(
#'     OwnerId = "string",
#'     DomainName = "string",
#'     Region = "string"
#'   ),
#'   ConnectionAlias = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_create_outbound_cross_cluster_search_connection
elasticsearchservice_create_outbound_cross_cluster_search_connection <- function(SourceDomainInfo, DestinationDomainInfo, ConnectionAlias) {
  op <- new_operation(
    name = "CreateOutboundCrossClusterSearchConnection",
    http_method = "POST",
    http_path = "/2015-01-01/es/ccs/outboundConnection",
    paginator = list()
  )
  input <- .elasticsearchservice$create_outbound_cross_cluster_search_connection_input(SourceDomainInfo = SourceDomainInfo, DestinationDomainInfo = DestinationDomainInfo, ConnectionAlias = ConnectionAlias)
  output <- .elasticsearchservice$create_outbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_outbound_cross_cluster_search_connection <- elasticsearchservice_create_outbound_cross_cluster_search_connection

#' Create a package for use with Amazon ES domains
#'
#' Create a package for use with Amazon ES domains.
#'
#' @usage
#' elasticsearchservice_create_package(PackageName, PackageType,
#'   PackageDescription, PackageSource)
#'
#' @param PackageName &#91;required&#93; Unique identifier for the package.
#' @param PackageType &#91;required&#93; Type of package. Currently supports only TXT-DICTIONARY.
#' @param PackageDescription Description of the package.
#' @param PackageSource &#91;required&#93; The customer S3 location `PackageSource` for importing the package.
#'
#' @section Request syntax:
#' ```
#' svc$create_package(
#'   PackageName = "string",
#'   PackageType = "TXT-DICTIONARY",
#'   PackageDescription = "string",
#'   PackageSource = list(
#'     S3BucketName = "string",
#'     S3Key = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_create_package
elasticsearchservice_create_package <- function(PackageName, PackageType, PackageDescription = NULL, PackageSource) {
  op <- new_operation(
    name = "CreatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages",
    paginator = list()
  )
  input <- .elasticsearchservice$create_package_input(PackageName = PackageName, PackageType = PackageType, PackageDescription = PackageDescription, PackageSource = PackageSource)
  output <- .elasticsearchservice$create_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_package <- elasticsearchservice_create_package

#' Permanently deletes the specified Elasticsearch domain and all of its
#' data
#'
#' Permanently deletes the specified Elasticsearch domain and all of its
#' data. Once a domain is deleted, it cannot be recovered.
#'
#' @usage
#' elasticsearchservice_delete_elasticsearch_domain(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain that you want to permanently
#' delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_elasticsearch_domain(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_elasticsearch_domain
elasticsearchservice_delete_elasticsearch_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteElasticsearchDomain",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/domain/{DomainName}",
    paginator = list()
  )
  input <- .elasticsearchservice$delete_elasticsearch_domain_input(DomainName = DomainName)
  output <- .elasticsearchservice$delete_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_elasticsearch_domain <- elasticsearchservice_delete_elasticsearch_domain

#' Deletes the service-linked role that Elasticsearch Service uses to
#' manage and maintain VPC domains
#'
#' Deletes the service-linked role that Elasticsearch Service uses to
#' manage and maintain VPC domains. Role deletion will fail if any existing
#' VPC domains use the role. You must delete any such Elasticsearch domains
#' before deleting the role. See [Deleting Elasticsearch Service
#' Role](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr)
#' in *VPC Endpoints for Amazon Elasticsearch Service Domains*.
#'
#' @usage
#' elasticsearchservice_delete_elasticsearch_service_role()
#'

#'

#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_elasticsearch_service_role
elasticsearchservice_delete_elasticsearch_service_role <- function() {
  op <- new_operation(
    name = "DeleteElasticsearchServiceRole",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/role",
    paginator = list()
  )
  input <- .elasticsearchservice$delete_elasticsearch_service_role_input()
  output <- .elasticsearchservice$delete_elasticsearch_service_role_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_elasticsearch_service_role <- elasticsearchservice_delete_elasticsearch_service_role

#' Allows the destination domain owner to delete an existing inbound
#' cross-cluster search connection
#'
#' Allows the destination domain owner to delete an existing inbound
#' cross-cluster search connection.
#'
#' @usage
#' elasticsearchservice_delete_inbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId)
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the inbound connection that you want to permanently delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_inbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_inbound_cross_cluster_search_connection
elasticsearchservice_delete_inbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "DeleteInboundCrossClusterSearchConnection",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}",
    paginator = list()
  )
  input <- .elasticsearchservice$delete_inbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$delete_inbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_inbound_cross_cluster_search_connection <- elasticsearchservice_delete_inbound_cross_cluster_search_connection

#' Allows the source domain owner to delete an existing outbound
#' cross-cluster search connection
#'
#' Allows the source domain owner to delete an existing outbound
#' cross-cluster search connection.
#'
#' @usage
#' elasticsearchservice_delete_outbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId)
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the outbound connection that you want to permanently delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_outbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_outbound_cross_cluster_search_connection
elasticsearchservice_delete_outbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "DeleteOutboundCrossClusterSearchConnection",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/ccs/outboundConnection/{ConnectionId}",
    paginator = list()
  )
  input <- .elasticsearchservice$delete_outbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$delete_outbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_outbound_cross_cluster_search_connection <- elasticsearchservice_delete_outbound_cross_cluster_search_connection

#' Delete the package
#'
#' Delete the package.
#'
#' @usage
#' elasticsearchservice_delete_package(PackageID)
#'
#' @param PackageID &#91;required&#93; Internal ID of the package that you want to delete. Use
#' `DescribePackages` to find this value.
#'
#' @section Request syntax:
#' ```
#' svc$delete_package(
#'   PackageID = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_package
elasticsearchservice_delete_package <- function(PackageID) {
  op <- new_operation(
    name = "DeletePackage",
    http_method = "DELETE",
    http_path = "/2015-01-01/packages/{PackageID}",
    paginator = list()
  )
  input <- .elasticsearchservice$delete_package_input(PackageID = PackageID)
  output <- .elasticsearchservice$delete_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_package <- elasticsearchservice_delete_package

#' Returns domain configuration information about the specified
#' Elasticsearch domain, including the domain ID, domain endpoint, and
#' domain ARN
#'
#' Returns domain configuration information about the specified
#' Elasticsearch domain, including the domain ID, domain endpoint, and
#' domain ARN.
#'
#' @usage
#' elasticsearchservice_describe_elasticsearch_domain(DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain for which you want information.
#'
#' @section Request syntax:
#' ```
#' svc$describe_elasticsearch_domain(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_domain
elasticsearchservice_describe_elasticsearch_domain <- function(DomainName) {
  op <- new_operation(
    name = "DescribeElasticsearchDomain",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_elasticsearch_domain_input(DomainName = DomainName)
  output <- .elasticsearchservice$describe_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_domain <- elasticsearchservice_describe_elasticsearch_domain

#' Provides cluster configuration information about the specified
#' Elasticsearch domain, such as the state, creation date, update version,
#' and update date for cluster options
#'
#' Provides cluster configuration information about the specified
#' Elasticsearch domain, such as the state, creation date, update version,
#' and update date for cluster options.
#'
#' @usage
#' elasticsearchservice_describe_elasticsearch_domain_config(DomainName)
#'
#' @param DomainName &#91;required&#93; The Elasticsearch domain that you want to get information about.
#'
#' @section Request syntax:
#' ```
#' svc$describe_elasticsearch_domain_config(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_domain_config
elasticsearchservice_describe_elasticsearch_domain_config <- function(DomainName) {
  op <- new_operation(
    name = "DescribeElasticsearchDomainConfig",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}/config",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_elasticsearch_domain_config_input(DomainName = DomainName)
  output <- .elasticsearchservice$describe_elasticsearch_domain_config_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_domain_config <- elasticsearchservice_describe_elasticsearch_domain_config

#' Returns domain configuration information about the specified
#' Elasticsearch domains, including the domain ID, domain endpoint, and
#' domain ARN
#'
#' Returns domain configuration information about the specified
#' Elasticsearch domains, including the domain ID, domain endpoint, and
#' domain ARN.
#'
#' @usage
#' elasticsearchservice_describe_elasticsearch_domains(DomainNames)
#'
#' @param DomainNames &#91;required&#93; The Elasticsearch domains for which you want information.
#'
#' @section Request syntax:
#' ```
#' svc$describe_elasticsearch_domains(
#'   DomainNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_domains
elasticsearchservice_describe_elasticsearch_domains <- function(DomainNames) {
  op <- new_operation(
    name = "DescribeElasticsearchDomains",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain-info",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_elasticsearch_domains_input(DomainNames = DomainNames)
  output <- .elasticsearchservice$describe_elasticsearch_domains_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_domains <- elasticsearchservice_describe_elasticsearch_domains

#' Describe Elasticsearch Limits for a given InstanceType and
#' ElasticsearchVersion
#'
#' Describe Elasticsearch Limits for a given InstanceType and
#' ElasticsearchVersion. When modifying existing Domain, specify the
#' ` <a>DomainName</a> ` to know what Limits are supported for modifying.
#'
#' @usage
#' elasticsearchservice_describe_elasticsearch_instance_type_limits(
#'   DomainName, InstanceType, ElasticsearchVersion)
#'
#' @param DomainName DomainName represents the name of the Domain that we are trying to
#' modify. This should be present only if we are querying for Elasticsearch
#' ` <a>Limits</a> ` for existing domain.
#' @param InstanceType &#91;required&#93; The instance type for an Elasticsearch cluster for which Elasticsearch
#' ` <a>Limits</a> ` are needed.
#' @param ElasticsearchVersion &#91;required&#93; Version of Elasticsearch for which ` <a>Limits</a> ` are needed.
#'
#' @section Request syntax:
#' ```
#' svc$describe_elasticsearch_instance_type_limits(
#'   DomainName = "string",
#'   InstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
#'   ElasticsearchVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_instance_type_limits
elasticsearchservice_describe_elasticsearch_instance_type_limits <- function(DomainName = NULL, InstanceType, ElasticsearchVersion) {
  op <- new_operation(
    name = "DescribeElasticsearchInstanceTypeLimits",
    http_method = "GET",
    http_path = "/2015-01-01/es/instanceTypeLimits/{ElasticsearchVersion}/{InstanceType}",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_elasticsearch_instance_type_limits_input(DomainName = DomainName, InstanceType = InstanceType, ElasticsearchVersion = ElasticsearchVersion)
  output <- .elasticsearchservice$describe_elasticsearch_instance_type_limits_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_instance_type_limits <- elasticsearchservice_describe_elasticsearch_instance_type_limits

#' Lists all the inbound cross-cluster search connections for a destination
#' domain
#'
#' Lists all the inbound cross-cluster search connections for a destination
#' domain.
#'
#' @usage
#' elasticsearchservice_describe_inbound_cross_cluster_search_connections(
#'   Filters, MaxResults, NextToken)
#'
#' @param Filters A list of filters used to match properties for inbound cross-cluster
#' search connection. Available `<a>Filter</a>` names for this operation
#' are:
#' 
#' -   cross-cluster-search-connection-id
#' -   source-domain-info.domain-name
#' -   source-domain-info.owner-id
#' -   source-domain-info.region
#' -   destination-domain-info.domain-name
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken. It is used for pagination.
#'
#' @section Request syntax:
#' ```
#' svc$describe_inbound_cross_cluster_search_connections(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_inbound_cross_cluster_search_connections
elasticsearchservice_describe_inbound_cross_cluster_search_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInboundCrossClusterSearchConnections",
    http_method = "POST",
    http_path = "/2015-01-01/es/ccs/inboundConnection/search",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_inbound_cross_cluster_search_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_inbound_cross_cluster_search_connections_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_inbound_cross_cluster_search_connections <- elasticsearchservice_describe_inbound_cross_cluster_search_connections

#' Lists all the outbound cross-cluster search connections for a source
#' domain
#'
#' Lists all the outbound cross-cluster search connections for a source
#' domain.
#'
#' @usage
#' elasticsearchservice_describe_outbound_cross_cluster_search_connections(
#'   Filters, MaxResults, NextToken)
#'
#' @param Filters A list of filters used to match properties for outbound cross-cluster
#' search connection. Available `<a>Filter</a>` names for this operation
#' are:
#' 
#' -   cross-cluster-search-connection-id
#' -   destination-domain-info.domain-name
#' -   destination-domain-info.owner-id
#' -   destination-domain-info.region
#' -   source-domain-info.domain-name
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken. It is used for pagination.
#'
#' @section Request syntax:
#' ```
#' svc$describe_outbound_cross_cluster_search_connections(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_outbound_cross_cluster_search_connections
elasticsearchservice_describe_outbound_cross_cluster_search_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOutboundCrossClusterSearchConnections",
    http_method = "POST",
    http_path = "/2015-01-01/es/ccs/outboundConnection/search",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_outbound_cross_cluster_search_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_outbound_cross_cluster_search_connections_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_outbound_cross_cluster_search_connections <- elasticsearchservice_describe_outbound_cross_cluster_search_connections

#' Describes all packages available to Amazon ES
#'
#' Describes all packages available to Amazon ES. Includes options for
#' filtering, limiting the number of results, and pagination.
#'
#' @usage
#' elasticsearchservice_describe_packages(Filters, MaxResults, NextToken)
#'
#' @param Filters Only returns packages that match the `DescribePackagesFilterList`
#' values.
#' @param MaxResults Limits results to a maximum number of packages.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @section Request syntax:
#' ```
#' svc$describe_packages(
#'   Filters = list(
#'     list(
#'       Name = "PackageID"|"PackageName"|"PackageStatus",
#'       Value = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_packages
elasticsearchservice_describe_packages <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePackages",
    http_method = "POST",
    http_path = "/2015-01-01/packages/describe",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_packages_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_packages_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_packages <- elasticsearchservice_describe_packages

#' Lists available reserved Elasticsearch instance offerings
#'
#' Lists available reserved Elasticsearch instance offerings.
#'
#' @usage
#' elasticsearchservice_describe_reserved_elasticsearch_instance_offerings(
#'   ReservedElasticsearchInstanceOfferingId, MaxResults, NextToken)
#'
#' @param ReservedElasticsearchInstanceOfferingId The offering identifier filter value. Use this parameter to show only
#' the available offering that matches the specified reservation
#' identifier.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken should be sent in case if earlier API call produced result
#' containing NextToken. It is used for pagination.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_elasticsearch_instance_offerings(
#'   ReservedElasticsearchInstanceOfferingId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_reserved_elasticsearch_instance_offerings
elasticsearchservice_describe_reserved_elasticsearch_instance_offerings <- function(ReservedElasticsearchInstanceOfferingId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedElasticsearchInstanceOfferings",
    http_method = "GET",
    http_path = "/2015-01-01/es/reservedInstanceOfferings",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_reserved_elasticsearch_instance_offerings_input(ReservedElasticsearchInstanceOfferingId = ReservedElasticsearchInstanceOfferingId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_reserved_elasticsearch_instance_offerings_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_reserved_elasticsearch_instance_offerings <- elasticsearchservice_describe_reserved_elasticsearch_instance_offerings

#' Returns information about reserved Elasticsearch instances for this
#' account
#'
#' Returns information about reserved Elasticsearch instances for this
#' account.
#'
#' @usage
#' elasticsearchservice_describe_reserved_elasticsearch_instances(
#'   ReservedElasticsearchInstanceId, MaxResults, NextToken)
#'
#' @param ReservedElasticsearchInstanceId The reserved instance identifier filter value. Use this parameter to
#' show only the reservation that matches the specified reserved
#' Elasticsearch instance ID.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken should be sent in case if earlier API call produced result
#' containing NextToken. It is used for pagination.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_elasticsearch_instances(
#'   ReservedElasticsearchInstanceId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_reserved_elasticsearch_instances
elasticsearchservice_describe_reserved_elasticsearch_instances <- function(ReservedElasticsearchInstanceId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedElasticsearchInstances",
    http_method = "GET",
    http_path = "/2015-01-01/es/reservedInstances",
    paginator = list()
  )
  input <- .elasticsearchservice$describe_reserved_elasticsearch_instances_input(ReservedElasticsearchInstanceId = ReservedElasticsearchInstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_reserved_elasticsearch_instances_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_reserved_elasticsearch_instances <- elasticsearchservice_describe_reserved_elasticsearch_instances

#' Dissociates a package from the Amazon ES domain
#'
#' Dissociates a package from the Amazon ES domain.
#'
#' @usage
#' elasticsearchservice_dissociate_package(PackageID, DomainName)
#'
#' @param PackageID &#91;required&#93; Internal ID of the package that you want to associate with a domain. Use
#' `DescribePackages` to find this value.
#' @param DomainName &#91;required&#93; Name of the domain that you want to associate the package with.
#'
#' @section Request syntax:
#' ```
#' svc$dissociate_package(
#'   PackageID = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_dissociate_package
elasticsearchservice_dissociate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "DissociatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages/dissociate/{PackageID}/{DomainName}",
    paginator = list()
  )
  input <- .elasticsearchservice$dissociate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .elasticsearchservice$dissociate_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$dissociate_package <- elasticsearchservice_dissociate_package

#' Returns a list of upgrade compatible Elastisearch versions
#'
#' Returns a list of upgrade compatible Elastisearch versions. You can
#' optionally pass a ` <a>DomainName</a> ` to get all upgrade compatible
#' Elasticsearch versions for that specific domain.
#'
#' @usage
#' elasticsearchservice_get_compatible_elasticsearch_versions(DomainName)
#'
#' @param DomainName 
#'
#' @section Request syntax:
#' ```
#' svc$get_compatible_elasticsearch_versions(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_compatible_elasticsearch_versions
elasticsearchservice_get_compatible_elasticsearch_versions <- function(DomainName = NULL) {
  op <- new_operation(
    name = "GetCompatibleElasticsearchVersions",
    http_method = "GET",
    http_path = "/2015-01-01/es/compatibleVersions",
    paginator = list()
  )
  input <- .elasticsearchservice$get_compatible_elasticsearch_versions_input(DomainName = DomainName)
  output <- .elasticsearchservice$get_compatible_elasticsearch_versions_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_compatible_elasticsearch_versions <- elasticsearchservice_get_compatible_elasticsearch_versions

#' Retrieves the complete history of the last 10 upgrades that were
#' performed on the domain
#'
#' Retrieves the complete history of the last 10 upgrades that were
#' performed on the domain.
#'
#' @usage
#' elasticsearchservice_get_upgrade_history(DomainName, MaxResults,
#'   NextToken)
#'
#' @param DomainName &#91;required&#93; 
#' @param MaxResults 
#' @param NextToken 
#'
#' @section Request syntax:
#' ```
#' svc$get_upgrade_history(
#'   DomainName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_upgrade_history
elasticsearchservice_get_upgrade_history <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetUpgradeHistory",
    http_method = "GET",
    http_path = "/2015-01-01/es/upgradeDomain/{DomainName}/history",
    paginator = list()
  )
  input <- .elasticsearchservice$get_upgrade_history_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$get_upgrade_history_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_upgrade_history <- elasticsearchservice_get_upgrade_history

#' Retrieves the latest status of the last upgrade or upgrade eligibility
#' check that was performed on the domain
#'
#' Retrieves the latest status of the last upgrade or upgrade eligibility
#' check that was performed on the domain.
#'
#' @usage
#' elasticsearchservice_get_upgrade_status(DomainName)
#'
#' @param DomainName &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_upgrade_status(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_upgrade_status
elasticsearchservice_get_upgrade_status <- function(DomainName) {
  op <- new_operation(
    name = "GetUpgradeStatus",
    http_method = "GET",
    http_path = "/2015-01-01/es/upgradeDomain/{DomainName}/status",
    paginator = list()
  )
  input <- .elasticsearchservice$get_upgrade_status_input(DomainName = DomainName)
  output <- .elasticsearchservice$get_upgrade_status_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_upgrade_status <- elasticsearchservice_get_upgrade_status

#' Returns the name of all Elasticsearch domains owned by the current
#' user's account
#'
#' Returns the name of all Elasticsearch domains owned by the current
#' user\'s account.
#'
#' @usage
#' elasticsearchservice_list_domain_names()
#'

#'

#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_domain_names
elasticsearchservice_list_domain_names <- function() {
  op <- new_operation(
    name = "ListDomainNames",
    http_method = "GET",
    http_path = "/2015-01-01/domain",
    paginator = list()
  )
  input <- .elasticsearchservice$list_domain_names_input()
  output <- .elasticsearchservice$list_domain_names_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_domain_names <- elasticsearchservice_list_domain_names

#' Lists all Amazon ES domains associated with the package
#'
#' Lists all Amazon ES domains associated with the package.
#'
#' @usage
#' elasticsearchservice_list_domains_for_package(PackageID, MaxResults,
#'   NextToken)
#'
#' @param PackageID &#91;required&#93; The package for which to list domains.
#' @param MaxResults Limits results to a maximum number of domains.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @section Request syntax:
#' ```
#' svc$list_domains_for_package(
#'   PackageID = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_domains_for_package
elasticsearchservice_list_domains_for_package <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomainsForPackage",
    http_method = "GET",
    http_path = "/2015-01-01/packages/{PackageID}/domains",
    paginator = list()
  )
  input <- .elasticsearchservice$list_domains_for_package_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_domains_for_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_domains_for_package <- elasticsearchservice_list_domains_for_package

#' List all Elasticsearch instance types that are supported for given
#' ElasticsearchVersion
#'
#' List all Elasticsearch instance types that are supported for given
#' ElasticsearchVersion
#'
#' @usage
#' elasticsearchservice_list_elasticsearch_instance_types(
#'   ElasticsearchVersion, DomainName, MaxResults, NextToken)
#'
#' @param ElasticsearchVersion &#91;required&#93; Version of Elasticsearch for which list of supported elasticsearch
#' instance types are needed.
#' @param DomainName DomainName represents the name of the Domain that we are trying to
#' modify. This should be present only if we are querying for list of
#' available Elasticsearch instance types when modifying existing domain.
#' @param MaxResults Set this value to limit the number of results returned. Value provided
#' must be greater than 30 else it wont be honored.
#' @param NextToken NextToken should be sent in case if earlier API call produced result
#' containing NextToken. It is used for pagination.
#'
#' @section Request syntax:
#' ```
#' svc$list_elasticsearch_instance_types(
#'   ElasticsearchVersion = "string",
#'   DomainName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_elasticsearch_instance_types
elasticsearchservice_list_elasticsearch_instance_types <- function(ElasticsearchVersion, DomainName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListElasticsearchInstanceTypes",
    http_method = "GET",
    http_path = "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
    paginator = list()
  )
  input <- .elasticsearchservice$list_elasticsearch_instance_types_input(ElasticsearchVersion = ElasticsearchVersion, DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_elasticsearch_instance_types_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_elasticsearch_instance_types <- elasticsearchservice_list_elasticsearch_instance_types

#' List all supported Elasticsearch versions
#'
#' List all supported Elasticsearch versions
#'
#' @usage
#' elasticsearchservice_list_elasticsearch_versions(MaxResults, NextToken)
#'
#' @param MaxResults Set this value to limit the number of results returned. Value provided
#' must be greater than 10 else it wont be honored.
#' @param NextToken 
#'
#' @section Request syntax:
#' ```
#' svc$list_elasticsearch_versions(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_elasticsearch_versions
elasticsearchservice_list_elasticsearch_versions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListElasticsearchVersions",
    http_method = "GET",
    http_path = "/2015-01-01/es/versions",
    paginator = list()
  )
  input <- .elasticsearchservice$list_elasticsearch_versions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_elasticsearch_versions_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_elasticsearch_versions <- elasticsearchservice_list_elasticsearch_versions

#' Lists all packages associated with the Amazon ES domain
#'
#' Lists all packages associated with the Amazon ES domain.
#'
#' @usage
#' elasticsearchservice_list_packages_for_domain(DomainName, MaxResults,
#'   NextToken)
#'
#' @param DomainName &#91;required&#93; The name of the domain for which you want to list associated packages.
#' @param MaxResults Limits results to a maximum number of packages.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @section Request syntax:
#' ```
#' svc$list_packages_for_domain(
#'   DomainName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_packages_for_domain
elasticsearchservice_list_packages_for_domain <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPackagesForDomain",
    http_method = "GET",
    http_path = "/2015-01-01/domain/{DomainName}/packages",
    paginator = list()
  )
  input <- .elasticsearchservice$list_packages_for_domain_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_packages_for_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_packages_for_domain <- elasticsearchservice_list_packages_for_domain

#' Returns all tags for the given Elasticsearch domain
#'
#' Returns all tags for the given Elasticsearch domain.
#'
#' @usage
#' elasticsearchservice_list_tags(ARN)
#'
#' @param ARN &#91;required&#93; Specify the `ARN` for the Elasticsearch domain to which the tags are
#' attached that you want to view.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_tags
elasticsearchservice_list_tags <- function(ARN) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/2015-01-01/tags/",
    paginator = list()
  )
  input <- .elasticsearchservice$list_tags_input(ARN = ARN)
  output <- .elasticsearchservice$list_tags_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_tags <- elasticsearchservice_list_tags

#' Allows you to purchase reserved Elasticsearch instances
#'
#' Allows you to purchase reserved Elasticsearch instances.
#'
#' @usage
#' elasticsearchservice_purchase_reserved_elasticsearch_instance_offering(
#'   ReservedElasticsearchInstanceOfferingId, ReservationName, InstanceCount)
#'
#' @param ReservedElasticsearchInstanceOfferingId &#91;required&#93; The ID of the reserved Elasticsearch instance offering to purchase.
#' @param ReservationName &#91;required&#93; A customer-specified identifier to track this reservation.
#' @param InstanceCount The number of Elasticsearch instances to reserve.
#'
#' @section Request syntax:
#' ```
#' svc$purchase_reserved_elasticsearch_instance_offering(
#'   ReservedElasticsearchInstanceOfferingId = "string",
#'   ReservationName = "string",
#'   InstanceCount = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_purchase_reserved_elasticsearch_instance_offering
elasticsearchservice_purchase_reserved_elasticsearch_instance_offering <- function(ReservedElasticsearchInstanceOfferingId, ReservationName, InstanceCount = NULL) {
  op <- new_operation(
    name = "PurchaseReservedElasticsearchInstanceOffering",
    http_method = "POST",
    http_path = "/2015-01-01/es/purchaseReservedInstanceOffering",
    paginator = list()
  )
  input <- .elasticsearchservice$purchase_reserved_elasticsearch_instance_offering_input(ReservedElasticsearchInstanceOfferingId = ReservedElasticsearchInstanceOfferingId, ReservationName = ReservationName, InstanceCount = InstanceCount)
  output <- .elasticsearchservice$purchase_reserved_elasticsearch_instance_offering_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$purchase_reserved_elasticsearch_instance_offering <- elasticsearchservice_purchase_reserved_elasticsearch_instance_offering

#' Allows the destination domain owner to reject an inbound cross-cluster
#' search connection request
#'
#' Allows the destination domain owner to reject an inbound cross-cluster
#' search connection request.
#'
#' @usage
#' elasticsearchservice_reject_inbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId)
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the inbound connection that you want to reject.
#'
#' @section Request syntax:
#' ```
#' svc$reject_inbound_cross_cluster_search_connection(
#'   CrossClusterSearchConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_reject_inbound_cross_cluster_search_connection
elasticsearchservice_reject_inbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "RejectInboundCrossClusterSearchConnection",
    http_method = "PUT",
    http_path = "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/reject",
    paginator = list()
  )
  input <- .elasticsearchservice$reject_inbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$reject_inbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$reject_inbound_cross_cluster_search_connection <- elasticsearchservice_reject_inbound_cross_cluster_search_connection

#' Removes the specified set of tags from the specified Elasticsearch
#' domain
#'
#' Removes the specified set of tags from the specified Elasticsearch
#' domain.
#'
#' @usage
#' elasticsearchservice_remove_tags(ARN, TagKeys)
#'
#' @param ARN &#91;required&#93; Specifies the `ARN` for the Elasticsearch domain from which you want to
#' delete the specified tags.
#' @param TagKeys &#91;required&#93; Specifies the `TagKey` list which you want to remove from the
#' Elasticsearch domain.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags(
#'   ARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_remove_tags
elasticsearchservice_remove_tags <- function(ARN, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/2015-01-01/tags-removal",
    paginator = list()
  )
  input <- .elasticsearchservice$remove_tags_input(ARN = ARN, TagKeys = TagKeys)
  output <- .elasticsearchservice$remove_tags_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$remove_tags <- elasticsearchservice_remove_tags

#' Schedules a service software update for an Amazon ES domain
#'
#' Schedules a service software update for an Amazon ES domain.
#'
#' @usage
#' elasticsearchservice_start_elasticsearch_service_software_update(
#'   DomainName)
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update to the latest service
#' software.
#'
#' @section Request syntax:
#' ```
#' svc$start_elasticsearch_service_software_update(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_start_elasticsearch_service_software_update
elasticsearchservice_start_elasticsearch_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "StartElasticsearchServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2015-01-01/es/serviceSoftwareUpdate/start",
    paginator = list()
  )
  input <- .elasticsearchservice$start_elasticsearch_service_software_update_input(DomainName = DomainName)
  output <- .elasticsearchservice$start_elasticsearch_service_software_update_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$start_elasticsearch_service_software_update <- elasticsearchservice_start_elasticsearch_service_software_update

#' Modifies the cluster configuration of the specified Elasticsearch
#' domain, setting as setting the instance type and the number of instances
#'
#' Modifies the cluster configuration of the specified Elasticsearch
#' domain, setting as setting the instance type and the number of
#' instances.
#'
#' @usage
#' elasticsearchservice_update_elasticsearch_domain_config(DomainName,
#'   ElasticsearchClusterConfig, EBSOptions, SnapshotOptions, VPCOptions,
#'   CognitoOptions, AdvancedOptions, AccessPolicies, LogPublishingOptions,
#'   DomainEndpointOptions, AdvancedSecurityOptions)
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain that you are updating.
#' @param ElasticsearchClusterConfig The type and number of instances to instantiate for the domain cluster.
#' @param EBSOptions Specify the type and size of the EBS volume that you want to use.
#' @param SnapshotOptions Option to set the time, in UTC format, for the daily automated snapshot.
#' Default value is `0` hours.
#' @param VPCOptions Options to specify the subnets and security groups for VPC endpoint. For
#' more information, see [Creating a
#' VPC](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc)
#' in *VPC Endpoints for Amazon Elasticsearch Service Domains*
#' @param CognitoOptions Options to specify the Cognito user and identity pools for Kibana
#' authentication. For more information, see [Amazon Cognito Authentication
#' for
#' Kibana](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
#' @param AdvancedOptions Modifies the advanced option to allow references to indices in an HTTP
#' request body. Must be `false` when configuring access to individual
#' sub-resources. By default, the value is `true`. See [Configuration
#' Advanced
#' Options](http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
#' for more information.
#' @param AccessPolicies IAM access policy as a JSON-formatted string.
#' @param LogPublishingOptions Map of `LogType` and `LogPublishingOption`, each containing options to
#' publish a given type of Elasticsearch log.
#' @param DomainEndpointOptions Options to specify configuration that will be applied to the domain
#' endpoint.
#' @param AdvancedSecurityOptions Specifies advanced security options.
#'
#' @section Request syntax:
#' ```
#' svc$update_elasticsearch_domain_config(
#'   DomainName = "string",
#'   ElasticsearchClusterConfig = list(
#'     InstanceType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
#'     InstanceCount = 123,
#'     DedicatedMasterEnabled = TRUE|FALSE,
#'     ZoneAwarenessEnabled = TRUE|FALSE,
#'     ZoneAwarenessConfig = list(
#'       AvailabilityZoneCount = 123
#'     ),
#'     DedicatedMasterType = "m3.medium.elasticsearch"|"m3.large.elasticsearch"|"m3.xlarge.elasticsearch"|"m3.2xlarge.elasticsearch"|"m4.large.elasticsearch"|"m4.xlarge.elasticsearch"|"m4.2xlarge.elasticsearch"|"m4.4xlarge.elasticsearch"|"m4.10xlarge.elasticsearch"|"m5.large.elasticsearch"|"m5.xlarge.elasticsearch"|"m5.2xlarge.elasticsearch"|"m5.4xlarge.elasticsearch"|"m5.12xlarge.elasticsearch"|"r5.large.elasticsearch"|"r5.xlarge.elasticsearch"|"r5.2xlarge.elasticsearch"|"r5.4xlarge.elasticsearch"|"r5.12xlarge.elasticsearch"|"c5.large.elasticsearch"|"c5.xlarge.elasticsearch"|"c5.2xlarge.elasticsearch"|"c5.4xlarge.elasticsearch"|"c5.9xlarge.elasticsearch"|"c5.18xlarge.elasticsearch"|"ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch"|"t2.micro.elasticsearch"|"t2.small.elasticsearch"|"t2.medium.elasticsearch"|"r3.large.elasticsearch"|"r3.xlarge.elasticsearch"|"r3.2xlarge.elasticsearch"|"r3.4xlarge.elasticsearch"|"r3.8xlarge.elasticsearch"|"i2.xlarge.elasticsearch"|"i2.2xlarge.elasticsearch"|"d2.xlarge.elasticsearch"|"d2.2xlarge.elasticsearch"|"d2.4xlarge.elasticsearch"|"d2.8xlarge.elasticsearch"|"c4.large.elasticsearch"|"c4.xlarge.elasticsearch"|"c4.2xlarge.elasticsearch"|"c4.4xlarge.elasticsearch"|"c4.8xlarge.elasticsearch"|"r4.large.elasticsearch"|"r4.xlarge.elasticsearch"|"r4.2xlarge.elasticsearch"|"r4.4xlarge.elasticsearch"|"r4.8xlarge.elasticsearch"|"r4.16xlarge.elasticsearch"|"i3.large.elasticsearch"|"i3.xlarge.elasticsearch"|"i3.2xlarge.elasticsearch"|"i3.4xlarge.elasticsearch"|"i3.8xlarge.elasticsearch"|"i3.16xlarge.elasticsearch",
#'     DedicatedMasterCount = 123,
#'     WarmEnabled = TRUE|FALSE,
#'     WarmType = "ultrawarm1.medium.elasticsearch"|"ultrawarm1.large.elasticsearch",
#'     WarmCount = 123
#'   ),
#'   EBSOptions = list(
#'     EBSEnabled = TRUE|FALSE,
#'     VolumeType = "standard"|"gp2"|"io1",
#'     VolumeSize = 123,
#'     Iops = 123
#'   ),
#'   SnapshotOptions = list(
#'     AutomatedSnapshotStartHour = 123
#'   ),
#'   VPCOptions = list(
#'     SubnetIds = list(
#'       "string"
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     )
#'   ),
#'   CognitoOptions = list(
#'     Enabled = TRUE|FALSE,
#'     UserPoolId = "string",
#'     IdentityPoolId = "string",
#'     RoleArn = "string"
#'   ),
#'   AdvancedOptions = list(
#'     "string"
#'   ),
#'   AccessPolicies = "string",
#'   LogPublishingOptions = list(
#'     list(
#'       CloudWatchLogsLogGroupArn = "string",
#'       Enabled = TRUE|FALSE
#'     )
#'   ),
#'   DomainEndpointOptions = list(
#'     EnforceHTTPS = TRUE|FALSE,
#'     TLSSecurityPolicy = "Policy-Min-TLS-1-0-2019-07"|"Policy-Min-TLS-1-2-2019-07"
#'   ),
#'   AdvancedSecurityOptions = list(
#'     Enabled = TRUE|FALSE,
#'     InternalUserDatabaseEnabled = TRUE|FALSE,
#'     MasterUserOptions = list(
#'       MasterUserARN = "string",
#'       MasterUserName = "string",
#'       MasterUserPassword = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_update_elasticsearch_domain_config
elasticsearchservice_update_elasticsearch_domain_config <- function(DomainName, ElasticsearchClusterConfig = NULL, EBSOptions = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, AdvancedOptions = NULL, AccessPolicies = NULL, LogPublishingOptions = NULL, DomainEndpointOptions = NULL, AdvancedSecurityOptions = NULL) {
  op <- new_operation(
    name = "UpdateElasticsearchDomainConfig",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain/{DomainName}/config",
    paginator = list()
  )
  input <- .elasticsearchservice$update_elasticsearch_domain_config_input(DomainName = DomainName, ElasticsearchClusterConfig = ElasticsearchClusterConfig, EBSOptions = EBSOptions, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, AdvancedOptions = AdvancedOptions, AccessPolicies = AccessPolicies, LogPublishingOptions = LogPublishingOptions, DomainEndpointOptions = DomainEndpointOptions, AdvancedSecurityOptions = AdvancedSecurityOptions)
  output <- .elasticsearchservice$update_elasticsearch_domain_config_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$update_elasticsearch_domain_config <- elasticsearchservice_update_elasticsearch_domain_config

#' Allows you to either upgrade your domain or perform an Upgrade
#' eligibility check to a compatible Elasticsearch version
#'
#' Allows you to either upgrade your domain or perform an Upgrade
#' eligibility check to a compatible Elasticsearch version.
#'
#' @usage
#' elasticsearchservice_upgrade_elasticsearch_domain(DomainName,
#'   TargetVersion, PerformCheckOnly)
#'
#' @param DomainName &#91;required&#93; 
#' @param TargetVersion &#91;required&#93; The version of Elasticsearch that you intend to upgrade the domain to.
#' @param PerformCheckOnly This flag, when set to True, indicates that an Upgrade Eligibility Check
#' needs to be performed. This will not actually perform the Upgrade.
#'
#' @section Request syntax:
#' ```
#' svc$upgrade_elasticsearch_domain(
#'   DomainName = "string",
#'   TargetVersion = "string",
#'   PerformCheckOnly = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_upgrade_elasticsearch_domain
elasticsearchservice_upgrade_elasticsearch_domain <- function(DomainName, TargetVersion, PerformCheckOnly = NULL) {
  op <- new_operation(
    name = "UpgradeElasticsearchDomain",
    http_method = "POST",
    http_path = "/2015-01-01/es/upgradeDomain",
    paginator = list()
  )
  input <- .elasticsearchservice$upgrade_elasticsearch_domain_input(DomainName = DomainName, TargetVersion = TargetVersion, PerformCheckOnly = PerformCheckOnly)
  output <- .elasticsearchservice$upgrade_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$upgrade_elasticsearch_domain <- elasticsearchservice_upgrade_elasticsearch_domain
