% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_template_alias}
\alias{quicksight_update_template_alias}
\title{Updates the template alias of a template}
\usage{
quicksight_update_template_alias(AwsAccountId, TemplateId, AliasName,
  TemplateVersionNumber)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the template alias that you\'re
updating.}

\item{TemplateId}{[required] The ID for the template.}

\item{AliasName}{[required] The alias of the template that you want to update. If you name a
specific alias, you update the version that the alias points to. You can
specify the latest version of the template by providing the keyword
\verb{$LATEST} in the \code{AliasName} parameter. The keyword \verb{$PUBLISHED}
doesn\'t apply to templates.}

\item{TemplateVersionNumber}{[required] The version number of the template.}
}
\description{
Updates the template alias of a template.
}
\section{Request syntax}{
\preformatted{svc$update_template_alias(
  AwsAccountId = "string",
  TemplateId = "string",
  AliasName = "string",
  TemplateVersionNumber = 123
)
}
}

\keyword{internal}
