% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_create_data_catalog}
\alias{athena_create_data_catalog}
\title{Creates (registers) a data catalog with the specified name and
properties}
\usage{
athena_create_data_catalog(Name, Type, Description, Parameters, Tags)
}
\arguments{
\item{Name}{[required] The name of the data catalog to create. The catalog name must be unique
for the AWS account and can use a maximum of 128 alphanumeric,
underscore, at sign, or hyphen characters.}

\item{Type}{[required] The type of data catalog to create: \code{LAMBDA} for a federated catalog,
\code{GLUE} for AWS Glue Catalog, or \code{HIVE} for an external hive metastore.}

\item{Description}{A description of the data catalog to be created.}

\item{Parameters}{Specifies the Lambda function or functions to use for creating the data
catalog. This is a mapping whose values depend on the catalog type.
\itemize{
\item For the \code{HIVE} data catalog type, use the following syntax. The
\verb{metadata-function} parameter is required. \verb{The sdk-version}
parameter is optional and defaults to the currently supported
version.

\verb{metadata-function=lambda_arn, sdk-version=version_number }
\item For the \code{LAMBDA} data catalog type, use one of the following sets of
required parameters, but not both.
\itemize{
\item If you have one Lambda function that processes metadata and
another for reading the actual data, use the following syntax.
Both parameters are required.

\verb{metadata-function=lambda_arn, record-function=lambda_arn }
\item If you have a composite Lambda function that processes both
metadata and data, use the following syntax to specify your
Lambda function.

\verb{function=lambda_arn }
}
\item The \code{GLUE} type has no parameters.
}}

\item{Tags}{A list of comma separated tags to add to the data catalog that is
created.}
}
\value{
An empty list.
}
\description{
Creates (registers) a data catalog with the specified name and
properties. Catalogs created are visible to all users of the same AWS
account.
}
\section{Request syntax}{
\preformatted{svc$create_data_catalog(
  Name = "string",
  Type = "LAMBDA"|"GLUE"|"HIVE",
  Description = "string",
  Parameters = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
