# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include glue_service.R
NULL

#' Creates one or more partitions in a batch operation
#'
#' @description
#' Creates one or more partitions in a batch operation.
#'
#' @usage
#' glue_batch_create_partition(CatalogId, DatabaseName, TableName,
#'   PartitionInputList)
#'
#' @param CatalogId The ID of the catalog in which the partition is to be created.
#' Currently, this should be the AWS account ID.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' created.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be created.
#' @param PartitionInputList &#91;required&#93; A list of `PartitionInput` structures that define the partitions to be
#' created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       PartitionValues = list(
#'         "string"
#'       ),
#'       ErrorDetail = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_create_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionInputList = list(
#'     list(
#'       Values = list(
#'         "string"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE,
#'         SchemaReference = list(
#'           SchemaId = list(
#'             SchemaArn = "string",
#'             SchemaName = "string",
#'             RegistryName = "string"
#'           ),
#'           SchemaVersionId = "string",
#'           SchemaVersionNumber = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_create_partition
glue_batch_create_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionInputList) {
  op <- new_operation(
    name = "BatchCreatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_create_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionInputList = PartitionInputList)
  output <- .glue$batch_create_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_create_partition <- glue_batch_create_partition

#' Deletes a list of connection definitions from the Data Catalog
#'
#' @description
#' Deletes a list of connection definitions from the Data Catalog.
#'
#' @usage
#' glue_batch_delete_connection(CatalogId, ConnectionNameList)
#'
#' @param CatalogId The ID of the Data Catalog in which the connections reside. If none is
#' provided, the AWS account ID is used by default.
#' @param ConnectionNameList &#91;required&#93; A list of names of the connections to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Succeeded = list(
#'     "string"
#'   ),
#'   Errors = list(
#'     list(
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_connection(
#'   CatalogId = "string",
#'   ConnectionNameList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_connection
glue_batch_delete_connection <- function(CatalogId = NULL, ConnectionNameList) {
  op <- new_operation(
    name = "BatchDeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_connection_input(CatalogId = CatalogId, ConnectionNameList = ConnectionNameList)
  output <- .glue$batch_delete_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_connection <- glue_batch_delete_connection

#' Deletes one or more partitions in a batch operation
#'
#' @description
#' Deletes one or more partitions in a batch operation.
#'
#' @usage
#' glue_batch_delete_partition(CatalogId, DatabaseName, TableName,
#'   PartitionsToDelete)
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be deleted resides. If
#' none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table that contains the partitions to be deleted.
#' @param PartitionsToDelete &#91;required&#93; A list of `PartitionInput` structures that define the partitions to be
#' deleted.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       PartitionValues = list(
#'         "string"
#'       ),
#'       ErrorDetail = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionsToDelete = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_partition
glue_batch_delete_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionsToDelete) {
  op <- new_operation(
    name = "BatchDeletePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionsToDelete = PartitionsToDelete)
  output <- .glue$batch_delete_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_partition <- glue_batch_delete_partition

#' Deletes multiple tables at once
#'
#' @description
#' Deletes multiple tables at once.
#' 
#' After completing this operation, you no longer have access to the table
#' versions and partitions that belong to the deleted table. AWS Glue
#' deletes these "orphaned" resources asynchronously in a timely manner, at
#' the discretion of the service.
#' 
#' To ensure the immediate deletion of all related resources, before
#' calling [`batch_delete_table`][glue_batch_delete_table], use
#' [`delete_table_version`][glue_delete_table_version] or
#' [`batch_delete_table_version`][glue_batch_delete_table_version], and
#' [`delete_partition`][glue_delete_partition] or
#' [`batch_delete_partition`][glue_batch_delete_partition], to delete any
#' resources that belong to the table.
#'
#' @usage
#' glue_batch_delete_table(CatalogId, DatabaseName, TablesToDelete)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the tables to delete reside.
#' For Hive compatibility, this name is entirely lowercase.
#' @param TablesToDelete &#91;required&#93; A list of the table to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       TableName = "string",
#'       ErrorDetail = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TablesToDelete = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_table
glue_batch_delete_table <- function(CatalogId = NULL, DatabaseName, TablesToDelete) {
  op <- new_operation(
    name = "BatchDeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TablesToDelete = TablesToDelete)
  output <- .glue$batch_delete_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_table <- glue_batch_delete_table

#' Deletes a specified batch of versions of a table
#'
#' @description
#' Deletes a specified batch of versions of a table.
#'
#' @usage
#' glue_batch_delete_table_version(CatalogId, DatabaseName, TableName,
#'   VersionIds)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionIds &#91;required&#93; A list of the IDs of versions to be deleted. A `VersionId` is a string
#' representation of an integer. Each version is incremented by 1.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       TableName = "string",
#'       VersionId = "string",
#'       ErrorDetail = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_table_version(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   VersionIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_table_version
glue_batch_delete_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionIds) {
  op <- new_operation(
    name = "BatchDeleteTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionIds = VersionIds)
  output <- .glue$batch_delete_table_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_table_version <- glue_batch_delete_table_version

#' Returns a list of resource metadata for a given list of crawler names
#'
#' @description
#' Returns a list of resource metadata for a given list of crawler names.
#' After calling the [`list_crawlers`][glue_list_crawlers] operation, you
#' can call this operation to access the data to which you have been
#' granted permissions. This operation supports all IAM permissions,
#' including permission conditions that uses tags.
#'
#' @usage
#' glue_batch_get_crawlers(CrawlerNames)
#'
#' @param CrawlerNames &#91;required&#93; A list of crawler names, which might be the names returned from the
#' [`list_crawlers`][glue_list_crawlers] operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Crawlers = list(
#'     list(
#'       Name = "string",
#'       Role = "string",
#'       Targets = list(
#'         S3Targets = list(
#'           list(
#'             Path = "string",
#'             Exclusions = list(
#'               "string"
#'             ),
#'             ConnectionName = "string"
#'           )
#'         ),
#'         JdbcTargets = list(
#'           list(
#'             ConnectionName = "string",
#'             Path = "string",
#'             Exclusions = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MongoDBTargets = list(
#'           list(
#'             ConnectionName = "string",
#'             Path = "string",
#'             ScanAll = TRUE|FALSE
#'           )
#'         ),
#'         DynamoDBTargets = list(
#'           list(
#'             Path = "string",
#'             scanAll = TRUE|FALSE,
#'             scanRate = 123.0
#'           )
#'         ),
#'         CatalogTargets = list(
#'           list(
#'             DatabaseName = "string",
#'             Tables = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       DatabaseName = "string",
#'       Description = "string",
#'       Classifiers = list(
#'         "string"
#'       ),
#'       RecrawlPolicy = list(
#'         RecrawlBehavior = "CRAWL_EVERYTHING"|"CRAWL_NEW_FOLDERS_ONLY"
#'       ),
#'       SchemaChangePolicy = list(
#'         UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'         DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'       ),
#'       LineageConfiguration = list(
#'         CrawlerLineageSettings = "ENABLE"|"DISABLE"
#'       ),
#'       State = "READY"|"RUNNING"|"STOPPING",
#'       TablePrefix = "string",
#'       Schedule = list(
#'         ScheduleExpression = "string",
#'         State = "SCHEDULED"|"NOT_SCHEDULED"|"TRANSITIONING"
#'       ),
#'       CrawlElapsedTime = 123,
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastCrawl = list(
#'         Status = "SUCCEEDED"|"CANCELLED"|"FAILED",
#'         ErrorMessage = "string",
#'         LogGroup = "string",
#'         LogStream = "string",
#'         MessagePrefix = "string",
#'         StartTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       Version = 123,
#'       Configuration = "string",
#'       CrawlerSecurityConfiguration = "string"
#'     )
#'   ),
#'   CrawlersNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_crawlers(
#'   CrawlerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_crawlers
glue_batch_get_crawlers <- function(CrawlerNames) {
  op <- new_operation(
    name = "BatchGetCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_crawlers_input(CrawlerNames = CrawlerNames)
  output <- .glue$batch_get_crawlers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_crawlers <- glue_batch_get_crawlers

#' Returns a list of resource metadata for a given list of development
#' endpoint names
#'
#' @description
#' Returns a list of resource metadata for a given list of development
#' endpoint names. After calling the
#' [`list_dev_endpoints`][glue_list_dev_endpoints] operation, you can call
#' this operation to access the data to which you have been granted
#' permissions. This operation supports all IAM permissions, including
#' permission conditions that uses tags.
#'
#' @usage
#' glue_batch_get_dev_endpoints(DevEndpointNames)
#'
#' @param DevEndpointNames &#91;required&#93; The list of `DevEndpoint` names, which might be the names returned from
#' the `ListDevEndpoint` operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DevEndpoints = list(
#'     list(
#'       EndpointName = "string",
#'       RoleArn = "string",
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       SubnetId = "string",
#'       YarnEndpointAddress = "string",
#'       PrivateAddress = "string",
#'       ZeppelinRemoteSparkInterpreterPort = 123,
#'       PublicAddress = "string",
#'       Status = "string",
#'       WorkerType = "Standard"|"G.1X"|"G.2X",
#'       GlueVersion = "string",
#'       NumberOfWorkers = 123,
#'       NumberOfNodes = 123,
#'       AvailabilityZone = "string",
#'       VpcId = "string",
#'       ExtraPythonLibsS3Path = "string",
#'       ExtraJarsS3Path = "string",
#'       FailureReason = "string",
#'       LastUpdateStatus = "string",
#'       CreatedTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       PublicKey = "string",
#'       PublicKeys = list(
#'         "string"
#'       ),
#'       SecurityConfiguration = "string",
#'       Arguments = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DevEndpointsNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_dev_endpoints(
#'   DevEndpointNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_dev_endpoints
glue_batch_get_dev_endpoints <- function(DevEndpointNames) {
  op <- new_operation(
    name = "BatchGetDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_dev_endpoints_input(DevEndpointNames = DevEndpointNames)
  output <- .glue$batch_get_dev_endpoints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_dev_endpoints <- glue_batch_get_dev_endpoints

#' Returns a list of resource metadata for a given list of job names
#'
#' @description
#' Returns a list of resource metadata for a given list of job names. After
#' calling the [`list_jobs`][glue_list_jobs] operation, you can call this
#' operation to access the data to which you have been granted permissions.
#' This operation supports all IAM permissions, including permission
#' conditions that uses tags.
#'
#' @usage
#' glue_batch_get_jobs(JobNames)
#'
#' @param JobNames &#91;required&#93; A list of job names, which might be the names returned from the
#' [`list_jobs`][glue_list_jobs] operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Jobs = list(
#'     list(
#'       Name = "string",
#'       Description = "string",
#'       LogUri = "string",
#'       Role = "string",
#'       CreatedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ExecutionProperty = list(
#'         MaxConcurrentRuns = 123
#'       ),
#'       Command = list(
#'         Name = "string",
#'         ScriptLocation = "string",
#'         PythonVersion = "string"
#'       ),
#'       DefaultArguments = list(
#'         "string"
#'       ),
#'       NonOverridableArguments = list(
#'         "string"
#'       ),
#'       Connections = list(
#'         Connections = list(
#'           "string"
#'         )
#'       ),
#'       MaxRetries = 123,
#'       AllocatedCapacity = 123,
#'       Timeout = 123,
#'       MaxCapacity = 123.0,
#'       WorkerType = "Standard"|"G.1X"|"G.2X",
#'       NumberOfWorkers = 123,
#'       SecurityConfiguration = "string",
#'       NotificationProperty = list(
#'         NotifyDelayAfter = 123
#'       ),
#'       GlueVersion = "string"
#'     )
#'   ),
#'   JobsNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_jobs(
#'   JobNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_jobs
glue_batch_get_jobs <- function(JobNames) {
  op <- new_operation(
    name = "BatchGetJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_jobs_input(JobNames = JobNames)
  output <- .glue$batch_get_jobs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_jobs <- glue_batch_get_jobs

#' Retrieves partitions in a batch request
#'
#' @description
#' Retrieves partitions in a batch request.
#'
#' @usage
#' glue_batch_get_partition(CatalogId, DatabaseName, TableName,
#'   PartitionsToGet)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionsToGet &#91;required&#93; A list of partition values identifying the partitions to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Partitions = list(
#'     list(
#'       Values = list(
#'         "string"
#'       ),
#'       DatabaseName = "string",
#'       TableName = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE,
#'         SchemaReference = list(
#'           SchemaId = list(
#'             SchemaArn = "string",
#'             SchemaName = "string",
#'             RegistryName = "string"
#'           ),
#'           SchemaVersionId = "string",
#'           SchemaVersionNumber = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CatalogId = "string"
#'     )
#'   ),
#'   UnprocessedKeys = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionsToGet = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_partition
glue_batch_get_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionsToGet) {
  op <- new_operation(
    name = "BatchGetPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionsToGet = PartitionsToGet)
  output <- .glue$batch_get_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_partition <- glue_batch_get_partition

#' Returns a list of resource metadata for a given list of trigger names
#'
#' @description
#' Returns a list of resource metadata for a given list of trigger names.
#' After calling the [`list_triggers`][glue_list_triggers] operation, you
#' can call this operation to access the data to which you have been
#' granted permissions. This operation supports all IAM permissions,
#' including permission conditions that uses tags.
#'
#' @usage
#' glue_batch_get_triggers(TriggerNames)
#'
#' @param TriggerNames &#91;required&#93; A list of trigger names, which may be the names returned from the
#' [`list_triggers`][glue_list_triggers] operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Triggers = list(
#'     list(
#'       Name = "string",
#'       WorkflowName = "string",
#'       Id = "string",
#'       Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'       State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'       Description = "string",
#'       Schedule = "string",
#'       Actions = list(
#'         list(
#'           JobName = "string",
#'           Arguments = list(
#'             "string"
#'           ),
#'           Timeout = 123,
#'           SecurityConfiguration = "string",
#'           NotificationProperty = list(
#'             NotifyDelayAfter = 123
#'           ),
#'           CrawlerName = "string"
#'         )
#'       ),
#'       Predicate = list(
#'         Logical = "AND"|"ANY",
#'         Conditions = list(
#'           list(
#'             LogicalOperator = "EQUALS",
#'             JobName = "string",
#'             State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'             CrawlerName = "string",
#'             CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   TriggersNotFound = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_triggers(
#'   TriggerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_triggers
glue_batch_get_triggers <- function(TriggerNames) {
  op <- new_operation(
    name = "BatchGetTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_triggers_input(TriggerNames = TriggerNames)
  output <- .glue$batch_get_triggers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_triggers <- glue_batch_get_triggers

#' Returns a list of resource metadata for a given list of workflow names
#'
#' @description
#' Returns a list of resource metadata for a given list of workflow names.
#' After calling the [`list_workflows`][glue_list_workflows] operation, you
#' can call this operation to access the data to which you have been
#' granted permissions. This operation supports all IAM permissions,
#' including permission conditions that uses tags.
#'
#' @usage
#' glue_batch_get_workflows(Names, IncludeGraph)
#'
#' @param Names &#91;required&#93; A list of workflow names, which may be the names returned from the
#' [`list_workflows`][glue_list_workflows] operation.
#' @param IncludeGraph Specifies whether to include a graph when returning the workflow
#' resource metadata.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Workflows = list(
#'     list(
#'       Name = "string",
#'       Description = "string",
#'       DefaultRunProperties = list(
#'         "string"
#'       ),
#'       CreatedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastRun = list(
#'         Name = "string",
#'         WorkflowRunId = "string",
#'         PreviousRunId = "string",
#'         WorkflowRunProperties = list(
#'           "string"
#'         ),
#'         StartedOn = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         CompletedOn = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Status = "RUNNING"|"COMPLETED"|"STOPPING"|"STOPPED"|"ERROR",
#'         ErrorMessage = "string",
#'         Statistics = list(
#'           TotalActions = 123,
#'           TimeoutActions = 123,
#'           FailedActions = 123,
#'           StoppedActions = 123,
#'           SucceededActions = 123,
#'           RunningActions = 123
#'         ),
#'         Graph = list(
#'           Nodes = list(
#'             list(
#'               Type = "CRAWLER"|"JOB"|"TRIGGER",
#'               Name = "string",
#'               UniqueId = "string",
#'               TriggerDetails = list(
#'                 Trigger = list(
#'                   Name = "string",
#'                   WorkflowName = "string",
#'                   Id = "string",
#'                   Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'                   State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'                   Description = "string",
#'                   Schedule = "string",
#'                   Actions = list(
#'                     list(
#'                       JobName = "string",
#'                       Arguments = list(
#'                         "string"
#'                       ),
#'                       Timeout = 123,
#'                       SecurityConfiguration = "string",
#'                       NotificationProperty = list(
#'                         NotifyDelayAfter = 123
#'                       ),
#'                       CrawlerName = "string"
#'                     )
#'                   ),
#'                   Predicate = list(
#'                     Logical = "AND"|"ANY",
#'                     Conditions = list(
#'                       list(
#'                         LogicalOperator = "EQUALS",
#'                         JobName = "string",
#'                         State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                         CrawlerName = "string",
#'                         CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'                       )
#'                     )
#'                   )
#'                 )
#'               ),
#'               JobDetails = list(
#'                 JobRuns = list(
#'                   list(
#'                     Id = "string",
#'                     Attempt = 123,
#'                     PreviousRunId = "string",
#'                     TriggerName = "string",
#'                     JobName = "string",
#'                     StartedOn = as.POSIXct(
#'                       "2015-01-01"
#'                     ),
#'                     LastModifiedOn = as.POSIXct(
#'                       "2015-01-01"
#'                     ),
#'                     CompletedOn = as.POSIXct(
#'                       "2015-01-01"
#'                     ),
#'                     JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                     Arguments = list(
#'                       "string"
#'                     ),
#'                     ErrorMessage = "string",
#'                     PredecessorRuns = list(
#'                       list(
#'                         JobName = "string",
#'                         RunId = "string"
#'                       )
#'                     ),
#'                     AllocatedCapacity = 123,
#'                     ExecutionTime = 123,
#'                     Timeout = 123,
#'                     MaxCapacity = 123.0,
#'                     WorkerType = "Standard"|"G.1X"|"G.2X",
#'                     NumberOfWorkers = 123,
#'                     SecurityConfiguration = "string",
#'                     LogGroupName = "string",
#'                     NotificationProperty = list(
#'                       NotifyDelayAfter = 123
#'                     ),
#'                     GlueVersion = "string"
#'                   )
#'                 )
#'               ),
#'               CrawlerDetails = list(
#'                 Crawls = list(
#'                   list(
#'                     State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
#'                     StartedOn = as.POSIXct(
#'                       "2015-01-01"
#'                     ),
#'                     CompletedOn = as.POSIXct(
#'                       "2015-01-01"
#'                     ),
#'                     ErrorMessage = "string",
#'                     LogGroup = "string",
#'                     LogStream = "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           Edges = list(
#'             list(
#'               SourceId = "string",
#'               DestinationId = "string"
#'             )
#'           )
#'         )
#'       ),
#'       Graph = list(
#'         Nodes = list(
#'           list(
#'             Type = "CRAWLER"|"JOB"|"TRIGGER",
#'             Name = "string",
#'             UniqueId = "string",
#'             TriggerDetails = list(
#'               Trigger = list(
#'                 Name = "string",
#'                 WorkflowName = "string",
#'                 Id = "string",
#'                 Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'                 State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'                 Description = "string",
#'                 Schedule = "string",
#'                 Actions = list(
#'                   list(
#'                     JobName = "string",
#'                     Arguments = list(
#'                       "string"
#'                     ),
#'                     Timeout = 123,
#'                     SecurityConfiguration = "string",
#'                     NotificationProperty = list(
#'                       NotifyDelayAfter = 123
#'                     ),
#'                     CrawlerName = "string"
#'                   )
#'                 ),
#'                 Predicate = list(
#'                   Logical = "AND"|"ANY",
#'                   Conditions = list(
#'                     list(
#'                       LogicalOperator = "EQUALS",
#'                       JobName = "string",
#'                       State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                       CrawlerName = "string",
#'                       CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             JobDetails = list(
#'               JobRuns = list(
#'                 list(
#'                   Id = "string",
#'                   Attempt = 123,
#'                   PreviousRunId = "string",
#'                   TriggerName = "string",
#'                   JobName = "string",
#'                   StartedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   LastModifiedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   CompletedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                   Arguments = list(
#'                     "string"
#'                   ),
#'                   ErrorMessage = "string",
#'                   PredecessorRuns = list(
#'                     list(
#'                       JobName = "string",
#'                       RunId = "string"
#'                     )
#'                   ),
#'                   AllocatedCapacity = 123,
#'                   ExecutionTime = 123,
#'                   Timeout = 123,
#'                   MaxCapacity = 123.0,
#'                   WorkerType = "Standard"|"G.1X"|"G.2X",
#'                   NumberOfWorkers = 123,
#'                   SecurityConfiguration = "string",
#'                   LogGroupName = "string",
#'                   NotificationProperty = list(
#'                     NotifyDelayAfter = 123
#'                   ),
#'                   GlueVersion = "string"
#'                 )
#'               )
#'             ),
#'             CrawlerDetails = list(
#'               Crawls = list(
#'                 list(
#'                   State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
#'                   StartedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   CompletedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   ErrorMessage = "string",
#'                   LogGroup = "string",
#'                   LogStream = "string"
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         Edges = list(
#'           list(
#'             SourceId = "string",
#'             DestinationId = "string"
#'           )
#'         )
#'       ),
#'       MaxConcurrentRuns = 123
#'     )
#'   ),
#'   MissingWorkflows = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_workflows(
#'   Names = list(
#'     "string"
#'   ),
#'   IncludeGraph = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_workflows
glue_batch_get_workflows <- function(Names, IncludeGraph = NULL) {
  op <- new_operation(
    name = "BatchGetWorkflows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_workflows_input(Names = Names, IncludeGraph = IncludeGraph)
  output <- .glue$batch_get_workflows_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_workflows <- glue_batch_get_workflows

#' Stops one or more job runs for a specified job definition
#'
#' @description
#' Stops one or more job runs for a specified job definition.
#'
#' @usage
#' glue_batch_stop_job_run(JobName, JobRunIds)
#'
#' @param JobName &#91;required&#93; The name of the job definition for which to stop job runs.
#' @param JobRunIds &#91;required&#93; A list of the `JobRunIds` that should be stopped for that job
#' definition.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SuccessfulSubmissions = list(
#'     list(
#'       JobName = "string",
#'       JobRunId = "string"
#'     )
#'   ),
#'   Errors = list(
#'     list(
#'       JobName = "string",
#'       JobRunId = "string",
#'       ErrorDetail = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_stop_job_run(
#'   JobName = "string",
#'   JobRunIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_stop_job_run
glue_batch_stop_job_run <- function(JobName, JobRunIds) {
  op <- new_operation(
    name = "BatchStopJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_stop_job_run_input(JobName = JobName, JobRunIds = JobRunIds)
  output <- .glue$batch_stop_job_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_stop_job_run <- glue_batch_stop_job_run

#' Updates one or more partitions in a batch operation
#'
#' @description
#' Updates one or more partitions in a batch operation.
#'
#' @usage
#' glue_batch_update_partition(CatalogId, DatabaseName, TableName, Entries)
#'
#' @param CatalogId The ID of the catalog in which the partition is to be updated.
#' Currently, this should be the AWS account ID.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' updated.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be updated.
#' @param Entries &#91;required&#93; A list of up to 100 `BatchUpdatePartitionRequestEntry` objects to
#' update.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       PartitionValueList = list(
#'         "string"
#'       ),
#'       ErrorDetail = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_update_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   Entries = list(
#'     list(
#'       PartitionValueList = list(
#'         "string"
#'       ),
#'       PartitionInput = list(
#'         Values = list(
#'           "string"
#'         ),
#'         LastAccessTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         StorageDescriptor = list(
#'           Columns = list(
#'             list(
#'               Name = "string",
#'               Type = "string",
#'               Comment = "string",
#'               Parameters = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Location = "string",
#'           InputFormat = "string",
#'           OutputFormat = "string",
#'           Compressed = TRUE|FALSE,
#'           NumberOfBuckets = 123,
#'           SerdeInfo = list(
#'             Name = "string",
#'             SerializationLibrary = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           ),
#'           BucketColumns = list(
#'             "string"
#'           ),
#'           SortColumns = list(
#'             list(
#'               Column = "string",
#'               SortOrder = 123
#'             )
#'           ),
#'           Parameters = list(
#'             "string"
#'           ),
#'           SkewedInfo = list(
#'             SkewedColumnNames = list(
#'               "string"
#'             ),
#'             SkewedColumnValues = list(
#'               "string"
#'             ),
#'             SkewedColumnValueLocationMaps = list(
#'               "string"
#'             )
#'           ),
#'           StoredAsSubDirectories = TRUE|FALSE,
#'           SchemaReference = list(
#'             SchemaId = list(
#'               SchemaArn = "string",
#'               SchemaName = "string",
#'               RegistryName = "string"
#'             ),
#'             SchemaVersionId = "string",
#'             SchemaVersionNumber = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         LastAnalyzedTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_update_partition
glue_batch_update_partition <- function(CatalogId = NULL, DatabaseName, TableName, Entries) {
  op <- new_operation(
    name = "BatchUpdatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_update_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Entries = Entries)
  output <- .glue$batch_update_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_update_partition <- glue_batch_update_partition

#' Cancels (stops) a task run
#'
#' @description
#' Cancels (stops) a task run. Machine learning task runs are asynchronous
#' tasks that AWS Glue runs on your behalf as part of various machine
#' learning workflows. You can cancel a machine learning task run at any
#' time by calling [`cancel_ml_task_run`][glue_cancel_ml_task_run] with a
#' task run's parent transform's `TransformID` and the task run's
#' `TaskRunId`.
#'
#' @usage
#' glue_cancel_ml_task_run(TransformId, TaskRunId)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param TaskRunId &#91;required&#93; A unique identifier for the task run.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformId = "string",
#'   TaskRunId = "string",
#'   Status = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_ml_task_run(
#'   TransformId = "string",
#'   TaskRunId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_cancel_ml_task_run
glue_cancel_ml_task_run <- function(TransformId, TaskRunId) {
  op <- new_operation(
    name = "CancelMLTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$cancel_ml_task_run_input(TransformId = TransformId, TaskRunId = TaskRunId)
  output <- .glue$cancel_ml_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$cancel_ml_task_run <- glue_cancel_ml_task_run

#' Validates the supplied schema
#'
#' @description
#' Validates the supplied schema. This call has no side effects, it simply
#' validates using the supplied schema using `DataFormat` as the format.
#' Since it does not take a schema set name, no compatibility checks are
#' performed.
#'
#' @usage
#' glue_check_schema_version_validity(DataFormat, SchemaDefinition)
#'
#' @param DataFormat &#91;required&#93; The data format of the schema definition. Currently only `AVRO` is
#' supported.
#' @param SchemaDefinition &#91;required&#93; The definition of the schema that has to be validated.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Valid = TRUE|FALSE,
#'   Error = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$check_schema_version_validity(
#'   DataFormat = "AVRO",
#'   SchemaDefinition = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_check_schema_version_validity
glue_check_schema_version_validity <- function(DataFormat, SchemaDefinition) {
  op <- new_operation(
    name = "CheckSchemaVersionValidity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$check_schema_version_validity_input(DataFormat = DataFormat, SchemaDefinition = SchemaDefinition)
  output <- .glue$check_schema_version_validity_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$check_schema_version_validity <- glue_check_schema_version_validity

#' Creates a classifier in the user's account
#'
#' @description
#' Creates a classifier in the user's account. This can be a
#' `GrokClassifier`, an `XMLClassifier`, a `JsonClassifier`, or a
#' `CsvClassifier`, depending on which field of the request is present.
#'
#' @usage
#' glue_create_classifier(GrokClassifier, XMLClassifier, JsonClassifier,
#'   CsvClassifier)
#'
#' @param GrokClassifier A `GrokClassifier` object specifying the classifier to create.
#' @param XMLClassifier An `XMLClassifier` object specifying the classifier to create.
#' @param JsonClassifier A `JsonClassifier` object specifying the classifier to create.
#' @param CsvClassifier A `CsvClassifier` object specifying the classifier to create.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_classifier(
#'   GrokClassifier = list(
#'     Classification = "string",
#'     Name = "string",
#'     GrokPattern = "string",
#'     CustomPatterns = "string"
#'   ),
#'   XMLClassifier = list(
#'     Classification = "string",
#'     Name = "string",
#'     RowTag = "string"
#'   ),
#'   JsonClassifier = list(
#'     Name = "string",
#'     JsonPath = "string"
#'   ),
#'   CsvClassifier = list(
#'     Name = "string",
#'     Delimiter = "string",
#'     QuoteSymbol = "string",
#'     ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
#'     Header = list(
#'       "string"
#'     ),
#'     DisableValueTrimming = TRUE|FALSE,
#'     AllowSingleColumn = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_classifier
glue_create_classifier <- function(GrokClassifier = NULL, XMLClassifier = NULL, JsonClassifier = NULL, CsvClassifier = NULL) {
  op <- new_operation(
    name = "CreateClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_classifier_input(GrokClassifier = GrokClassifier, XMLClassifier = XMLClassifier, JsonClassifier = JsonClassifier, CsvClassifier = CsvClassifier)
  output <- .glue$create_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_classifier <- glue_create_classifier

#' Creates a connection definition in the Data Catalog
#'
#' @description
#' Creates a connection definition in the Data Catalog.
#'
#' @usage
#' glue_create_connection(CatalogId, ConnectionInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the connection. If none is
#' provided, the AWS account ID is used by default.
#' @param ConnectionInput &#91;required&#93; A `ConnectionInput` object defining the connection to create.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_connection(
#'   CatalogId = "string",
#'   ConnectionInput = list(
#'     Name = "string",
#'     Description = "string",
#'     ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA"|"NETWORK"|"MARKETPLACE"|"CUSTOM",
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionProperties = list(
#'       "string"
#'     ),
#'     PhysicalConnectionRequirements = list(
#'       SubnetId = "string",
#'       SecurityGroupIdList = list(
#'         "string"
#'       ),
#'       AvailabilityZone = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_connection
glue_create_connection <- function(CatalogId = NULL, ConnectionInput) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_connection_input(CatalogId = CatalogId, ConnectionInput = ConnectionInput)
  output <- .glue$create_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_connection <- glue_create_connection

#' Creates a new crawler with specified targets, role, configuration, and
#' optional schedule
#'
#' @description
#' Creates a new crawler with specified targets, role, configuration, and
#' optional schedule. At least one crawl target must be specified, in the
#' `s3Targets` field, the `jdbcTargets` field, or the `DynamoDBTargets`
#' field.
#'
#' @usage
#' glue_create_crawler(Name, Role, DatabaseName, Description, Targets,
#'   Schedule, Classifiers, TablePrefix, SchemaChangePolicy, RecrawlPolicy,
#'   LineageConfiguration, Configuration, CrawlerSecurityConfiguration, Tags)
#'
#' @param Name &#91;required&#93; Name of the new crawler.
#' @param Role &#91;required&#93; The IAM role or Amazon Resource Name (ARN) of an IAM role used by the
#' new crawler to access customer resources.
#' @param DatabaseName The AWS Glue database where results are written, such as:
#' `arn:aws:daylight:us-east-1::database/sometable/*`.
#' @param Description A description of the new crawler.
#' @param Targets &#91;required&#93; A list of collection of targets to crawl.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' @param Classifiers A list of custom classifiers that the user has registered. By default,
#' all built-in classifiers are included in a crawl, but these custom
#' classifiers always override the default classifiers for a given
#' classification.
#' @param TablePrefix The table prefix used for catalog tables that are created.
#' @param SchemaChangePolicy The policy for the crawler's update and deletion behavior.
#' @param RecrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to
#' crawl only folders that were added since the last crawler run.
#' @param LineageConfiguration Specifies data lineage configuration settings for the crawler.
#' @param Configuration Crawler configuration information. This versioned JSON string allows
#' users to specify aspects of a crawler's behavior. For more information,
#' see [Configuring a
#' Crawler](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
#' @param CrawlerSecurityConfiguration The name of the `SecurityConfiguration` structure to be used by this
#' crawler.
#' @param Tags The tags to use with this crawler request. You may use tags to limit
#' access to the crawler. For more information about tags in AWS Glue, see
#' [AWS Tags in AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_crawler(
#'   Name = "string",
#'   Role = "string",
#'   DatabaseName = "string",
#'   Description = "string",
#'   Targets = list(
#'     S3Targets = list(
#'       list(
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         ),
#'         ConnectionName = "string"
#'       )
#'     ),
#'     JdbcTargets = list(
#'       list(
#'         ConnectionName = "string",
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     MongoDBTargets = list(
#'       list(
#'         ConnectionName = "string",
#'         Path = "string",
#'         ScanAll = TRUE|FALSE
#'       )
#'     ),
#'     DynamoDBTargets = list(
#'       list(
#'         Path = "string",
#'         scanAll = TRUE|FALSE,
#'         scanRate = 123.0
#'       )
#'     ),
#'     CatalogTargets = list(
#'       list(
#'         DatabaseName = "string",
#'         Tables = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   Schedule = "string",
#'   Classifiers = list(
#'     "string"
#'   ),
#'   TablePrefix = "string",
#'   SchemaChangePolicy = list(
#'     UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'     DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'   ),
#'   RecrawlPolicy = list(
#'     RecrawlBehavior = "CRAWL_EVERYTHING"|"CRAWL_NEW_FOLDERS_ONLY"
#'   ),
#'   LineageConfiguration = list(
#'     CrawlerLineageSettings = "ENABLE"|"DISABLE"
#'   ),
#'   Configuration = "string",
#'   CrawlerSecurityConfiguration = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_crawler
glue_create_crawler <- function(Name, Role, DatabaseName = NULL, Description = NULL, Targets, Schedule = NULL, Classifiers = NULL, TablePrefix = NULL, SchemaChangePolicy = NULL, RecrawlPolicy = NULL, LineageConfiguration = NULL, Configuration = NULL, CrawlerSecurityConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_crawler_input(Name = Name, Role = Role, DatabaseName = DatabaseName, Description = Description, Targets = Targets, Schedule = Schedule, Classifiers = Classifiers, TablePrefix = TablePrefix, SchemaChangePolicy = SchemaChangePolicy, RecrawlPolicy = RecrawlPolicy, LineageConfiguration = LineageConfiguration, Configuration = Configuration, CrawlerSecurityConfiguration = CrawlerSecurityConfiguration, Tags = Tags)
  output <- .glue$create_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_crawler <- glue_create_crawler

#' Creates a new database in a Data Catalog
#'
#' @description
#' Creates a new database in a Data Catalog.
#'
#' @usage
#' glue_create_database(CatalogId, DatabaseInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the database. If none is
#' provided, the AWS account ID is used by default.
#' @param DatabaseInput &#91;required&#93; The metadata for the database.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_database(
#'   CatalogId = "string",
#'   DatabaseInput = list(
#'     Name = "string",
#'     Description = "string",
#'     LocationUri = "string",
#'     Parameters = list(
#'       "string"
#'     ),
#'     CreateTableDefaultPermissions = list(
#'       list(
#'         Principal = list(
#'           DataLakePrincipalIdentifier = "string"
#'         ),
#'         Permissions = list(
#'           "ALL"|"SELECT"|"ALTER"|"DROP"|"DELETE"|"INSERT"|"CREATE_DATABASE"|"CREATE_TABLE"|"DATA_LOCATION_ACCESS"
#'         )
#'       )
#'     ),
#'     TargetDatabase = list(
#'       CatalogId = "string",
#'       DatabaseName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_database
glue_create_database <- function(CatalogId = NULL, DatabaseInput) {
  op <- new_operation(
    name = "CreateDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_database_input(CatalogId = CatalogId, DatabaseInput = DatabaseInput)
  output <- .glue$create_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_database <- glue_create_database

#' Creates a new development endpoint
#'
#' @description
#' Creates a new development endpoint.
#'
#' @usage
#' glue_create_dev_endpoint(EndpointName, RoleArn, SecurityGroupIds,
#'   SubnetId, PublicKey, PublicKeys, NumberOfNodes, WorkerType, GlueVersion,
#'   NumberOfWorkers, ExtraPythonLibsS3Path, ExtraJarsS3Path,
#'   SecurityConfiguration, Tags, Arguments)
#'
#' @param EndpointName &#91;required&#93; The name to be assigned to the new `DevEndpoint`.
#' @param RoleArn &#91;required&#93; The IAM role for the `DevEndpoint`.
#' @param SecurityGroupIds Security group IDs for the security groups to be used by the new
#' `DevEndpoint`.
#' @param SubnetId The subnet ID for the new `DevEndpoint` to use.
#' @param PublicKey The public key to be used by this `DevEndpoint` for authentication. This
#' attribute is provided for backward compatibility because the recommended
#' attribute to use is public keys.
#' @param PublicKeys A list of public keys to be used by the development endpoints for
#' authentication. The use of this attribute is preferred over a single
#' public key because the public keys allow you to have a different private
#' key per client.
#' 
#' If you previously created an endpoint with a public key, you must remove
#' that key to be able to set a list of public keys. Call the
#' [`update_dev_endpoint`][glue_update_dev_endpoint] API with the public
#' key content in the `deletePublicKeys` attribute, and the list of new
#' keys in the `addPublicKeys` attribute.
#' @param NumberOfNodes The number of AWS Glue Data Processing Units (DPUs) to allocate to this
#' `DevEndpoint`.
#' @param WorkerType The type of predefined worker that is allocated to the development
#' endpoint. Accepts a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker maps to 1 DPU (4 vCPU, 16 GB
#'     of memory, 64 GB disk), and provides 1 executor per worker. We
#'     recommend this worker type for memory-intensive jobs.
#' 
#' -   For the `G.2X` worker type, each worker maps to 2 DPU (8 vCPU, 32 GB
#'     of memory, 128 GB disk), and provides 1 executor per worker. We
#'     recommend this worker type for memory-intensive jobs.
#' 
#' Known issue: when a development endpoint is created with the `G.2X`
#' `WorkerType` configuration, the Spark drivers for the development
#' endpoint will run on 4 vCPU, 16 GB of memory, and a 64 GB disk.
#' @param GlueVersion Glue version determines the versions of Apache Spark and Python that AWS
#' Glue supports. The Python version indicates the version supported for
#' running your ETL scripts on development endpoints.
#' 
#' For more information about the available AWS Glue versions and
#' corresponding Spark and Python versions, see [Glue
#' version](https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the
#' developer guide.
#' 
#' Development endpoints that are created without specifying a Glue version
#' default to Glue 0.9.
#' 
#' You can specify a version of Python support for development endpoints by
#' using the `Arguments` parameter in the
#' [`create_dev_endpoint`][glue_create_dev_endpoint] or
#' [`update_dev_endpoint`][glue_update_dev_endpoint] APIs. If no arguments
#' are provided, the version defaults to Python 2.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated to
#' the development endpoint.
#' 
#' The maximum number of workers you can define are 299 for `G.1X`, and 149
#' for `G.2X`.
#' @param ExtraPythonLibsS3Path The paths to one or more Python libraries in an Amazon S3 bucket that
#' should be loaded in your `DevEndpoint`. Multiple values must be complete
#' paths separated by a comma.
#' 
#' You can only use pure Python libraries with a `DevEndpoint`. Libraries
#' that rely on C extensions, such as the
#' [pandas](https://pandas.pydata.org/) Python data analysis library, are
#' not yet supported.
#' @param ExtraJarsS3Path The path to one or more Java `.jar` files in an S3 bucket that should be
#' loaded in your `DevEndpoint`.
#' @param SecurityConfiguration The name of the `SecurityConfiguration` structure to be used with this
#' `DevEndpoint`.
#' @param Tags The tags to use with this DevEndpoint. You may use tags to limit access
#' to the DevEndpoint. For more information about tags in AWS Glue, see
#' [AWS Tags in AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param Arguments A map of arguments used to configure the `DevEndpoint`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EndpointName = "string",
#'   Status = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   SubnetId = "string",
#'   RoleArn = "string",
#'   YarnEndpointAddress = "string",
#'   ZeppelinRemoteSparkInterpreterPort = 123,
#'   NumberOfNodes = 123,
#'   WorkerType = "Standard"|"G.1X"|"G.2X",
#'   GlueVersion = "string",
#'   NumberOfWorkers = 123,
#'   AvailabilityZone = "string",
#'   VpcId = "string",
#'   ExtraPythonLibsS3Path = "string",
#'   ExtraJarsS3Path = "string",
#'   FailureReason = "string",
#'   SecurityConfiguration = "string",
#'   CreatedTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Arguments = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_dev_endpoint(
#'   EndpointName = "string",
#'   RoleArn = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   SubnetId = "string",
#'   PublicKey = "string",
#'   PublicKeys = list(
#'     "string"
#'   ),
#'   NumberOfNodes = 123,
#'   WorkerType = "Standard"|"G.1X"|"G.2X",
#'   GlueVersion = "string",
#'   NumberOfWorkers = 123,
#'   ExtraPythonLibsS3Path = "string",
#'   ExtraJarsS3Path = "string",
#'   SecurityConfiguration = "string",
#'   Tags = list(
#'     "string"
#'   ),
#'   Arguments = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_dev_endpoint
glue_create_dev_endpoint <- function(EndpointName, RoleArn, SecurityGroupIds = NULL, SubnetId = NULL, PublicKey = NULL, PublicKeys = NULL, NumberOfNodes = NULL, WorkerType = NULL, GlueVersion = NULL, NumberOfWorkers = NULL, ExtraPythonLibsS3Path = NULL, ExtraJarsS3Path = NULL, SecurityConfiguration = NULL, Tags = NULL, Arguments = NULL) {
  op <- new_operation(
    name = "CreateDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_dev_endpoint_input(EndpointName = EndpointName, RoleArn = RoleArn, SecurityGroupIds = SecurityGroupIds, SubnetId = SubnetId, PublicKey = PublicKey, PublicKeys = PublicKeys, NumberOfNodes = NumberOfNodes, WorkerType = WorkerType, GlueVersion = GlueVersion, NumberOfWorkers = NumberOfWorkers, ExtraPythonLibsS3Path = ExtraPythonLibsS3Path, ExtraJarsS3Path = ExtraJarsS3Path, SecurityConfiguration = SecurityConfiguration, Tags = Tags, Arguments = Arguments)
  output <- .glue$create_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_dev_endpoint <- glue_create_dev_endpoint

#' Creates a new job definition
#'
#' @description
#' Creates a new job definition.
#'
#' @usage
#' glue_create_job(Name, Description, LogUri, Role, ExecutionProperty,
#'   Command, DefaultArguments, NonOverridableArguments, Connections,
#'   MaxRetries, AllocatedCapacity, Timeout, MaxCapacity,
#'   SecurityConfiguration, Tags, NotificationProperty, GlueVersion,
#'   NumberOfWorkers, WorkerType)
#'
#' @param Name &#91;required&#93; The name you assign to this job definition. It must be unique in your
#' account.
#' @param Description Description of the job being defined.
#' @param LogUri This field is reserved for future use.
#' @param Role &#91;required&#93; The name or Amazon Resource Name (ARN) of the IAM role associated with
#' this job.
#' @param ExecutionProperty An `ExecutionProperty` specifying the maximum number of concurrent runs
#' allowed for this job.
#' @param Command &#91;required&#93; The `JobCommand` that executes this job.
#' @param DefaultArguments The default arguments for this job.
#' 
#' You can specify arguments here that your own job-execution script
#' consumes, as well as arguments that AWS Glue itself consumes.
#' 
#' For information about how to specify and consume your own Job arguments,
#' see the [Calling AWS Glue APIs in
#' Python](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
#' topic in the developer guide.
#' 
#' For information about the key-value pairs that AWS Glue consumes to set
#' up your job, see the [Special Parameters Used by AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
#' topic in the developer guide.
#' @param NonOverridableArguments Non-overridable arguments for this job, specified as name-value pairs.
#' @param Connections The connections used for this job.
#' @param MaxRetries The maximum number of times to retry this job if it fails.
#' @param AllocatedCapacity This parameter is deprecated. Use `MaxCapacity` instead.
#' 
#' The number of AWS Glue data processing units (DPUs) to allocate to this
#' Job. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a
#' relative measure of processing power that consists of 4 vCPUs of compute
#' capacity and 16 GB of memory. For more information, see the [AWS Glue
#' pricing page](https://aws.amazon.com/glue/pricing/).
#' @param Timeout The job timeout in minutes. This is the maximum time that a job run can
#' consume resources before it is terminated and enters `TIMEOUT` status.
#' The default is 2,880 minutes (48 hours).
#' @param MaxCapacity The number of AWS Glue data processing units (DPUs) that can be
#' allocated when this job runs. A DPU is a relative measure of processing
#' power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
#' For more information, see the [AWS Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' Do not set `Max Capacity` if using `WorkerType` and `NumberOfWorkers`.
#' 
#' The value that can be allocated for `MaxCapacity` depends on whether you
#' are running a Python shell job or an Apache Spark ETL job:
#' 
#' -   When you specify a Python shell job
#'     (`JobCommand.Name`="pythonshell"), you can allocate either 0.0625 or
#'     1 DPU. The default is 0.0625 DPU.
#' 
#' -   When you specify an Apache Spark ETL job
#'     (`JobCommand.Name`="glueetl") or Apache Spark streaming ETL job
#'     (`JobCommand.Name`="gluestreaming"), you can allocate from 2 to 100
#'     DPUs. The default is 10 DPUs. This job type cannot have a fractional
#'     DPU allocation.
#' @param SecurityConfiguration The name of the `SecurityConfiguration` structure to be used with this
#' job.
#' @param Tags The tags to use with this job. You may use tags to limit access to the
#' job. For more information about tags in AWS Glue, see [AWS Tags in AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param NotificationProperty Specifies configuration properties of a job notification.
#' @param GlueVersion Glue version determines the versions of Apache Spark and Python that AWS
#' Glue supports. The Python version indicates the version supported for
#' jobs of type Spark.
#' 
#' For more information about the available AWS Glue versions and
#' corresponding Spark and Python versions, see [Glue
#' version](https://docs.aws.amazon.com/glue/latest/dg/add-job.html) in the
#' developer guide.
#' 
#' Jobs that are created without specifying a Glue version default to Glue
#' 0.9.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' a job runs.
#' 
#' The maximum number of workers you can define are 299 for `G.1X`, and 149
#' for `G.2X`.
#' @param WorkerType The type of predefined worker that is allocated when a job runs. Accepts
#' a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker maps to 1 DPU (4 vCPU, 16 GB
#'     of memory, 64 GB disk), and provides 1 executor per worker. We
#'     recommend this worker type for memory-intensive jobs.
#' 
#' -   For the `G.2X` worker type, each worker maps to 2 DPU (8 vCPU, 32 GB
#'     of memory, 128 GB disk), and provides 1 executor per worker. We
#'     recommend this worker type for memory-intensive jobs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_job(
#'   Name = "string",
#'   Description = "string",
#'   LogUri = "string",
#'   Role = "string",
#'   ExecutionProperty = list(
#'     MaxConcurrentRuns = 123
#'   ),
#'   Command = list(
#'     Name = "string",
#'     ScriptLocation = "string",
#'     PythonVersion = "string"
#'   ),
#'   DefaultArguments = list(
#'     "string"
#'   ),
#'   NonOverridableArguments = list(
#'     "string"
#'   ),
#'   Connections = list(
#'     Connections = list(
#'       "string"
#'     )
#'   ),
#'   MaxRetries = 123,
#'   AllocatedCapacity = 123,
#'   Timeout = 123,
#'   MaxCapacity = 123.0,
#'   SecurityConfiguration = "string",
#'   Tags = list(
#'     "string"
#'   ),
#'   NotificationProperty = list(
#'     NotifyDelayAfter = 123
#'   ),
#'   GlueVersion = "string",
#'   NumberOfWorkers = 123,
#'   WorkerType = "Standard"|"G.1X"|"G.2X"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_job
glue_create_job <- function(Name, Description = NULL, LogUri = NULL, Role, ExecutionProperty = NULL, Command, DefaultArguments = NULL, NonOverridableArguments = NULL, Connections = NULL, MaxRetries = NULL, AllocatedCapacity = NULL, Timeout = NULL, MaxCapacity = NULL, SecurityConfiguration = NULL, Tags = NULL, NotificationProperty = NULL, GlueVersion = NULL, NumberOfWorkers = NULL, WorkerType = NULL) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_job_input(Name = Name, Description = Description, LogUri = LogUri, Role = Role, ExecutionProperty = ExecutionProperty, Command = Command, DefaultArguments = DefaultArguments, NonOverridableArguments = NonOverridableArguments, Connections = Connections, MaxRetries = MaxRetries, AllocatedCapacity = AllocatedCapacity, Timeout = Timeout, MaxCapacity = MaxCapacity, SecurityConfiguration = SecurityConfiguration, Tags = Tags, NotificationProperty = NotificationProperty, GlueVersion = GlueVersion, NumberOfWorkers = NumberOfWorkers, WorkerType = WorkerType)
  output <- .glue$create_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_job <- glue_create_job

#' Creates an AWS Glue machine learning transform
#'
#' @description
#' Creates an AWS Glue machine learning transform. This operation creates
#' the transform and all the necessary parameters to train it.
#' 
#' Call this operation as the first step in the process of using a machine
#' learning transform (such as the `FindMatches` transform) for
#' deduplicating data. You can provide an optional `Description`, in
#' addition to the parameters that you want to use for your algorithm.
#' 
#' You must also specify certain parameters for the tasks that AWS Glue
#' runs on your behalf as part of learning from your data and creating a
#' high-quality machine learning transform. These parameters include
#' `Role`, and optionally, `AllocatedCapacity`, `Timeout`, and
#' `MaxRetries`. For more information, see
#' [Jobs](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-job.html).
#'
#' @usage
#' glue_create_ml_transform(Name, Description, InputRecordTables,
#'   Parameters, Role, GlueVersion, MaxCapacity, WorkerType, NumberOfWorkers,
#'   Timeout, MaxRetries, Tags, TransformEncryption)
#'
#' @param Name &#91;required&#93; The unique name that you give the transform when you create it.
#' @param Description A description of the machine learning transform that is being defined.
#' The default is an empty string.
#' @param InputRecordTables &#91;required&#93; A list of AWS Glue table definitions used by the transform.
#' @param Parameters &#91;required&#93; The algorithmic parameters that are specific to the transform type used.
#' Conditionally dependent on the transform type.
#' @param Role &#91;required&#93; The name or Amazon Resource Name (ARN) of the IAM role with the required
#' permissions. The required permissions include both AWS Glue service role
#' permissions to AWS Glue resources, and Amazon S3 permissions required by
#' the transform.
#' 
#' -   This role needs AWS Glue service role permissions to allow access to
#'     resources in AWS Glue. See [Attach a Policy to IAM Users That Access
#'     AWS
#'     Glue](https://docs.aws.amazon.com/glue/latest/dg/attach-policy-iam-user.html).
#' 
#' -   This role needs permission to your Amazon Simple Storage Service
#'     (Amazon S3) sources, targets, temporary directory, scripts, and any
#'     libraries used by the task run for this transform.
#' @param GlueVersion This value determines which version of AWS Glue this machine learning
#' transform is compatible with. Glue 1.0 is recommended for most
#' customers. If the value is not set, the Glue compatibility defaults to
#' Glue 0.9. For more information, see [AWS Glue
#' Versions](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
#' in the developer guide.
#' @param MaxCapacity The number of AWS Glue data processing units (DPUs) that are allocated
#' to task runs for this transform. You can allocate from 2 to 100 DPUs;
#' the default is 10. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
#' information, see the [AWS Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' `MaxCapacity` is a mutually exclusive option with `NumberOfWorkers` and
#' `WorkerType`.
#' 
#' -   If either `NumberOfWorkers` or `WorkerType` is set, then
#'     `MaxCapacity` cannot be set.
#' 
#' -   If `MaxCapacity` is set then neither `NumberOfWorkers` or
#'     `WorkerType` can be set.
#' 
#' -   If `WorkerType` is set, then `NumberOfWorkers` is required (and vice
#'     versa).
#' 
#' -   `MaxCapacity` and `NumberOfWorkers` must both be at least 1.
#' 
#' When the `WorkerType` field is set to a value other than `Standard`, the
#' `MaxCapacity` field is set automatically and becomes read-only.
#' 
#' When the `WorkerType` field is set to a value other than `Standard`, the
#' `MaxCapacity` field is set automatically and becomes read-only.
#' @param WorkerType The type of predefined worker that is allocated when this task runs.
#' Accepts a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker provides 4 vCPU, 16 GB of
#'     memory and a 64GB disk, and 1 executor per worker.
#' 
#' -   For the `G.2X` worker type, each worker provides 8 vCPU, 32 GB of
#'     memory and a 128GB disk, and 1 executor per worker.
#' 
#' `MaxCapacity` is a mutually exclusive option with `NumberOfWorkers` and
#' `WorkerType`.
#' 
#' -   If either `NumberOfWorkers` or `WorkerType` is set, then
#'     `MaxCapacity` cannot be set.
#' 
#' -   If `MaxCapacity` is set then neither `NumberOfWorkers` or
#'     `WorkerType` can be set.
#' 
#' -   If `WorkerType` is set, then `NumberOfWorkers` is required (and vice
#'     versa).
#' 
#' -   `MaxCapacity` and `NumberOfWorkers` must both be at least 1.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' this task runs.
#' 
#' If `WorkerType` is set, then `NumberOfWorkers` is required (and vice
#' versa).
#' @param Timeout The timeout of the task run for this transform in minutes. This is the
#' maximum time that a task run for this transform can consume resources
#' before it is terminated and enters `TIMEOUT` status. The default is
#' 2,880 minutes (48 hours).
#' @param MaxRetries The maximum number of times to retry a task for this transform after a
#' task run fails.
#' @param Tags The tags to use with this machine learning transform. You may use tags
#' to limit access to the machine learning transform. For more information
#' about tags in AWS Glue, see [AWS Tags in AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param TransformEncryption The encryption-at-rest settings of the transform that apply to accessing
#' user data. Machine learning transforms can access user data encrypted in
#' Amazon S3 using KMS.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_ml_transform(
#'   Name = "string",
#'   Description = "string",
#'   InputRecordTables = list(
#'     list(
#'       DatabaseName = "string",
#'       TableName = "string",
#'       CatalogId = "string",
#'       ConnectionName = "string"
#'     )
#'   ),
#'   Parameters = list(
#'     TransformType = "FIND_MATCHES",
#'     FindMatchesParameters = list(
#'       PrimaryKeyColumnName = "string",
#'       PrecisionRecallTradeoff = 123.0,
#'       AccuracyCostTradeoff = 123.0,
#'       EnforceProvidedLabels = TRUE|FALSE
#'     )
#'   ),
#'   Role = "string",
#'   GlueVersion = "string",
#'   MaxCapacity = 123.0,
#'   WorkerType = "Standard"|"G.1X"|"G.2X",
#'   NumberOfWorkers = 123,
#'   Timeout = 123,
#'   MaxRetries = 123,
#'   Tags = list(
#'     "string"
#'   ),
#'   TransformEncryption = list(
#'     MlUserDataEncryption = list(
#'       MlUserDataEncryptionMode = "DISABLED"|"SSE-KMS",
#'       KmsKeyId = "string"
#'     ),
#'     TaskRunSecurityConfigurationName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_ml_transform
glue_create_ml_transform <- function(Name, Description = NULL, InputRecordTables, Parameters, Role, GlueVersion = NULL, MaxCapacity = NULL, WorkerType = NULL, NumberOfWorkers = NULL, Timeout = NULL, MaxRetries = NULL, Tags = NULL, TransformEncryption = NULL) {
  op <- new_operation(
    name = "CreateMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_ml_transform_input(Name = Name, Description = Description, InputRecordTables = InputRecordTables, Parameters = Parameters, Role = Role, GlueVersion = GlueVersion, MaxCapacity = MaxCapacity, WorkerType = WorkerType, NumberOfWorkers = NumberOfWorkers, Timeout = Timeout, MaxRetries = MaxRetries, Tags = Tags, TransformEncryption = TransformEncryption)
  output <- .glue$create_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_ml_transform <- glue_create_ml_transform

#' Creates a new partition
#'
#' @description
#' Creates a new partition.
#'
#' @usage
#' glue_create_partition(CatalogId, DatabaseName, TableName,
#'   PartitionInput)
#'
#' @param CatalogId The AWS account ID of the catalog in which the partition is to be
#' created.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' created.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be created.
#' @param PartitionInput &#91;required&#93; A `PartitionInput` structure defining the partition to be created.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionInput = list(
#'     Values = list(
#'       "string"
#'     ),
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE,
#'       SchemaReference = list(
#'         SchemaId = list(
#'           SchemaArn = "string",
#'           SchemaName = "string",
#'           RegistryName = "string"
#'         ),
#'         SchemaVersionId = "string",
#'         SchemaVersionNumber = 123
#'       )
#'     ),
#'     Parameters = list(
#'       "string"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_partition
glue_create_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionInput) {
  op <- new_operation(
    name = "CreatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionInput = PartitionInput)
  output <- .glue$create_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_partition <- glue_create_partition

#' Creates a specified partition index in an existing table
#'
#' @description
#' Creates a specified partition index in an existing table.
#'
#' @usage
#' glue_create_partition_index(CatalogId, DatabaseName, TableName,
#'   PartitionIndex)
#'
#' @param CatalogId The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; Specifies the name of a database in which you want to create a partition
#' index.
#' @param TableName &#91;required&#93; Specifies the name of a table in which you want to create a partition
#' index.
#' @param PartitionIndex &#91;required&#93; Specifies a `PartitionIndex` structure to create a partition index in an
#' existing table.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_partition_index(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionIndex = list(
#'     Keys = list(
#'       "string"
#'     ),
#'     IndexName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_partition_index
glue_create_partition_index <- function(CatalogId = NULL, DatabaseName, TableName, PartitionIndex) {
  op <- new_operation(
    name = "CreatePartitionIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_partition_index_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionIndex = PartitionIndex)
  output <- .glue$create_partition_index_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_partition_index <- glue_create_partition_index

#' Creates a new registry which may be used to hold a collection of schemas
#'
#' @description
#' Creates a new registry which may be used to hold a collection of
#' schemas.
#'
#' @usage
#' glue_create_registry(RegistryName, Description, Tags)
#'
#' @param RegistryName &#91;required&#93; Name of the registry to be created of max length of 255, and may only
#' contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.
#' No whitespace.
#' @param Description A description of the registry. If description is not provided, there
#' will not be any default value for this.
#' @param Tags AWS tags that contain a key value pair and may be searched by console,
#' command line, or API.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegistryArn = "string",
#'   RegistryName = "string",
#'   Description = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_registry(
#'   RegistryName = "string",
#'   Description = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_registry
glue_create_registry <- function(RegistryName, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_registry_input(RegistryName = RegistryName, Description = Description, Tags = Tags)
  output <- .glue$create_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_registry <- glue_create_registry

#' Creates a new schema set and registers the schema definition
#'
#' @description
#' Creates a new schema set and registers the schema definition. Returns an
#' error if the schema set already exists without actually registering the
#' version.
#' 
#' When the schema set is created, a version checkpoint will be set to the
#' first version. Compatibility mode "DISABLED" restricts any additional
#' schema versions from being added after the first schema version. For all
#' other compatibility modes, validation of compatibility settings will be
#' applied only from the second version onwards when the
#' [`register_schema_version`][glue_register_schema_version] API is used.
#' 
#' When this API is called without a `RegistryId`, this will create an
#' entry for a "default-registry" in the registry database tables, if it is
#' not already present.
#'
#' @usage
#' glue_create_schema(RegistryId, SchemaName, DataFormat, Compatibility,
#'   Description, Tags, SchemaDefinition)
#'
#' @param RegistryId This is a wrapper shape to contain the registry identity fields. If this
#' is not provided, the default registry will be used. The ARN format for
#' the same will be:
#' `arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id`.
#' @param SchemaName &#91;required&#93; Name of the schema to be created of max length of 255, and may only
#' contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.
#' No whitespace.
#' @param DataFormat &#91;required&#93; The data format of the schema definition. Currently only `AVRO` is
#' supported.
#' @param Compatibility The compatibility mode of the schema. The possible values are:
#' 
#' -   *NONE*: No compatibility mode applies. You can use this choice in
#'     development scenarios or if you do not know the compatibility mode
#'     that you want to apply to schemas. Any new version added will be
#'     accepted without undergoing a compatibility check.
#' 
#' -   *DISABLED*: This compatibility choice prevents versioning for a
#'     particular schema. You can use this choice to prevent future
#'     versioning of a schema.
#' 
#' -   *BACKWARD*: This compatibility choice is recommended as it allows
#'     data receivers to read both the current and one previous schema
#'     version. This means that for instance, a new schema version cannot
#'     drop data fields or change the type of these fields, so they can't
#'     be read by readers using the previous version.
#' 
#' -   *BACKWARD_ALL*: This compatibility choice allows data receivers to
#'     read both the current and all previous schema versions. You can use
#'     this choice when you need to delete fields or add optional fields,
#'     and check compatibility against all previous schema versions.
#' 
#' -   *FORWARD*: This compatibility choice allows data receivers to read
#'     both the current and one next schema version, but not necessarily
#'     later versions. You can use this choice when you need to add fields
#'     or delete optional fields, but only check compatibility against the
#'     last schema version.
#' 
#' -   *FORWARD_ALL*: This compatibility choice allows data receivers to
#'     read written by producers of any new registered schema. You can use
#'     this choice when you need to add fields or delete optional fields,
#'     and check compatibility against all previous schema versions.
#' 
#' -   *FULL*: This compatibility choice allows data receivers to read data
#'     written by producers using the previous or next version of the
#'     schema, but not necessarily earlier or later versions. You can use
#'     this choice when you need to add or remove optional fields, but only
#'     check compatibility against the last schema version.
#' 
#' -   *FULL_ALL*: This compatibility choice allows data receivers to read
#'     data written by producers using all previous schema versions. You
#'     can use this choice when you need to add or remove optional fields,
#'     and check compatibility against all previous schema versions.
#' @param Description An optional description of the schema. If description is not provided,
#' there will not be any automatic default value for this.
#' @param Tags AWS tags that contain a key value pair and may be searched by console,
#' command line, or API. If specified, follows the AWS tags-on-create
#' pattern.
#' @param SchemaDefinition The schema definition using the `DataFormat` setting for `SchemaName`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegistryName = "string",
#'   RegistryArn = "string",
#'   SchemaName = "string",
#'   SchemaArn = "string",
#'   Description = "string",
#'   DataFormat = "AVRO",
#'   Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
#'   SchemaCheckpoint = 123,
#'   LatestSchemaVersion = 123,
#'   NextSchemaVersion = 123,
#'   SchemaStatus = "AVAILABLE"|"PENDING"|"DELETING",
#'   Tags = list(
#'     "string"
#'   ),
#'   SchemaVersionId = "string",
#'   SchemaVersionStatus = "AVAILABLE"|"PENDING"|"FAILURE"|"DELETING"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_schema(
#'   RegistryId = list(
#'     RegistryName = "string",
#'     RegistryArn = "string"
#'   ),
#'   SchemaName = "string",
#'   DataFormat = "AVRO",
#'   Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
#'   Description = "string",
#'   Tags = list(
#'     "string"
#'   ),
#'   SchemaDefinition = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_schema
glue_create_schema <- function(RegistryId = NULL, SchemaName, DataFormat, Compatibility = NULL, Description = NULL, Tags = NULL, SchemaDefinition = NULL) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_schema_input(RegistryId = RegistryId, SchemaName = SchemaName, DataFormat = DataFormat, Compatibility = Compatibility, Description = Description, Tags = Tags, SchemaDefinition = SchemaDefinition)
  output <- .glue$create_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_schema <- glue_create_schema

#' Transforms a directed acyclic graph (DAG) into code
#'
#' @description
#' Transforms a directed acyclic graph (DAG) into code.
#'
#' @usage
#' glue_create_script(DagNodes, DagEdges, Language)
#'
#' @param DagNodes A list of the nodes in the DAG.
#' @param DagEdges A list of the edges in the DAG.
#' @param Language The programming language of the resulting code from the DAG.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PythonScript = "string",
#'   ScalaCode = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_script(
#'   DagNodes = list(
#'     list(
#'       Id = "string",
#'       NodeType = "string",
#'       Args = list(
#'         list(
#'           Name = "string",
#'           Value = "string",
#'           Param = TRUE|FALSE
#'         )
#'       ),
#'       LineNumber = 123
#'     )
#'   ),
#'   DagEdges = list(
#'     list(
#'       Source = "string",
#'       Target = "string",
#'       TargetParameter = "string"
#'     )
#'   ),
#'   Language = "PYTHON"|"SCALA"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_script
glue_create_script <- function(DagNodes = NULL, DagEdges = NULL, Language = NULL) {
  op <- new_operation(
    name = "CreateScript",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_script_input(DagNodes = DagNodes, DagEdges = DagEdges, Language = Language)
  output <- .glue$create_script_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_script <- glue_create_script

#' Creates a new security configuration
#'
#' @description
#' Creates a new security configuration. A security configuration is a set
#' of security properties that can be used by AWS Glue. You can use a
#' security configuration to encrypt data at rest. For information about
#' using security configurations in AWS Glue, see [Encrypting Data Written
#' by Crawlers, Jobs, and Development
#' Endpoints](https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html).
#'
#' @usage
#' glue_create_security_configuration(Name, EncryptionConfiguration)
#'
#' @param Name &#91;required&#93; The name for the new security configuration.
#' @param EncryptionConfiguration &#91;required&#93; The encryption configuration for the new security configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string",
#'   CreatedTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_security_configuration(
#'   Name = "string",
#'   EncryptionConfiguration = list(
#'     S3Encryption = list(
#'       list(
#'         S3EncryptionMode = "DISABLED"|"SSE-KMS"|"SSE-S3",
#'         KmsKeyArn = "string"
#'       )
#'     ),
#'     CloudWatchEncryption = list(
#'       CloudWatchEncryptionMode = "DISABLED"|"SSE-KMS",
#'       KmsKeyArn = "string"
#'     ),
#'     JobBookmarksEncryption = list(
#'       JobBookmarksEncryptionMode = "DISABLED"|"CSE-KMS",
#'       KmsKeyArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_security_configuration
glue_create_security_configuration <- function(Name, EncryptionConfiguration) {
  op <- new_operation(
    name = "CreateSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_security_configuration_input(Name = Name, EncryptionConfiguration = EncryptionConfiguration)
  output <- .glue$create_security_configuration_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_security_configuration <- glue_create_security_configuration

#' Creates a new table definition in the Data Catalog
#'
#' @description
#' Creates a new table definition in the Data Catalog.
#'
#' @usage
#' glue_create_table(CatalogId, DatabaseName, TableInput, PartitionIndexes)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the `Table`. If none is
#' supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The catalog database in which to create the new table. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableInput &#91;required&#93; The `TableInput` object that defines the metadata table to create in the
#' catalog.
#' @param PartitionIndexes A list of partition indexes, `PartitionIndex` structures, to create in
#' the table.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableInput = list(
#'     Name = "string",
#'     Description = "string",
#'     Owner = "string",
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Retention = 123,
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE,
#'       SchemaReference = list(
#'         SchemaId = list(
#'           SchemaArn = "string",
#'           SchemaName = "string",
#'           RegistryName = "string"
#'         ),
#'         SchemaVersionId = "string",
#'         SchemaVersionNumber = 123
#'       )
#'     ),
#'     PartitionKeys = list(
#'       list(
#'         Name = "string",
#'         Type = "string",
#'         Comment = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     ViewOriginalText = "string",
#'     ViewExpandedText = "string",
#'     TableType = "string",
#'     Parameters = list(
#'       "string"
#'     ),
#'     TargetTable = list(
#'       CatalogId = "string",
#'       DatabaseName = "string",
#'       Name = "string"
#'     )
#'   ),
#'   PartitionIndexes = list(
#'     list(
#'       Keys = list(
#'         "string"
#'       ),
#'       IndexName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_table
glue_create_table <- function(CatalogId = NULL, DatabaseName, TableInput, PartitionIndexes = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableInput = TableInput, PartitionIndexes = PartitionIndexes)
  output <- .glue$create_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_table <- glue_create_table

#' Creates a new trigger
#'
#' @description
#' Creates a new trigger.
#'
#' @usage
#' glue_create_trigger(Name, WorkflowName, Type, Schedule, Predicate,
#'   Actions, Description, StartOnCreation, Tags)
#'
#' @param Name &#91;required&#93; The name of the trigger.
#' @param WorkflowName The name of the workflow associated with the trigger.
#' @param Type &#91;required&#93; The type of the new trigger.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' 
#' This field is required when the trigger type is SCHEDULED.
#' @param Predicate A predicate to specify when the new trigger should fire.
#' 
#' This field is required when the trigger type is `CONDITIONAL`.
#' @param Actions &#91;required&#93; The actions initiated by this trigger when it fires.
#' @param Description A description of the new trigger.
#' @param StartOnCreation Set to `true` to start `SCHEDULED` and `CONDITIONAL` triggers when
#' created. True is not supported for `ON_DEMAND` triggers.
#' @param Tags The tags to use with this trigger. You may use tags to limit access to
#' the trigger. For more information about tags in AWS Glue, see [AWS Tags
#' in AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_trigger(
#'   Name = "string",
#'   WorkflowName = "string",
#'   Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'   Schedule = "string",
#'   Predicate = list(
#'     Logical = "AND"|"ANY",
#'     Conditions = list(
#'       list(
#'         LogicalOperator = "EQUALS",
#'         JobName = "string",
#'         State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'         CrawlerName = "string",
#'         CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'       )
#'     )
#'   ),
#'   Actions = list(
#'     list(
#'       JobName = "string",
#'       Arguments = list(
#'         "string"
#'       ),
#'       Timeout = 123,
#'       SecurityConfiguration = "string",
#'       NotificationProperty = list(
#'         NotifyDelayAfter = 123
#'       ),
#'       CrawlerName = "string"
#'     )
#'   ),
#'   Description = "string",
#'   StartOnCreation = TRUE|FALSE,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_trigger
glue_create_trigger <- function(Name, WorkflowName = NULL, Type, Schedule = NULL, Predicate = NULL, Actions, Description = NULL, StartOnCreation = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_trigger_input(Name = Name, WorkflowName = WorkflowName, Type = Type, Schedule = Schedule, Predicate = Predicate, Actions = Actions, Description = Description, StartOnCreation = StartOnCreation, Tags = Tags)
  output <- .glue$create_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_trigger <- glue_create_trigger

#' Creates a new function definition in the Data Catalog
#'
#' @description
#' Creates a new function definition in the Data Catalog.
#'
#' @usage
#' glue_create_user_defined_function(CatalogId, DatabaseName,
#'   FunctionInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the function. If none is
#' provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which to create the function.
#' @param FunctionInput &#91;required&#93; A `FunctionInput` object that defines the function to create in the Data
#' Catalog.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$create_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionInput = list(
#'     FunctionName = "string",
#'     ClassName = "string",
#'     OwnerName = "string",
#'     OwnerType = "USER"|"ROLE"|"GROUP",
#'     ResourceUris = list(
#'       list(
#'         ResourceType = "JAR"|"FILE"|"ARCHIVE",
#'         Uri = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_user_defined_function
glue_create_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionInput) {
  op <- new_operation(
    name = "CreateUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionInput = FunctionInput)
  output <- .glue$create_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_user_defined_function <- glue_create_user_defined_function

#' Creates a new workflow
#'
#' @description
#' Creates a new workflow.
#'
#' @usage
#' glue_create_workflow(Name, Description, DefaultRunProperties, Tags,
#'   MaxConcurrentRuns)
#'
#' @param Name &#91;required&#93; The name to be assigned to the workflow. It should be unique within your
#' account.
#' @param Description A description of the workflow.
#' @param DefaultRunProperties A collection of properties to be used as part of each execution of the
#' workflow.
#' @param Tags The tags to be used with this workflow.
#' @param MaxConcurrentRuns You can use this parameter to prevent unwanted multiple updates to data,
#' to control costs, or in some cases, to prevent exceeding the maximum
#' number of concurrent runs of any of the component jobs. If you leave
#' this parameter blank, there is no limit to the number of concurrent
#' workflow runs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_workflow(
#'   Name = "string",
#'   Description = "string",
#'   DefaultRunProperties = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   ),
#'   MaxConcurrentRuns = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_workflow
glue_create_workflow <- function(Name, Description = NULL, DefaultRunProperties = NULL, Tags = NULL, MaxConcurrentRuns = NULL) {
  op <- new_operation(
    name = "CreateWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_workflow_input(Name = Name, Description = Description, DefaultRunProperties = DefaultRunProperties, Tags = Tags, MaxConcurrentRuns = MaxConcurrentRuns)
  output <- .glue$create_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_workflow <- glue_create_workflow

#' Removes a classifier from the Data Catalog
#'
#' @description
#' Removes a classifier from the Data Catalog.
#'
#' @usage
#' glue_delete_classifier(Name)
#'
#' @param Name &#91;required&#93; Name of the classifier to remove.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_classifier(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_classifier
glue_delete_classifier <- function(Name) {
  op <- new_operation(
    name = "DeleteClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_classifier_input(Name = Name)
  output <- .glue$delete_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_classifier <- glue_delete_classifier

#' Delete the partition column statistics of a column
#'
#' @description
#' Delete the partition column statistics of a column.
#' 
#' The Identity and Access Management (IAM) permission required for this
#' operation is [`delete_partition`][glue_delete_partition].
#'
#' @usage
#' glue_delete_column_statistics_for_partition(CatalogId, DatabaseName,
#'   TableName, PartitionValues, ColumnName)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionValues &#91;required&#93; A list of partition values identifying the partition.
#' @param ColumnName &#91;required&#93; Name of the column.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_column_statistics_for_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   ),
#'   ColumnName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_column_statistics_for_partition
glue_delete_column_statistics_for_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues, ColumnName) {
  op <- new_operation(
    name = "DeleteColumnStatisticsForPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_column_statistics_for_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, ColumnName = ColumnName)
  output <- .glue$delete_column_statistics_for_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_column_statistics_for_partition <- glue_delete_column_statistics_for_partition

#' Retrieves table statistics of columns
#'
#' @description
#' Retrieves table statistics of columns.
#' 
#' The Identity and Access Management (IAM) permission required for this
#' operation is [`delete_table`][glue_delete_table].
#'
#' @usage
#' glue_delete_column_statistics_for_table(CatalogId, DatabaseName,
#'   TableName, ColumnName)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param ColumnName &#91;required&#93; The name of the column.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_column_statistics_for_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   ColumnName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_column_statistics_for_table
glue_delete_column_statistics_for_table <- function(CatalogId = NULL, DatabaseName, TableName, ColumnName) {
  op <- new_operation(
    name = "DeleteColumnStatisticsForTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_column_statistics_for_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, ColumnName = ColumnName)
  output <- .glue$delete_column_statistics_for_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_column_statistics_for_table <- glue_delete_column_statistics_for_table

#' Deletes a connection from the Data Catalog
#'
#' @description
#' Deletes a connection from the Data Catalog.
#'
#' @usage
#' glue_delete_connection(CatalogId, ConnectionName)
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the AWS account ID is used by default.
#' @param ConnectionName &#91;required&#93; The name of the connection to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_connection(
#'   CatalogId = "string",
#'   ConnectionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_connection
glue_delete_connection <- function(CatalogId = NULL, ConnectionName) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_connection_input(CatalogId = CatalogId, ConnectionName = ConnectionName)
  output <- .glue$delete_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_connection <- glue_delete_connection

#' Removes a specified crawler from the AWS Glue Data Catalog, unless the
#' crawler state is RUNNING
#'
#' @description
#' Removes a specified crawler from the AWS Glue Data Catalog, unless the
#' crawler state is `RUNNING`.
#'
#' @usage
#' glue_delete_crawler(Name)
#'
#' @param Name &#91;required&#93; The name of the crawler to remove.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_crawler
glue_delete_crawler <- function(Name) {
  op <- new_operation(
    name = "DeleteCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_crawler_input(Name = Name)
  output <- .glue$delete_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_crawler <- glue_delete_crawler

#' Removes a specified database from a Data Catalog
#'
#' @description
#' Removes a specified database from a Data Catalog.
#' 
#' After completing this operation, you no longer have access to the tables
#' (and all table versions and partitions that might belong to the tables)
#' and the user-defined functions in the deleted database. AWS Glue deletes
#' these "orphaned" resources asynchronously in a timely manner, at the
#' discretion of the service.
#' 
#' To ensure the immediate deletion of all related resources, before
#' calling [`delete_database`][glue_delete_database], use
#' [`delete_table_version`][glue_delete_table_version] or
#' [`batch_delete_table_version`][glue_batch_delete_table_version],
#' [`delete_partition`][glue_delete_partition] or
#' [`batch_delete_partition`][glue_batch_delete_partition],
#' [`delete_user_defined_function`][glue_delete_user_defined_function], and
#' [`delete_table`][glue_delete_table] or
#' [`batch_delete_table`][glue_batch_delete_table], to delete any resources
#' that belong to the database.
#'
#' @usage
#' glue_delete_database(CatalogId, Name)
#'
#' @param CatalogId The ID of the Data Catalog in which the database resides. If none is
#' provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to delete. For Hive compatibility, this must be
#' all lowercase.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_database(
#'   CatalogId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_database
glue_delete_database <- function(CatalogId = NULL, Name) {
  op <- new_operation(
    name = "DeleteDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_database_input(CatalogId = CatalogId, Name = Name)
  output <- .glue$delete_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_database <- glue_delete_database

#' Deletes a specified development endpoint
#'
#' @description
#' Deletes a specified development endpoint.
#'
#' @usage
#' glue_delete_dev_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; The name of the `DevEndpoint`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dev_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_dev_endpoint
glue_delete_dev_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_dev_endpoint_input(EndpointName = EndpointName)
  output <- .glue$delete_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_dev_endpoint <- glue_delete_dev_endpoint

#' Deletes a specified job definition
#'
#' @description
#' Deletes a specified job definition. If the job definition is not found,
#' no exception is thrown.
#'
#' @usage
#' glue_delete_job(JobName)
#'
#' @param JobName &#91;required&#93; The name of the job definition to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_job(
#'   JobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_job
glue_delete_job <- function(JobName) {
  op <- new_operation(
    name = "DeleteJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_job_input(JobName = JobName)
  output <- .glue$delete_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_job <- glue_delete_job

#' Deletes an AWS Glue machine learning transform
#'
#' @description
#' Deletes an AWS Glue machine learning transform. Machine learning
#' transforms are a special type of transform that use machine learning to
#' learn the details of the transformation to be performed by learning from
#' examples provided by humans. These transformations are then saved by AWS
#' Glue. If you no longer need a transform, you can delete it by calling
#' `DeleteMLTransforms`. However, any AWS Glue jobs that still reference
#' the deleted transform will no longer succeed.
#'
#' @usage
#' glue_delete_ml_transform(TransformId)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the transform to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_ml_transform(
#'   TransformId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_ml_transform
glue_delete_ml_transform <- function(TransformId) {
  op <- new_operation(
    name = "DeleteMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_ml_transform_input(TransformId = TransformId)
  output <- .glue$delete_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_ml_transform <- glue_delete_ml_transform

#' Deletes a specified partition
#'
#' @description
#' Deletes a specified partition.
#'
#' @usage
#' glue_delete_partition(CatalogId, DatabaseName, TableName,
#'   PartitionValues)
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be deleted resides. If
#' none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table that contains the partition to be deleted.
#' @param PartitionValues &#91;required&#93; The values that define the partition.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_partition
glue_delete_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues) {
  op <- new_operation(
    name = "DeletePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues)
  output <- .glue$delete_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_partition <- glue_delete_partition

#' Deletes a specified partition index from an existing table
#'
#' @description
#' Deletes a specified partition index from an existing table.
#'
#' @usage
#' glue_delete_partition_index(CatalogId, DatabaseName, TableName,
#'   IndexName)
#'
#' @param CatalogId The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; Specifies the name of a database from which you want to delete a
#' partition index.
#' @param TableName &#91;required&#93; Specifies the name of a table from which you want to delete a partition
#' index.
#' @param IndexName &#91;required&#93; The name of the partition index to be deleted.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_partition_index(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   IndexName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_partition_index
glue_delete_partition_index <- function(CatalogId = NULL, DatabaseName, TableName, IndexName) {
  op <- new_operation(
    name = "DeletePartitionIndex",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_partition_index_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, IndexName = IndexName)
  output <- .glue$delete_partition_index_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_partition_index <- glue_delete_partition_index

#' Delete the entire registry including schema and all of its versions
#'
#' @description
#' Delete the entire registry including schema and all of its versions. To
#' get the status of the delete operation, you can call the
#' [`get_registry`][glue_get_registry] API after the asynchronous call.
#' Deleting a registry will disable all online operations for the registry
#' such as the [`update_registry`][glue_update_registry],
#' [`create_schema`][glue_create_schema],
#' [`update_schema`][glue_update_schema], and
#' [`register_schema_version`][glue_register_schema_version] APIs.
#'
#' @usage
#' glue_delete_registry(RegistryId)
#'
#' @param RegistryId &#91;required&#93; This is a wrapper structure that may contain the registry name and
#' Amazon Resource Name (ARN).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegistryName = "string",
#'   RegistryArn = "string",
#'   Status = "AVAILABLE"|"DELETING"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_registry(
#'   RegistryId = list(
#'     RegistryName = "string",
#'     RegistryArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_registry
glue_delete_registry <- function(RegistryId) {
  op <- new_operation(
    name = "DeleteRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_registry_input(RegistryId = RegistryId)
  output <- .glue$delete_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_registry <- glue_delete_registry

#' Deletes a specified policy
#'
#' @description
#' Deletes a specified policy.
#'
#' @usage
#' glue_delete_resource_policy(PolicyHashCondition, ResourceArn)
#'
#' @param PolicyHashCondition The hash value returned when this policy was set.
#' @param ResourceArn The ARN of the AWS Glue resource for the resource policy to be deleted.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_policy(
#'   PolicyHashCondition = "string",
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_resource_policy
glue_delete_resource_policy <- function(PolicyHashCondition = NULL, ResourceArn = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_resource_policy_input(PolicyHashCondition = PolicyHashCondition, ResourceArn = ResourceArn)
  output <- .glue$delete_resource_policy_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_resource_policy <- glue_delete_resource_policy

#' Deletes the entire schema set, including the schema set and all of its
#' versions
#'
#' @description
#' Deletes the entire schema set, including the schema set and all of its
#' versions. To get the status of the delete operation, you can call
#' [`get_schema`][glue_get_schema] API after the asynchronous call.
#' Deleting a registry will disable all online operations for the schema,
#' such as the [`get_schema_by_definition`][glue_get_schema_by_definition],
#' and [`register_schema_version`][glue_register_schema_version] APIs.
#'
#' @usage
#' glue_delete_schema(SchemaId)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure that may contain the schema name and Amazon
#' Resource Name (ARN).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaArn = "string",
#'   SchemaName = "string",
#'   Status = "AVAILABLE"|"PENDING"|"DELETING"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_schema(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_schema
glue_delete_schema <- function(SchemaId) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_schema_input(SchemaId = SchemaId)
  output <- .glue$delete_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_schema <- glue_delete_schema

#' Remove versions from the specified schema
#'
#' @description
#' Remove versions from the specified schema. A version number or range may
#' be supplied. If the compatibility mode forbids deleting of a version
#' that is necessary, such as BACKWARDS_FULL, an error is returned.
#' Calling the `GetSchemaVersions` API after this call will list the status
#' of the deleted versions.
#' 
#' When the range of version numbers contain check pointed version, the API
#' will return a 409 conflict and will not proceed with the deletion. You
#' have to remove the checkpoint first using the `DeleteSchemaCheckpoint`
#' API before using this API.
#' 
#' You cannot use the
#' [`delete_schema_versions`][glue_delete_schema_versions] API to delete
#' the first schema version in the schema set. The first schema version can
#' only be deleted by the [`delete_schema`][glue_delete_schema] API. This
#' operation will also delete the attached `SchemaVersionMetadata` under
#' the schema versions. Hard deletes will be enforced on the database.
#' 
#' If the compatibility mode forbids deleting of a version that is
#' necessary, such as BACKWARDS_FULL, an error is returned.
#'
#' @usage
#' glue_delete_schema_versions(SchemaId, Versions)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure that may contain the schema name and Amazon
#' Resource Name (ARN).
#' @param Versions &#91;required&#93; A version range may be supplied which may be of the format:
#' 
#' -   a single version number, 5
#' 
#' -   a range, 5-8 : deletes versions 5, 6, 7, 8
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaVersionErrors = list(
#'     list(
#'       VersionNumber = 123,
#'       ErrorDetails = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_schema_versions(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   Versions = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_schema_versions
glue_delete_schema_versions <- function(SchemaId, Versions) {
  op <- new_operation(
    name = "DeleteSchemaVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_schema_versions_input(SchemaId = SchemaId, Versions = Versions)
  output <- .glue$delete_schema_versions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_schema_versions <- glue_delete_schema_versions

#' Deletes a specified security configuration
#'
#' @description
#' Deletes a specified security configuration.
#'
#' @usage
#' glue_delete_security_configuration(Name)
#'
#' @param Name &#91;required&#93; The name of the security configuration to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_security_configuration(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_security_configuration
glue_delete_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DeleteSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_security_configuration_input(Name = Name)
  output <- .glue$delete_security_configuration_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_security_configuration <- glue_delete_security_configuration

#' Removes a table definition from the Data Catalog
#'
#' @description
#' Removes a table definition from the Data Catalog.
#' 
#' After completing this operation, you no longer have access to the table
#' versions and partitions that belong to the deleted table. AWS Glue
#' deletes these "orphaned" resources asynchronously in a timely manner, at
#' the discretion of the service.
#' 
#' To ensure the immediate deletion of all related resources, before
#' calling [`delete_table`][glue_delete_table], use
#' [`delete_table_version`][glue_delete_table_version] or
#' [`batch_delete_table_version`][glue_batch_delete_table_version], and
#' [`delete_partition`][glue_delete_partition] or
#' [`batch_delete_partition`][glue_batch_delete_partition], to delete any
#' resources that belong to the table.
#'
#' @usage
#' glue_delete_table(CatalogId, DatabaseName, Name)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param Name &#91;required&#93; The name of the table to be deleted. For Hive compatibility, this name
#' is entirely lowercase.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_table
glue_delete_table <- function(CatalogId = NULL, DatabaseName, Name) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name)
  output <- .glue$delete_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table <- glue_delete_table

#' Deletes a specified version of a table
#'
#' @description
#' Deletes a specified version of a table.
#'
#' @usage
#' glue_delete_table_version(CatalogId, DatabaseName, TableName, VersionId)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionId &#91;required&#93; The ID of the table version to be deleted. A `VersionID` is a string
#' representation of an integer. Each version is incremented by 1.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_table_version(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_table_version
glue_delete_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionId) {
  op <- new_operation(
    name = "DeleteTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionId = VersionId)
  output <- .glue$delete_table_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table_version <- glue_delete_table_version

#' Deletes a specified trigger
#'
#' @description
#' Deletes a specified trigger. If the trigger is not found, no exception
#' is thrown.
#'
#' @usage
#' glue_delete_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_trigger
glue_delete_trigger <- function(Name) {
  op <- new_operation(
    name = "DeleteTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_trigger_input(Name = Name)
  output <- .glue$delete_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_trigger <- glue_delete_trigger

#' Deletes an existing function definition from the Data Catalog
#'
#' @description
#' Deletes an existing function definition from the Data Catalog.
#'
#' @usage
#' glue_delete_user_defined_function(CatalogId, DatabaseName, FunctionName)
#'
#' @param CatalogId The ID of the Data Catalog where the function to be deleted is located.
#' If none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function is located.
#' @param FunctionName &#91;required&#93; The name of the function definition to be deleted.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_user_defined_function
glue_delete_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName) {
  op <- new_operation(
    name = "DeleteUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName)
  output <- .glue$delete_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_user_defined_function <- glue_delete_user_defined_function

#' Deletes a workflow
#'
#' @description
#' Deletes a workflow.
#'
#' @usage
#' glue_delete_workflow(Name)
#'
#' @param Name &#91;required&#93; Name of the workflow to be deleted.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_workflow(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_workflow
glue_delete_workflow <- function(Name) {
  op <- new_operation(
    name = "DeleteWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_workflow_input(Name = Name)
  output <- .glue$delete_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_workflow <- glue_delete_workflow

#' Retrieves the status of a migration operation
#'
#' @description
#' Retrieves the status of a migration operation.
#'
#' @usage
#' glue_get_catalog_import_status(CatalogId)
#'
#' @param CatalogId The ID of the catalog to migrate. Currently, this should be the AWS
#' account ID.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ImportStatus = list(
#'     ImportCompleted = TRUE|FALSE,
#'     ImportTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ImportedBy = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_catalog_import_status(
#'   CatalogId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_catalog_import_status
glue_get_catalog_import_status <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetCatalogImportStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_catalog_import_status_input(CatalogId = CatalogId)
  output <- .glue$get_catalog_import_status_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_catalog_import_status <- glue_get_catalog_import_status

#' Retrieve a classifier by name
#'
#' @description
#' Retrieve a classifier by name.
#'
#' @usage
#' glue_get_classifier(Name)
#'
#' @param Name &#91;required&#93; Name of the classifier to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Classifier = list(
#'     GrokClassifier = list(
#'       Name = "string",
#'       Classification = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Version = 123,
#'       GrokPattern = "string",
#'       CustomPatterns = "string"
#'     ),
#'     XMLClassifier = list(
#'       Name = "string",
#'       Classification = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Version = 123,
#'       RowTag = "string"
#'     ),
#'     JsonClassifier = list(
#'       Name = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Version = 123,
#'       JsonPath = "string"
#'     ),
#'     CsvClassifier = list(
#'       Name = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Version = 123,
#'       Delimiter = "string",
#'       QuoteSymbol = "string",
#'       ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
#'       Header = list(
#'         "string"
#'       ),
#'       DisableValueTrimming = TRUE|FALSE,
#'       AllowSingleColumn = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_classifier(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_classifier
glue_get_classifier <- function(Name) {
  op <- new_operation(
    name = "GetClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_classifier_input(Name = Name)
  output <- .glue$get_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_classifier <- glue_get_classifier

#' Lists all classifier objects in the Data Catalog
#'
#' @description
#' Lists all classifier objects in the Data Catalog.
#'
#' @usage
#' glue_get_classifiers(MaxResults, NextToken)
#'
#' @param MaxResults The size of the list to return (optional).
#' @param NextToken An optional continuation token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Classifiers = list(
#'     list(
#'       GrokClassifier = list(
#'         Name = "string",
#'         Classification = "string",
#'         CreationTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         LastUpdated = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Version = 123,
#'         GrokPattern = "string",
#'         CustomPatterns = "string"
#'       ),
#'       XMLClassifier = list(
#'         Name = "string",
#'         Classification = "string",
#'         CreationTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         LastUpdated = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Version = 123,
#'         RowTag = "string"
#'       ),
#'       JsonClassifier = list(
#'         Name = "string",
#'         CreationTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         LastUpdated = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Version = 123,
#'         JsonPath = "string"
#'       ),
#'       CsvClassifier = list(
#'         Name = "string",
#'         CreationTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         LastUpdated = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Version = 123,
#'         Delimiter = "string",
#'         QuoteSymbol = "string",
#'         ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
#'         Header = list(
#'           "string"
#'         ),
#'         DisableValueTrimming = TRUE|FALSE,
#'         AllowSingleColumn = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_classifiers(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_classifiers
glue_get_classifiers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetClassifiers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_classifiers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_classifiers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_classifiers <- glue_get_classifiers

#' Retrieves partition statistics of columns
#'
#' @description
#' Retrieves partition statistics of columns.
#' 
#' The Identity and Access Management (IAM) permission required for this
#' operation is [`get_partition`][glue_get_partition].
#'
#' @usage
#' glue_get_column_statistics_for_partition(CatalogId, DatabaseName,
#'   TableName, PartitionValues, ColumnNames)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionValues &#91;required&#93; A list of partition values identifying the partition.
#' @param ColumnNames &#91;required&#93; A list of the column names.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ColumnStatisticsList = list(
#'     list(
#'       ColumnName = "string",
#'       ColumnType = "string",
#'       AnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StatisticsData = list(
#'         Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
#'         BooleanColumnStatisticsData = list(
#'           NumberOfTrues = 123,
#'           NumberOfFalses = 123,
#'           NumberOfNulls = 123
#'         ),
#'         DateColumnStatisticsData = list(
#'           MinimumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           MaximumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DecimalColumnStatisticsData = list(
#'           MinimumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           MaximumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DoubleColumnStatisticsData = list(
#'           MinimumValue = 123.0,
#'           MaximumValue = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         LongColumnStatisticsData = list(
#'           MinimumValue = 123,
#'           MaximumValue = 123,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         StringColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         BinaryColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123
#'         )
#'       )
#'     )
#'   ),
#'   Errors = list(
#'     list(
#'       ColumnName = "string",
#'       Error = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_column_statistics_for_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   ),
#'   ColumnNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_column_statistics_for_partition
glue_get_column_statistics_for_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues, ColumnNames) {
  op <- new_operation(
    name = "GetColumnStatisticsForPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_column_statistics_for_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, ColumnNames = ColumnNames)
  output <- .glue$get_column_statistics_for_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_column_statistics_for_partition <- glue_get_column_statistics_for_partition

#' Retrieves table statistics of columns
#'
#' @description
#' Retrieves table statistics of columns.
#' 
#' The Identity and Access Management (IAM) permission required for this
#' operation is [`get_table`][glue_get_table].
#'
#' @usage
#' glue_get_column_statistics_for_table(CatalogId, DatabaseName, TableName,
#'   ColumnNames)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param ColumnNames &#91;required&#93; A list of the column names.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ColumnStatisticsList = list(
#'     list(
#'       ColumnName = "string",
#'       ColumnType = "string",
#'       AnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StatisticsData = list(
#'         Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
#'         BooleanColumnStatisticsData = list(
#'           NumberOfTrues = 123,
#'           NumberOfFalses = 123,
#'           NumberOfNulls = 123
#'         ),
#'         DateColumnStatisticsData = list(
#'           MinimumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           MaximumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DecimalColumnStatisticsData = list(
#'           MinimumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           MaximumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DoubleColumnStatisticsData = list(
#'           MinimumValue = 123.0,
#'           MaximumValue = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         LongColumnStatisticsData = list(
#'           MinimumValue = 123,
#'           MaximumValue = 123,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         StringColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         BinaryColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123
#'         )
#'       )
#'     )
#'   ),
#'   Errors = list(
#'     list(
#'       ColumnName = "string",
#'       Error = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_column_statistics_for_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   ColumnNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_column_statistics_for_table
glue_get_column_statistics_for_table <- function(CatalogId = NULL, DatabaseName, TableName, ColumnNames) {
  op <- new_operation(
    name = "GetColumnStatisticsForTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_column_statistics_for_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, ColumnNames = ColumnNames)
  output <- .glue$get_column_statistics_for_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_column_statistics_for_table <- glue_get_column_statistics_for_table

#' Retrieves a connection definition from the Data Catalog
#'
#' @description
#' Retrieves a connection definition from the Data Catalog.
#'
#' @usage
#' glue_get_connection(CatalogId, Name, HidePassword)
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the connection definition to retrieve.
#' @param HidePassword Allows you to retrieve the connection metadata without returning the
#' password. For instance, the AWS Glue console uses this flag to retrieve
#' the connection, and does not display the password. Set this parameter
#' when the caller might not have permission to use the AWS KMS key to
#' decrypt the password, but it does have permission to access the rest of
#' the connection properties.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Connection = list(
#'     Name = "string",
#'     Description = "string",
#'     ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA"|"NETWORK"|"MARKETPLACE"|"CUSTOM",
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionProperties = list(
#'       "string"
#'     ),
#'     PhysicalConnectionRequirements = list(
#'       SubnetId = "string",
#'       SecurityGroupIdList = list(
#'         "string"
#'       ),
#'       AvailabilityZone = "string"
#'     ),
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastUpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastUpdatedBy = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_connection(
#'   CatalogId = "string",
#'   Name = "string",
#'   HidePassword = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_connection
glue_get_connection <- function(CatalogId = NULL, Name, HidePassword = NULL) {
  op <- new_operation(
    name = "GetConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_connection_input(CatalogId = CatalogId, Name = Name, HidePassword = HidePassword)
  output <- .glue$get_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_connection <- glue_get_connection

#' Retrieves a list of connection definitions from the Data Catalog
#'
#' @description
#' Retrieves a list of connection definitions from the Data Catalog.
#'
#' @usage
#' glue_get_connections(CatalogId, Filter, HidePassword, NextToken,
#'   MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog in which the connections reside. If none is
#' provided, the AWS account ID is used by default.
#' @param Filter A filter that controls which connections are returned.
#' @param HidePassword Allows you to retrieve the connection metadata without returning the
#' password. For instance, the AWS Glue console uses this flag to retrieve
#' the connection, and does not display the password. Set this parameter
#' when the caller might not have permission to use the AWS KMS key to
#' decrypt the password, but it does have permission to access the rest of
#' the connection properties.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of connections to return in one response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConnectionList = list(
#'     list(
#'       Name = "string",
#'       Description = "string",
#'       ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA"|"NETWORK"|"MARKETPLACE"|"CUSTOM",
#'       MatchCriteria = list(
#'         "string"
#'       ),
#'       ConnectionProperties = list(
#'         "string"
#'       ),
#'       PhysicalConnectionRequirements = list(
#'         SubnetId = "string",
#'         SecurityGroupIdList = list(
#'           "string"
#'         ),
#'         AvailabilityZone = "string"
#'       ),
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdatedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdatedBy = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_connections(
#'   CatalogId = "string",
#'   Filter = list(
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA"|"NETWORK"|"MARKETPLACE"|"CUSTOM"
#'   ),
#'   HidePassword = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_connections
glue_get_connections <- function(CatalogId = NULL, Filter = NULL, HidePassword = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_connections_input(CatalogId = CatalogId, Filter = Filter, HidePassword = HidePassword, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_connections_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_connections <- glue_get_connections

#' Retrieves metadata for a specified crawler
#'
#' @description
#' Retrieves metadata for a specified crawler.
#'
#' @usage
#' glue_get_crawler(Name)
#'
#' @param Name &#91;required&#93; The name of the crawler to retrieve metadata for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Crawler = list(
#'     Name = "string",
#'     Role = "string",
#'     Targets = list(
#'       S3Targets = list(
#'         list(
#'           Path = "string",
#'           Exclusions = list(
#'             "string"
#'           ),
#'           ConnectionName = "string"
#'         )
#'       ),
#'       JdbcTargets = list(
#'         list(
#'           ConnectionName = "string",
#'           Path = "string",
#'           Exclusions = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       MongoDBTargets = list(
#'         list(
#'           ConnectionName = "string",
#'           Path = "string",
#'           ScanAll = TRUE|FALSE
#'         )
#'       ),
#'       DynamoDBTargets = list(
#'         list(
#'           Path = "string",
#'           scanAll = TRUE|FALSE,
#'           scanRate = 123.0
#'         )
#'       ),
#'       CatalogTargets = list(
#'         list(
#'           DatabaseName = "string",
#'           Tables = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     DatabaseName = "string",
#'     Description = "string",
#'     Classifiers = list(
#'       "string"
#'     ),
#'     RecrawlPolicy = list(
#'       RecrawlBehavior = "CRAWL_EVERYTHING"|"CRAWL_NEW_FOLDERS_ONLY"
#'     ),
#'     SchemaChangePolicy = list(
#'       UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'       DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'     ),
#'     LineageConfiguration = list(
#'       CrawlerLineageSettings = "ENABLE"|"DISABLE"
#'     ),
#'     State = "READY"|"RUNNING"|"STOPPING",
#'     TablePrefix = "string",
#'     Schedule = list(
#'       ScheduleExpression = "string",
#'       State = "SCHEDULED"|"NOT_SCHEDULED"|"TRANSITIONING"
#'     ),
#'     CrawlElapsedTime = 123,
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastCrawl = list(
#'       Status = "SUCCEEDED"|"CANCELLED"|"FAILED",
#'       ErrorMessage = "string",
#'       LogGroup = "string",
#'       LogStream = "string",
#'       MessagePrefix = "string",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     Version = 123,
#'     Configuration = "string",
#'     CrawlerSecurityConfiguration = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_crawler
glue_get_crawler <- function(Name) {
  op <- new_operation(
    name = "GetCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawler_input(Name = Name)
  output <- .glue$get_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawler <- glue_get_crawler

#' Retrieves metrics about specified crawlers
#'
#' @description
#' Retrieves metrics about specified crawlers.
#'
#' @usage
#' glue_get_crawler_metrics(CrawlerNameList, MaxResults, NextToken)
#'
#' @param CrawlerNameList A list of the names of crawlers about which to retrieve metrics.
#' @param MaxResults The maximum size of a list to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CrawlerMetricsList = list(
#'     list(
#'       CrawlerName = "string",
#'       TimeLeftSeconds = 123.0,
#'       StillEstimating = TRUE|FALSE,
#'       LastRuntimeSeconds = 123.0,
#'       MedianRuntimeSeconds = 123.0,
#'       TablesCreated = 123,
#'       TablesUpdated = 123,
#'       TablesDeleted = 123
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_crawler_metrics(
#'   CrawlerNameList = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_crawler_metrics
glue_get_crawler_metrics <- function(CrawlerNameList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCrawlerMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawler_metrics_input(CrawlerNameList = CrawlerNameList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_crawler_metrics_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawler_metrics <- glue_get_crawler_metrics

#' Retrieves metadata for all crawlers defined in the customer account
#'
#' @description
#' Retrieves metadata for all crawlers defined in the customer account.
#'
#' @usage
#' glue_get_crawlers(MaxResults, NextToken)
#'
#' @param MaxResults The number of crawlers to return on each call.
#' @param NextToken A continuation token, if this is a continuation request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Crawlers = list(
#'     list(
#'       Name = "string",
#'       Role = "string",
#'       Targets = list(
#'         S3Targets = list(
#'           list(
#'             Path = "string",
#'             Exclusions = list(
#'               "string"
#'             ),
#'             ConnectionName = "string"
#'           )
#'         ),
#'         JdbcTargets = list(
#'           list(
#'             ConnectionName = "string",
#'             Path = "string",
#'             Exclusions = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         MongoDBTargets = list(
#'           list(
#'             ConnectionName = "string",
#'             Path = "string",
#'             ScanAll = TRUE|FALSE
#'           )
#'         ),
#'         DynamoDBTargets = list(
#'           list(
#'             Path = "string",
#'             scanAll = TRUE|FALSE,
#'             scanRate = 123.0
#'           )
#'         ),
#'         CatalogTargets = list(
#'           list(
#'             DatabaseName = "string",
#'             Tables = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       DatabaseName = "string",
#'       Description = "string",
#'       Classifiers = list(
#'         "string"
#'       ),
#'       RecrawlPolicy = list(
#'         RecrawlBehavior = "CRAWL_EVERYTHING"|"CRAWL_NEW_FOLDERS_ONLY"
#'       ),
#'       SchemaChangePolicy = list(
#'         UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'         DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'       ),
#'       LineageConfiguration = list(
#'         CrawlerLineageSettings = "ENABLE"|"DISABLE"
#'       ),
#'       State = "READY"|"RUNNING"|"STOPPING",
#'       TablePrefix = "string",
#'       Schedule = list(
#'         ScheduleExpression = "string",
#'         State = "SCHEDULED"|"NOT_SCHEDULED"|"TRANSITIONING"
#'       ),
#'       CrawlElapsedTime = 123,
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastCrawl = list(
#'         Status = "SUCCEEDED"|"CANCELLED"|"FAILED",
#'         ErrorMessage = "string",
#'         LogGroup = "string",
#'         LogStream = "string",
#'         MessagePrefix = "string",
#'         StartTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       Version = 123,
#'       Configuration = "string",
#'       CrawlerSecurityConfiguration = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_crawlers(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_crawlers
glue_get_crawlers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawlers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_crawlers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawlers <- glue_get_crawlers

#' Retrieves the security configuration for a specified catalog
#'
#' @description
#' Retrieves the security configuration for a specified catalog.
#'
#' @usage
#' glue_get_data_catalog_encryption_settings(CatalogId)
#'
#' @param CatalogId The ID of the Data Catalog to retrieve the security configuration for.
#' If none is provided, the AWS account ID is used by default.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DataCatalogEncryptionSettings = list(
#'     EncryptionAtRest = list(
#'       CatalogEncryptionMode = "DISABLED"|"SSE-KMS",
#'       SseAwsKmsKeyId = "string"
#'     ),
#'     ConnectionPasswordEncryption = list(
#'       ReturnConnectionPasswordEncrypted = TRUE|FALSE,
#'       AwsKmsKeyId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_data_catalog_encryption_settings(
#'   CatalogId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_data_catalog_encryption_settings
glue_get_data_catalog_encryption_settings <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetDataCatalogEncryptionSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_catalog_encryption_settings_input(CatalogId = CatalogId)
  output <- .glue$get_data_catalog_encryption_settings_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_catalog_encryption_settings <- glue_get_data_catalog_encryption_settings

#' Retrieves the definition of a specified database
#'
#' @description
#' Retrieves the definition of a specified database.
#'
#' @usage
#' glue_get_database(CatalogId, Name)
#'
#' @param CatalogId The ID of the Data Catalog in which the database resides. If none is
#' provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to retrieve. For Hive compatibility, this
#' should be all lowercase.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Database = list(
#'     Name = "string",
#'     Description = "string",
#'     LocationUri = "string",
#'     Parameters = list(
#'       "string"
#'     ),
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreateTableDefaultPermissions = list(
#'       list(
#'         Principal = list(
#'           DataLakePrincipalIdentifier = "string"
#'         ),
#'         Permissions = list(
#'           "ALL"|"SELECT"|"ALTER"|"DROP"|"DELETE"|"INSERT"|"CREATE_DATABASE"|"CREATE_TABLE"|"DATA_LOCATION_ACCESS"
#'         )
#'       )
#'     ),
#'     TargetDatabase = list(
#'       CatalogId = "string",
#'       DatabaseName = "string"
#'     ),
#'     CatalogId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_database(
#'   CatalogId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_database
glue_get_database <- function(CatalogId = NULL, Name) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_database_input(CatalogId = CatalogId, Name = Name)
  output <- .glue$get_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_database <- glue_get_database

#' Retrieves all databases defined in a given Data Catalog
#'
#' @description
#' Retrieves all databases defined in a given Data Catalog.
#'
#' @usage
#' glue_get_databases(CatalogId, NextToken, MaxResults, ResourceShareType)
#'
#' @param CatalogId The ID of the Data Catalog from which to retrieve `Databases`. If none
#' is provided, the AWS account ID is used by default.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of databases to return in one response.
#' @param ResourceShareType Allows you to specify that you want to list the databases shared with
#' your account. The allowable values are `FOREIGN` or `ALL`.
#' 
#' -   If set to `FOREIGN`, will list the databases shared with your
#'     account.
#' 
#' -   If set to `ALL`, will list the databases shared with your account,
#'     as well as the databases in yor local account.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DatabaseList = list(
#'     list(
#'       Name = "string",
#'       Description = "string",
#'       LocationUri = "string",
#'       Parameters = list(
#'         "string"
#'       ),
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CreateTableDefaultPermissions = list(
#'         list(
#'           Principal = list(
#'             DataLakePrincipalIdentifier = "string"
#'           ),
#'           Permissions = list(
#'             "ALL"|"SELECT"|"ALTER"|"DROP"|"DELETE"|"INSERT"|"CREATE_DATABASE"|"CREATE_TABLE"|"DATA_LOCATION_ACCESS"
#'           )
#'         )
#'       ),
#'       TargetDatabase = list(
#'         CatalogId = "string",
#'         DatabaseName = "string"
#'       ),
#'       CatalogId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_databases(
#'   CatalogId = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ResourceShareType = "FOREIGN"|"ALL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_databases
glue_get_databases <- function(CatalogId = NULL, NextToken = NULL, MaxResults = NULL, ResourceShareType = NULL) {
  op <- new_operation(
    name = "GetDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_databases_input(CatalogId = CatalogId, NextToken = NextToken, MaxResults = MaxResults, ResourceShareType = ResourceShareType)
  output <- .glue$get_databases_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_databases <- glue_get_databases

#' Transforms a Python script into a directed acyclic graph (DAG)
#'
#' @description
#' Transforms a Python script into a directed acyclic graph (DAG).
#'
#' @usage
#' glue_get_dataflow_graph(PythonScript)
#'
#' @param PythonScript The Python script to transform.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DagNodes = list(
#'     list(
#'       Id = "string",
#'       NodeType = "string",
#'       Args = list(
#'         list(
#'           Name = "string",
#'           Value = "string",
#'           Param = TRUE|FALSE
#'         )
#'       ),
#'       LineNumber = 123
#'     )
#'   ),
#'   DagEdges = list(
#'     list(
#'       Source = "string",
#'       Target = "string",
#'       TargetParameter = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_dataflow_graph(
#'   PythonScript = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_dataflow_graph
glue_get_dataflow_graph <- function(PythonScript = NULL) {
  op <- new_operation(
    name = "GetDataflowGraph",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dataflow_graph_input(PythonScript = PythonScript)
  output <- .glue$get_dataflow_graph_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dataflow_graph <- glue_get_dataflow_graph

#' Retrieves information about a specified development endpoint
#'
#' @description
#' Retrieves information about a specified development endpoint.
#' 
#' When you create a development endpoint in a virtual private cloud (VPC),
#' AWS Glue returns only a private IP address, and the public IP address
#' field is not populated. When you create a non-VPC development endpoint,
#' AWS Glue returns only a public IP address.
#'
#' @usage
#' glue_get_dev_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; Name of the `DevEndpoint` to retrieve information for.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DevEndpoint = list(
#'     EndpointName = "string",
#'     RoleArn = "string",
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     SubnetId = "string",
#'     YarnEndpointAddress = "string",
#'     PrivateAddress = "string",
#'     ZeppelinRemoteSparkInterpreterPort = 123,
#'     PublicAddress = "string",
#'     Status = "string",
#'     WorkerType = "Standard"|"G.1X"|"G.2X",
#'     GlueVersion = "string",
#'     NumberOfWorkers = 123,
#'     NumberOfNodes = 123,
#'     AvailabilityZone = "string",
#'     VpcId = "string",
#'     ExtraPythonLibsS3Path = "string",
#'     ExtraJarsS3Path = "string",
#'     FailureReason = "string",
#'     LastUpdateStatus = "string",
#'     CreatedTimestamp = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedTimestamp = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PublicKey = "string",
#'     PublicKeys = list(
#'       "string"
#'     ),
#'     SecurityConfiguration = "string",
#'     Arguments = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_dev_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_dev_endpoint
glue_get_dev_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "GetDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dev_endpoint_input(EndpointName = EndpointName)
  output <- .glue$get_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dev_endpoint <- glue_get_dev_endpoint

#' Retrieves all the development endpoints in this AWS account
#'
#' @description
#' Retrieves all the development endpoints in this AWS account.
#' 
#' When you create a development endpoint in a virtual private cloud (VPC),
#' AWS Glue returns only a private IP address and the public IP address
#' field is not populated. When you create a non-VPC development endpoint,
#' AWS Glue returns only a public IP address.
#'
#' @usage
#' glue_get_dev_endpoints(MaxResults, NextToken)
#'
#' @param MaxResults The maximum size of information to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DevEndpoints = list(
#'     list(
#'       EndpointName = "string",
#'       RoleArn = "string",
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       SubnetId = "string",
#'       YarnEndpointAddress = "string",
#'       PrivateAddress = "string",
#'       ZeppelinRemoteSparkInterpreterPort = 123,
#'       PublicAddress = "string",
#'       Status = "string",
#'       WorkerType = "Standard"|"G.1X"|"G.2X",
#'       GlueVersion = "string",
#'       NumberOfWorkers = 123,
#'       NumberOfNodes = 123,
#'       AvailabilityZone = "string",
#'       VpcId = "string",
#'       ExtraPythonLibsS3Path = "string",
#'       ExtraJarsS3Path = "string",
#'       FailureReason = "string",
#'       LastUpdateStatus = "string",
#'       CreatedTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       PublicKey = "string",
#'       PublicKeys = list(
#'         "string"
#'       ),
#'       SecurityConfiguration = "string",
#'       Arguments = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_dev_endpoints(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_dev_endpoints
glue_get_dev_endpoints <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dev_endpoints_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_dev_endpoints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dev_endpoints <- glue_get_dev_endpoints

#' Retrieves an existing job definition
#'
#' @description
#' Retrieves an existing job definition.
#'
#' @usage
#' glue_get_job(JobName)
#'
#' @param JobName &#91;required&#93; The name of the job definition to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Job = list(
#'     Name = "string",
#'     Description = "string",
#'     LogUri = "string",
#'     Role = "string",
#'     CreatedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ExecutionProperty = list(
#'       MaxConcurrentRuns = 123
#'     ),
#'     Command = list(
#'       Name = "string",
#'       ScriptLocation = "string",
#'       PythonVersion = "string"
#'     ),
#'     DefaultArguments = list(
#'       "string"
#'     ),
#'     NonOverridableArguments = list(
#'       "string"
#'     ),
#'     Connections = list(
#'       Connections = list(
#'         "string"
#'       )
#'     ),
#'     MaxRetries = 123,
#'     AllocatedCapacity = 123,
#'     Timeout = 123,
#'     MaxCapacity = 123.0,
#'     WorkerType = "Standard"|"G.1X"|"G.2X",
#'     NumberOfWorkers = 123,
#'     SecurityConfiguration = "string",
#'     NotificationProperty = list(
#'       NotifyDelayAfter = 123
#'     ),
#'     GlueVersion = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_job(
#'   JobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job
glue_get_job <- function(JobName) {
  op <- new_operation(
    name = "GetJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_input(JobName = JobName)
  output <- .glue$get_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job <- glue_get_job

#' Returns information on a job bookmark entry
#'
#' @description
#' Returns information on a job bookmark entry.
#'
#' @usage
#' glue_get_job_bookmark(JobName, RunId)
#'
#' @param JobName &#91;required&#93; The name of the job in question.
#' @param RunId The unique run identifier associated with this job run.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobBookmarkEntry = list(
#'     JobName = "string",
#'     Version = 123,
#'     Run = 123,
#'     Attempt = 123,
#'     PreviousRunId = "string",
#'     RunId = "string",
#'     JobBookmark = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_job_bookmark(
#'   JobName = "string",
#'   RunId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job_bookmark
glue_get_job_bookmark <- function(JobName, RunId = NULL) {
  op <- new_operation(
    name = "GetJobBookmark",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_bookmark_input(JobName = JobName, RunId = RunId)
  output <- .glue$get_job_bookmark_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_bookmark <- glue_get_job_bookmark

#' Retrieves the metadata for a given job run
#'
#' @description
#' Retrieves the metadata for a given job run.
#'
#' @usage
#' glue_get_job_run(JobName, RunId, PredecessorsIncluded)
#'
#' @param JobName &#91;required&#93; Name of the job definition being run.
#' @param RunId &#91;required&#93; The ID of the job run.
#' @param PredecessorsIncluded True if a list of predecessor runs should be returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobRun = list(
#'     Id = "string",
#'     Attempt = 123,
#'     PreviousRunId = "string",
#'     TriggerName = "string",
#'     JobName = "string",
#'     StartedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CompletedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'     Arguments = list(
#'       "string"
#'     ),
#'     ErrorMessage = "string",
#'     PredecessorRuns = list(
#'       list(
#'         JobName = "string",
#'         RunId = "string"
#'       )
#'     ),
#'     AllocatedCapacity = 123,
#'     ExecutionTime = 123,
#'     Timeout = 123,
#'     MaxCapacity = 123.0,
#'     WorkerType = "Standard"|"G.1X"|"G.2X",
#'     NumberOfWorkers = 123,
#'     SecurityConfiguration = "string",
#'     LogGroupName = "string",
#'     NotificationProperty = list(
#'       NotifyDelayAfter = 123
#'     ),
#'     GlueVersion = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_job_run(
#'   JobName = "string",
#'   RunId = "string",
#'   PredecessorsIncluded = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job_run
glue_get_job_run <- function(JobName, RunId, PredecessorsIncluded = NULL) {
  op <- new_operation(
    name = "GetJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_run_input(JobName = JobName, RunId = RunId, PredecessorsIncluded = PredecessorsIncluded)
  output <- .glue$get_job_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_run <- glue_get_job_run

#' Retrieves metadata for all runs of a given job definition
#'
#' @description
#' Retrieves metadata for all runs of a given job definition.
#'
#' @usage
#' glue_get_job_runs(JobName, NextToken, MaxResults)
#'
#' @param JobName &#91;required&#93; The name of the job definition for which to retrieve all job runs.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobRuns = list(
#'     list(
#'       Id = "string",
#'       Attempt = 123,
#'       PreviousRunId = "string",
#'       TriggerName = "string",
#'       JobName = "string",
#'       StartedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CompletedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'       Arguments = list(
#'         "string"
#'       ),
#'       ErrorMessage = "string",
#'       PredecessorRuns = list(
#'         list(
#'           JobName = "string",
#'           RunId = "string"
#'         )
#'       ),
#'       AllocatedCapacity = 123,
#'       ExecutionTime = 123,
#'       Timeout = 123,
#'       MaxCapacity = 123.0,
#'       WorkerType = "Standard"|"G.1X"|"G.2X",
#'       NumberOfWorkers = 123,
#'       SecurityConfiguration = "string",
#'       LogGroupName = "string",
#'       NotificationProperty = list(
#'         NotifyDelayAfter = 123
#'       ),
#'       GlueVersion = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_job_runs(
#'   JobName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job_runs
glue_get_job_runs <- function(JobName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetJobRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_runs_input(JobName = JobName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_job_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_runs <- glue_get_job_runs

#' Retrieves all current job definitions
#'
#' @description
#' Retrieves all current job definitions.
#'
#' @usage
#' glue_get_jobs(NextToken, MaxResults)
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Jobs = list(
#'     list(
#'       Name = "string",
#'       Description = "string",
#'       LogUri = "string",
#'       Role = "string",
#'       CreatedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ExecutionProperty = list(
#'         MaxConcurrentRuns = 123
#'       ),
#'       Command = list(
#'         Name = "string",
#'         ScriptLocation = "string",
#'         PythonVersion = "string"
#'       ),
#'       DefaultArguments = list(
#'         "string"
#'       ),
#'       NonOverridableArguments = list(
#'         "string"
#'       ),
#'       Connections = list(
#'         Connections = list(
#'           "string"
#'         )
#'       ),
#'       MaxRetries = 123,
#'       AllocatedCapacity = 123,
#'       Timeout = 123,
#'       MaxCapacity = 123.0,
#'       WorkerType = "Standard"|"G.1X"|"G.2X",
#'       NumberOfWorkers = 123,
#'       SecurityConfiguration = "string",
#'       NotificationProperty = list(
#'         NotifyDelayAfter = 123
#'       ),
#'       GlueVersion = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_jobs(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_jobs
glue_get_jobs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_jobs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_jobs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_jobs <- glue_get_jobs

#' Gets details for a specific task run on a machine learning transform
#'
#' @description
#' Gets details for a specific task run on a machine learning transform.
#' Machine learning task runs are asynchronous tasks that AWS Glue runs on
#' your behalf as part of various machine learning workflows. You can check
#' the stats of any task run by calling
#' [`get_ml_task_run`][glue_get_ml_task_run] with the `TaskRunID` and its
#' parent transform's `TransformID`.
#'
#' @usage
#' glue_get_ml_task_run(TransformId, TaskRunId)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param TaskRunId &#91;required&#93; The unique identifier of the task run.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformId = "string",
#'   TaskRunId = "string",
#'   Status = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'   LogGroupName = "string",
#'   Properties = list(
#'     TaskType = "EVALUATION"|"LABELING_SET_GENERATION"|"IMPORT_LABELS"|"EXPORT_LABELS"|"FIND_MATCHES",
#'     ImportLabelsTaskRunProperties = list(
#'       InputS3Path = "string",
#'       Replace = TRUE|FALSE
#'     ),
#'     ExportLabelsTaskRunProperties = list(
#'       OutputS3Path = "string"
#'     ),
#'     LabelingSetGenerationTaskRunProperties = list(
#'       OutputS3Path = "string"
#'     ),
#'     FindMatchesTaskRunProperties = list(
#'       JobId = "string",
#'       JobName = "string",
#'       JobRunId = "string"
#'     )
#'   ),
#'   ErrorString = "string",
#'   StartedOn = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedOn = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CompletedOn = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ExecutionTime = 123
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_ml_task_run(
#'   TransformId = "string",
#'   TaskRunId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_task_run
glue_get_ml_task_run <- function(TransformId, TaskRunId) {
  op <- new_operation(
    name = "GetMLTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_ml_task_run_input(TransformId = TransformId, TaskRunId = TaskRunId)
  output <- .glue$get_ml_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_task_run <- glue_get_ml_task_run

#' Gets a list of runs for a machine learning transform
#'
#' @description
#' Gets a list of runs for a machine learning transform. Machine learning
#' task runs are asynchronous tasks that AWS Glue runs on your behalf as
#' part of various machine learning workflows. You can get a sortable,
#' filterable list of machine learning task runs by calling
#' [`get_ml_task_runs`][glue_get_ml_task_runs] with their parent
#' transform's `TransformID` and other optional parameters as documented in
#' this section.
#' 
#' This operation returns a list of historic runs and must be paginated.
#'
#' @usage
#' glue_get_ml_task_runs(TransformId, NextToken, MaxResults, Filter, Sort)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param NextToken A token for pagination of the results. The default is empty.
#' @param MaxResults The maximum number of results to return.
#' @param Filter The filter criteria, in the `TaskRunFilterCriteria` structure, for the
#' task run.
#' @param Sort The sorting criteria, in the `TaskRunSortCriteria` structure, for the
#' task run.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TaskRuns = list(
#'     list(
#'       TransformId = "string",
#'       TaskRunId = "string",
#'       Status = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'       LogGroupName = "string",
#'       Properties = list(
#'         TaskType = "EVALUATION"|"LABELING_SET_GENERATION"|"IMPORT_LABELS"|"EXPORT_LABELS"|"FIND_MATCHES",
#'         ImportLabelsTaskRunProperties = list(
#'           InputS3Path = "string",
#'           Replace = TRUE|FALSE
#'         ),
#'         ExportLabelsTaskRunProperties = list(
#'           OutputS3Path = "string"
#'         ),
#'         LabelingSetGenerationTaskRunProperties = list(
#'           OutputS3Path = "string"
#'         ),
#'         FindMatchesTaskRunProperties = list(
#'           JobId = "string",
#'           JobName = "string",
#'           JobRunId = "string"
#'         )
#'       ),
#'       ErrorString = "string",
#'       StartedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CompletedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ExecutionTime = 123
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_ml_task_runs(
#'   TransformId = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filter = list(
#'     TaskRunType = "EVALUATION"|"LABELING_SET_GENERATION"|"IMPORT_LABELS"|"EXPORT_LABELS"|"FIND_MATCHES",
#'     Status = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'     StartedBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StartedAfter = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   Sort = list(
#'     Column = "TASK_RUN_TYPE"|"STATUS"|"STARTED",
#'     SortDirection = "DESCENDING"|"ASCENDING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_task_runs
glue_get_ml_task_runs <- function(TransformId, NextToken = NULL, MaxResults = NULL, Filter = NULL, Sort = NULL) {
  op <- new_operation(
    name = "GetMLTaskRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_ml_task_runs_input(TransformId = TransformId, NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Sort = Sort)
  output <- .glue$get_ml_task_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_task_runs <- glue_get_ml_task_runs

#' Gets an AWS Glue machine learning transform artifact and all its
#' corresponding metadata
#'
#' @description
#' Gets an AWS Glue machine learning transform artifact and all its
#' corresponding metadata. Machine learning transforms are a special type
#' of transform that use machine learning to learn the details of the
#' transformation to be performed by learning from examples provided by
#' humans. These transformations are then saved by AWS Glue. You can
#' retrieve their metadata by calling
#' [`get_ml_transform`][glue_get_ml_transform].
#'
#' @usage
#' glue_get_ml_transform(TransformId)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the transform, generated at the time that the
#' transform was created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformId = "string",
#'   Name = "string",
#'   Description = "string",
#'   Status = "NOT_READY"|"READY"|"DELETING",
#'   CreatedOn = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedOn = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   InputRecordTables = list(
#'     list(
#'       DatabaseName = "string",
#'       TableName = "string",
#'       CatalogId = "string",
#'       ConnectionName = "string"
#'     )
#'   ),
#'   Parameters = list(
#'     TransformType = "FIND_MATCHES",
#'     FindMatchesParameters = list(
#'       PrimaryKeyColumnName = "string",
#'       PrecisionRecallTradeoff = 123.0,
#'       AccuracyCostTradeoff = 123.0,
#'       EnforceProvidedLabels = TRUE|FALSE
#'     )
#'   ),
#'   EvaluationMetrics = list(
#'     TransformType = "FIND_MATCHES",
#'     FindMatchesMetrics = list(
#'       AreaUnderPRCurve = 123.0,
#'       Precision = 123.0,
#'       Recall = 123.0,
#'       F1 = 123.0,
#'       ConfusionMatrix = list(
#'         NumTruePositives = 123,
#'         NumFalsePositives = 123,
#'         NumTrueNegatives = 123,
#'         NumFalseNegatives = 123
#'       ),
#'       ColumnImportances = list(
#'         list(
#'           ColumnName = "string",
#'           Importance = 123.0
#'         )
#'       )
#'     )
#'   ),
#'   LabelCount = 123,
#'   Schema = list(
#'     list(
#'       Name = "string",
#'       DataType = "string"
#'     )
#'   ),
#'   Role = "string",
#'   GlueVersion = "string",
#'   MaxCapacity = 123.0,
#'   WorkerType = "Standard"|"G.1X"|"G.2X",
#'   NumberOfWorkers = 123,
#'   Timeout = 123,
#'   MaxRetries = 123,
#'   TransformEncryption = list(
#'     MlUserDataEncryption = list(
#'       MlUserDataEncryptionMode = "DISABLED"|"SSE-KMS",
#'       KmsKeyId = "string"
#'     ),
#'     TaskRunSecurityConfigurationName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_ml_transform(
#'   TransformId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_transform
glue_get_ml_transform <- function(TransformId) {
  op <- new_operation(
    name = "GetMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_ml_transform_input(TransformId = TransformId)
  output <- .glue$get_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_transform <- glue_get_ml_transform

#' Gets a sortable, filterable list of existing AWS Glue machine learning
#' transforms
#'
#' @description
#' Gets a sortable, filterable list of existing AWS Glue machine learning
#' transforms. Machine learning transforms are a special type of transform
#' that use machine learning to learn the details of the transformation to
#' be performed by learning from examples provided by humans. These
#' transformations are then saved by AWS Glue, and you can retrieve their
#' metadata by calling [`get_ml_transforms`][glue_get_ml_transforms].
#'
#' @usage
#' glue_get_ml_transforms(NextToken, MaxResults, Filter, Sort)
#'
#' @param NextToken A paginated token to offset the results.
#' @param MaxResults The maximum number of results to return.
#' @param Filter The filter transformation criteria.
#' @param Sort The sorting criteria.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Transforms = list(
#'     list(
#'       TransformId = "string",
#'       Name = "string",
#'       Description = "string",
#'       Status = "NOT_READY"|"READY"|"DELETING",
#'       CreatedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastModifiedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       InputRecordTables = list(
#'         list(
#'           DatabaseName = "string",
#'           TableName = "string",
#'           CatalogId = "string",
#'           ConnectionName = "string"
#'         )
#'       ),
#'       Parameters = list(
#'         TransformType = "FIND_MATCHES",
#'         FindMatchesParameters = list(
#'           PrimaryKeyColumnName = "string",
#'           PrecisionRecallTradeoff = 123.0,
#'           AccuracyCostTradeoff = 123.0,
#'           EnforceProvidedLabels = TRUE|FALSE
#'         )
#'       ),
#'       EvaluationMetrics = list(
#'         TransformType = "FIND_MATCHES",
#'         FindMatchesMetrics = list(
#'           AreaUnderPRCurve = 123.0,
#'           Precision = 123.0,
#'           Recall = 123.0,
#'           F1 = 123.0,
#'           ConfusionMatrix = list(
#'             NumTruePositives = 123,
#'             NumFalsePositives = 123,
#'             NumTrueNegatives = 123,
#'             NumFalseNegatives = 123
#'           ),
#'           ColumnImportances = list(
#'             list(
#'               ColumnName = "string",
#'               Importance = 123.0
#'             )
#'           )
#'         )
#'       ),
#'       LabelCount = 123,
#'       Schema = list(
#'         list(
#'           Name = "string",
#'           DataType = "string"
#'         )
#'       ),
#'       Role = "string",
#'       GlueVersion = "string",
#'       MaxCapacity = 123.0,
#'       WorkerType = "Standard"|"G.1X"|"G.2X",
#'       NumberOfWorkers = 123,
#'       Timeout = 123,
#'       MaxRetries = 123,
#'       TransformEncryption = list(
#'         MlUserDataEncryption = list(
#'           MlUserDataEncryptionMode = "DISABLED"|"SSE-KMS",
#'           KmsKeyId = "string"
#'         ),
#'         TaskRunSecurityConfigurationName = "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_ml_transforms(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filter = list(
#'     Name = "string",
#'     TransformType = "FIND_MATCHES",
#'     Status = "NOT_READY"|"READY"|"DELETING",
#'     GlueVersion = "string",
#'     CreatedBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreatedAfter = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedAfter = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Schema = list(
#'       list(
#'         Name = "string",
#'         DataType = "string"
#'       )
#'     )
#'   ),
#'   Sort = list(
#'     Column = "NAME"|"TRANSFORM_TYPE"|"STATUS"|"CREATED"|"LAST_MODIFIED",
#'     SortDirection = "DESCENDING"|"ASCENDING"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_ml_transforms
glue_get_ml_transforms <- function(NextToken = NULL, MaxResults = NULL, Filter = NULL, Sort = NULL) {
  op <- new_operation(
    name = "GetMLTransforms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_ml_transforms_input(NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Sort = Sort)
  output <- .glue$get_ml_transforms_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_ml_transforms <- glue_get_ml_transforms

#' Creates mappings
#'
#' @description
#' Creates mappings.
#'
#' @usage
#' glue_get_mapping(Source, Sinks, Location)
#'
#' @param Source &#91;required&#93; Specifies the source table.
#' @param Sinks A list of target tables.
#' @param Location Parameters for the mapping.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Mapping = list(
#'     list(
#'       SourceTable = "string",
#'       SourcePath = "string",
#'       SourceType = "string",
#'       TargetTable = "string",
#'       TargetPath = "string",
#'       TargetType = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_mapping(
#'   Source = list(
#'     DatabaseName = "string",
#'     TableName = "string"
#'   ),
#'   Sinks = list(
#'     list(
#'       DatabaseName = "string",
#'       TableName = "string"
#'     )
#'   ),
#'   Location = list(
#'     Jdbc = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     S3 = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     DynamoDB = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_mapping
glue_get_mapping <- function(Source, Sinks = NULL, Location = NULL) {
  op <- new_operation(
    name = "GetMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_mapping_input(Source = Source, Sinks = Sinks, Location = Location)
  output <- .glue$get_mapping_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_mapping <- glue_get_mapping

#' Retrieves information about a specified partition
#'
#' @description
#' Retrieves information about a specified partition.
#'
#' @usage
#' glue_get_partition(CatalogId, DatabaseName, TableName, PartitionValues)
#'
#' @param CatalogId The ID of the Data Catalog where the partition in question resides. If
#' none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partition resides.
#' @param TableName &#91;required&#93; The name of the partition's table.
#' @param PartitionValues &#91;required&#93; The values that define the partition.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Partition = list(
#'     Values = list(
#'       "string"
#'     ),
#'     DatabaseName = "string",
#'     TableName = "string",
#'     CreationTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE,
#'       SchemaReference = list(
#'         SchemaId = list(
#'           SchemaArn = "string",
#'           SchemaName = "string",
#'           RegistryName = "string"
#'         ),
#'         SchemaVersionId = "string",
#'         SchemaVersionNumber = 123
#'       )
#'     ),
#'     Parameters = list(
#'       "string"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CatalogId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_partition
glue_get_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues) {
  op <- new_operation(
    name = "GetPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues)
  output <- .glue$get_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partition <- glue_get_partition

#' Retrieves the partition indexes associated with a table
#'
#' @description
#' Retrieves the partition indexes associated with a table.
#'
#' @usage
#' glue_get_partition_indexes(CatalogId, DatabaseName, TableName,
#'   NextToken)
#'
#' @param CatalogId The catalog ID where the table resides.
#' @param DatabaseName &#91;required&#93; Specifies the name of a database from which you want to retrieve
#' partition indexes.
#' @param TableName &#91;required&#93; Specifies the name of a table for which you want to retrieve the
#' partition indexes.
#' @param NextToken A continuation token, included if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PartitionIndexDescriptorList = list(
#'     list(
#'       IndexName = "string",
#'       Keys = list(
#'         list(
#'           Name = "string",
#'           Type = "string"
#'         )
#'       ),
#'       IndexStatus = "CREATING"|"ACTIVE"|"DELETING"|"FAILED",
#'       BackfillErrors = list(
#'         list(
#'           Code = "ENCRYPTED_PARTITION_ERROR"|"INTERNAL_ERROR"|"INVALID_PARTITION_TYPE_DATA_ERROR"|"MISSING_PARTITION_VALUE_ERROR"|"UNSUPPORTED_PARTITION_CHARACTER_ERROR",
#'           Partitions = list(
#'             list(
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_partition_indexes(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_partition_indexes
glue_get_partition_indexes <- function(CatalogId = NULL, DatabaseName, TableName, NextToken = NULL) {
  op <- new_operation(
    name = "GetPartitionIndexes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_partition_indexes_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, NextToken = NextToken)
  output <- .glue$get_partition_indexes_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partition_indexes <- glue_get_partition_indexes

#' Retrieves information about the partitions in a table
#'
#' @description
#' Retrieves information about the partitions in a table.
#'
#' @usage
#' glue_get_partitions(CatalogId, DatabaseName, TableName, Expression,
#'   NextToken, Segment, MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param Expression An expression that filters the partitions to be returned.
#' 
#' The expression uses SQL syntax similar to the SQL `WHERE` filter clause.
#' The SQL statement parser
#' [JSQLParser](http://jsqlparser.sourceforge.net/home.php) parses the
#' expression.
#' 
#' *Operators*: The following are the operators that you can use in the
#' `Expression` API call:
#' 
#' ### =
#' 
#' Checks whether the values of the two operands are equal; if yes, then
#' the condition becomes true.
#' 
#' Example: Assume 'variable a' holds 10 and 'variable b' holds 20.
#' 
#' (a = b) is not true.
#' 
#' ### &lt; &gt;
#' 
#' Checks whether the values of two operands are equal; if the values are
#' not equal, then the condition becomes true.
#' 
#' Example: (a &lt; &gt; b) is true.
#' 
#' ### &gt;
#' 
#' Checks whether the value of the left operand is greater than the value
#' of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a &gt; b) is not true.
#' 
#' ### &lt;
#' 
#' Checks whether the value of the left operand is less than the value of
#' the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a &lt; b) is true.
#' 
#' ### &gt;=
#' 
#' Checks whether the value of the left operand is greater than or equal to
#' the value of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a &gt;= b) is not true.
#' 
#' ### &lt;=
#' 
#' Checks whether the value of the left operand is less than or equal to
#' the value of the right operand; if yes, then the condition becomes true.
#' 
#' Example: (a &lt;= b) is true.
#' 
#' ### AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL
#' 
#' Logical operators.
#' 
#' *Supported Partition Key Types*: The following are the supported
#' partition keys.
#' 
#' -   `string`
#' 
#' -   `date`
#' 
#' -   `timestamp`
#' 
#' -   `int`
#' 
#' -   `bigint`
#' 
#' -   `long`
#' 
#' -   `tinyint`
#' 
#' -   `smallint`
#' 
#' -   `decimal`
#' 
#' If an invalid type is encountered, an exception is thrown.
#' 
#' The following list shows the valid operators on each type. When you
#' define a crawler, the `partitionKey` type is created as a `STRING`, to
#' be compatible with the catalog partitions.
#' 
#' *Sample API Call*:
#' @param NextToken A continuation token, if this is not the first call to retrieve these
#' partitions.
#' @param Segment The segment of the table's partitions to scan in this request.
#' @param MaxResults The maximum number of partitions to return in a single response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Partitions = list(
#'     list(
#'       Values = list(
#'         "string"
#'       ),
#'       DatabaseName = "string",
#'       TableName = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE,
#'         SchemaReference = list(
#'           SchemaId = list(
#'             SchemaArn = "string",
#'             SchemaName = "string",
#'             RegistryName = "string"
#'           ),
#'           SchemaVersionId = "string",
#'           SchemaVersionNumber = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CatalogId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_partitions(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   Expression = "string",
#'   NextToken = "string",
#'   Segment = list(
#'     SegmentNumber = 123,
#'     TotalSegments = 123
#'   ),
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_partitions
glue_get_partitions <- function(CatalogId = NULL, DatabaseName, TableName, Expression = NULL, NextToken = NULL, Segment = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetPartitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_partitions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Expression = Expression, NextToken = NextToken, Segment = Segment, MaxResults = MaxResults)
  output <- .glue$get_partitions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partitions <- glue_get_partitions

#' Gets code to perform a specified mapping
#'
#' @description
#' Gets code to perform a specified mapping.
#'
#' @usage
#' glue_get_plan(Mapping, Source, Sinks, Location, Language,
#'   AdditionalPlanOptionsMap)
#'
#' @param Mapping &#91;required&#93; The list of mappings from a source table to target tables.
#' @param Source &#91;required&#93; The source table.
#' @param Sinks The target tables.
#' @param Location The parameters for the mapping.
#' @param Language The programming language of the code to perform the mapping.
#' @param AdditionalPlanOptionsMap A map to hold additional optional key-value parameters.
#' 
#' Currently, these key-value pairs are supported:
#' 
#' -   `inferSchema`  —  Specifies whether to set `inferSchema` to true or
#'     false for the default script generated by an AWS Glue job. For
#'     example, to set `inferSchema` to true, pass the following key value
#'     pair:
#' 
#'     `--additional-plan-options-map '{"inferSchema":"true"}'`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PythonScript = "string",
#'   ScalaCode = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_plan(
#'   Mapping = list(
#'     list(
#'       SourceTable = "string",
#'       SourcePath = "string",
#'       SourceType = "string",
#'       TargetTable = "string",
#'       TargetPath = "string",
#'       TargetType = "string"
#'     )
#'   ),
#'   Source = list(
#'     DatabaseName = "string",
#'     TableName = "string"
#'   ),
#'   Sinks = list(
#'     list(
#'       DatabaseName = "string",
#'       TableName = "string"
#'     )
#'   ),
#'   Location = list(
#'     Jdbc = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     S3 = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     DynamoDB = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   Language = "PYTHON"|"SCALA",
#'   AdditionalPlanOptionsMap = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_plan
glue_get_plan <- function(Mapping, Source, Sinks = NULL, Location = NULL, Language = NULL, AdditionalPlanOptionsMap = NULL) {
  op <- new_operation(
    name = "GetPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_plan_input(Mapping = Mapping, Source = Source, Sinks = Sinks, Location = Location, Language = Language, AdditionalPlanOptionsMap = AdditionalPlanOptionsMap)
  output <- .glue$get_plan_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_plan <- glue_get_plan

#' Describes the specified registry in detail
#'
#' @description
#' Describes the specified registry in detail.
#'
#' @usage
#' glue_get_registry(RegistryId)
#'
#' @param RegistryId &#91;required&#93; This is a wrapper structure that may contain the registry name and
#' Amazon Resource Name (ARN).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegistryName = "string",
#'   RegistryArn = "string",
#'   Description = "string",
#'   Status = "AVAILABLE"|"DELETING",
#'   CreatedTime = "string",
#'   UpdatedTime = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_registry(
#'   RegistryId = list(
#'     RegistryName = "string",
#'     RegistryArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_registry
glue_get_registry <- function(RegistryId) {
  op <- new_operation(
    name = "GetRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_registry_input(RegistryId = RegistryId)
  output <- .glue$get_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_registry <- glue_get_registry

#' Retrieves the security configurations for the resource policies set on
#' individual resources, and also the account-level policy
#'
#' @description
#' Retrieves the security configurations for the resource policies set on
#' individual resources, and also the account-level policy.
#' 
#' This operation also returns the Data Catalog resource policy. However,
#' if you enabled metadata encryption in Data Catalog settings, and you do
#' not have permission on the AWS KMS key, the operation can't return the
#' Data Catalog resource policy.
#'
#' @usage
#' glue_get_resource_policies(NextToken, MaxResults)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   GetResourcePoliciesResponseList = list(
#'     list(
#'       PolicyInJson = "string",
#'       PolicyHash = "string",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       UpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_policies(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_resource_policies
glue_get_resource_policies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_resource_policies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_resource_policies_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_resource_policies <- glue_get_resource_policies

#' Retrieves a specified resource policy
#'
#' @description
#' Retrieves a specified resource policy.
#'
#' @usage
#' glue_get_resource_policy(ResourceArn)
#'
#' @param ResourceArn The ARN of the AWS Glue resource for the resource policy to be
#' retrieved. For more information about AWS Glue resource ARNs, see the
#' [AWS Glue ARN string
#' pattern](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id)
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PolicyInJson = "string",
#'   PolicyHash = "string",
#'   CreateTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UpdateTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_policy(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_resource_policy
glue_get_resource_policy <- function(ResourceArn = NULL) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_resource_policy_input(ResourceArn = ResourceArn)
  output <- .glue$get_resource_policy_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_resource_policy <- glue_get_resource_policy

#' Describes the specified schema in detail
#'
#' @description
#' Describes the specified schema in detail.
#'
#' @usage
#' glue_get_schema(SchemaId)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegistryName = "string",
#'   RegistryArn = "string",
#'   SchemaName = "string",
#'   SchemaArn = "string",
#'   Description = "string",
#'   DataFormat = "AVRO",
#'   Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
#'   SchemaCheckpoint = 123,
#'   LatestSchemaVersion = 123,
#'   NextSchemaVersion = 123,
#'   SchemaStatus = "AVAILABLE"|"PENDING"|"DELETING",
#'   CreatedTime = "string",
#'   UpdatedTime = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_schema(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_schema
glue_get_schema <- function(SchemaId) {
  op <- new_operation(
    name = "GetSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_input(SchemaId = SchemaId)
  output <- .glue$get_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema <- glue_get_schema

#' Retrieves a schema by the SchemaDefinition
#'
#' @description
#' Retrieves a schema by the `SchemaDefinition`. The schema definition is
#' sent to the Schema Registry, canonicalized, and hashed. If the hash is
#' matched within the scope of the `SchemaName` or ARN (or the default
#' registry, if none is supplied), that schema’s metadata is returned.
#' Otherwise, a 404 or NotFound error is returned. Schema versions in
#' `Deleted` statuses will not be included in the results.
#'
#' @usage
#' glue_get_schema_by_definition(SchemaId, SchemaDefinition)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     One of `SchemaArn` or `SchemaName` has to be provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. One of `SchemaArn` or
#'     `SchemaName` has to be provided.
#' @param SchemaDefinition &#91;required&#93; The definition of the schema for which schema details are required.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaVersionId = "string",
#'   SchemaArn = "string",
#'   DataFormat = "AVRO",
#'   Status = "AVAILABLE"|"PENDING"|"FAILURE"|"DELETING",
#'   CreatedTime = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_schema_by_definition(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaDefinition = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_schema_by_definition
glue_get_schema_by_definition <- function(SchemaId, SchemaDefinition) {
  op <- new_operation(
    name = "GetSchemaByDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_by_definition_input(SchemaId = SchemaId, SchemaDefinition = SchemaDefinition)
  output <- .glue$get_schema_by_definition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema_by_definition <- glue_get_schema_by_definition

#' Get the specified schema by its unique ID assigned when a version of the
#' schema is created or registered
#'
#' @description
#' Get the specified schema by its unique ID assigned when a version of the
#' schema is created or registered. Schema versions in Deleted status will
#' not be included in the results.
#'
#' @usage
#' glue_get_schema_version(SchemaId, SchemaVersionId, SchemaVersionNumber)
#'
#' @param SchemaId This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#' @param SchemaVersionId The `SchemaVersionId` of the schema version. This field is required for
#' fetching by schema ID. Either this or the `SchemaId` wrapper has to be
#' provided.
#' @param SchemaVersionNumber The version number of the schema.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaVersionId = "string",
#'   SchemaDefinition = "string",
#'   DataFormat = "AVRO",
#'   SchemaArn = "string",
#'   VersionNumber = 123,
#'   Status = "AVAILABLE"|"PENDING"|"FAILURE"|"DELETING",
#'   CreatedTime = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_schema_version(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaVersionId = "string",
#'   SchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_schema_version
glue_get_schema_version <- function(SchemaId = NULL, SchemaVersionId = NULL, SchemaVersionNumber = NULL) {
  op <- new_operation(
    name = "GetSchemaVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_version_input(SchemaId = SchemaId, SchemaVersionId = SchemaVersionId, SchemaVersionNumber = SchemaVersionNumber)
  output <- .glue$get_schema_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema_version <- glue_get_schema_version

#' Fetches the schema version difference in the specified difference type
#' between two stored schema versions in the Schema Registry
#'
#' @description
#' Fetches the schema version difference in the specified difference type
#' between two stored schema versions in the Schema Registry.
#' 
#' This API allows you to compare two schema versions between two schema
#' definitions under the same schema.
#'
#' @usage
#' glue_get_schema_versions_diff(SchemaId, FirstSchemaVersionNumber,
#'   SecondSchemaVersionNumber, SchemaDiffType)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     One of `SchemaArn` or `SchemaName` has to be provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. One of `SchemaArn` or
#'     `SchemaName` has to be provided.
#' @param FirstSchemaVersionNumber &#91;required&#93; The first of the two schema versions to be compared.
#' @param SecondSchemaVersionNumber &#91;required&#93; The second of the two schema versions to be compared.
#' @param SchemaDiffType &#91;required&#93; Refers to `SYNTAX_DIFF`, which is the currently supported diff type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Diff = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_schema_versions_diff(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   FirstSchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   ),
#'   SecondSchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   ),
#'   SchemaDiffType = "SYNTAX_DIFF"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_schema_versions_diff
glue_get_schema_versions_diff <- function(SchemaId, FirstSchemaVersionNumber, SecondSchemaVersionNumber, SchemaDiffType) {
  op <- new_operation(
    name = "GetSchemaVersionsDiff",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_schema_versions_diff_input(SchemaId = SchemaId, FirstSchemaVersionNumber = FirstSchemaVersionNumber, SecondSchemaVersionNumber = SecondSchemaVersionNumber, SchemaDiffType = SchemaDiffType)
  output <- .glue$get_schema_versions_diff_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_schema_versions_diff <- glue_get_schema_versions_diff

#' Retrieves a specified security configuration
#'
#' @description
#' Retrieves a specified security configuration.
#'
#' @usage
#' glue_get_security_configuration(Name)
#'
#' @param Name &#91;required&#93; The name of the security configuration to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SecurityConfiguration = list(
#'     Name = "string",
#'     CreatedTimeStamp = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EncryptionConfiguration = list(
#'       S3Encryption = list(
#'         list(
#'           S3EncryptionMode = "DISABLED"|"SSE-KMS"|"SSE-S3",
#'           KmsKeyArn = "string"
#'         )
#'       ),
#'       CloudWatchEncryption = list(
#'         CloudWatchEncryptionMode = "DISABLED"|"SSE-KMS",
#'         KmsKeyArn = "string"
#'       ),
#'       JobBookmarksEncryption = list(
#'         JobBookmarksEncryptionMode = "DISABLED"|"CSE-KMS",
#'         KmsKeyArn = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_security_configuration(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_security_configuration
glue_get_security_configuration <- function(Name) {
  op <- new_operation(
    name = "GetSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_security_configuration_input(Name = Name)
  output <- .glue$get_security_configuration_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_security_configuration <- glue_get_security_configuration

#' Retrieves a list of all security configurations
#'
#' @description
#' Retrieves a list of all security configurations.
#'
#' @usage
#' glue_get_security_configurations(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of results to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SecurityConfigurations = list(
#'     list(
#'       Name = "string",
#'       CreatedTimeStamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EncryptionConfiguration = list(
#'         S3Encryption = list(
#'           list(
#'             S3EncryptionMode = "DISABLED"|"SSE-KMS"|"SSE-S3",
#'             KmsKeyArn = "string"
#'           )
#'         ),
#'         CloudWatchEncryption = list(
#'           CloudWatchEncryptionMode = "DISABLED"|"SSE-KMS",
#'           KmsKeyArn = "string"
#'         ),
#'         JobBookmarksEncryption = list(
#'           JobBookmarksEncryptionMode = "DISABLED"|"CSE-KMS",
#'           KmsKeyArn = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_security_configurations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_security_configurations
glue_get_security_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetSecurityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_security_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_security_configurations_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_security_configurations <- glue_get_security_configurations

#' Retrieves the Table definition in a Data Catalog for a specified table
#'
#' @description
#' Retrieves the `Table` definition in a Data Catalog for a specified
#' table.
#'
#' @usage
#' glue_get_table(CatalogId, DatabaseName, Name)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides. For
#' Hive compatibility, this name is entirely lowercase.
#' @param Name &#91;required&#93; The name of the table for which to retrieve the definition. For Hive
#' compatibility, this name is entirely lowercase.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Table = list(
#'     Name = "string",
#'     DatabaseName = "string",
#'     Description = "string",
#'     Owner = "string",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UpdateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Retention = 123,
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE,
#'       SchemaReference = list(
#'         SchemaId = list(
#'           SchemaArn = "string",
#'           SchemaName = "string",
#'           RegistryName = "string"
#'         ),
#'         SchemaVersionId = "string",
#'         SchemaVersionNumber = 123
#'       )
#'     ),
#'     PartitionKeys = list(
#'       list(
#'         Name = "string",
#'         Type = "string",
#'         Comment = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     ViewOriginalText = "string",
#'     ViewExpandedText = "string",
#'     TableType = "string",
#'     Parameters = list(
#'       "string"
#'     ),
#'     CreatedBy = "string",
#'     IsRegisteredWithLakeFormation = TRUE|FALSE,
#'     TargetTable = list(
#'       CatalogId = "string",
#'       DatabaseName = "string",
#'       Name = "string"
#'     ),
#'     CatalogId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_table
glue_get_table <- function(CatalogId = NULL, DatabaseName, Name) {
  op <- new_operation(
    name = "GetTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name)
  output <- .glue$get_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table <- glue_get_table

#' Retrieves a specified version of a table
#'
#' @description
#' Retrieves a specified version of a table.
#'
#' @usage
#' glue_get_table_version(CatalogId, DatabaseName, TableName, VersionId)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionId The ID value of the table version to be retrieved. A `VersionID` is a
#' string representation of an integer. Each version is incremented by 1.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TableVersion = list(
#'     Table = list(
#'       Name = "string",
#'       DatabaseName = "string",
#'       Description = "string",
#'       Owner = "string",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       UpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Retention = 123,
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE,
#'         SchemaReference = list(
#'           SchemaId = list(
#'             SchemaArn = "string",
#'             SchemaName = "string",
#'             RegistryName = "string"
#'           ),
#'           SchemaVersionId = "string",
#'           SchemaVersionNumber = 123
#'         )
#'       ),
#'       PartitionKeys = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ViewOriginalText = "string",
#'       ViewExpandedText = "string",
#'       TableType = "string",
#'       Parameters = list(
#'         "string"
#'       ),
#'       CreatedBy = "string",
#'       IsRegisteredWithLakeFormation = TRUE|FALSE,
#'       TargetTable = list(
#'         CatalogId = "string",
#'         DatabaseName = "string",
#'         Name = "string"
#'       ),
#'       CatalogId = "string"
#'     ),
#'     VersionId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_table_version(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_table_version
glue_get_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionId = NULL) {
  op <- new_operation(
    name = "GetTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionId = VersionId)
  output <- .glue$get_table_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_version <- glue_get_table_version

#' Retrieves a list of strings that identify available versions of a
#' specified table
#'
#' @description
#' Retrieves a list of strings that identify available versions of a
#' specified table.
#'
#' @usage
#' glue_get_table_versions(CatalogId, DatabaseName, TableName, NextToken,
#'   MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param NextToken A continuation token, if this is not the first call.
#' @param MaxResults The maximum number of table versions to return in one response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TableVersions = list(
#'     list(
#'       Table = list(
#'         Name = "string",
#'         DatabaseName = "string",
#'         Description = "string",
#'         Owner = "string",
#'         CreateTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         UpdateTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         LastAccessTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         LastAnalyzedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         Retention = 123,
#'         StorageDescriptor = list(
#'           Columns = list(
#'             list(
#'               Name = "string",
#'               Type = "string",
#'               Comment = "string",
#'               Parameters = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Location = "string",
#'           InputFormat = "string",
#'           OutputFormat = "string",
#'           Compressed = TRUE|FALSE,
#'           NumberOfBuckets = 123,
#'           SerdeInfo = list(
#'             Name = "string",
#'             SerializationLibrary = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           ),
#'           BucketColumns = list(
#'             "string"
#'           ),
#'           SortColumns = list(
#'             list(
#'               Column = "string",
#'               SortOrder = 123
#'             )
#'           ),
#'           Parameters = list(
#'             "string"
#'           ),
#'           SkewedInfo = list(
#'             SkewedColumnNames = list(
#'               "string"
#'             ),
#'             SkewedColumnValues = list(
#'               "string"
#'             ),
#'             SkewedColumnValueLocationMaps = list(
#'               "string"
#'             )
#'           ),
#'           StoredAsSubDirectories = TRUE|FALSE,
#'           SchemaReference = list(
#'             SchemaId = list(
#'               SchemaArn = "string",
#'               SchemaName = "string",
#'               RegistryName = "string"
#'             ),
#'             SchemaVersionId = "string",
#'             SchemaVersionNumber = 123
#'           )
#'         ),
#'         PartitionKeys = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         ViewOriginalText = "string",
#'         ViewExpandedText = "string",
#'         TableType = "string",
#'         Parameters = list(
#'           "string"
#'         ),
#'         CreatedBy = "string",
#'         IsRegisteredWithLakeFormation = TRUE|FALSE,
#'         TargetTable = list(
#'           CatalogId = "string",
#'           DatabaseName = "string",
#'           Name = "string"
#'         ),
#'         CatalogId = "string"
#'       ),
#'       VersionId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_table_versions(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_table_versions
glue_get_table_versions <- function(CatalogId = NULL, DatabaseName, TableName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTableVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_versions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_table_versions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_versions <- glue_get_table_versions

#' Retrieves the definitions of some or all of the tables in a given
#' Database
#'
#' @description
#' Retrieves the definitions of some or all of the tables in a given
#' `Database`.
#'
#' @usage
#' glue_get_tables(CatalogId, DatabaseName, Expression, NextToken,
#'   MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog whose tables to list. For Hive
#' compatibility, this name is entirely lowercase.
#' @param Expression A regular expression pattern. If present, only those tables whose names
#' match the pattern are returned.
#' @param NextToken A continuation token, included if this is a continuation call.
#' @param MaxResults The maximum number of tables to return in a single response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TableList = list(
#'     list(
#'       Name = "string",
#'       DatabaseName = "string",
#'       Description = "string",
#'       Owner = "string",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       UpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Retention = 123,
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE,
#'         SchemaReference = list(
#'           SchemaId = list(
#'             SchemaArn = "string",
#'             SchemaName = "string",
#'             RegistryName = "string"
#'           ),
#'           SchemaVersionId = "string",
#'           SchemaVersionNumber = 123
#'         )
#'       ),
#'       PartitionKeys = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ViewOriginalText = "string",
#'       ViewExpandedText = "string",
#'       TableType = "string",
#'       Parameters = list(
#'         "string"
#'       ),
#'       CreatedBy = "string",
#'       IsRegisteredWithLakeFormation = TRUE|FALSE,
#'       TargetTable = list(
#'         CatalogId = "string",
#'         DatabaseName = "string",
#'         Name = "string"
#'       ),
#'       CatalogId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_tables(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Expression = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_tables
glue_get_tables <- function(CatalogId = NULL, DatabaseName, Expression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_tables_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Expression = Expression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_tables_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_tables <- glue_get_tables

#' Retrieves a list of tags associated with a resource
#'
#' @description
#' Retrieves a list of tags associated with a resource.
#'
#' @usage
#' glue_get_tags(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which to retrieve
#' tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_tags(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_tags
glue_get_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_tags_input(ResourceArn = ResourceArn)
  output <- .glue$get_tags_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_tags <- glue_get_tags

#' Retrieves the definition of a trigger
#'
#' @description
#' Retrieves the definition of a trigger.
#'
#' @usage
#' glue_get_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Trigger = list(
#'     Name = "string",
#'     WorkflowName = "string",
#'     Id = "string",
#'     Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'     State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'     Description = "string",
#'     Schedule = "string",
#'     Actions = list(
#'       list(
#'         JobName = "string",
#'         Arguments = list(
#'           "string"
#'         ),
#'         Timeout = 123,
#'         SecurityConfiguration = "string",
#'         NotificationProperty = list(
#'           NotifyDelayAfter = 123
#'         ),
#'         CrawlerName = "string"
#'       )
#'     ),
#'     Predicate = list(
#'       Logical = "AND"|"ANY",
#'       Conditions = list(
#'         list(
#'           LogicalOperator = "EQUALS",
#'           JobName = "string",
#'           State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'           CrawlerName = "string",
#'           CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_trigger
glue_get_trigger <- function(Name) {
  op <- new_operation(
    name = "GetTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_trigger_input(Name = Name)
  output <- .glue$get_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_trigger <- glue_get_trigger

#' Gets all the triggers associated with a job
#'
#' @description
#' Gets all the triggers associated with a job.
#'
#' @usage
#' glue_get_triggers(NextToken, DependentJobName, MaxResults)
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param DependentJobName The name of the job to retrieve triggers for. The trigger that can start
#' this job is returned, and if there is no such trigger, all triggers are
#' returned.
#' @param MaxResults The maximum size of the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Triggers = list(
#'     list(
#'       Name = "string",
#'       WorkflowName = "string",
#'       Id = "string",
#'       Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'       State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'       Description = "string",
#'       Schedule = "string",
#'       Actions = list(
#'         list(
#'           JobName = "string",
#'           Arguments = list(
#'             "string"
#'           ),
#'           Timeout = 123,
#'           SecurityConfiguration = "string",
#'           NotificationProperty = list(
#'             NotifyDelayAfter = 123
#'           ),
#'           CrawlerName = "string"
#'         )
#'       ),
#'       Predicate = list(
#'         Logical = "AND"|"ANY",
#'         Conditions = list(
#'           list(
#'             LogicalOperator = "EQUALS",
#'             JobName = "string",
#'             State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'             CrawlerName = "string",
#'             CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_triggers(
#'   NextToken = "string",
#'   DependentJobName = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_triggers
glue_get_triggers <- function(NextToken = NULL, DependentJobName = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_triggers_input(NextToken = NextToken, DependentJobName = DependentJobName, MaxResults = MaxResults)
  output <- .glue$get_triggers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_triggers <- glue_get_triggers

#' Retrieves a specified function definition from the Data Catalog
#'
#' @description
#' Retrieves a specified function definition from the Data Catalog.
#'
#' @usage
#' glue_get_user_defined_function(CatalogId, DatabaseName, FunctionName)
#'
#' @param CatalogId The ID of the Data Catalog where the function to be retrieved is
#' located. If none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function is located.
#' @param FunctionName &#91;required&#93; The name of the function.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UserDefinedFunction = list(
#'     FunctionName = "string",
#'     DatabaseName = "string",
#'     ClassName = "string",
#'     OwnerName = "string",
#'     OwnerType = "USER"|"ROLE"|"GROUP",
#'     CreateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ResourceUris = list(
#'       list(
#'         ResourceType = "JAR"|"FILE"|"ARCHIVE",
#'         Uri = "string"
#'       )
#'     ),
#'     CatalogId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_user_defined_function
glue_get_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName) {
  op <- new_operation(
    name = "GetUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName)
  output <- .glue$get_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_user_defined_function <- glue_get_user_defined_function

#' Retrieves multiple function definitions from the Data Catalog
#'
#' @description
#' Retrieves multiple function definitions from the Data Catalog.
#'
#' @usage
#' glue_get_user_defined_functions(CatalogId, DatabaseName, Pattern,
#'   NextToken, MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the functions to be retrieved are
#' located. If none is provided, the AWS account ID is used by default.
#' @param DatabaseName The name of the catalog database where the functions are located. If
#' none is provided, functions from all the databases across the catalog
#' will be returned.
#' @param Pattern &#91;required&#93; An optional function-name pattern string that filters the function
#' definitions returned.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of functions to return in one response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UserDefinedFunctions = list(
#'     list(
#'       FunctionName = "string",
#'       DatabaseName = "string",
#'       ClassName = "string",
#'       OwnerName = "string",
#'       OwnerType = "USER"|"ROLE"|"GROUP",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ResourceUris = list(
#'         list(
#'           ResourceType = "JAR"|"FILE"|"ARCHIVE",
#'           Uri = "string"
#'         )
#'       ),
#'       CatalogId = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_user_defined_functions(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Pattern = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_user_defined_functions
glue_get_user_defined_functions <- function(CatalogId = NULL, DatabaseName = NULL, Pattern, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetUserDefinedFunctions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_user_defined_functions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Pattern = Pattern, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_user_defined_functions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_user_defined_functions <- glue_get_user_defined_functions

#' Retrieves resource metadata for a workflow
#'
#' @description
#' Retrieves resource metadata for a workflow.
#'
#' @usage
#' glue_get_workflow(Name, IncludeGraph)
#'
#' @param Name &#91;required&#93; The name of the workflow to retrieve.
#' @param IncludeGraph Specifies whether to include a graph when returning the workflow
#' resource metadata.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Workflow = list(
#'     Name = "string",
#'     Description = "string",
#'     DefaultRunProperties = list(
#'       "string"
#'     ),
#'     CreatedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastRun = list(
#'       Name = "string",
#'       WorkflowRunId = "string",
#'       PreviousRunId = "string",
#'       WorkflowRunProperties = list(
#'         "string"
#'       ),
#'       StartedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CompletedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Status = "RUNNING"|"COMPLETED"|"STOPPING"|"STOPPED"|"ERROR",
#'       ErrorMessage = "string",
#'       Statistics = list(
#'         TotalActions = 123,
#'         TimeoutActions = 123,
#'         FailedActions = 123,
#'         StoppedActions = 123,
#'         SucceededActions = 123,
#'         RunningActions = 123
#'       ),
#'       Graph = list(
#'         Nodes = list(
#'           list(
#'             Type = "CRAWLER"|"JOB"|"TRIGGER",
#'             Name = "string",
#'             UniqueId = "string",
#'             TriggerDetails = list(
#'               Trigger = list(
#'                 Name = "string",
#'                 WorkflowName = "string",
#'                 Id = "string",
#'                 Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'                 State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'                 Description = "string",
#'                 Schedule = "string",
#'                 Actions = list(
#'                   list(
#'                     JobName = "string",
#'                     Arguments = list(
#'                       "string"
#'                     ),
#'                     Timeout = 123,
#'                     SecurityConfiguration = "string",
#'                     NotificationProperty = list(
#'                       NotifyDelayAfter = 123
#'                     ),
#'                     CrawlerName = "string"
#'                   )
#'                 ),
#'                 Predicate = list(
#'                   Logical = "AND"|"ANY",
#'                   Conditions = list(
#'                     list(
#'                       LogicalOperator = "EQUALS",
#'                       JobName = "string",
#'                       State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                       CrawlerName = "string",
#'                       CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             JobDetails = list(
#'               JobRuns = list(
#'                 list(
#'                   Id = "string",
#'                   Attempt = 123,
#'                   PreviousRunId = "string",
#'                   TriggerName = "string",
#'                   JobName = "string",
#'                   StartedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   LastModifiedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   CompletedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                   Arguments = list(
#'                     "string"
#'                   ),
#'                   ErrorMessage = "string",
#'                   PredecessorRuns = list(
#'                     list(
#'                       JobName = "string",
#'                       RunId = "string"
#'                     )
#'                   ),
#'                   AllocatedCapacity = 123,
#'                   ExecutionTime = 123,
#'                   Timeout = 123,
#'                   MaxCapacity = 123.0,
#'                   WorkerType = "Standard"|"G.1X"|"G.2X",
#'                   NumberOfWorkers = 123,
#'                   SecurityConfiguration = "string",
#'                   LogGroupName = "string",
#'                   NotificationProperty = list(
#'                     NotifyDelayAfter = 123
#'                   ),
#'                   GlueVersion = "string"
#'                 )
#'               )
#'             ),
#'             CrawlerDetails = list(
#'               Crawls = list(
#'                 list(
#'                   State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
#'                   StartedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   CompletedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   ErrorMessage = "string",
#'                   LogGroup = "string",
#'                   LogStream = "string"
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         Edges = list(
#'           list(
#'             SourceId = "string",
#'             DestinationId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     Graph = list(
#'       Nodes = list(
#'         list(
#'           Type = "CRAWLER"|"JOB"|"TRIGGER",
#'           Name = "string",
#'           UniqueId = "string",
#'           TriggerDetails = list(
#'             Trigger = list(
#'               Name = "string",
#'               WorkflowName = "string",
#'               Id = "string",
#'               Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'               State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'               Description = "string",
#'               Schedule = "string",
#'               Actions = list(
#'                 list(
#'                   JobName = "string",
#'                   Arguments = list(
#'                     "string"
#'                   ),
#'                   Timeout = 123,
#'                   SecurityConfiguration = "string",
#'                   NotificationProperty = list(
#'                     NotifyDelayAfter = 123
#'                   ),
#'                   CrawlerName = "string"
#'                 )
#'               ),
#'               Predicate = list(
#'                 Logical = "AND"|"ANY",
#'                 Conditions = list(
#'                   list(
#'                     LogicalOperator = "EQUALS",
#'                     JobName = "string",
#'                     State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                     CrawlerName = "string",
#'                     CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           JobDetails = list(
#'             JobRuns = list(
#'               list(
#'                 Id = "string",
#'                 Attempt = 123,
#'                 PreviousRunId = "string",
#'                 TriggerName = "string",
#'                 JobName = "string",
#'                 StartedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 LastModifiedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 CompletedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                 Arguments = list(
#'                   "string"
#'                 ),
#'                 ErrorMessage = "string",
#'                 PredecessorRuns = list(
#'                   list(
#'                     JobName = "string",
#'                     RunId = "string"
#'                   )
#'                 ),
#'                 AllocatedCapacity = 123,
#'                 ExecutionTime = 123,
#'                 Timeout = 123,
#'                 MaxCapacity = 123.0,
#'                 WorkerType = "Standard"|"G.1X"|"G.2X",
#'                 NumberOfWorkers = 123,
#'                 SecurityConfiguration = "string",
#'                 LogGroupName = "string",
#'                 NotificationProperty = list(
#'                   NotifyDelayAfter = 123
#'                 ),
#'                 GlueVersion = "string"
#'               )
#'             )
#'           ),
#'           CrawlerDetails = list(
#'             Crawls = list(
#'               list(
#'                 State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
#'                 StartedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 CompletedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 ErrorMessage = "string",
#'                 LogGroup = "string",
#'                 LogStream = "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       Edges = list(
#'         list(
#'           SourceId = "string",
#'           DestinationId = "string"
#'         )
#'       )
#'     ),
#'     MaxConcurrentRuns = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_workflow(
#'   Name = "string",
#'   IncludeGraph = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow
glue_get_workflow <- function(Name, IncludeGraph = NULL) {
  op <- new_operation(
    name = "GetWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_input(Name = Name, IncludeGraph = IncludeGraph)
  output <- .glue$get_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow <- glue_get_workflow

#' Retrieves the metadata for a given workflow run
#'
#' @description
#' Retrieves the metadata for a given workflow run.
#'
#' @usage
#' glue_get_workflow_run(Name, RunId, IncludeGraph)
#'
#' @param Name &#91;required&#93; Name of the workflow being run.
#' @param RunId &#91;required&#93; The ID of the workflow run.
#' @param IncludeGraph Specifies whether to include the workflow graph in response or not.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Run = list(
#'     Name = "string",
#'     WorkflowRunId = "string",
#'     PreviousRunId = "string",
#'     WorkflowRunProperties = list(
#'       "string"
#'     ),
#'     StartedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CompletedOn = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Status = "RUNNING"|"COMPLETED"|"STOPPING"|"STOPPED"|"ERROR",
#'     ErrorMessage = "string",
#'     Statistics = list(
#'       TotalActions = 123,
#'       TimeoutActions = 123,
#'       FailedActions = 123,
#'       StoppedActions = 123,
#'       SucceededActions = 123,
#'       RunningActions = 123
#'     ),
#'     Graph = list(
#'       Nodes = list(
#'         list(
#'           Type = "CRAWLER"|"JOB"|"TRIGGER",
#'           Name = "string",
#'           UniqueId = "string",
#'           TriggerDetails = list(
#'             Trigger = list(
#'               Name = "string",
#'               WorkflowName = "string",
#'               Id = "string",
#'               Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'               State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'               Description = "string",
#'               Schedule = "string",
#'               Actions = list(
#'                 list(
#'                   JobName = "string",
#'                   Arguments = list(
#'                     "string"
#'                   ),
#'                   Timeout = 123,
#'                   SecurityConfiguration = "string",
#'                   NotificationProperty = list(
#'                     NotifyDelayAfter = 123
#'                   ),
#'                   CrawlerName = "string"
#'                 )
#'               ),
#'               Predicate = list(
#'                 Logical = "AND"|"ANY",
#'                 Conditions = list(
#'                   list(
#'                     LogicalOperator = "EQUALS",
#'                     JobName = "string",
#'                     State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                     CrawlerName = "string",
#'                     CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           JobDetails = list(
#'             JobRuns = list(
#'               list(
#'                 Id = "string",
#'                 Attempt = 123,
#'                 PreviousRunId = "string",
#'                 TriggerName = "string",
#'                 JobName = "string",
#'                 StartedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 LastModifiedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 CompletedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                 Arguments = list(
#'                   "string"
#'                 ),
#'                 ErrorMessage = "string",
#'                 PredecessorRuns = list(
#'                   list(
#'                     JobName = "string",
#'                     RunId = "string"
#'                   )
#'                 ),
#'                 AllocatedCapacity = 123,
#'                 ExecutionTime = 123,
#'                 Timeout = 123,
#'                 MaxCapacity = 123.0,
#'                 WorkerType = "Standard"|"G.1X"|"G.2X",
#'                 NumberOfWorkers = 123,
#'                 SecurityConfiguration = "string",
#'                 LogGroupName = "string",
#'                 NotificationProperty = list(
#'                   NotifyDelayAfter = 123
#'                 ),
#'                 GlueVersion = "string"
#'               )
#'             )
#'           ),
#'           CrawlerDetails = list(
#'             Crawls = list(
#'               list(
#'                 State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
#'                 StartedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 CompletedOn = as.POSIXct(
#'                   "2015-01-01"
#'                 ),
#'                 ErrorMessage = "string",
#'                 LogGroup = "string",
#'                 LogStream = "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       Edges = list(
#'         list(
#'           SourceId = "string",
#'           DestinationId = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_workflow_run(
#'   Name = "string",
#'   RunId = "string",
#'   IncludeGraph = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow_run
glue_get_workflow_run <- function(Name, RunId, IncludeGraph = NULL) {
  op <- new_operation(
    name = "GetWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_run_input(Name = Name, RunId = RunId, IncludeGraph = IncludeGraph)
  output <- .glue$get_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow_run <- glue_get_workflow_run

#' Retrieves the workflow run properties which were set during the run
#'
#' @description
#' Retrieves the workflow run properties which were set during the run.
#'
#' @usage
#' glue_get_workflow_run_properties(Name, RunId)
#'
#' @param Name &#91;required&#93; Name of the workflow which was run.
#' @param RunId &#91;required&#93; The ID of the workflow run whose run properties should be returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RunProperties = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_workflow_run_properties(
#'   Name = "string",
#'   RunId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow_run_properties
glue_get_workflow_run_properties <- function(Name, RunId) {
  op <- new_operation(
    name = "GetWorkflowRunProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_run_properties_input(Name = Name, RunId = RunId)
  output <- .glue$get_workflow_run_properties_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow_run_properties <- glue_get_workflow_run_properties

#' Retrieves metadata for all runs of a given workflow
#'
#' @description
#' Retrieves metadata for all runs of a given workflow.
#'
#' @usage
#' glue_get_workflow_runs(Name, IncludeGraph, NextToken, MaxResults)
#'
#' @param Name &#91;required&#93; Name of the workflow whose metadata of runs should be returned.
#' @param IncludeGraph Specifies whether to include the workflow graph in response or not.
#' @param NextToken The maximum size of the response.
#' @param MaxResults The maximum number of workflow runs to be included in the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Runs = list(
#'     list(
#'       Name = "string",
#'       WorkflowRunId = "string",
#'       PreviousRunId = "string",
#'       WorkflowRunProperties = list(
#'         "string"
#'       ),
#'       StartedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       CompletedOn = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Status = "RUNNING"|"COMPLETED"|"STOPPING"|"STOPPED"|"ERROR",
#'       ErrorMessage = "string",
#'       Statistics = list(
#'         TotalActions = 123,
#'         TimeoutActions = 123,
#'         FailedActions = 123,
#'         StoppedActions = 123,
#'         SucceededActions = 123,
#'         RunningActions = 123
#'       ),
#'       Graph = list(
#'         Nodes = list(
#'           list(
#'             Type = "CRAWLER"|"JOB"|"TRIGGER",
#'             Name = "string",
#'             UniqueId = "string",
#'             TriggerDetails = list(
#'               Trigger = list(
#'                 Name = "string",
#'                 WorkflowName = "string",
#'                 Id = "string",
#'                 Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'                 State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'                 Description = "string",
#'                 Schedule = "string",
#'                 Actions = list(
#'                   list(
#'                     JobName = "string",
#'                     Arguments = list(
#'                       "string"
#'                     ),
#'                     Timeout = 123,
#'                     SecurityConfiguration = "string",
#'                     NotificationProperty = list(
#'                       NotifyDelayAfter = 123
#'                     ),
#'                     CrawlerName = "string"
#'                   )
#'                 ),
#'                 Predicate = list(
#'                   Logical = "AND"|"ANY",
#'                   Conditions = list(
#'                     list(
#'                       LogicalOperator = "EQUALS",
#'                       JobName = "string",
#'                       State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                       CrawlerName = "string",
#'                       CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'                     )
#'                   )
#'                 )
#'               )
#'             ),
#'             JobDetails = list(
#'               JobRuns = list(
#'                 list(
#'                   Id = "string",
#'                   Attempt = 123,
#'                   PreviousRunId = "string",
#'                   TriggerName = "string",
#'                   JobName = "string",
#'                   StartedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   LastModifiedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   CompletedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'                   Arguments = list(
#'                     "string"
#'                   ),
#'                   ErrorMessage = "string",
#'                   PredecessorRuns = list(
#'                     list(
#'                       JobName = "string",
#'                       RunId = "string"
#'                     )
#'                   ),
#'                   AllocatedCapacity = 123,
#'                   ExecutionTime = 123,
#'                   Timeout = 123,
#'                   MaxCapacity = 123.0,
#'                   WorkerType = "Standard"|"G.1X"|"G.2X",
#'                   NumberOfWorkers = 123,
#'                   SecurityConfiguration = "string",
#'                   LogGroupName = "string",
#'                   NotificationProperty = list(
#'                     NotifyDelayAfter = 123
#'                   ),
#'                   GlueVersion = "string"
#'                 )
#'               )
#'             ),
#'             CrawlerDetails = list(
#'               Crawls = list(
#'                 list(
#'                   State = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED",
#'                   StartedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   CompletedOn = as.POSIXct(
#'                     "2015-01-01"
#'                   ),
#'                   ErrorMessage = "string",
#'                   LogGroup = "string",
#'                   LogStream = "string"
#'                 )
#'               )
#'             )
#'           )
#'         ),
#'         Edges = list(
#'           list(
#'             SourceId = "string",
#'             DestinationId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_workflow_runs(
#'   Name = "string",
#'   IncludeGraph = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_workflow_runs
glue_get_workflow_runs <- function(Name, IncludeGraph = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetWorkflowRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_workflow_runs_input(Name = Name, IncludeGraph = IncludeGraph, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_workflow_runs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_workflow_runs <- glue_get_workflow_runs

#' Imports an existing Amazon Athena Data Catalog to AWS Glue
#'
#' @description
#' Imports an existing Amazon Athena Data Catalog to AWS Glue
#'
#' @usage
#' glue_import_catalog_to_glue(CatalogId)
#'
#' @param CatalogId The ID of the catalog to import. Currently, this should be the AWS
#' account ID.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$import_catalog_to_glue(
#'   CatalogId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_import_catalog_to_glue
glue_import_catalog_to_glue <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "ImportCatalogToGlue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$import_catalog_to_glue_input(CatalogId = CatalogId)
  output <- .glue$import_catalog_to_glue_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$import_catalog_to_glue <- glue_import_catalog_to_glue

#' Retrieves the names of all crawler resources in this AWS account, or the
#' resources with the specified tag
#'
#' @description
#' Retrieves the names of all crawler resources in this AWS account, or the
#' resources with the specified tag. This operation allows you to see which
#' resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field, which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' are retrieved.
#'
#' @usage
#' glue_list_crawlers(MaxResults, NextToken, Tags)
#'
#' @param MaxResults The maximum size of a list to return.
#' @param NextToken A continuation token, if this is a continuation request.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   CrawlerNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_crawlers(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_crawlers
glue_list_crawlers <- function(MaxResults = NULL, NextToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_crawlers_input(MaxResults = MaxResults, NextToken = NextToken, Tags = Tags)
  output <- .glue$list_crawlers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_crawlers <- glue_list_crawlers

#' Retrieves the names of all DevEndpoint resources in this AWS account, or
#' the resources with the specified tag
#'
#' @description
#' Retrieves the names of all `DevEndpoint` resources in this AWS account,
#' or the resources with the specified tag. This operation allows you to
#' see which resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field, which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' are retrieved.
#'
#' @usage
#' glue_list_dev_endpoints(NextToken, MaxResults, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   DevEndpointNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_dev_endpoints(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_dev_endpoints
glue_list_dev_endpoints <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_dev_endpoints_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_dev_endpoints_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_dev_endpoints <- glue_list_dev_endpoints

#' Retrieves the names of all job resources in this AWS account, or the
#' resources with the specified tag
#'
#' @description
#' Retrieves the names of all job resources in this AWS account, or the
#' resources with the specified tag. This operation allows you to see which
#' resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field, which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' are retrieved.
#'
#' @usage
#' glue_list_jobs(NextToken, MaxResults, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_jobs
glue_list_jobs <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_jobs_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_jobs_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_jobs <- glue_list_jobs

#' Retrieves a sortable, filterable list of existing AWS Glue machine
#' learning transforms in this AWS account, or the resources with the
#' specified tag
#'
#' @description
#' Retrieves a sortable, filterable list of existing AWS Glue machine
#' learning transforms in this AWS account, or the resources with the
#' specified tag. This operation takes the optional `Tags` field, which you
#' can use as a filter of the responses so that tagged resources can be
#' retrieved as a group. If you choose to use tag filtering, only resources
#' with the tags are retrieved.
#'
#' @usage
#' glue_list_ml_transforms(NextToken, MaxResults, Filter, Sort, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Filter A `TransformFilterCriteria` used to filter the machine learning
#' transforms.
#' @param Sort A `TransformSortCriteria` used to sort the machine learning transforms.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_ml_transforms(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filter = list(
#'     Name = "string",
#'     TransformType = "FIND_MATCHES",
#'     Status = "NOT_READY"|"READY"|"DELETING",
#'     GlueVersion = "string",
#'     CreatedBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     CreatedAfter = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedBefore = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastModifiedAfter = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Schema = list(
#'       list(
#'         Name = "string",
#'         DataType = "string"
#'       )
#'     )
#'   ),
#'   Sort = list(
#'     Column = "NAME"|"TRANSFORM_TYPE"|"STATUS"|"CREATED"|"LAST_MODIFIED",
#'     SortDirection = "DESCENDING"|"ASCENDING"
#'   ),
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_ml_transforms
glue_list_ml_transforms <- function(NextToken = NULL, MaxResults = NULL, Filter = NULL, Sort = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListMLTransforms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_ml_transforms_input(NextToken = NextToken, MaxResults = MaxResults, Filter = Filter, Sort = Sort, Tags = Tags)
  output <- .glue$list_ml_transforms_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_ml_transforms <- glue_list_ml_transforms

#' Returns a list of registries that you have created, with minimal
#' registry information
#'
#' @description
#' Returns a list of registries that you have created, with minimal
#' registry information. Registries in the `Deleting` status will not be
#' included in the results. Empty results will be returned if there are no
#' registries available.
#'
#' @usage
#' glue_list_registries(MaxResults, NextToken)
#'
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Registries = list(
#'     list(
#'       RegistryName = "string",
#'       RegistryArn = "string",
#'       Description = "string",
#'       Status = "AVAILABLE"|"DELETING",
#'       CreatedTime = "string",
#'       UpdatedTime = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_registries(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_registries
glue_list_registries <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRegistries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_registries_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_registries_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_registries <- glue_list_registries

#' Returns a list of schema versions that you have created, with minimal
#' information
#'
#' @description
#' Returns a list of schema versions that you have created, with minimal
#' information. Schema versions in Deleted status will not be included in
#' the results. Empty results will be returned if there are no schema
#' versions available.
#'
#' @usage
#' glue_list_schema_versions(SchemaId, MaxResults, NextToken)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Schemas = list(
#'     list(
#'       SchemaArn = "string",
#'       SchemaVersionId = "string",
#'       VersionNumber = 123,
#'       Status = "AVAILABLE"|"PENDING"|"FAILURE"|"DELETING",
#'       CreatedTime = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_schema_versions(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_schema_versions
glue_list_schema_versions <- function(SchemaId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSchemaVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_schema_versions_input(SchemaId = SchemaId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_schema_versions_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_schema_versions <- glue_list_schema_versions

#' Returns a list of schemas with minimal details
#'
#' @description
#' Returns a list of schemas with minimal details. Schemas in Deleting
#' status will not be included in the results. Empty results will be
#' returned if there are no schemas available.
#' 
#' When the `RegistryId` is not provided, all the schemas across registries
#' will be part of the API response.
#'
#' @usage
#' glue_list_schemas(RegistryId, MaxResults, NextToken)
#'
#' @param RegistryId A wrapper structure that may contain the registry name and Amazon
#' Resource Name (ARN).
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Schemas = list(
#'     list(
#'       RegistryName = "string",
#'       SchemaName = "string",
#'       SchemaArn = "string",
#'       Description = "string",
#'       SchemaStatus = "AVAILABLE"|"PENDING"|"DELETING",
#'       CreatedTime = "string",
#'       UpdatedTime = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_schemas(
#'   RegistryId = list(
#'     RegistryName = "string",
#'     RegistryArn = "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_schemas
glue_list_schemas <- function(RegistryId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_schemas_input(RegistryId = RegistryId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$list_schemas_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_schemas <- glue_list_schemas

#' Retrieves the names of all trigger resources in this AWS account, or the
#' resources with the specified tag
#'
#' @description
#' Retrieves the names of all trigger resources in this AWS account, or the
#' resources with the specified tag. This operation allows you to see which
#' resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field, which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' are retrieved.
#'
#' @usage
#' glue_list_triggers(NextToken, DependentJobName, MaxResults, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param DependentJobName The name of the job for which to retrieve triggers. The trigger that can
#' start this job is returned. If there is no such trigger, all triggers
#' are returned.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TriggerNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_triggers(
#'   NextToken = "string",
#'   DependentJobName = "string",
#'   MaxResults = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_triggers
glue_list_triggers <- function(NextToken = NULL, DependentJobName = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_triggers_input(NextToken = NextToken, DependentJobName = DependentJobName, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_triggers_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_triggers <- glue_list_triggers

#' Lists names of workflows created in the account
#'
#' @description
#' Lists names of workflows created in the account.
#'
#' @usage
#' glue_list_workflows(NextToken, MaxResults)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Workflows = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_workflows(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_workflows
glue_list_workflows <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkflows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_workflows_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$list_workflows_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_workflows <- glue_list_workflows

#' Sets the security configuration for a specified catalog
#'
#' @description
#' Sets the security configuration for a specified catalog. After the
#' configuration has been set, the specified encryption is applied to every
#' catalog write thereafter.
#'
#' @usage
#' glue_put_data_catalog_encryption_settings(CatalogId,
#'   DataCatalogEncryptionSettings)
#'
#' @param CatalogId The ID of the Data Catalog to set the security configuration for. If
#' none is provided, the AWS account ID is used by default.
#' @param DataCatalogEncryptionSettings &#91;required&#93; The security configuration to set.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_data_catalog_encryption_settings(
#'   CatalogId = "string",
#'   DataCatalogEncryptionSettings = list(
#'     EncryptionAtRest = list(
#'       CatalogEncryptionMode = "DISABLED"|"SSE-KMS",
#'       SseAwsKmsKeyId = "string"
#'     ),
#'     ConnectionPasswordEncryption = list(
#'       ReturnConnectionPasswordEncrypted = TRUE|FALSE,
#'       AwsKmsKeyId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_put_data_catalog_encryption_settings
glue_put_data_catalog_encryption_settings <- function(CatalogId = NULL, DataCatalogEncryptionSettings) {
  op <- new_operation(
    name = "PutDataCatalogEncryptionSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_data_catalog_encryption_settings_input(CatalogId = CatalogId, DataCatalogEncryptionSettings = DataCatalogEncryptionSettings)
  output <- .glue$put_data_catalog_encryption_settings_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_data_catalog_encryption_settings <- glue_put_data_catalog_encryption_settings

#' Sets the Data Catalog resource policy for access control
#'
#' @description
#' Sets the Data Catalog resource policy for access control.
#'
#' @usage
#' glue_put_resource_policy(PolicyInJson, ResourceArn, PolicyHashCondition,
#'   PolicyExistsCondition, EnableHybrid)
#'
#' @param PolicyInJson &#91;required&#93; Contains the policy document to set, in JSON format.
#' @param ResourceArn The ARN of the AWS Glue resource for the resource policy to be set. For
#' more information about AWS Glue resource ARNs, see the [AWS Glue ARN
#' string
#' pattern](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id)
#' @param PolicyHashCondition The hash value returned when the previous policy was set using
#' [`put_resource_policy`][glue_put_resource_policy]. Its purpose is to
#' prevent concurrent modifications of a policy. Do not use this parameter
#' if no previous policy has been set.
#' @param PolicyExistsCondition A value of `MUST_EXIST` is used to update a policy. A value of
#' `NOT_EXIST` is used to create a new policy. If a value of `NONE` or a
#' null value is used, the call will not depend on the existence of a
#' policy.
#' @param EnableHybrid Allows you to specify if you want to use both resource-level and
#' account/catalog-level resource policies. A resource-level policy is a
#' policy attached to an individual resource such as a database or a table.
#' 
#' The default value of `NO` indicates that resource-level policies cannot
#' co-exist with an account-level policy. A value of `YES` means the use of
#' both resource-level and account/catalog-level resource policies is
#' allowed.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PolicyHash = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_resource_policy(
#'   PolicyInJson = "string",
#'   ResourceArn = "string",
#'   PolicyHashCondition = "string",
#'   PolicyExistsCondition = "MUST_EXIST"|"NOT_EXIST"|"NONE",
#'   EnableHybrid = "TRUE"|"FALSE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_put_resource_policy
glue_put_resource_policy <- function(PolicyInJson, ResourceArn = NULL, PolicyHashCondition = NULL, PolicyExistsCondition = NULL, EnableHybrid = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_resource_policy_input(PolicyInJson = PolicyInJson, ResourceArn = ResourceArn, PolicyHashCondition = PolicyHashCondition, PolicyExistsCondition = PolicyExistsCondition, EnableHybrid = EnableHybrid)
  output <- .glue$put_resource_policy_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_resource_policy <- glue_put_resource_policy

#' Puts the metadata key value pair for a specified schema version ID
#'
#' @description
#' Puts the metadata key value pair for a specified schema version ID. A
#' maximum of 10 key value pairs will be allowed per schema version. They
#' can be added over one or more calls.
#'
#' @usage
#' glue_put_schema_version_metadata(SchemaId, SchemaVersionNumber,
#'   SchemaVersionId, MetadataKeyValue)
#'
#' @param SchemaId The unique ID for the schema.
#' @param SchemaVersionNumber The version number of the schema.
#' @param SchemaVersionId The unique version ID of the schema version.
#' @param MetadataKeyValue &#91;required&#93; The metadata key's corresponding value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaArn = "string",
#'   SchemaName = "string",
#'   RegistryName = "string",
#'   LatestVersion = TRUE|FALSE,
#'   VersionNumber = 123,
#'   SchemaVersionId = "string",
#'   MetadataKey = "string",
#'   MetadataValue = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_schema_version_metadata(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   ),
#'   SchemaVersionId = "string",
#'   MetadataKeyValue = list(
#'     MetadataKey = "string",
#'     MetadataValue = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_put_schema_version_metadata
glue_put_schema_version_metadata <- function(SchemaId = NULL, SchemaVersionNumber = NULL, SchemaVersionId = NULL, MetadataKeyValue) {
  op <- new_operation(
    name = "PutSchemaVersionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_schema_version_metadata_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, SchemaVersionId = SchemaVersionId, MetadataKeyValue = MetadataKeyValue)
  output <- .glue$put_schema_version_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_schema_version_metadata <- glue_put_schema_version_metadata

#' Puts the specified workflow run properties for the given workflow run
#'
#' @description
#' Puts the specified workflow run properties for the given workflow run.
#' If a property already exists for the specified run, then it overrides
#' the value otherwise adds the property to existing properties.
#'
#' @usage
#' glue_put_workflow_run_properties(Name, RunId, RunProperties)
#'
#' @param Name &#91;required&#93; Name of the workflow which was run.
#' @param RunId &#91;required&#93; The ID of the workflow run for which the run properties should be
#' updated.
#' @param RunProperties &#91;required&#93; The properties to put for the specified run.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_workflow_run_properties(
#'   Name = "string",
#'   RunId = "string",
#'   RunProperties = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_put_workflow_run_properties
glue_put_workflow_run_properties <- function(Name, RunId, RunProperties) {
  op <- new_operation(
    name = "PutWorkflowRunProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_workflow_run_properties_input(Name = Name, RunId = RunId, RunProperties = RunProperties)
  output <- .glue$put_workflow_run_properties_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_workflow_run_properties <- glue_put_workflow_run_properties

#' Queries for the schema version metadata information
#'
#' @description
#' Queries for the schema version metadata information.
#'
#' @usage
#' glue_query_schema_version_metadata(SchemaId, SchemaVersionNumber,
#'   SchemaVersionId, MetadataList, MaxResults, NextToken)
#'
#' @param SchemaId A wrapper structure that may contain the schema name and Amazon Resource
#' Name (ARN).
#' @param SchemaVersionNumber The version number of the schema.
#' @param SchemaVersionId The unique version ID of the schema version.
#' @param MetadataList Search key-value pairs for metadata, if they are not provided all the
#' metadata information will be fetched.
#' @param MaxResults Maximum number of results required per page. If the value is not
#' supplied, this will be defaulted to 25 per page.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   MetadataInfoMap = list(
#'     list(
#'       MetadataValue = "string",
#'       CreatedTime = "string"
#'     )
#'   ),
#'   SchemaVersionId = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$query_schema_version_metadata(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   ),
#'   SchemaVersionId = "string",
#'   MetadataList = list(
#'     list(
#'       MetadataKey = "string",
#'       MetadataValue = "string"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_query_schema_version_metadata
glue_query_schema_version_metadata <- function(SchemaId = NULL, SchemaVersionNumber = NULL, SchemaVersionId = NULL, MetadataList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "QuerySchemaVersionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$query_schema_version_metadata_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, SchemaVersionId = SchemaVersionId, MetadataList = MetadataList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$query_schema_version_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$query_schema_version_metadata <- glue_query_schema_version_metadata

#' Adds a new version to the existing schema
#'
#' @description
#' Adds a new version to the existing schema. Returns an error if new
#' version of schema does not meet the compatibility requirements of the
#' schema set. This API will not create a new schema set and will return a
#' 404 error if the schema set is not already present in the Schema
#' Registry.
#' 
#' If this is the first schema definition to be registered in the Schema
#' Registry, this API will store the schema version and return immediately.
#' Otherwise, this call has the potential to run longer than other
#' operations due to compatibility modes. You can call the
#' [`get_schema_version`][glue_get_schema_version] API with the
#' `SchemaVersionId` to check compatibility modes.
#' 
#' If the same schema definition is already stored in Schema Registry as a
#' version, the schema ID of the existing schema is returned to the caller.
#'
#' @usage
#' glue_register_schema_version(SchemaId, SchemaDefinition)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     Either `SchemaArn` or `SchemaName` and `RegistryName` has to be
#'     provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. Either `SchemaArn` or
#'     `SchemaName` and `RegistryName` has to be provided.
#' @param SchemaDefinition &#91;required&#93; The schema definition using the `DataFormat` setting for the
#' `SchemaName`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaVersionId = "string",
#'   VersionNumber = 123,
#'   Status = "AVAILABLE"|"PENDING"|"FAILURE"|"DELETING"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$register_schema_version(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaDefinition = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_register_schema_version
glue_register_schema_version <- function(SchemaId, SchemaDefinition) {
  op <- new_operation(
    name = "RegisterSchemaVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$register_schema_version_input(SchemaId = SchemaId, SchemaDefinition = SchemaDefinition)
  output <- .glue$register_schema_version_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$register_schema_version <- glue_register_schema_version

#' Removes a key value pair from the schema version metadata for the
#' specified schema version ID
#'
#' @description
#' Removes a key value pair from the schema version metadata for the
#' specified schema version ID.
#'
#' @usage
#' glue_remove_schema_version_metadata(SchemaId, SchemaVersionNumber,
#'   SchemaVersionId, MetadataKeyValue)
#'
#' @param SchemaId A wrapper structure that may contain the schema name and Amazon Resource
#' Name (ARN).
#' @param SchemaVersionNumber The version number of the schema.
#' @param SchemaVersionId The unique version ID of the schema version.
#' @param MetadataKeyValue &#91;required&#93; The value of the metadata key.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaArn = "string",
#'   SchemaName = "string",
#'   RegistryName = "string",
#'   LatestVersion = TRUE|FALSE,
#'   VersionNumber = 123,
#'   SchemaVersionId = "string",
#'   MetadataKey = "string",
#'   MetadataValue = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$remove_schema_version_metadata(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   ),
#'   SchemaVersionId = "string",
#'   MetadataKeyValue = list(
#'     MetadataKey = "string",
#'     MetadataValue = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_remove_schema_version_metadata
glue_remove_schema_version_metadata <- function(SchemaId = NULL, SchemaVersionNumber = NULL, SchemaVersionId = NULL, MetadataKeyValue) {
  op <- new_operation(
    name = "RemoveSchemaVersionMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$remove_schema_version_metadata_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, SchemaVersionId = SchemaVersionId, MetadataKeyValue = MetadataKeyValue)
  output <- .glue$remove_schema_version_metadata_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$remove_schema_version_metadata <- glue_remove_schema_version_metadata

#' Resets a bookmark entry
#'
#' @description
#' Resets a bookmark entry.
#'
#' @usage
#' glue_reset_job_bookmark(JobName, RunId)
#'
#' @param JobName &#91;required&#93; The name of the job in question.
#' @param RunId The unique run identifier associated with this job run.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobBookmarkEntry = list(
#'     JobName = "string",
#'     Version = 123,
#'     Run = 123,
#'     Attempt = 123,
#'     PreviousRunId = "string",
#'     RunId = "string",
#'     JobBookmark = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$reset_job_bookmark(
#'   JobName = "string",
#'   RunId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_reset_job_bookmark
glue_reset_job_bookmark <- function(JobName, RunId = NULL) {
  op <- new_operation(
    name = "ResetJobBookmark",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$reset_job_bookmark_input(JobName = JobName, RunId = RunId)
  output <- .glue$reset_job_bookmark_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$reset_job_bookmark <- glue_reset_job_bookmark

#' Restarts selected nodes of a previous partially completed workflow run
#' and resumes the workflow run
#'
#' @description
#' Restarts selected nodes of a previous partially completed workflow run
#' and resumes the workflow run. The selected nodes and all nodes that are
#' downstream from the selected nodes are run.
#'
#' @usage
#' glue_resume_workflow_run(Name, RunId, NodeIds)
#'
#' @param Name &#91;required&#93; The name of the workflow to resume.
#' @param RunId &#91;required&#93; The ID of the workflow run to resume.
#' @param NodeIds &#91;required&#93; A list of the node IDs for the nodes you want to restart. The nodes that
#' are to be restarted must have a run attempt in the original run.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RunId = "string",
#'   NodeIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$resume_workflow_run(
#'   Name = "string",
#'   RunId = "string",
#'   NodeIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_resume_workflow_run
glue_resume_workflow_run <- function(Name, RunId, NodeIds) {
  op <- new_operation(
    name = "ResumeWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$resume_workflow_run_input(Name = Name, RunId = RunId, NodeIds = NodeIds)
  output <- .glue$resume_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$resume_workflow_run <- glue_resume_workflow_run

#' Searches a set of tables based on properties in the table metadata as
#' well as on the parent database
#'
#' @description
#' Searches a set of tables based on properties in the table metadata as
#' well as on the parent database. You can search against text or filter
#' conditions.
#' 
#' You can only get tables that you have access to based on the security
#' policies defined in Lake Formation. You need at least a read-only access
#' to the table for it to be returned. If you do not have access to all the
#' columns in the table, these columns will not be searched against when
#' returning the list of tables back to you. If you have access to the
#' columns but not the data in the columns, those columns and the
#' associated metadata for those columns will be included in the search.
#'
#' @usage
#' glue_search_tables(CatalogId, NextToken, Filters, SearchText,
#'   SortCriteria, MaxResults, ResourceShareType)
#'
#' @param CatalogId A unique identifier, consisting of ` account_id `.
#' @param NextToken A continuation token, included if this is a continuation call.
#' @param Filters A list of key-value pairs, and a comparator used to filter the search
#' results. Returns all entities matching the predicate.
#' 
#' The `Comparator` member of the `PropertyPredicate` struct is used only
#' for time fields, and can be omitted for other field types. Also, when
#' comparing string values, such as when `Key=Name`, a fuzzy match
#' algorithm is used. The `Key` field (for example, the value of the `Name`
#' field) is split on certain punctuation characters, for example, -, :,
#' \#, etc. into tokens. Then each token is exact-match compared with the
#' `Value` member of `PropertyPredicate`. For example, if `Key=Name` and
#' `Value=link`, tables named `customer-link` and `xx-link-yy` are
#' returned, but `xxlinkyy` is not returned.
#' @param SearchText A string used for a text search.
#' 
#' Specifying a value in quotes filters based on an exact match to the
#' value.
#' @param SortCriteria A list of criteria for sorting the results by a field name, in an
#' ascending or descending order.
#' @param MaxResults The maximum number of tables to return in a single response.
#' @param ResourceShareType Allows you to specify that you want to search the tables shared with
#' your account. The allowable values are `FOREIGN` or `ALL`.
#' 
#' -   If set to `FOREIGN`, will search the tables shared with your
#'     account.
#' 
#' -   If set to `ALL`, will search the tables shared with your account, as
#'     well as the tables in yor local account.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   TableList = list(
#'     list(
#'       Name = "string",
#'       DatabaseName = "string",
#'       Description = "string",
#'       Owner = "string",
#'       CreateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       UpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Retention = 123,
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string",
#'             Parameters = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE,
#'         SchemaReference = list(
#'           SchemaId = list(
#'             SchemaArn = "string",
#'             SchemaName = "string",
#'             RegistryName = "string"
#'           ),
#'           SchemaVersionId = "string",
#'           SchemaVersionNumber = 123
#'         )
#'       ),
#'       PartitionKeys = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ViewOriginalText = "string",
#'       ViewExpandedText = "string",
#'       TableType = "string",
#'       Parameters = list(
#'         "string"
#'       ),
#'       CreatedBy = "string",
#'       IsRegisteredWithLakeFormation = TRUE|FALSE,
#'       TargetTable = list(
#'         CatalogId = "string",
#'         DatabaseName = "string",
#'         Name = "string"
#'       ),
#'       CatalogId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$search_tables(
#'   CatalogId = "string",
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Comparator = "EQUALS"|"GREATER_THAN"|"LESS_THAN"|"GREATER_THAN_EQUALS"|"LESS_THAN_EQUALS"
#'     )
#'   ),
#'   SearchText = "string",
#'   SortCriteria = list(
#'     list(
#'       FieldName = "string",
#'       Sort = "ASC"|"DESC"
#'     )
#'   ),
#'   MaxResults = 123,
#'   ResourceShareType = "FOREIGN"|"ALL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_search_tables
glue_search_tables <- function(CatalogId = NULL, NextToken = NULL, Filters = NULL, SearchText = NULL, SortCriteria = NULL, MaxResults = NULL, ResourceShareType = NULL) {
  op <- new_operation(
    name = "SearchTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$search_tables_input(CatalogId = CatalogId, NextToken = NextToken, Filters = Filters, SearchText = SearchText, SortCriteria = SortCriteria, MaxResults = MaxResults, ResourceShareType = ResourceShareType)
  output <- .glue$search_tables_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$search_tables <- glue_search_tables

#' Starts a crawl using the specified crawler, regardless of what is
#' scheduled
#'
#' @description
#' Starts a crawl using the specified crawler, regardless of what is
#' scheduled. If the crawler is already running, returns a
#' [CrawlerRunningException](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException).
#'
#' @usage
#' glue_start_crawler(Name)
#'
#' @param Name &#91;required&#93; Name of the crawler to start.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$start_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_crawler
glue_start_crawler <- function(Name) {
  op <- new_operation(
    name = "StartCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_crawler_input(Name = Name)
  output <- .glue$start_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_crawler <- glue_start_crawler

#' Changes the schedule state of the specified crawler to SCHEDULED, unless
#' the crawler is already running or the schedule state is already
#' SCHEDULED
#'
#' @description
#' Changes the schedule state of the specified crawler to `SCHEDULED`,
#' unless the crawler is already running or the schedule state is already
#' `SCHEDULED`.
#'
#' @usage
#' glue_start_crawler_schedule(CrawlerName)
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler to schedule.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$start_crawler_schedule(
#'   CrawlerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_crawler_schedule
glue_start_crawler_schedule <- function(CrawlerName) {
  op <- new_operation(
    name = "StartCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_crawler_schedule_input(CrawlerName = CrawlerName)
  output <- .glue$start_crawler_schedule_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_crawler_schedule <- glue_start_crawler_schedule

#' Begins an asynchronous task to export all labeled data for a particular
#' transform
#'
#' @description
#' Begins an asynchronous task to export all labeled data for a particular
#' transform. This task is the only label-related API call that is not part
#' of the typical active learning workflow. You typically use
#' [`start_export_labels_task_run`][glue_start_export_labels_task_run] when
#' you want to work with all of your existing labels at the same time, such
#' as when you want to remove or change labels that were previously
#' submitted as truth. This API operation accepts the `TransformId` whose
#' labels you want to export and an Amazon Simple Storage Service (Amazon
#' S3) path to export the labels to. The operation returns a `TaskRunId`.
#' You can check on the status of your task run by calling the
#' [`get_ml_task_run`][glue_get_ml_task_run] API.
#'
#' @usage
#' glue_start_export_labels_task_run(TransformId, OutputS3Path)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param OutputS3Path &#91;required&#93; The Amazon S3 path where you export the labels.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TaskRunId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_export_labels_task_run(
#'   TransformId = "string",
#'   OutputS3Path = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_export_labels_task_run
glue_start_export_labels_task_run <- function(TransformId, OutputS3Path) {
  op <- new_operation(
    name = "StartExportLabelsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_export_labels_task_run_input(TransformId = TransformId, OutputS3Path = OutputS3Path)
  output <- .glue$start_export_labels_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_export_labels_task_run <- glue_start_export_labels_task_run

#' Enables you to provide additional labels (examples of truth) to be used
#' to teach the machine learning transform and improve its quality
#'
#' @description
#' Enables you to provide additional labels (examples of truth) to be used
#' to teach the machine learning transform and improve its quality. This
#' API operation is generally used as part of the active learning workflow
#' that starts with the
#' [`start_ml_labeling_set_generation_task_run`][glue_start_ml_labeling_set_generation_task_run]
#' call and that ultimately results in improving the quality of your
#' machine learning transform.
#' 
#' After the
#' [`start_ml_labeling_set_generation_task_run`][glue_start_ml_labeling_set_generation_task_run]
#' finishes, AWS Glue machine learning will have generated a series of
#' questions for humans to answer. (Answering these questions is often
#' called 'labeling' in the machine learning workflows). In the case of the
#' `FindMatches` transform, these questions are of the form, “What is the
#' correct way to group these rows together into groups composed entirely
#' of matching records?” After the labeling process is finished, users
#' upload their answers/labels with a call to
#' [`start_import_labels_task_run`][glue_start_import_labels_task_run].
#' After
#' [`start_import_labels_task_run`][glue_start_import_labels_task_run]
#' finishes, all future runs of the machine learning transform use the new
#' and improved labels and perform a higher-quality transformation.
#' 
#' By default,
#' [`start_ml_labeling_set_generation_task_run`][glue_start_ml_labeling_set_generation_task_run]
#' continually learns from and combines all labels that you upload unless
#' you set `Replace` to true. If you set `Replace` to true,
#' [`start_import_labels_task_run`][glue_start_import_labels_task_run]
#' deletes and forgets all previously uploaded labels and learns only from
#' the exact set that you upload. Replacing labels can be helpful if you
#' realize that you previously uploaded incorrect labels, and you believe
#' that they are having a negative effect on your transform quality.
#' 
#' You can check on the status of your task run by calling the
#' [`get_ml_task_run`][glue_get_ml_task_run] operation.
#'
#' @usage
#' glue_start_import_labels_task_run(TransformId, InputS3Path,
#'   ReplaceAllLabels)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param InputS3Path &#91;required&#93; The Amazon Simple Storage Service (Amazon S3) path from where you import
#' the labels.
#' @param ReplaceAllLabels Indicates whether to overwrite your existing labels.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TaskRunId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_import_labels_task_run(
#'   TransformId = "string",
#'   InputS3Path = "string",
#'   ReplaceAllLabels = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_import_labels_task_run
glue_start_import_labels_task_run <- function(TransformId, InputS3Path, ReplaceAllLabels = NULL) {
  op <- new_operation(
    name = "StartImportLabelsTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_import_labels_task_run_input(TransformId = TransformId, InputS3Path = InputS3Path, ReplaceAllLabels = ReplaceAllLabels)
  output <- .glue$start_import_labels_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_import_labels_task_run <- glue_start_import_labels_task_run

#' Starts a job run using a job definition
#'
#' @description
#' Starts a job run using a job definition.
#'
#' @usage
#' glue_start_job_run(JobName, JobRunId, Arguments, AllocatedCapacity,
#'   Timeout, MaxCapacity, SecurityConfiguration, NotificationProperty,
#'   WorkerType, NumberOfWorkers)
#'
#' @param JobName &#91;required&#93; The name of the job definition to use.
#' @param JobRunId The ID of a previous `JobRun` to retry.
#' @param Arguments The job arguments specifically for this run. For this job run, they
#' replace the default arguments set in the job definition itself.
#' 
#' You can specify arguments here that your own job-execution script
#' consumes, as well as arguments that AWS Glue itself consumes.
#' 
#' For information about how to specify and consume your own Job arguments,
#' see the [Calling AWS Glue APIs in
#' Python](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
#' topic in the developer guide.
#' 
#' For information about the key-value pairs that AWS Glue consumes to set
#' up your job, see the [Special Parameters Used by AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
#' topic in the developer guide.
#' @param AllocatedCapacity This field is deprecated. Use `MaxCapacity` instead.
#' 
#' The number of AWS Glue data processing units (DPUs) to allocate to this
#' JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is
#' a relative measure of processing power that consists of 4 vCPUs of
#' compute capacity and 16 GB of memory. For more information, see the AWS
#' Glue pricing page.
#' @param Timeout The `JobRun` timeout in minutes. This is the maximum time that a job run
#' can consume resources before it is terminated and enters `TIMEOUT`
#' status. The default is 2,880 minutes (48 hours). This overrides the
#' timeout value set in the parent job.
#' @param MaxCapacity The number of AWS Glue data processing units (DPUs) that can be
#' allocated when this job runs. A DPU is a relative measure of processing
#' power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
#' For more information, see the AWS Glue pricing page.
#' 
#' Do not set `Max Capacity` if using `WorkerType` and `NumberOfWorkers`.
#' 
#' The value that can be allocated for `MaxCapacity` depends on whether you
#' are running a Python shell job, or an Apache Spark ETL job:
#' 
#' -   When you specify a Python shell job
#'     (`JobCommand.Name`="pythonshell"), you can allocate either 0.0625 or
#'     1 DPU. The default is 0.0625 DPU.
#' 
#' -   When you specify an Apache Spark ETL job
#'     (`JobCommand.Name`="glueetl"), you can allocate from 2 to 100 DPUs.
#'     The default is 10 DPUs. This job type cannot have a fractional DPU
#'     allocation.
#' @param SecurityConfiguration The name of the `SecurityConfiguration` structure to be used with this
#' job run.
#' @param NotificationProperty Specifies configuration properties of a job run notification.
#' @param WorkerType The type of predefined worker that is allocated when a job runs. Accepts
#' a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker provides 4 vCPU, 16 GB of
#'     memory and a 64GB disk, and 1 executor per worker.
#' 
#' -   For the `G.2X` worker type, each worker provides 8 vCPU, 32 GB of
#'     memory and a 128GB disk, and 1 executor per worker.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' a job runs.
#' 
#' The maximum number of workers you can define are 299 for `G.1X`, and 149
#' for `G.2X`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobRunId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_job_run(
#'   JobName = "string",
#'   JobRunId = "string",
#'   Arguments = list(
#'     "string"
#'   ),
#'   AllocatedCapacity = 123,
#'   Timeout = 123,
#'   MaxCapacity = 123.0,
#'   SecurityConfiguration = "string",
#'   NotificationProperty = list(
#'     NotifyDelayAfter = 123
#'   ),
#'   WorkerType = "Standard"|"G.1X"|"G.2X",
#'   NumberOfWorkers = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_job_run
glue_start_job_run <- function(JobName, JobRunId = NULL, Arguments = NULL, AllocatedCapacity = NULL, Timeout = NULL, MaxCapacity = NULL, SecurityConfiguration = NULL, NotificationProperty = NULL, WorkerType = NULL, NumberOfWorkers = NULL) {
  op <- new_operation(
    name = "StartJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_job_run_input(JobName = JobName, JobRunId = JobRunId, Arguments = Arguments, AllocatedCapacity = AllocatedCapacity, Timeout = Timeout, MaxCapacity = MaxCapacity, SecurityConfiguration = SecurityConfiguration, NotificationProperty = NotificationProperty, WorkerType = WorkerType, NumberOfWorkers = NumberOfWorkers)
  output <- .glue$start_job_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_job_run <- glue_start_job_run

#' Starts a task to estimate the quality of the transform
#'
#' @description
#' Starts a task to estimate the quality of the transform.
#' 
#' When you provide label sets as examples of truth, AWS Glue machine
#' learning uses some of those examples to learn from them. The rest of the
#' labels are used as a test to estimate quality.
#' 
#' Returns a unique identifier for the run. You can call
#' [`get_ml_task_run`][glue_get_ml_task_run] to get more information about
#' the stats of the `EvaluationTaskRun`.
#'
#' @usage
#' glue_start_ml_evaluation_task_run(TransformId)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TaskRunId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_ml_evaluation_task_run(
#'   TransformId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_ml_evaluation_task_run
glue_start_ml_evaluation_task_run <- function(TransformId) {
  op <- new_operation(
    name = "StartMLEvaluationTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_ml_evaluation_task_run_input(TransformId = TransformId)
  output <- .glue$start_ml_evaluation_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_ml_evaluation_task_run <- glue_start_ml_evaluation_task_run

#' Starts the active learning workflow for your machine learning transform
#' to improve the transform's quality by generating label sets and adding
#' labels
#'
#' @description
#' Starts the active learning workflow for your machine learning transform
#' to improve the transform's quality by generating label sets and adding
#' labels.
#' 
#' When the
#' [`start_ml_labeling_set_generation_task_run`][glue_start_ml_labeling_set_generation_task_run]
#' finishes, AWS Glue will have generated a "labeling set" or a set of
#' questions for humans to answer.
#' 
#' In the case of the `FindMatches` transform, these questions are of the
#' form, “What is the correct way to group these rows together into groups
#' composed entirely of matching records?”
#' 
#' After the labeling process is finished, you can upload your labels with
#' a call to
#' [`start_import_labels_task_run`][glue_start_import_labels_task_run].
#' After
#' [`start_import_labels_task_run`][glue_start_import_labels_task_run]
#' finishes, all future runs of the machine learning transform will use the
#' new and improved labels and perform a higher-quality transformation.
#'
#' @usage
#' glue_start_ml_labeling_set_generation_task_run(TransformId,
#'   OutputS3Path)
#'
#' @param TransformId &#91;required&#93; The unique identifier of the machine learning transform.
#' @param OutputS3Path &#91;required&#93; The Amazon Simple Storage Service (Amazon S3) path where you generate
#' the labeling set.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TaskRunId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_ml_labeling_set_generation_task_run(
#'   TransformId = "string",
#'   OutputS3Path = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_ml_labeling_set_generation_task_run
glue_start_ml_labeling_set_generation_task_run <- function(TransformId, OutputS3Path) {
  op <- new_operation(
    name = "StartMLLabelingSetGenerationTaskRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_ml_labeling_set_generation_task_run_input(TransformId = TransformId, OutputS3Path = OutputS3Path)
  output <- .glue$start_ml_labeling_set_generation_task_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_ml_labeling_set_generation_task_run <- glue_start_ml_labeling_set_generation_task_run

#' Starts an existing trigger
#'
#' @description
#' Starts an existing trigger. See [Triggering
#' Jobs](https://docs.aws.amazon.com/glue/latest/dg/trigger-job.html) for
#' information about how different types of trigger are started.
#'
#' @usage
#' glue_start_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to start.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_trigger
glue_start_trigger <- function(Name) {
  op <- new_operation(
    name = "StartTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_trigger_input(Name = Name)
  output <- .glue$start_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_trigger <- glue_start_trigger

#' Starts a new run of the specified workflow
#'
#' @description
#' Starts a new run of the specified workflow.
#'
#' @usage
#' glue_start_workflow_run(Name)
#'
#' @param Name &#91;required&#93; The name of the workflow to start.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RunId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_workflow_run(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_workflow_run
glue_start_workflow_run <- function(Name) {
  op <- new_operation(
    name = "StartWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_workflow_run_input(Name = Name)
  output <- .glue$start_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_workflow_run <- glue_start_workflow_run

#' If the specified crawler is running, stops the crawl
#'
#' @description
#' If the specified crawler is running, stops the crawl.
#'
#' @usage
#' glue_stop_crawler(Name)
#'
#' @param Name &#91;required&#93; Name of the crawler to stop.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$stop_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_crawler
glue_stop_crawler <- function(Name) {
  op <- new_operation(
    name = "StopCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_crawler_input(Name = Name)
  output <- .glue$stop_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_crawler <- glue_stop_crawler

#' Sets the schedule state of the specified crawler to NOT_SCHEDULED, but
#' does not stop the crawler if it is already running
#'
#' @description
#' Sets the schedule state of the specified crawler to `NOT_SCHEDULED`, but
#' does not stop the crawler if it is already running.
#'
#' @usage
#' glue_stop_crawler_schedule(CrawlerName)
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler whose schedule state to set.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$stop_crawler_schedule(
#'   CrawlerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_crawler_schedule
glue_stop_crawler_schedule <- function(CrawlerName) {
  op <- new_operation(
    name = "StopCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_crawler_schedule_input(CrawlerName = CrawlerName)
  output <- .glue$stop_crawler_schedule_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_crawler_schedule <- glue_stop_crawler_schedule

#' Stops a specified trigger
#'
#' @description
#' Stops a specified trigger.
#'
#' @usage
#' glue_stop_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to stop.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_trigger
glue_stop_trigger <- function(Name) {
  op <- new_operation(
    name = "StopTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_trigger_input(Name = Name)
  output <- .glue$stop_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_trigger <- glue_stop_trigger

#' Stops the execution of the specified workflow run
#'
#' @description
#' Stops the execution of the specified workflow run.
#'
#' @usage
#' glue_stop_workflow_run(Name, RunId)
#'
#' @param Name &#91;required&#93; The name of the workflow to stop.
#' @param RunId &#91;required&#93; The ID of the workflow run to stop.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$stop_workflow_run(
#'   Name = "string",
#'   RunId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_workflow_run
glue_stop_workflow_run <- function(Name, RunId) {
  op <- new_operation(
    name = "StopWorkflowRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_workflow_run_input(Name = Name, RunId = RunId)
  output <- .glue$stop_workflow_run_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_workflow_run <- glue_stop_workflow_run

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource. A tag is a label you can assign to an AWS
#' resource. In AWS Glue, you can tag only certain resources. For
#' information about what resources you can tag, see [AWS Tags in AWS
#' Glue](https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html).
#'
#' @usage
#' glue_tag_resource(ResourceArn, TagsToAdd)
#'
#' @param ResourceArn &#91;required&#93; The ARN of the AWS Glue resource to which to add the tags. For more
#' information about AWS Glue resource ARNs, see the [AWS Glue ARN string
#' pattern](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id).
#' @param TagsToAdd &#91;required&#93; Tags to add to this resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   TagsToAdd = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_tag_resource
glue_tag_resource <- function(ResourceArn, TagsToAdd) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$tag_resource_input(ResourceArn = ResourceArn, TagsToAdd = TagsToAdd)
  output <- .glue$tag_resource_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$tag_resource <- glue_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' @usage
#' glue_untag_resource(ResourceArn, TagsToRemove)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to remove the
#' tags.
#' @param TagsToRemove &#91;required&#93; Tags to remove from this resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagsToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_untag_resource
glue_untag_resource <- function(ResourceArn, TagsToRemove) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$untag_resource_input(ResourceArn = ResourceArn, TagsToRemove = TagsToRemove)
  output <- .glue$untag_resource_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$untag_resource <- glue_untag_resource

#' Modifies an existing classifier (a GrokClassifier, an XMLClassifier, a
#' JsonClassifier, or a CsvClassifier, depending on which field is present)
#'
#' @description
#' Modifies an existing classifier (a `GrokClassifier`, an `XMLClassifier`,
#' a `JsonClassifier`, or a `CsvClassifier`, depending on which field is
#' present).
#'
#' @usage
#' glue_update_classifier(GrokClassifier, XMLClassifier, JsonClassifier,
#'   CsvClassifier)
#'
#' @param GrokClassifier A `GrokClassifier` object with updated fields.
#' @param XMLClassifier An `XMLClassifier` object with updated fields.
#' @param JsonClassifier A `JsonClassifier` object with updated fields.
#' @param CsvClassifier A `CsvClassifier` object with updated fields.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_classifier(
#'   GrokClassifier = list(
#'     Name = "string",
#'     Classification = "string",
#'     GrokPattern = "string",
#'     CustomPatterns = "string"
#'   ),
#'   XMLClassifier = list(
#'     Name = "string",
#'     Classification = "string",
#'     RowTag = "string"
#'   ),
#'   JsonClassifier = list(
#'     Name = "string",
#'     JsonPath = "string"
#'   ),
#'   CsvClassifier = list(
#'     Name = "string",
#'     Delimiter = "string",
#'     QuoteSymbol = "string",
#'     ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
#'     Header = list(
#'       "string"
#'     ),
#'     DisableValueTrimming = TRUE|FALSE,
#'     AllowSingleColumn = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_classifier
glue_update_classifier <- function(GrokClassifier = NULL, XMLClassifier = NULL, JsonClassifier = NULL, CsvClassifier = NULL) {
  op <- new_operation(
    name = "UpdateClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_classifier_input(GrokClassifier = GrokClassifier, XMLClassifier = XMLClassifier, JsonClassifier = JsonClassifier, CsvClassifier = CsvClassifier)
  output <- .glue$update_classifier_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_classifier <- glue_update_classifier

#' Creates or updates partition statistics of columns
#'
#' @description
#' Creates or updates partition statistics of columns.
#' 
#' The Identity and Access Management (IAM) permission required for this
#' operation is [`update_partition`][glue_update_partition].
#'
#' @usage
#' glue_update_column_statistics_for_partition(CatalogId, DatabaseName,
#'   TableName, PartitionValues, ColumnStatisticsList)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param PartitionValues &#91;required&#93; A list of partition values identifying the partition.
#' @param ColumnStatisticsList &#91;required&#93; A list of the column statistics.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       ColumnStatistics = list(
#'         ColumnName = "string",
#'         ColumnType = "string",
#'         AnalyzedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         StatisticsData = list(
#'           Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
#'           BooleanColumnStatisticsData = list(
#'             NumberOfTrues = 123,
#'             NumberOfFalses = 123,
#'             NumberOfNulls = 123
#'           ),
#'           DateColumnStatisticsData = list(
#'             MinimumValue = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             MaximumValue = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           DecimalColumnStatisticsData = list(
#'             MinimumValue = list(
#'               UnscaledValue = raw,
#'               Scale = 123
#'             ),
#'             MaximumValue = list(
#'               UnscaledValue = raw,
#'               Scale = 123
#'             ),
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           DoubleColumnStatisticsData = list(
#'             MinimumValue = 123.0,
#'             MaximumValue = 123.0,
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           LongColumnStatisticsData = list(
#'             MinimumValue = 123,
#'             MaximumValue = 123,
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           StringColumnStatisticsData = list(
#'             MaximumLength = 123,
#'             AverageLength = 123.0,
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           BinaryColumnStatisticsData = list(
#'             MaximumLength = 123,
#'             AverageLength = 123.0,
#'             NumberOfNulls = 123
#'           )
#'         )
#'       ),
#'       Error = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_column_statistics_for_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   ),
#'   ColumnStatisticsList = list(
#'     list(
#'       ColumnName = "string",
#'       ColumnType = "string",
#'       AnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StatisticsData = list(
#'         Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
#'         BooleanColumnStatisticsData = list(
#'           NumberOfTrues = 123,
#'           NumberOfFalses = 123,
#'           NumberOfNulls = 123
#'         ),
#'         DateColumnStatisticsData = list(
#'           MinimumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           MaximumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DecimalColumnStatisticsData = list(
#'           MinimumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           MaximumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DoubleColumnStatisticsData = list(
#'           MinimumValue = 123.0,
#'           MaximumValue = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         LongColumnStatisticsData = list(
#'           MinimumValue = 123,
#'           MaximumValue = 123,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         StringColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         BinaryColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_column_statistics_for_partition
glue_update_column_statistics_for_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues, ColumnStatisticsList) {
  op <- new_operation(
    name = "UpdateColumnStatisticsForPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_column_statistics_for_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues, ColumnStatisticsList = ColumnStatisticsList)
  output <- .glue$update_column_statistics_for_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_column_statistics_for_partition <- glue_update_column_statistics_for_partition

#' Creates or updates table statistics of columns
#'
#' @description
#' Creates or updates table statistics of columns.
#' 
#' The Identity and Access Management (IAM) permission required for this
#' operation is [`update_table`][glue_update_table].
#'
#' @usage
#' glue_update_column_statistics_for_table(CatalogId, DatabaseName,
#'   TableName, ColumnStatisticsList)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions' table.
#' @param ColumnStatisticsList &#91;required&#93; A list of the column statistics.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Errors = list(
#'     list(
#'       ColumnStatistics = list(
#'         ColumnName = "string",
#'         ColumnType = "string",
#'         AnalyzedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         StatisticsData = list(
#'           Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
#'           BooleanColumnStatisticsData = list(
#'             NumberOfTrues = 123,
#'             NumberOfFalses = 123,
#'             NumberOfNulls = 123
#'           ),
#'           DateColumnStatisticsData = list(
#'             MinimumValue = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             MaximumValue = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           DecimalColumnStatisticsData = list(
#'             MinimumValue = list(
#'               UnscaledValue = raw,
#'               Scale = 123
#'             ),
#'             MaximumValue = list(
#'               UnscaledValue = raw,
#'               Scale = 123
#'             ),
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           DoubleColumnStatisticsData = list(
#'             MinimumValue = 123.0,
#'             MaximumValue = 123.0,
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           LongColumnStatisticsData = list(
#'             MinimumValue = 123,
#'             MaximumValue = 123,
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           StringColumnStatisticsData = list(
#'             MaximumLength = 123,
#'             AverageLength = 123.0,
#'             NumberOfNulls = 123,
#'             NumberOfDistinctValues = 123
#'           ),
#'           BinaryColumnStatisticsData = list(
#'             MaximumLength = 123,
#'             AverageLength = 123.0,
#'             NumberOfNulls = 123
#'           )
#'         )
#'       ),
#'       Error = list(
#'         ErrorCode = "string",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_column_statistics_for_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   ColumnStatisticsList = list(
#'     list(
#'       ColumnName = "string",
#'       ColumnType = "string",
#'       AnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StatisticsData = list(
#'         Type = "BOOLEAN"|"DATE"|"DECIMAL"|"DOUBLE"|"LONG"|"STRING"|"BINARY",
#'         BooleanColumnStatisticsData = list(
#'           NumberOfTrues = 123,
#'           NumberOfFalses = 123,
#'           NumberOfNulls = 123
#'         ),
#'         DateColumnStatisticsData = list(
#'           MinimumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           MaximumValue = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DecimalColumnStatisticsData = list(
#'           MinimumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           MaximumValue = list(
#'             UnscaledValue = raw,
#'             Scale = 123
#'           ),
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         DoubleColumnStatisticsData = list(
#'           MinimumValue = 123.0,
#'           MaximumValue = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         LongColumnStatisticsData = list(
#'           MinimumValue = 123,
#'           MaximumValue = 123,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         StringColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123,
#'           NumberOfDistinctValues = 123
#'         ),
#'         BinaryColumnStatisticsData = list(
#'           MaximumLength = 123,
#'           AverageLength = 123.0,
#'           NumberOfNulls = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_column_statistics_for_table
glue_update_column_statistics_for_table <- function(CatalogId = NULL, DatabaseName, TableName, ColumnStatisticsList) {
  op <- new_operation(
    name = "UpdateColumnStatisticsForTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_column_statistics_for_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, ColumnStatisticsList = ColumnStatisticsList)
  output <- .glue$update_column_statistics_for_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_column_statistics_for_table <- glue_update_column_statistics_for_table

#' Updates a connection definition in the Data Catalog
#'
#' @description
#' Updates a connection definition in the Data Catalog.
#'
#' @usage
#' glue_update_connection(CatalogId, Name, ConnectionInput)
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the connection definition to update.
#' @param ConnectionInput &#91;required&#93; A `ConnectionInput` object that redefines the connection in question.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_connection(
#'   CatalogId = "string",
#'   Name = "string",
#'   ConnectionInput = list(
#'     Name = "string",
#'     Description = "string",
#'     ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA"|"NETWORK"|"MARKETPLACE"|"CUSTOM",
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionProperties = list(
#'       "string"
#'     ),
#'     PhysicalConnectionRequirements = list(
#'       SubnetId = "string",
#'       SecurityGroupIdList = list(
#'         "string"
#'       ),
#'       AvailabilityZone = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_connection
glue_update_connection <- function(CatalogId = NULL, Name, ConnectionInput) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_connection_input(CatalogId = CatalogId, Name = Name, ConnectionInput = ConnectionInput)
  output <- .glue$update_connection_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_connection <- glue_update_connection

#' Updates a crawler
#'
#' @description
#' Updates a crawler. If a crawler is running, you must stop it using
#' [`stop_crawler`][glue_stop_crawler] before updating it.
#'
#' @usage
#' glue_update_crawler(Name, Role, DatabaseName, Description, Targets,
#'   Schedule, Classifiers, TablePrefix, SchemaChangePolicy, RecrawlPolicy,
#'   LineageConfiguration, Configuration, CrawlerSecurityConfiguration)
#'
#' @param Name &#91;required&#93; Name of the new crawler.
#' @param Role The IAM role or Amazon Resource Name (ARN) of an IAM role that is used
#' by the new crawler to access customer resources.
#' @param DatabaseName The AWS Glue database where results are stored, such as:
#' `arn:aws:daylight:us-east-1::database/sometable/*`.
#' @param Description A description of the new crawler.
#' @param Targets A list of targets to crawl.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' @param Classifiers A list of custom classifiers that the user has registered. By default,
#' all built-in classifiers are included in a crawl, but these custom
#' classifiers always override the default classifiers for a given
#' classification.
#' @param TablePrefix The table prefix used for catalog tables that are created.
#' @param SchemaChangePolicy The policy for the crawler's update and deletion behavior.
#' @param RecrawlPolicy A policy that specifies whether to crawl the entire dataset again, or to
#' crawl only folders that were added since the last crawler run.
#' @param LineageConfiguration Specifies data lineage configuration settings for the crawler.
#' @param Configuration Crawler configuration information. This versioned JSON string allows
#' users to specify aspects of a crawler's behavior. For more information,
#' see [Configuring a
#' Crawler](https://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
#' @param CrawlerSecurityConfiguration The name of the `SecurityConfiguration` structure to be used by this
#' crawler.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_crawler(
#'   Name = "string",
#'   Role = "string",
#'   DatabaseName = "string",
#'   Description = "string",
#'   Targets = list(
#'     S3Targets = list(
#'       list(
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         ),
#'         ConnectionName = "string"
#'       )
#'     ),
#'     JdbcTargets = list(
#'       list(
#'         ConnectionName = "string",
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     MongoDBTargets = list(
#'       list(
#'         ConnectionName = "string",
#'         Path = "string",
#'         ScanAll = TRUE|FALSE
#'       )
#'     ),
#'     DynamoDBTargets = list(
#'       list(
#'         Path = "string",
#'         scanAll = TRUE|FALSE,
#'         scanRate = 123.0
#'       )
#'     ),
#'     CatalogTargets = list(
#'       list(
#'         DatabaseName = "string",
#'         Tables = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   Schedule = "string",
#'   Classifiers = list(
#'     "string"
#'   ),
#'   TablePrefix = "string",
#'   SchemaChangePolicy = list(
#'     UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'     DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'   ),
#'   RecrawlPolicy = list(
#'     RecrawlBehavior = "CRAWL_EVERYTHING"|"CRAWL_NEW_FOLDERS_ONLY"
#'   ),
#'   LineageConfiguration = list(
#'     CrawlerLineageSettings = "ENABLE"|"DISABLE"
#'   ),
#'   Configuration = "string",
#'   CrawlerSecurityConfiguration = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_crawler
glue_update_crawler <- function(Name, Role = NULL, DatabaseName = NULL, Description = NULL, Targets = NULL, Schedule = NULL, Classifiers = NULL, TablePrefix = NULL, SchemaChangePolicy = NULL, RecrawlPolicy = NULL, LineageConfiguration = NULL, Configuration = NULL, CrawlerSecurityConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_crawler_input(Name = Name, Role = Role, DatabaseName = DatabaseName, Description = Description, Targets = Targets, Schedule = Schedule, Classifiers = Classifiers, TablePrefix = TablePrefix, SchemaChangePolicy = SchemaChangePolicy, RecrawlPolicy = RecrawlPolicy, LineageConfiguration = LineageConfiguration, Configuration = Configuration, CrawlerSecurityConfiguration = CrawlerSecurityConfiguration)
  output <- .glue$update_crawler_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_crawler <- glue_update_crawler

#' Updates the schedule of a crawler using a cron expression
#'
#' @description
#' Updates the schedule of a crawler using a `cron` expression.
#'
#' @usage
#' glue_update_crawler_schedule(CrawlerName, Schedule)
#'
#' @param CrawlerName &#91;required&#93; The name of the crawler whose schedule to update.
#' @param Schedule The updated `cron` expression used to specify the schedule (see
#' [Time-Based Schedules for Jobs and
#' Crawlers](https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_crawler_schedule(
#'   CrawlerName = "string",
#'   Schedule = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_crawler_schedule
glue_update_crawler_schedule <- function(CrawlerName, Schedule = NULL) {
  op <- new_operation(
    name = "UpdateCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_crawler_schedule_input(CrawlerName = CrawlerName, Schedule = Schedule)
  output <- .glue$update_crawler_schedule_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_crawler_schedule <- glue_update_crawler_schedule

#' Updates an existing database definition in a Data Catalog
#'
#' @description
#' Updates an existing database definition in a Data Catalog.
#'
#' @usage
#' glue_update_database(CatalogId, Name, DatabaseInput)
#'
#' @param CatalogId The ID of the Data Catalog in which the metadata database resides. If
#' none is provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to update in the catalog. For Hive
#' compatibility, this is folded to lowercase.
#' @param DatabaseInput &#91;required&#93; A `DatabaseInput` object specifying the new definition of the metadata
#' database in the catalog.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_database(
#'   CatalogId = "string",
#'   Name = "string",
#'   DatabaseInput = list(
#'     Name = "string",
#'     Description = "string",
#'     LocationUri = "string",
#'     Parameters = list(
#'       "string"
#'     ),
#'     CreateTableDefaultPermissions = list(
#'       list(
#'         Principal = list(
#'           DataLakePrincipalIdentifier = "string"
#'         ),
#'         Permissions = list(
#'           "ALL"|"SELECT"|"ALTER"|"DROP"|"DELETE"|"INSERT"|"CREATE_DATABASE"|"CREATE_TABLE"|"DATA_LOCATION_ACCESS"
#'         )
#'       )
#'     ),
#'     TargetDatabase = list(
#'       CatalogId = "string",
#'       DatabaseName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_database
glue_update_database <- function(CatalogId = NULL, Name, DatabaseInput) {
  op <- new_operation(
    name = "UpdateDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_database_input(CatalogId = CatalogId, Name = Name, DatabaseInput = DatabaseInput)
  output <- .glue$update_database_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_database <- glue_update_database

#' Updates a specified development endpoint
#'
#' @description
#' Updates a specified development endpoint.
#'
#' @usage
#' glue_update_dev_endpoint(EndpointName, PublicKey, AddPublicKeys,
#'   DeletePublicKeys, CustomLibraries, UpdateEtlLibraries, DeleteArguments,
#'   AddArguments)
#'
#' @param EndpointName &#91;required&#93; The name of the `DevEndpoint` to be updated.
#' @param PublicKey The public key for the `DevEndpoint` to use.
#' @param AddPublicKeys The list of public keys for the `DevEndpoint` to use.
#' @param DeletePublicKeys The list of public keys to be deleted from the `DevEndpoint`.
#' @param CustomLibraries Custom Python or Java libraries to be loaded in the `DevEndpoint`.
#' @param UpdateEtlLibraries `True` if the list of custom libraries to be loaded in the development
#' endpoint needs to be updated, or `False` if otherwise.
#' @param DeleteArguments The list of argument keys to be deleted from the map of arguments used
#' to configure the `DevEndpoint`.
#' @param AddArguments The map of arguments to add the map of arguments used to configure the
#' `DevEndpoint`.
#' 
#' Valid arguments are:
#' 
#' -   `"--enable-glue-datacatalog": ""`
#' 
#' -   `"GLUE_PYTHON_VERSION": "3"`
#' 
#' -   `"GLUE_PYTHON_VERSION": "2"`
#' 
#' You can specify a version of Python support for development endpoints by
#' using the `Arguments` parameter in the
#' [`create_dev_endpoint`][glue_create_dev_endpoint] or
#' [`update_dev_endpoint`][glue_update_dev_endpoint] APIs. If no arguments
#' are provided, the version defaults to Python 2.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_dev_endpoint(
#'   EndpointName = "string",
#'   PublicKey = "string",
#'   AddPublicKeys = list(
#'     "string"
#'   ),
#'   DeletePublicKeys = list(
#'     "string"
#'   ),
#'   CustomLibraries = list(
#'     ExtraPythonLibsS3Path = "string",
#'     ExtraJarsS3Path = "string"
#'   ),
#'   UpdateEtlLibraries = TRUE|FALSE,
#'   DeleteArguments = list(
#'     "string"
#'   ),
#'   AddArguments = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_dev_endpoint
glue_update_dev_endpoint <- function(EndpointName, PublicKey = NULL, AddPublicKeys = NULL, DeletePublicKeys = NULL, CustomLibraries = NULL, UpdateEtlLibraries = NULL, DeleteArguments = NULL, AddArguments = NULL) {
  op <- new_operation(
    name = "UpdateDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_dev_endpoint_input(EndpointName = EndpointName, PublicKey = PublicKey, AddPublicKeys = AddPublicKeys, DeletePublicKeys = DeletePublicKeys, CustomLibraries = CustomLibraries, UpdateEtlLibraries = UpdateEtlLibraries, DeleteArguments = DeleteArguments, AddArguments = AddArguments)
  output <- .glue$update_dev_endpoint_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_dev_endpoint <- glue_update_dev_endpoint

#' Updates an existing job definition
#'
#' @description
#' Updates an existing job definition.
#'
#' @usage
#' glue_update_job(JobName, JobUpdate)
#'
#' @param JobName &#91;required&#93; The name of the job definition to update.
#' @param JobUpdate &#91;required&#93; Specifies the values with which to update the job definition.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   JobName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_job(
#'   JobName = "string",
#'   JobUpdate = list(
#'     Description = "string",
#'     LogUri = "string",
#'     Role = "string",
#'     ExecutionProperty = list(
#'       MaxConcurrentRuns = 123
#'     ),
#'     Command = list(
#'       Name = "string",
#'       ScriptLocation = "string",
#'       PythonVersion = "string"
#'     ),
#'     DefaultArguments = list(
#'       "string"
#'     ),
#'     NonOverridableArguments = list(
#'       "string"
#'     ),
#'     Connections = list(
#'       Connections = list(
#'         "string"
#'       )
#'     ),
#'     MaxRetries = 123,
#'     AllocatedCapacity = 123,
#'     Timeout = 123,
#'     MaxCapacity = 123.0,
#'     WorkerType = "Standard"|"G.1X"|"G.2X",
#'     NumberOfWorkers = 123,
#'     SecurityConfiguration = "string",
#'     NotificationProperty = list(
#'       NotifyDelayAfter = 123
#'     ),
#'     GlueVersion = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_job
glue_update_job <- function(JobName, JobUpdate) {
  op <- new_operation(
    name = "UpdateJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_job_input(JobName = JobName, JobUpdate = JobUpdate)
  output <- .glue$update_job_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_job <- glue_update_job

#' Updates an existing machine learning transform
#'
#' @description
#' Updates an existing machine learning transform. Call this operation to
#' tune the algorithm parameters to achieve better results.
#' 
#' After calling this operation, you can call the
#' [`start_ml_evaluation_task_run`][glue_start_ml_evaluation_task_run]
#' operation to assess how well your new parameters achieved your goals
#' (such as improving the quality of your machine learning transform, or
#' making it more cost-effective).
#'
#' @usage
#' glue_update_ml_transform(TransformId, Name, Description, Parameters,
#'   Role, GlueVersion, MaxCapacity, WorkerType, NumberOfWorkers, Timeout,
#'   MaxRetries)
#'
#' @param TransformId &#91;required&#93; A unique identifier that was generated when the transform was created.
#' @param Name The unique name that you gave the transform when you created it.
#' @param Description A description of the transform. The default is an empty string.
#' @param Parameters The configuration parameters that are specific to the transform type
#' (algorithm) used. Conditionally dependent on the transform type.
#' @param Role The name or Amazon Resource Name (ARN) of the IAM role with the required
#' permissions.
#' @param GlueVersion This value determines which version of AWS Glue this machine learning
#' transform is compatible with. Glue 1.0 is recommended for most
#' customers. If the value is not set, the Glue compatibility defaults to
#' Glue 0.9. For more information, see [AWS Glue
#' Versions](https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
#' in the developer guide.
#' @param MaxCapacity The number of AWS Glue data processing units (DPUs) that are allocated
#' to task runs for this transform. You can allocate from 2 to 100 DPUs;
#' the default is 10. A DPU is a relative measure of processing power that
#' consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
#' information, see the [AWS Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' When the `WorkerType` field is set to a value other than `Standard`, the
#' `MaxCapacity` field is set automatically and becomes read-only.
#' @param WorkerType The type of predefined worker that is allocated when this task runs.
#' Accepts a value of Standard, G.1X, or G.2X.
#' 
#' -   For the `Standard` worker type, each worker provides 4 vCPU, 16 GB
#'     of memory and a 50GB disk, and 2 executors per worker.
#' 
#' -   For the `G.1X` worker type, each worker provides 4 vCPU, 16 GB of
#'     memory and a 64GB disk, and 1 executor per worker.
#' 
#' -   For the `G.2X` worker type, each worker provides 8 vCPU, 32 GB of
#'     memory and a 128GB disk, and 1 executor per worker.
#' @param NumberOfWorkers The number of workers of a defined `workerType` that are allocated when
#' this task runs.
#' @param Timeout The timeout for a task run for this transform in minutes. This is the
#' maximum time that a task run for this transform can consume resources
#' before it is terminated and enters `TIMEOUT` status. The default is
#' 2,880 minutes (48 hours).
#' @param MaxRetries The maximum number of times to retry a task for this transform after a
#' task run fails.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TransformId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_ml_transform(
#'   TransformId = "string",
#'   Name = "string",
#'   Description = "string",
#'   Parameters = list(
#'     TransformType = "FIND_MATCHES",
#'     FindMatchesParameters = list(
#'       PrimaryKeyColumnName = "string",
#'       PrecisionRecallTradeoff = 123.0,
#'       AccuracyCostTradeoff = 123.0,
#'       EnforceProvidedLabels = TRUE|FALSE
#'     )
#'   ),
#'   Role = "string",
#'   GlueVersion = "string",
#'   MaxCapacity = 123.0,
#'   WorkerType = "Standard"|"G.1X"|"G.2X",
#'   NumberOfWorkers = 123,
#'   Timeout = 123,
#'   MaxRetries = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_ml_transform
glue_update_ml_transform <- function(TransformId, Name = NULL, Description = NULL, Parameters = NULL, Role = NULL, GlueVersion = NULL, MaxCapacity = NULL, WorkerType = NULL, NumberOfWorkers = NULL, Timeout = NULL, MaxRetries = NULL) {
  op <- new_operation(
    name = "UpdateMLTransform",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_ml_transform_input(TransformId = TransformId, Name = Name, Description = Description, Parameters = Parameters, Role = Role, GlueVersion = GlueVersion, MaxCapacity = MaxCapacity, WorkerType = WorkerType, NumberOfWorkers = NumberOfWorkers, Timeout = Timeout, MaxRetries = MaxRetries)
  output <- .glue$update_ml_transform_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_ml_transform <- glue_update_ml_transform

#' Updates a partition
#'
#' @description
#' Updates a partition.
#'
#' @usage
#' glue_update_partition(CatalogId, DatabaseName, TableName,
#'   PartitionValueList, PartitionInput)
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be updated resides. If
#' none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table in which the partition to be updated is located.
#' @param PartitionValueList &#91;required&#93; List of partition key values that define the partition to update.
#' @param PartitionInput &#91;required&#93; The new partition object to update the partition to.
#' 
#' The `Values` property can't be changed. If you want to change the
#' partition key values for a partition, delete and recreate the partition.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValueList = list(
#'     "string"
#'   ),
#'   PartitionInput = list(
#'     Values = list(
#'       "string"
#'     ),
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE,
#'       SchemaReference = list(
#'         SchemaId = list(
#'           SchemaArn = "string",
#'           SchemaName = "string",
#'           RegistryName = "string"
#'         ),
#'         SchemaVersionId = "string",
#'         SchemaVersionNumber = 123
#'       )
#'     ),
#'     Parameters = list(
#'       "string"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_partition
glue_update_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValueList, PartitionInput) {
  op <- new_operation(
    name = "UpdatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValueList = PartitionValueList, PartitionInput = PartitionInput)
  output <- .glue$update_partition_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_partition <- glue_update_partition

#' Updates an existing registry which is used to hold a collection of
#' schemas
#'
#' @description
#' Updates an existing registry which is used to hold a collection of
#' schemas. The updated properties relate to the registry, and do not
#' modify any of the schemas within the registry.
#'
#' @usage
#' glue_update_registry(RegistryId, Description)
#'
#' @param RegistryId &#91;required&#93; This is a wrapper structure that may contain the registry name and
#' Amazon Resource Name (ARN).
#' @param Description &#91;required&#93; A description of the registry. If description is not provided, this
#' field will not be updated.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegistryName = "string",
#'   RegistryArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_registry(
#'   RegistryId = list(
#'     RegistryName = "string",
#'     RegistryArn = "string"
#'   ),
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_registry
glue_update_registry <- function(RegistryId, Description) {
  op <- new_operation(
    name = "UpdateRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_registry_input(RegistryId = RegistryId, Description = Description)
  output <- .glue$update_registry_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_registry <- glue_update_registry

#' Updates the description, compatibility setting, or version checkpoint
#' for a schema set
#'
#' @description
#' Updates the description, compatibility setting, or version checkpoint
#' for a schema set.
#' 
#' For updating the compatibility setting, the call will not validate
#' compatibility for the entire set of schema versions with the new
#' compatibility setting. If the value for `Compatibility` is provided, the
#' `VersionNumber` (a checkpoint) is also required. The API will validate
#' the checkpoint version number for consistency.
#' 
#' If the value for the `VersionNumber` (checkpoint) is provided,
#' `Compatibility` is optional and this can be used to set/reset a
#' checkpoint for the schema.
#' 
#' This update will happen only if the schema is in the AVAILABLE state.
#'
#' @usage
#' glue_update_schema(SchemaId, SchemaVersionNumber, Compatibility,
#'   Description)
#'
#' @param SchemaId &#91;required&#93; This is a wrapper structure to contain schema identity fields. The
#' structure contains:
#' 
#' -   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
#'     One of `SchemaArn` or `SchemaName` has to be provided.
#' 
#' -   SchemaId$SchemaName: The name of the schema. One of `SchemaArn` or
#'     `SchemaName` has to be provided.
#' @param SchemaVersionNumber Version number required for check pointing. One of `VersionNumber` or
#' `Compatibility` has to be provided.
#' @param Compatibility The new compatibility setting for the schema.
#' @param Description The new description for the schema.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SchemaArn = "string",
#'   SchemaName = "string",
#'   RegistryName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_schema(
#'   SchemaId = list(
#'     SchemaArn = "string",
#'     SchemaName = "string",
#'     RegistryName = "string"
#'   ),
#'   SchemaVersionNumber = list(
#'     LatestVersion = TRUE|FALSE,
#'     VersionNumber = 123
#'   ),
#'   Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_schema
glue_update_schema <- function(SchemaId, SchemaVersionNumber = NULL, Compatibility = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_schema_input(SchemaId = SchemaId, SchemaVersionNumber = SchemaVersionNumber, Compatibility = Compatibility, Description = Description)
  output <- .glue$update_schema_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_schema <- glue_update_schema

#' Updates a metadata table in the Data Catalog
#'
#' @description
#' Updates a metadata table in the Data Catalog.
#'
#' @usage
#' glue_update_table(CatalogId, DatabaseName, TableInput, SkipArchive)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is provided,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableInput &#91;required&#93; An updated `TableInput` object to define the metadata table in the
#' catalog.
#' @param SkipArchive By default, [`update_table`][glue_update_table] always creates an
#' archived version of the table before updating it. However, if
#' `skipArchive` is set to true, [`update_table`][glue_update_table] does
#' not create the archived version.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableInput = list(
#'     Name = "string",
#'     Description = "string",
#'     Owner = "string",
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Retention = 123,
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE,
#'       SchemaReference = list(
#'         SchemaId = list(
#'           SchemaArn = "string",
#'           SchemaName = "string",
#'           RegistryName = "string"
#'         ),
#'         SchemaVersionId = "string",
#'         SchemaVersionNumber = 123
#'       )
#'     ),
#'     PartitionKeys = list(
#'       list(
#'         Name = "string",
#'         Type = "string",
#'         Comment = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     ViewOriginalText = "string",
#'     ViewExpandedText = "string",
#'     TableType = "string",
#'     Parameters = list(
#'       "string"
#'     ),
#'     TargetTable = list(
#'       CatalogId = "string",
#'       DatabaseName = "string",
#'       Name = "string"
#'     )
#'   ),
#'   SkipArchive = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_table
glue_update_table <- function(CatalogId = NULL, DatabaseName, TableInput, SkipArchive = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableInput = TableInput, SkipArchive = SkipArchive)
  output <- .glue$update_table_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_table <- glue_update_table

#' Updates a trigger definition
#'
#' @description
#' Updates a trigger definition.
#'
#' @usage
#' glue_update_trigger(Name, TriggerUpdate)
#'
#' @param Name &#91;required&#93; The name of the trigger to update.
#' @param TriggerUpdate &#91;required&#93; The new values with which to update the trigger.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Trigger = list(
#'     Name = "string",
#'     WorkflowName = "string",
#'     Id = "string",
#'     Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'     State = "CREATING"|"CREATED"|"ACTIVATING"|"ACTIVATED"|"DEACTIVATING"|"DEACTIVATED"|"DELETING"|"UPDATING",
#'     Description = "string",
#'     Schedule = "string",
#'     Actions = list(
#'       list(
#'         JobName = "string",
#'         Arguments = list(
#'           "string"
#'         ),
#'         Timeout = 123,
#'         SecurityConfiguration = "string",
#'         NotificationProperty = list(
#'           NotifyDelayAfter = 123
#'         ),
#'         CrawlerName = "string"
#'       )
#'     ),
#'     Predicate = list(
#'       Logical = "AND"|"ANY",
#'       Conditions = list(
#'         list(
#'           LogicalOperator = "EQUALS",
#'           JobName = "string",
#'           State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'           CrawlerName = "string",
#'           CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_trigger(
#'   Name = "string",
#'   TriggerUpdate = list(
#'     Name = "string",
#'     Description = "string",
#'     Schedule = "string",
#'     Actions = list(
#'       list(
#'         JobName = "string",
#'         Arguments = list(
#'           "string"
#'         ),
#'         Timeout = 123,
#'         SecurityConfiguration = "string",
#'         NotificationProperty = list(
#'           NotifyDelayAfter = 123
#'         ),
#'         CrawlerName = "string"
#'       )
#'     ),
#'     Predicate = list(
#'       Logical = "AND"|"ANY",
#'       Conditions = list(
#'         list(
#'           LogicalOperator = "EQUALS",
#'           JobName = "string",
#'           State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
#'           CrawlerName = "string",
#'           CrawlState = "RUNNING"|"CANCELLING"|"CANCELLED"|"SUCCEEDED"|"FAILED"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_trigger
glue_update_trigger <- function(Name, TriggerUpdate) {
  op <- new_operation(
    name = "UpdateTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_trigger_input(Name = Name, TriggerUpdate = TriggerUpdate)
  output <- .glue$update_trigger_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_trigger <- glue_update_trigger

#' Updates an existing function definition in the Data Catalog
#'
#' @description
#' Updates an existing function definition in the Data Catalog.
#'
#' @usage
#' glue_update_user_defined_function(CatalogId, DatabaseName, FunctionName,
#'   FunctionInput)
#'
#' @param CatalogId The ID of the Data Catalog where the function to be updated is located.
#' If none is provided, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function to be updated is
#' located.
#' @param FunctionName &#91;required&#93; The name of the function.
#' @param FunctionInput &#91;required&#93; A `FunctionInput` object that redefines the function in the Data
#' Catalog.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionName = "string",
#'   FunctionInput = list(
#'     FunctionName = "string",
#'     ClassName = "string",
#'     OwnerName = "string",
#'     OwnerType = "USER"|"ROLE"|"GROUP",
#'     ResourceUris = list(
#'       list(
#'         ResourceType = "JAR"|"FILE"|"ARCHIVE",
#'         Uri = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_user_defined_function
glue_update_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName, FunctionInput) {
  op <- new_operation(
    name = "UpdateUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName, FunctionInput = FunctionInput)
  output <- .glue$update_user_defined_function_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_user_defined_function <- glue_update_user_defined_function

#' Updates an existing workflow
#'
#' @description
#' Updates an existing workflow.
#'
#' @usage
#' glue_update_workflow(Name, Description, DefaultRunProperties,
#'   MaxConcurrentRuns)
#'
#' @param Name &#91;required&#93; Name of the workflow to be updated.
#' @param Description The description of the workflow.
#' @param DefaultRunProperties A collection of properties to be used as part of each execution of the
#' workflow.
#' @param MaxConcurrentRuns You can use this parameter to prevent unwanted multiple updates to data,
#' to control costs, or in some cases, to prevent exceeding the maximum
#' number of concurrent runs of any of the component jobs. If you leave
#' this parameter blank, there is no limit to the number of concurrent
#' workflow runs.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_workflow(
#'   Name = "string",
#'   Description = "string",
#'   DefaultRunProperties = list(
#'     "string"
#'   ),
#'   MaxConcurrentRuns = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_workflow
glue_update_workflow <- function(Name, Description = NULL, DefaultRunProperties = NULL, MaxConcurrentRuns = NULL) {
  op <- new_operation(
    name = "UpdateWorkflow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_workflow_input(Name = Name, Description = Description, DefaultRunProperties = DefaultRunProperties, MaxConcurrentRuns = MaxConcurrentRuns)
  output <- .glue$update_workflow_output()
  config <- get_config()
  svc <- .glue$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_workflow <- glue_update_workflow
