% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_list_crawlers}
\alias{glue_list_crawlers}
\title{Retrieves the names of all crawler resources in this AWS account, or the
resources with the specified tag}
\usage{
glue_list_crawlers(MaxResults, NextToken, Tags)
}
\arguments{
\item{MaxResults}{The maximum size of a list to return.}

\item{NextToken}{A continuation token, if this is a continuation request.}

\item{Tags}{Specifies to return only these tagged resources.}
}
\description{
Retrieves the names of all crawler resources in this AWS account, or the
resources with the specified tag. This operation allows you to see which
resources are available in your account, and their names.

This operation takes the optional \code{Tags} field, which you can use as a
filter on the response so that tagged resources can be retrieved as a
group. If you choose to use tags filtering, only resources with the tag
are retrieved.
}
\section{Request syntax}{
\preformatted{svc$list_crawlers(
  MaxResults = 123,
  NextToken = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
