% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_set_termination_protection}
\alias{emr_set_termination_protection}
\title{SetTerminationProtection locks a cluster (job flow) so the EC2 instances
in the cluster cannot be terminated by user intervention, an API call,
or in the event of a job-flow error}
\usage{
emr_set_termination_protection(JobFlowIds, TerminationProtected)
}
\arguments{
\item{JobFlowIds}{[required] A list of strings that uniquely identify the clusters to protect. This
identifier is returned by RunJobFlow and can also be obtained from
DescribeJobFlows .}

\item{TerminationProtected}{[required] A Boolean that indicates whether to protect the cluster and prevent the
Amazon EC2 instances in the cluster from shutting down due to API calls,
user intervention, or job-flow error.}
}
\description{
SetTerminationProtection locks a cluster (job flow) so the EC2 instances
in the cluster cannot be terminated by user intervention, an API call,
or in the event of a job-flow error. The cluster still terminates upon
successful completion of the job flow. Calling
\code{SetTerminationProtection} on a cluster is similar to calling the Amazon
EC2 \code{DisableAPITermination} API on all EC2 instances in a cluster.

\code{SetTerminationProtection} is used to prevent accidental termination of
a cluster and to ensure that in the event of an error, the instances
persist so that you can recover any data stored in their ephemeral
instance storage.

To terminate a cluster that has been locked by setting
\code{SetTerminationProtection} to \code{true}, you must first unlock the job flow
by a subsequent call to \code{SetTerminationProtection} in which you set the
value to \code{false}.

For more information, see\href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html}{Managing Cluster Termination}
in the \emph{Amazon EMR Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_termination_protection(
  JobFlowIds = list(
    "string"
  ),
  TerminationProtected = TRUE|FALSE
)
}
}

\keyword{internal}
