# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include glue_service.R
NULL

#' Creates one or more partitions in a batch operation
#'
#' Creates one or more partitions in a batch operation.
#'
#' @usage
#' glue_batch_create_partition(CatalogId, DatabaseName, TableName,
#'   PartitionInputList)
#'
#' @param CatalogId The ID of the catalog in which the partion is to be created. Currently,
#' this should be the AWS account ID.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' created.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be created.
#' @param PartitionInputList &#91;required&#93; A list of `PartitionInput` structures that define the partitions to be
#' created.
#'
#' @section Request syntax:
#' ```
#' svc$batch_create_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionInputList = list(
#'     list(
#'       Values = list(
#'         "string"
#'       ),
#'       LastAccessTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       StorageDescriptor = list(
#'         Columns = list(
#'           list(
#'             Name = "string",
#'             Type = "string",
#'             Comment = "string"
#'           )
#'         ),
#'         Location = "string",
#'         InputFormat = "string",
#'         OutputFormat = "string",
#'         Compressed = TRUE|FALSE,
#'         NumberOfBuckets = 123,
#'         SerdeInfo = list(
#'           Name = "string",
#'           SerializationLibrary = "string",
#'           Parameters = list(
#'             "string"
#'           )
#'         ),
#'         BucketColumns = list(
#'           "string"
#'         ),
#'         SortColumns = list(
#'           list(
#'             Column = "string",
#'             SortOrder = 123
#'           )
#'         ),
#'         Parameters = list(
#'           "string"
#'         ),
#'         SkewedInfo = list(
#'           SkewedColumnNames = list(
#'             "string"
#'           ),
#'           SkewedColumnValues = list(
#'             "string"
#'           ),
#'           SkewedColumnValueLocationMaps = list(
#'             "string"
#'           )
#'         ),
#'         StoredAsSubDirectories = TRUE|FALSE
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       LastAnalyzedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_create_partition
glue_batch_create_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionInputList) {
  op <- new_operation(
    name = "BatchCreatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_create_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionInputList = PartitionInputList)
  output <- .glue$batch_create_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_create_partition <- glue_batch_create_partition

#' Deletes a list of connection definitions from the Data Catalog
#'
#' Deletes a list of connection definitions from the Data Catalog.
#'
#' @usage
#' glue_batch_delete_connection(CatalogId, ConnectionNameList)
#'
#' @param CatalogId The ID of the Data Catalog in which the connections reside. If none is
#' provided, the AWS account ID is used by default.
#' @param ConnectionNameList &#91;required&#93; A list of names of the connections to delete.
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_connection(
#'   CatalogId = "string",
#'   ConnectionNameList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_connection
glue_batch_delete_connection <- function(CatalogId = NULL, ConnectionNameList) {
  op <- new_operation(
    name = "BatchDeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_connection_input(CatalogId = CatalogId, ConnectionNameList = ConnectionNameList)
  output <- .glue$batch_delete_connection_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_connection <- glue_batch_delete_connection

#' Deletes one or more partitions in a batch operation
#'
#' Deletes one or more partitions in a batch operation.
#'
#' @usage
#' glue_batch_delete_partition(CatalogId, DatabaseName, TableName,
#'   PartitionsToDelete)
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be deleted resides. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table where the partitions to be deleted is located.
#' @param PartitionsToDelete &#91;required&#93; A list of `PartitionInput` structures that define the partitions to be
#' deleted.
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionsToDelete = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_partition
glue_batch_delete_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionsToDelete) {
  op <- new_operation(
    name = "BatchDeletePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionsToDelete = PartitionsToDelete)
  output <- .glue$batch_delete_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_partition <- glue_batch_delete_partition

#' Deletes multiple tables at once
#'
#' Deletes multiple tables at once.
#' 
#' After completing this operation, you will no longer have access to the
#' table versions and partitions that belong to the deleted table. AWS Glue
#' deletes these \"orphaned\" resources asynchronously in a timely manner,
#' at the discretion of the service.
#' 
#' To ensure immediate deletion of all related resources, before calling
#' `BatchDeleteTable`, use `DeleteTableVersion` or
#' `BatchDeleteTableVersion`, and `DeletePartition` or
#' `BatchDeletePartition`, to delete any resources that belong to the
#' table.
#'
#' @usage
#' glue_batch_delete_table(CatalogId, DatabaseName, TablesToDelete)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the tables to delete reside. For
#' Hive compatibility, this name is entirely lowercase.
#' @param TablesToDelete &#91;required&#93; A list of the table to delete.
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TablesToDelete = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_table
glue_batch_delete_table <- function(CatalogId = NULL, DatabaseName, TablesToDelete) {
  op <- new_operation(
    name = "BatchDeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TablesToDelete = TablesToDelete)
  output <- .glue$batch_delete_table_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_table <- glue_batch_delete_table

#' Deletes a specified batch of versions of a table
#'
#' Deletes a specified batch of versions of a table.
#'
#' @usage
#' glue_batch_delete_table_version(CatalogId, DatabaseName, TableName,
#'   VersionIds)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionIds &#91;required&#93; A list of the IDs of versions to be deleted. A `VersionId` is a string
#' representation of an integer. Each version is incremented by 1.
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_table_version(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   VersionIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_delete_table_version
glue_batch_delete_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionIds) {
  op <- new_operation(
    name = "BatchDeleteTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_delete_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionIds = VersionIds)
  output <- .glue$batch_delete_table_version_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_delete_table_version <- glue_batch_delete_table_version

#' Returns a list of resource metadata for a given list of crawler names
#'
#' Returns a list of resource metadata for a given list of crawler names.
#' After calling the `ListCrawlers` operation, you can call this operation
#' to access the data to which you have been granted permissions. This
#' operation supports all IAM permissions, including permission conditions
#' that uses tags.
#'
#' @usage
#' glue_batch_get_crawlers(CrawlerNames)
#'
#' @param CrawlerNames &#91;required&#93; A list of crawler names, which may be the names returned from the
#' `ListCrawlers` operation.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_crawlers(
#'   CrawlerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_crawlers
glue_batch_get_crawlers <- function(CrawlerNames) {
  op <- new_operation(
    name = "BatchGetCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_crawlers_input(CrawlerNames = CrawlerNames)
  output <- .glue$batch_get_crawlers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_crawlers <- glue_batch_get_crawlers

#' Returns a list of resource metadata for a given list of DevEndpoint
#' names
#'
#' Returns a list of resource metadata for a given list of DevEndpoint
#' names. After calling the `ListDevEndpoints` operation, you can call this
#' operation to access the data to which you have been granted permissions.
#' This operation supports all IAM permissions, including permission
#' conditions that uses tags.
#'
#' @usage
#' glue_batch_get_dev_endpoints(DevEndpointNames)
#'
#' @param DevEndpointNames &#91;required&#93; The list of DevEndpoint names, which may be the names returned from the
#' `ListDevEndpoint` operation.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_dev_endpoints(
#'   DevEndpointNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_dev_endpoints
glue_batch_get_dev_endpoints <- function(DevEndpointNames) {
  op <- new_operation(
    name = "BatchGetDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_dev_endpoints_input(DevEndpointNames = DevEndpointNames)
  output <- .glue$batch_get_dev_endpoints_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_dev_endpoints <- glue_batch_get_dev_endpoints

#' Returns a list of resource metadata for a given list of job names
#'
#' Returns a list of resource metadata for a given list of job names. After
#' calling the `ListJobs` operation, you can call this operation to access
#' the data to which you have been granted permissions. This operation
#' supports all IAM permissions, including permission conditions that uses
#' tags.
#'
#' @usage
#' glue_batch_get_jobs(JobNames)
#'
#' @param JobNames &#91;required&#93; A list of job names, which may be the names returned from the `ListJobs`
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_jobs(
#'   JobNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_jobs
glue_batch_get_jobs <- function(JobNames) {
  op <- new_operation(
    name = "BatchGetJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_jobs_input(JobNames = JobNames)
  output <- .glue$batch_get_jobs_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_jobs <- glue_batch_get_jobs

#' Retrieves partitions in a batch request
#'
#' Retrieves partitions in a batch request.
#'
#' @usage
#' glue_batch_get_partition(CatalogId, DatabaseName, TableName,
#'   PartitionsToGet)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions\' table.
#' @param PartitionsToGet &#91;required&#93; A list of partition values identifying the partitions to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionsToGet = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_partition
glue_batch_get_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionsToGet) {
  op <- new_operation(
    name = "BatchGetPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionsToGet = PartitionsToGet)
  output <- .glue$batch_get_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_partition <- glue_batch_get_partition

#' Returns a list of resource metadata for a given list of trigger names
#'
#' Returns a list of resource metadata for a given list of trigger names.
#' After calling the `ListTriggers` operation, you can call this operation
#' to access the data to which you have been granted permissions. This
#' operation supports all IAM permissions, including permission conditions
#' that uses tags.
#'
#' @usage
#' glue_batch_get_triggers(TriggerNames)
#'
#' @param TriggerNames &#91;required&#93; A list of trigger names, which may be the names returned from the
#' `ListTriggers` operation.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_triggers(
#'   TriggerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_get_triggers
glue_batch_get_triggers <- function(TriggerNames) {
  op <- new_operation(
    name = "BatchGetTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_get_triggers_input(TriggerNames = TriggerNames)
  output <- .glue$batch_get_triggers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_get_triggers <- glue_batch_get_triggers

#' Stops one or more job runs for a specified job definition
#'
#' Stops one or more job runs for a specified job definition.
#'
#' @usage
#' glue_batch_stop_job_run(JobName, JobRunIds)
#'
#' @param JobName &#91;required&#93; The name of the job definition for which to stop job runs.
#' @param JobRunIds &#91;required&#93; A list of the JobRunIds that should be stopped for that job definition.
#'
#' @section Request syntax:
#' ```
#' svc$batch_stop_job_run(
#'   JobName = "string",
#'   JobRunIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_batch_stop_job_run
glue_batch_stop_job_run <- function(JobName, JobRunIds) {
  op <- new_operation(
    name = "BatchStopJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$batch_stop_job_run_input(JobName = JobName, JobRunIds = JobRunIds)
  output <- .glue$batch_stop_job_run_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$batch_stop_job_run <- glue_batch_stop_job_run

#' Creates a classifier in the user's account
#'
#' Creates a classifier in the user\'s account. This may be a
#' `GrokClassifier`, an `XMLClassifier`, a `JsonClassifier`, or a
#' `CsvClassifier`, depending on which field of the request is present.
#'
#' @usage
#' glue_create_classifier(GrokClassifier, XMLClassifier, JsonClassifier,
#'   CsvClassifier)
#'
#' @param GrokClassifier A `GrokClassifier` object specifying the classifier to create.
#' @param XMLClassifier An `XMLClassifier` object specifying the classifier to create.
#' @param JsonClassifier A `JsonClassifier` object specifying the classifier to create.
#' @param CsvClassifier A `CsvClassifier` object specifying the classifier to create.
#'
#' @section Request syntax:
#' ```
#' svc$create_classifier(
#'   GrokClassifier = list(
#'     Classification = "string",
#'     Name = "string",
#'     GrokPattern = "string",
#'     CustomPatterns = "string"
#'   ),
#'   XMLClassifier = list(
#'     Classification = "string",
#'     Name = "string",
#'     RowTag = "string"
#'   ),
#'   JsonClassifier = list(
#'     Name = "string",
#'     JsonPath = "string"
#'   ),
#'   CsvClassifier = list(
#'     Name = "string",
#'     Delimiter = "string",
#'     QuoteSymbol = "string",
#'     ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
#'     Header = list(
#'       "string"
#'     ),
#'     DisableValueTrimming = TRUE|FALSE,
#'     AllowSingleColumn = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_classifier
glue_create_classifier <- function(GrokClassifier = NULL, XMLClassifier = NULL, JsonClassifier = NULL, CsvClassifier = NULL) {
  op <- new_operation(
    name = "CreateClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_classifier_input(GrokClassifier = GrokClassifier, XMLClassifier = XMLClassifier, JsonClassifier = JsonClassifier, CsvClassifier = CsvClassifier)
  output <- .glue$create_classifier_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_classifier <- glue_create_classifier

#' Creates a connection definition in the Data Catalog
#'
#' Creates a connection definition in the Data Catalog.
#'
#' @usage
#' glue_create_connection(CatalogId, ConnectionInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the connection. If none is
#' provided, the AWS account ID is used by default.
#' @param ConnectionInput &#91;required&#93; A `ConnectionInput` object defining the connection to create.
#'
#' @section Request syntax:
#' ```
#' svc$create_connection(
#'   CatalogId = "string",
#'   ConnectionInput = list(
#'     Name = "string",
#'     Description = "string",
#'     ConnectionType = "JDBC"|"SFTP",
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionProperties = list(
#'       "string"
#'     ),
#'     PhysicalConnectionRequirements = list(
#'       SubnetId = "string",
#'       SecurityGroupIdList = list(
#'         "string"
#'       ),
#'       AvailabilityZone = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_connection
glue_create_connection <- function(CatalogId = NULL, ConnectionInput) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_connection_input(CatalogId = CatalogId, ConnectionInput = ConnectionInput)
  output <- .glue$create_connection_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_connection <- glue_create_connection

#' Creates a new crawler with specified targets, role, configuration, and
#' optional schedule
#'
#' Creates a new crawler with specified targets, role, configuration, and
#' optional schedule. At least one crawl target must be specified, in the
#' *s3Targets* field, the *jdbcTargets* field, or the *DynamoDBTargets*
#' field.
#'
#' @usage
#' glue_create_crawler(Name, Role, DatabaseName, Description, Targets,
#'   Schedule, Classifiers, TablePrefix, SchemaChangePolicy, Configuration,
#'   CrawlerSecurityConfiguration, Tags)
#'
#' @param Name &#91;required&#93; Name of the new crawler.
#' @param Role &#91;required&#93; The IAM role (or ARN of an IAM role) used by the new crawler to access
#' customer resources.
#' @param DatabaseName &#91;required&#93; The AWS Glue database where results are written, such as:
#' `arn:aws:daylight:us-east-1::database/sometable/*`.
#' @param Description A description of the new crawler.
#' @param Targets &#91;required&#93; A list of collection of targets to crawl.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' @param Classifiers A list of custom classifiers that the user has registered. By default,
#' all built-in classifiers are included in a crawl, but these custom
#' classifiers always override the default classifiers for a given
#' classification.
#' @param TablePrefix The table prefix used for catalog tables that are created.
#' @param SchemaChangePolicy Policy for the crawler\'s update and deletion behavior.
#' @param Configuration Crawler configuration information. This versioned JSON string allows
#' users to specify aspects of a crawler\'s behavior. For more information,
#' see [Configuring a
#' Crawler](http://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
#' @param CrawlerSecurityConfiguration The name of the SecurityConfiguration structure to be used by this
#' Crawler.
#' @param Tags The tags to use with this crawler request. You may use tags to limit
#' access to the crawler. For more information about tags in AWS Glue, see
#' [AWS Tags in AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#'
#' @section Request syntax:
#' ```
#' svc$create_crawler(
#'   Name = "string",
#'   Role = "string",
#'   DatabaseName = "string",
#'   Description = "string",
#'   Targets = list(
#'     S3Targets = list(
#'       list(
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     JdbcTargets = list(
#'       list(
#'         ConnectionName = "string",
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     DynamoDBTargets = list(
#'       list(
#'         Path = "string"
#'       )
#'     )
#'   ),
#'   Schedule = "string",
#'   Classifiers = list(
#'     "string"
#'   ),
#'   TablePrefix = "string",
#'   SchemaChangePolicy = list(
#'     UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'     DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'   ),
#'   Configuration = "string",
#'   CrawlerSecurityConfiguration = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_crawler
glue_create_crawler <- function(Name, Role, DatabaseName, Description = NULL, Targets, Schedule = NULL, Classifiers = NULL, TablePrefix = NULL, SchemaChangePolicy = NULL, Configuration = NULL, CrawlerSecurityConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_crawler_input(Name = Name, Role = Role, DatabaseName = DatabaseName, Description = Description, Targets = Targets, Schedule = Schedule, Classifiers = Classifiers, TablePrefix = TablePrefix, SchemaChangePolicy = SchemaChangePolicy, Configuration = Configuration, CrawlerSecurityConfiguration = CrawlerSecurityConfiguration, Tags = Tags)
  output <- .glue$create_crawler_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_crawler <- glue_create_crawler

#' Creates a new database in a Data Catalog
#'
#' Creates a new database in a Data Catalog.
#'
#' @usage
#' glue_create_database(CatalogId, DatabaseInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the database. If none is
#' supplied, the AWS account ID is used by default.
#' @param DatabaseInput &#91;required&#93; A `DatabaseInput` object defining the metadata database to create in the
#' catalog.
#'
#' @section Request syntax:
#' ```
#' svc$create_database(
#'   CatalogId = "string",
#'   DatabaseInput = list(
#'     Name = "string",
#'     Description = "string",
#'     LocationUri = "string",
#'     Parameters = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_database
glue_create_database <- function(CatalogId = NULL, DatabaseInput) {
  op <- new_operation(
    name = "CreateDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_database_input(CatalogId = CatalogId, DatabaseInput = DatabaseInput)
  output <- .glue$create_database_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_database <- glue_create_database

#' Creates a new DevEndpoint
#'
#' Creates a new DevEndpoint.
#'
#' @usage
#' glue_create_dev_endpoint(EndpointName, RoleArn, SecurityGroupIds,
#'   SubnetId, PublicKey, PublicKeys, NumberOfNodes, ExtraPythonLibsS3Path,
#'   ExtraJarsS3Path, SecurityConfiguration, Tags, Arguments)
#'
#' @param EndpointName &#91;required&#93; The name to be assigned to the new DevEndpoint.
#' @param RoleArn &#91;required&#93; The IAM role for the DevEndpoint.
#' @param SecurityGroupIds Security group IDs for the security groups to be used by the new
#' DevEndpoint.
#' @param SubnetId The subnet ID for the new DevEndpoint to use.
#' @param PublicKey The public key to be used by this DevEndpoint for authentication. This
#' attribute is provided for backward compatibility, as the recommended
#' attribute to use is public keys.
#' @param PublicKeys A list of public keys to be used by the DevEndpoints for authentication.
#' The use of this attribute is preferred over a single public key because
#' the public keys allow you to have a different private key per client.
#' 
#' If you previously created an endpoint with a public key, you must remove
#' that key to be able to set a list of public keys: call the
#' `UpdateDevEndpoint` API with the public key content in the
#' `deletePublicKeys` attribute, and the list of new keys in the
#' `addPublicKeys` attribute.
#' @param NumberOfNodes The number of AWS Glue Data Processing Units (DPUs) to allocate to this
#' DevEndpoint.
#' @param ExtraPythonLibsS3Path Path(s) to one or more Python libraries in an S3 bucket that should be
#' loaded in your DevEndpoint. Multiple values must be complete paths
#' separated by a comma.
#' 
#' Please note that only pure Python libraries can currently be used on a
#' DevEndpoint. Libraries that rely on C extensions, such as the
#' [pandas](http://pandas.pydata.org/) Python data analysis library, are
#' not yet supported.
#' @param ExtraJarsS3Path Path to one or more Java Jars in an S3 bucket that should be loaded in
#' your DevEndpoint.
#' @param SecurityConfiguration The name of the SecurityConfiguration structure to be used with this
#' DevEndpoint.
#' @param Tags The tags to use with this DevEndpoint. You may use tags to limit access
#' to the DevEndpoint. For more information about tags in AWS Glue, see
#' [AWS Tags in AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#' @param Arguments A map of arguments used to configure the DevEndpoint.
#'
#' @section Request syntax:
#' ```
#' svc$create_dev_endpoint(
#'   EndpointName = "string",
#'   RoleArn = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   SubnetId = "string",
#'   PublicKey = "string",
#'   PublicKeys = list(
#'     "string"
#'   ),
#'   NumberOfNodes = 123,
#'   ExtraPythonLibsS3Path = "string",
#'   ExtraJarsS3Path = "string",
#'   SecurityConfiguration = "string",
#'   Tags = list(
#'     "string"
#'   ),
#'   Arguments = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_dev_endpoint
glue_create_dev_endpoint <- function(EndpointName, RoleArn, SecurityGroupIds = NULL, SubnetId = NULL, PublicKey = NULL, PublicKeys = NULL, NumberOfNodes = NULL, ExtraPythonLibsS3Path = NULL, ExtraJarsS3Path = NULL, SecurityConfiguration = NULL, Tags = NULL, Arguments = NULL) {
  op <- new_operation(
    name = "CreateDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_dev_endpoint_input(EndpointName = EndpointName, RoleArn = RoleArn, SecurityGroupIds = SecurityGroupIds, SubnetId = SubnetId, PublicKey = PublicKey, PublicKeys = PublicKeys, NumberOfNodes = NumberOfNodes, ExtraPythonLibsS3Path = ExtraPythonLibsS3Path, ExtraJarsS3Path = ExtraJarsS3Path, SecurityConfiguration = SecurityConfiguration, Tags = Tags, Arguments = Arguments)
  output <- .glue$create_dev_endpoint_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_dev_endpoint <- glue_create_dev_endpoint

#' Creates a new job definition
#'
#' Creates a new job definition.
#'
#' @usage
#' glue_create_job(Name, Description, LogUri, Role, ExecutionProperty,
#'   Command, DefaultArguments, Connections, MaxRetries, AllocatedCapacity,
#'   Timeout, MaxCapacity, NotificationProperty, SecurityConfiguration, Tags)
#'
#' @param Name &#91;required&#93; The name you assign to this job definition. It must be unique in your
#' account.
#' @param Description Description of the job being defined.
#' @param LogUri This field is reserved for future use.
#' @param Role &#91;required&#93; The name or ARN of the IAM role associated with this job.
#' @param ExecutionProperty An ExecutionProperty specifying the maximum number of concurrent runs
#' allowed for this job.
#' @param Command &#91;required&#93; The JobCommand that executes this job.
#' @param DefaultArguments The default arguments for this job.
#' 
#' You can specify arguments here that your own job-execution script
#' consumes, as well as arguments that AWS Glue itself consumes.
#' 
#' For information about how to specify and consume your own Job arguments,
#' see the [Calling AWS Glue APIs in
#' Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
#' topic in the developer guide.
#' 
#' For information about the key-value pairs that AWS Glue consumes to set
#' up your job, see the [Special Parameters Used by AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
#' topic in the developer guide.
#' @param Connections The connections used for this job.
#' @param MaxRetries The maximum number of times to retry this job if it fails.
#' @param AllocatedCapacity This parameter is deprecated. Use `MaxCapacity` instead.
#' 
#' The number of AWS Glue data processing units (DPUs) to allocate to this
#' Job. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a
#' relative measure of processing power that consists of 4 vCPUs of compute
#' capacity and 16 GB of memory. For more information, see the [AWS Glue
#' pricing page](https://aws.amazon.com/glue/pricing/).
#' @param Timeout The job timeout in minutes. This is the maximum time that a job run can
#' consume resources before it is terminated and enters `TIMEOUT` status.
#' The default is 2,880 minutes (48 hours).
#' @param MaxCapacity The number of AWS Glue data processing units (DPUs) that can be
#' allocated when this job runs. A DPU is a relative measure of processing
#' power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
#' For more information, see the [AWS Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' The value that can be allocated for `MaxCapacity` depends on whether you
#' are running a python shell job, or an Apache Spark ETL job:
#' 
#' -   When you specify a python shell job
#'     (`JobCommand.Name`=\"pythonshell\"), you can allocate either 0.0625
#'     or 1 DPU. The default is 0.0625 DPU.
#' 
#' -   When you specify an Apache Spark ETL job
#'     (`JobCommand.Name`=\"glueetl\"), you can allocate from 2 to 100
#'     DPUs. The default is 10 DPUs. This job type cannot have a fractional
#'     DPU allocation.
#' @param NotificationProperty Specifies configuration properties of a job notification.
#' @param SecurityConfiguration The name of the SecurityConfiguration structure to be used with this
#' job.
#' @param Tags The tags to use with this job. You may use tags to limit access to the
#' job. For more information about tags in AWS Glue, see [AWS Tags in AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#'
#' @section Request syntax:
#' ```
#' svc$create_job(
#'   Name = "string",
#'   Description = "string",
#'   LogUri = "string",
#'   Role = "string",
#'   ExecutionProperty = list(
#'     MaxConcurrentRuns = 123
#'   ),
#'   Command = list(
#'     Name = "string",
#'     ScriptLocation = "string"
#'   ),
#'   DefaultArguments = list(
#'     "string"
#'   ),
#'   Connections = list(
#'     Connections = list(
#'       "string"
#'     )
#'   ),
#'   MaxRetries = 123,
#'   AllocatedCapacity = 123,
#'   Timeout = 123,
#'   MaxCapacity = 123.0,
#'   NotificationProperty = list(
#'     NotifyDelayAfter = 123
#'   ),
#'   SecurityConfiguration = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_job
glue_create_job <- function(Name, Description = NULL, LogUri = NULL, Role, ExecutionProperty = NULL, Command, DefaultArguments = NULL, Connections = NULL, MaxRetries = NULL, AllocatedCapacity = NULL, Timeout = NULL, MaxCapacity = NULL, NotificationProperty = NULL, SecurityConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_job_input(Name = Name, Description = Description, LogUri = LogUri, Role = Role, ExecutionProperty = ExecutionProperty, Command = Command, DefaultArguments = DefaultArguments, Connections = Connections, MaxRetries = MaxRetries, AllocatedCapacity = AllocatedCapacity, Timeout = Timeout, MaxCapacity = MaxCapacity, NotificationProperty = NotificationProperty, SecurityConfiguration = SecurityConfiguration, Tags = Tags)
  output <- .glue$create_job_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_job <- glue_create_job

#' Creates a new partition
#'
#' Creates a new partition.
#'
#' @usage
#' glue_create_partition(CatalogId, DatabaseName, TableName,
#'   PartitionInput)
#'
#' @param CatalogId The ID of the catalog in which the partion is to be created. Currently,
#' this should be the AWS account ID.
#' @param DatabaseName &#91;required&#93; The name of the metadata database in which the partition is to be
#' created.
#' @param TableName &#91;required&#93; The name of the metadata table in which the partition is to be created.
#' @param PartitionInput &#91;required&#93; A `PartitionInput` structure defining the partition to be created.
#'
#' @section Request syntax:
#' ```
#' svc$create_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionInput = list(
#'     Values = list(
#'       "string"
#'     ),
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string"
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE
#'     ),
#'     Parameters = list(
#'       "string"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_partition
glue_create_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionInput) {
  op <- new_operation(
    name = "CreatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionInput = PartitionInput)
  output <- .glue$create_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_partition <- glue_create_partition

#' Transforms a directed acyclic graph (DAG) into code
#'
#' Transforms a directed acyclic graph (DAG) into code.
#'
#' @usage
#' glue_create_script(DagNodes, DagEdges, Language)
#'
#' @param DagNodes A list of the nodes in the DAG.
#' @param DagEdges A list of the edges in the DAG.
#' @param Language The programming language of the resulting code from the DAG.
#'
#' @section Request syntax:
#' ```
#' svc$create_script(
#'   DagNodes = list(
#'     list(
#'       Id = "string",
#'       NodeType = "string",
#'       Args = list(
#'         list(
#'           Name = "string",
#'           Value = "string",
#'           Param = TRUE|FALSE
#'         )
#'       ),
#'       LineNumber = 123
#'     )
#'   ),
#'   DagEdges = list(
#'     list(
#'       Source = "string",
#'       Target = "string",
#'       TargetParameter = "string"
#'     )
#'   ),
#'   Language = "PYTHON"|"SCALA"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_script
glue_create_script <- function(DagNodes = NULL, DagEdges = NULL, Language = NULL) {
  op <- new_operation(
    name = "CreateScript",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_script_input(DagNodes = DagNodes, DagEdges = DagEdges, Language = Language)
  output <- .glue$create_script_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_script <- glue_create_script

#' Creates a new security configuration
#'
#' Creates a new security configuration.
#'
#' @usage
#' glue_create_security_configuration(Name, EncryptionConfiguration)
#'
#' @param Name &#91;required&#93; The name for the new security configuration.
#' @param EncryptionConfiguration &#91;required&#93; The encryption configuration for the new security configuration.
#'
#' @section Request syntax:
#' ```
#' svc$create_security_configuration(
#'   Name = "string",
#'   EncryptionConfiguration = list(
#'     S3Encryption = list(
#'       list(
#'         S3EncryptionMode = "DISABLED"|"SSE-KMS"|"SSE-S3",
#'         KmsKeyArn = "string"
#'       )
#'     ),
#'     CloudWatchEncryption = list(
#'       CloudWatchEncryptionMode = "DISABLED"|"SSE-KMS",
#'       KmsKeyArn = "string"
#'     ),
#'     JobBookmarksEncryption = list(
#'       JobBookmarksEncryptionMode = "DISABLED"|"CSE-KMS",
#'       KmsKeyArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_security_configuration
glue_create_security_configuration <- function(Name, EncryptionConfiguration) {
  op <- new_operation(
    name = "CreateSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_security_configuration_input(Name = Name, EncryptionConfiguration = EncryptionConfiguration)
  output <- .glue$create_security_configuration_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_security_configuration <- glue_create_security_configuration

#' Creates a new table definition in the Data Catalog
#'
#' Creates a new table definition in the Data Catalog.
#'
#' @usage
#' glue_create_table(CatalogId, DatabaseName, TableInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the `Table`. If none is
#' supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The catalog database in which to create the new table. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableInput &#91;required&#93; The `TableInput` object that defines the metadata table to create in the
#' catalog.
#'
#' @section Request syntax:
#' ```
#' svc$create_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableInput = list(
#'     Name = "string",
#'     Description = "string",
#'     Owner = "string",
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Retention = 123,
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string"
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE
#'     ),
#'     PartitionKeys = list(
#'       list(
#'         Name = "string",
#'         Type = "string",
#'         Comment = "string"
#'       )
#'     ),
#'     ViewOriginalText = "string",
#'     ViewExpandedText = "string",
#'     TableType = "string",
#'     Parameters = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_table
glue_create_table <- function(CatalogId = NULL, DatabaseName, TableInput) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableInput = TableInput)
  output <- .glue$create_table_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_table <- glue_create_table

#' Creates a new trigger
#'
#' Creates a new trigger.
#'
#' @usage
#' glue_create_trigger(Name, Type, Schedule, Predicate, Actions,
#'   Description, StartOnCreation, Tags)
#'
#' @param Name &#91;required&#93; The name of the trigger.
#' @param Type &#91;required&#93; The type of the new trigger.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' 
#' This field is required when the trigger type is SCHEDULED.
#' @param Predicate A predicate to specify when the new trigger should fire.
#' 
#' This field is required when the trigger type is CONDITIONAL.
#' @param Actions &#91;required&#93; The actions initiated by this trigger when it fires.
#' @param Description A description of the new trigger.
#' @param StartOnCreation Set to true to start SCHEDULED and CONDITIONAL triggers when created.
#' True not supported for ON\\_DEMAND triggers.
#' @param Tags The tags to use with this trigger. You may use tags to limit access to
#' the trigger. For more information about tags in AWS Glue, see [AWS Tags
#' in AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html) in
#' the developer guide.
#'
#' @section Request syntax:
#' ```
#' svc$create_trigger(
#'   Name = "string",
#'   Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
#'   Schedule = "string",
#'   Predicate = list(
#'     Logical = "AND"|"ANY",
#'     Conditions = list(
#'       list(
#'         LogicalOperator = "EQUALS",
#'         JobName = "string",
#'         State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT"
#'       )
#'     )
#'   ),
#'   Actions = list(
#'     list(
#'       JobName = "string",
#'       Arguments = list(
#'         "string"
#'       ),
#'       Timeout = 123,
#'       NotificationProperty = list(
#'         NotifyDelayAfter = 123
#'       ),
#'       SecurityConfiguration = "string"
#'     )
#'   ),
#'   Description = "string",
#'   StartOnCreation = TRUE|FALSE,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_trigger
glue_create_trigger <- function(Name, Type, Schedule = NULL, Predicate = NULL, Actions, Description = NULL, StartOnCreation = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_trigger_input(Name = Name, Type = Type, Schedule = Schedule, Predicate = Predicate, Actions = Actions, Description = Description, StartOnCreation = StartOnCreation, Tags = Tags)
  output <- .glue$create_trigger_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_trigger <- glue_create_trigger

#' Creates a new function definition in the Data Catalog
#'
#' Creates a new function definition in the Data Catalog.
#'
#' @usage
#' glue_create_user_defined_function(CatalogId, DatabaseName,
#'   FunctionInput)
#'
#' @param CatalogId The ID of the Data Catalog in which to create the function. If none is
#' supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which to create the function.
#' @param FunctionInput &#91;required&#93; A `FunctionInput` object that defines the function to create in the Data
#' Catalog.
#'
#' @section Request syntax:
#' ```
#' svc$create_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionInput = list(
#'     FunctionName = "string",
#'     ClassName = "string",
#'     OwnerName = "string",
#'     OwnerType = "USER"|"ROLE"|"GROUP",
#'     ResourceUris = list(
#'       list(
#'         ResourceType = "JAR"|"FILE"|"ARCHIVE",
#'         Uri = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_create_user_defined_function
glue_create_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionInput) {
  op <- new_operation(
    name = "CreateUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$create_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionInput = FunctionInput)
  output <- .glue$create_user_defined_function_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$create_user_defined_function <- glue_create_user_defined_function

#' Removes a classifier from the Data Catalog
#'
#' Removes a classifier from the Data Catalog.
#'
#' @usage
#' glue_delete_classifier(Name)
#'
#' @param Name &#91;required&#93; Name of the classifier to remove.
#'
#' @section Request syntax:
#' ```
#' svc$delete_classifier(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_classifier
glue_delete_classifier <- function(Name) {
  op <- new_operation(
    name = "DeleteClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_classifier_input(Name = Name)
  output <- .glue$delete_classifier_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_classifier <- glue_delete_classifier

#' Deletes a connection from the Data Catalog
#'
#' Deletes a connection from the Data Catalog.
#'
#' @usage
#' glue_delete_connection(CatalogId, ConnectionName)
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the AWS account ID is used by default.
#' @param ConnectionName &#91;required&#93; The name of the connection to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_connection(
#'   CatalogId = "string",
#'   ConnectionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_connection
glue_delete_connection <- function(CatalogId = NULL, ConnectionName) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_connection_input(CatalogId = CatalogId, ConnectionName = ConnectionName)
  output <- .glue$delete_connection_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_connection <- glue_delete_connection

#' Removes a specified crawler from the Data Catalog, unless the crawler
#' state is RUNNING
#'
#' Removes a specified crawler from the Data Catalog, unless the crawler
#' state is `RUNNING`.
#'
#' @usage
#' glue_delete_crawler(Name)
#'
#' @param Name &#91;required&#93; Name of the crawler to remove.
#'
#' @section Request syntax:
#' ```
#' svc$delete_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_crawler
glue_delete_crawler <- function(Name) {
  op <- new_operation(
    name = "DeleteCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_crawler_input(Name = Name)
  output <- .glue$delete_crawler_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_crawler <- glue_delete_crawler

#' Removes a specified Database from a Data Catalog
#'
#' Removes a specified Database from a Data Catalog.
#' 
#' After completing this operation, you will no longer have access to the
#' tables (and all table versions and partitions that might belong to the
#' tables) and the user-defined functions in the deleted database. AWS Glue
#' deletes these \"orphaned\" resources asynchronously in a timely manner,
#' at the discretion of the service.
#' 
#' To ensure immediate deletion of all related resources, before calling
#' `DeleteDatabase`, use `DeleteTableVersion` or `BatchDeleteTableVersion`,
#' `DeletePartition` or `BatchDeletePartition`,
#' `DeleteUserDefinedFunction`, and `DeleteTable` or `BatchDeleteTable`, to
#' delete any resources that belong to the database.
#'
#' @usage
#' glue_delete_database(CatalogId, Name)
#'
#' @param CatalogId The ID of the Data Catalog in which the database resides. If none is
#' supplied, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the Database to delete. For Hive compatibility, this must be
#' all lowercase.
#'
#' @section Request syntax:
#' ```
#' svc$delete_database(
#'   CatalogId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_database
glue_delete_database <- function(CatalogId = NULL, Name) {
  op <- new_operation(
    name = "DeleteDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_database_input(CatalogId = CatalogId, Name = Name)
  output <- .glue$delete_database_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_database <- glue_delete_database

#' Deletes a specified DevEndpoint
#'
#' Deletes a specified DevEndpoint.
#'
#' @usage
#' glue_delete_dev_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; The name of the DevEndpoint.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dev_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_dev_endpoint
glue_delete_dev_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_dev_endpoint_input(EndpointName = EndpointName)
  output <- .glue$delete_dev_endpoint_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_dev_endpoint <- glue_delete_dev_endpoint

#' Deletes a specified job definition
#'
#' Deletes a specified job definition. If the job definition is not found,
#' no exception is thrown.
#'
#' @usage
#' glue_delete_job(JobName)
#'
#' @param JobName &#91;required&#93; The name of the job definition to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_job(
#'   JobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_job
glue_delete_job <- function(JobName) {
  op <- new_operation(
    name = "DeleteJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_job_input(JobName = JobName)
  output <- .glue$delete_job_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_job <- glue_delete_job

#' Deletes a specified partition
#'
#' Deletes a specified partition.
#'
#' @usage
#' glue_delete_partition(CatalogId, DatabaseName, TableName,
#'   PartitionValues)
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be deleted resides. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table where the partition to be deleted is located.
#' @param PartitionValues &#91;required&#93; The values that define the partition.
#'
#' @section Request syntax:
#' ```
#' svc$delete_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_partition
glue_delete_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues) {
  op <- new_operation(
    name = "DeletePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues)
  output <- .glue$delete_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_partition <- glue_delete_partition

#' Deletes a specified policy
#'
#' Deletes a specified policy.
#'
#' @usage
#' glue_delete_resource_policy(PolicyHashCondition)
#'
#' @param PolicyHashCondition The hash value returned when this policy was set.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_policy(
#'   PolicyHashCondition = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_resource_policy
glue_delete_resource_policy <- function(PolicyHashCondition = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_resource_policy_input(PolicyHashCondition = PolicyHashCondition)
  output <- .glue$delete_resource_policy_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_resource_policy <- glue_delete_resource_policy

#' Deletes a specified security configuration
#'
#' Deletes a specified security configuration.
#'
#' @usage
#' glue_delete_security_configuration(Name)
#'
#' @param Name &#91;required&#93; The name of the security configuration to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_security_configuration(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_security_configuration
glue_delete_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DeleteSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_security_configuration_input(Name = Name)
  output <- .glue$delete_security_configuration_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_security_configuration <- glue_delete_security_configuration

#' Removes a table definition from the Data Catalog
#'
#' Removes a table definition from the Data Catalog.
#' 
#' After completing this operation, you will no longer have access to the
#' table versions and partitions that belong to the deleted table. AWS Glue
#' deletes these \"orphaned\" resources asynchronously in a timely manner,
#' at the discretion of the service.
#' 
#' To ensure immediate deletion of all related resources, before calling
#' `DeleteTable`, use `DeleteTableVersion` or `BatchDeleteTableVersion`,
#' and `DeletePartition` or `BatchDeletePartition`, to delete any resources
#' that belong to the table.
#'
#' @usage
#' glue_delete_table(CatalogId, DatabaseName, Name)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param Name &#91;required&#93; The name of the table to be deleted. For Hive compatibility, this name
#' is entirely lowercase.
#'
#' @section Request syntax:
#' ```
#' svc$delete_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_table
glue_delete_table <- function(CatalogId = NULL, DatabaseName, Name) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name)
  output <- .glue$delete_table_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table <- glue_delete_table

#' Deletes a specified version of a table
#'
#' Deletes a specified version of a table.
#'
#' @usage
#' glue_delete_table_version(CatalogId, DatabaseName, TableName, VersionId)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionId &#91;required&#93; The ID of the table version to be deleted. A `VersionID` is a string
#' representation of an integer. Each version is incremented by 1.
#'
#' @section Request syntax:
#' ```
#' svc$delete_table_version(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_table_version
glue_delete_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionId) {
  op <- new_operation(
    name = "DeleteTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionId = VersionId)
  output <- .glue$delete_table_version_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_table_version <- glue_delete_table_version

#' Deletes a specified trigger
#'
#' Deletes a specified trigger. If the trigger is not found, no exception
#' is thrown.
#'
#' @usage
#' glue_delete_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_trigger
glue_delete_trigger <- function(Name) {
  op <- new_operation(
    name = "DeleteTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_trigger_input(Name = Name)
  output <- .glue$delete_trigger_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_trigger <- glue_delete_trigger

#' Deletes an existing function definition from the Data Catalog
#'
#' Deletes an existing function definition from the Data Catalog.
#'
#' @usage
#' glue_delete_user_defined_function(CatalogId, DatabaseName, FunctionName)
#'
#' @param CatalogId The ID of the Data Catalog where the function to be deleted is located.
#' If none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function is located.
#' @param FunctionName &#91;required&#93; The name of the function definition to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_delete_user_defined_function
glue_delete_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName) {
  op <- new_operation(
    name = "DeleteUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$delete_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName)
  output <- .glue$delete_user_defined_function_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$delete_user_defined_function <- glue_delete_user_defined_function

#' Retrieves the status of a migration operation
#'
#' Retrieves the status of a migration operation.
#'
#' @usage
#' glue_get_catalog_import_status(CatalogId)
#'
#' @param CatalogId The ID of the catalog to migrate. Currently, this should be the AWS
#' account ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_catalog_import_status(
#'   CatalogId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_catalog_import_status
glue_get_catalog_import_status <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetCatalogImportStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_catalog_import_status_input(CatalogId = CatalogId)
  output <- .glue$get_catalog_import_status_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_catalog_import_status <- glue_get_catalog_import_status

#' Retrieve a classifier by name
#'
#' Retrieve a classifier by name.
#'
#' @usage
#' glue_get_classifier(Name)
#'
#' @param Name &#91;required&#93; Name of the classifier to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_classifier(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_classifier
glue_get_classifier <- function(Name) {
  op <- new_operation(
    name = "GetClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_classifier_input(Name = Name)
  output <- .glue$get_classifier_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_classifier <- glue_get_classifier

#' Lists all classifier objects in the Data Catalog
#'
#' Lists all classifier objects in the Data Catalog.
#'
#' @usage
#' glue_get_classifiers(MaxResults, NextToken)
#'
#' @param MaxResults Size of the list to return (optional).
#' @param NextToken An optional continuation token.
#'
#' @section Request syntax:
#' ```
#' svc$get_classifiers(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_classifiers
glue_get_classifiers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetClassifiers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_classifiers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_classifiers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_classifiers <- glue_get_classifiers

#' Retrieves a connection definition from the Data Catalog
#'
#' Retrieves a connection definition from the Data Catalog.
#'
#' @usage
#' glue_get_connection(CatalogId, Name, HidePassword)
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the connection definition to retrieve.
#' @param HidePassword Allows you to retrieve the connection metadata without returning the
#' password. For instance, the AWS Glue console uses this flag to retrieve
#' the connection, and does not display the password. Set this parameter
#' when the caller might not have permission to use the AWS KMS key to
#' decrypt the password, but does have permission to access the rest of the
#' connection properties.
#'
#' @section Request syntax:
#' ```
#' svc$get_connection(
#'   CatalogId = "string",
#'   Name = "string",
#'   HidePassword = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_connection
glue_get_connection <- function(CatalogId = NULL, Name, HidePassword = NULL) {
  op <- new_operation(
    name = "GetConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_connection_input(CatalogId = CatalogId, Name = Name, HidePassword = HidePassword)
  output <- .glue$get_connection_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_connection <- glue_get_connection

#' Retrieves a list of connection definitions from the Data Catalog
#'
#' Retrieves a list of connection definitions from the Data Catalog.
#'
#' @usage
#' glue_get_connections(CatalogId, Filter, HidePassword, NextToken,
#'   MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog in which the connections reside. If none is
#' provided, the AWS account ID is used by default.
#' @param Filter A filter that controls which connections will be returned.
#' @param HidePassword Allows you to retrieve the connection metadata without returning the
#' password. For instance, the AWS Glue console uses this flag to retrieve
#' the connection, and does not display the password. Set this parameter
#' when the caller might not have permission to use the AWS KMS key to
#' decrypt the password, but does have permission to access the rest of the
#' connection properties.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of connections to return in one response.
#'
#' @section Request syntax:
#' ```
#' svc$get_connections(
#'   CatalogId = "string",
#'   Filter = list(
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionType = "JDBC"|"SFTP"
#'   ),
#'   HidePassword = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_connections
glue_get_connections <- function(CatalogId = NULL, Filter = NULL, HidePassword = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_connections_input(CatalogId = CatalogId, Filter = Filter, HidePassword = HidePassword, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_connections_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_connections <- glue_get_connections

#' Retrieves metadata for a specified crawler
#'
#' Retrieves metadata for a specified crawler.
#'
#' @usage
#' glue_get_crawler(Name)
#'
#' @param Name &#91;required&#93; Name of the crawler to retrieve metadata for.
#'
#' @section Request syntax:
#' ```
#' svc$get_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_crawler
glue_get_crawler <- function(Name) {
  op <- new_operation(
    name = "GetCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawler_input(Name = Name)
  output <- .glue$get_crawler_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawler <- glue_get_crawler

#' Retrieves metrics about specified crawlers
#'
#' Retrieves metrics about specified crawlers.
#'
#' @usage
#' glue_get_crawler_metrics(CrawlerNameList, MaxResults, NextToken)
#'
#' @param CrawlerNameList A list of the names of crawlers about which to retrieve metrics.
#' @param MaxResults The maximum size of a list to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @section Request syntax:
#' ```
#' svc$get_crawler_metrics(
#'   CrawlerNameList = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_crawler_metrics
glue_get_crawler_metrics <- function(CrawlerNameList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCrawlerMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawler_metrics_input(CrawlerNameList = CrawlerNameList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_crawler_metrics_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawler_metrics <- glue_get_crawler_metrics

#' Retrieves metadata for all crawlers defined in the customer account
#'
#' Retrieves metadata for all crawlers defined in the customer account.
#'
#' @usage
#' glue_get_crawlers(MaxResults, NextToken)
#'
#' @param MaxResults The number of crawlers to return on each call.
#' @param NextToken A continuation token, if this is a continuation request.
#'
#' @section Request syntax:
#' ```
#' svc$get_crawlers(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_crawlers
glue_get_crawlers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_crawlers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_crawlers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_crawlers <- glue_get_crawlers

#' Retrieves the security configuration for a specified catalog
#'
#' Retrieves the security configuration for a specified catalog.
#'
#' @usage
#' glue_get_data_catalog_encryption_settings(CatalogId)
#'
#' @param CatalogId The ID of the Data Catalog for which to retrieve the security
#' configuration. If none is provided, the AWS account ID is used by
#' default.
#'
#' @section Request syntax:
#' ```
#' svc$get_data_catalog_encryption_settings(
#'   CatalogId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_data_catalog_encryption_settings
glue_get_data_catalog_encryption_settings <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "GetDataCatalogEncryptionSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_data_catalog_encryption_settings_input(CatalogId = CatalogId)
  output <- .glue$get_data_catalog_encryption_settings_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_data_catalog_encryption_settings <- glue_get_data_catalog_encryption_settings

#' Retrieves the definition of a specified database
#'
#' Retrieves the definition of a specified database.
#'
#' @usage
#' glue_get_database(CatalogId, Name)
#'
#' @param CatalogId The ID of the Data Catalog in which the database resides. If none is
#' supplied, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to retrieve. For Hive compatibility, this
#' should be all lowercase.
#'
#' @section Request syntax:
#' ```
#' svc$get_database(
#'   CatalogId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_database
glue_get_database <- function(CatalogId = NULL, Name) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_database_input(CatalogId = CatalogId, Name = Name)
  output <- .glue$get_database_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_database <- glue_get_database

#' Retrieves all Databases defined in a given Data Catalog
#'
#' Retrieves all Databases defined in a given Data Catalog.
#'
#' @usage
#' glue_get_databases(CatalogId, NextToken, MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog from which to retrieve `Databases`. If none
#' is supplied, the AWS account ID is used by default.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of databases to return in one response.
#'
#' @section Request syntax:
#' ```
#' svc$get_databases(
#'   CatalogId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_databases
glue_get_databases <- function(CatalogId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_databases_input(CatalogId = CatalogId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_databases_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_databases <- glue_get_databases

#' Transforms a Python script into a directed acyclic graph (DAG)
#'
#' Transforms a Python script into a directed acyclic graph (DAG).
#'
#' @usage
#' glue_get_dataflow_graph(PythonScript)
#'
#' @param PythonScript The Python script to transform.
#'
#' @section Request syntax:
#' ```
#' svc$get_dataflow_graph(
#'   PythonScript = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_dataflow_graph
glue_get_dataflow_graph <- function(PythonScript = NULL) {
  op <- new_operation(
    name = "GetDataflowGraph",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dataflow_graph_input(PythonScript = PythonScript)
  output <- .glue$get_dataflow_graph_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dataflow_graph <- glue_get_dataflow_graph

#' Retrieves information about a specified DevEndpoint
#'
#' Retrieves information about a specified DevEndpoint.
#' 
#' When you create a development endpoint in a virtual private cloud (VPC),
#' AWS Glue returns only a private IP address, and the public IP address
#' field is not populated. When you create a non-VPC development endpoint,
#' AWS Glue returns only a public IP address.
#'
#' @usage
#' glue_get_dev_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; Name of the DevEndpoint for which to retrieve information.
#'
#' @section Request syntax:
#' ```
#' svc$get_dev_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_dev_endpoint
glue_get_dev_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "GetDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dev_endpoint_input(EndpointName = EndpointName)
  output <- .glue$get_dev_endpoint_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dev_endpoint <- glue_get_dev_endpoint

#' Retrieves all the DevEndpoints in this AWS account
#'
#' Retrieves all the DevEndpoints in this AWS account.
#' 
#' When you create a development endpoint in a virtual private cloud (VPC),
#' AWS Glue returns only a private IP address and the public IP address
#' field is not populated. When you create a non-VPC development endpoint,
#' AWS Glue returns only a public IP address.
#'
#' @usage
#' glue_get_dev_endpoints(MaxResults, NextToken)
#'
#' @param MaxResults The maximum size of information to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @section Request syntax:
#' ```
#' svc$get_dev_endpoints(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_dev_endpoints
glue_get_dev_endpoints <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_dev_endpoints_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_dev_endpoints_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_dev_endpoints <- glue_get_dev_endpoints

#' Retrieves an existing job definition
#'
#' Retrieves an existing job definition.
#'
#' @usage
#' glue_get_job(JobName)
#'
#' @param JobName &#91;required&#93; The name of the job definition to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_job(
#'   JobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job
glue_get_job <- function(JobName) {
  op <- new_operation(
    name = "GetJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_input(JobName = JobName)
  output <- .glue$get_job_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job <- glue_get_job

#' Retrieves the metadata for a given job run
#'
#' Retrieves the metadata for a given job run.
#'
#' @usage
#' glue_get_job_run(JobName, RunId, PredecessorsIncluded)
#'
#' @param JobName &#91;required&#93; Name of the job definition being run.
#' @param RunId &#91;required&#93; The ID of the job run.
#' @param PredecessorsIncluded True if a list of predecessor runs should be returned.
#'
#' @section Request syntax:
#' ```
#' svc$get_job_run(
#'   JobName = "string",
#'   RunId = "string",
#'   PredecessorsIncluded = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job_run
glue_get_job_run <- function(JobName, RunId, PredecessorsIncluded = NULL) {
  op <- new_operation(
    name = "GetJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_run_input(JobName = JobName, RunId = RunId, PredecessorsIncluded = PredecessorsIncluded)
  output <- .glue$get_job_run_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_run <- glue_get_job_run

#' Retrieves metadata for all runs of a given job definition
#'
#' Retrieves metadata for all runs of a given job definition.
#'
#' @usage
#' glue_get_job_runs(JobName, NextToken, MaxResults)
#'
#' @param JobName &#91;required&#93; The name of the job definition for which to retrieve all job runs.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_job_runs(
#'   JobName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_job_runs
glue_get_job_runs <- function(JobName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetJobRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_job_runs_input(JobName = JobName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_job_runs_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_job_runs <- glue_get_job_runs

#' Retrieves all current job definitions
#'
#' Retrieves all current job definitions.
#'
#' @usage
#' glue_get_jobs(NextToken, MaxResults)
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum size of the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_jobs(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_jobs
glue_get_jobs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_jobs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_jobs_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_jobs <- glue_get_jobs

#' Creates mappings
#'
#' Creates mappings.
#'
#' @usage
#' glue_get_mapping(Source, Sinks, Location)
#'
#' @param Source &#91;required&#93; Specifies the source table.
#' @param Sinks A list of target tables.
#' @param Location Parameters for the mapping.
#'
#' @section Request syntax:
#' ```
#' svc$get_mapping(
#'   Source = list(
#'     DatabaseName = "string",
#'     TableName = "string"
#'   ),
#'   Sinks = list(
#'     list(
#'       DatabaseName = "string",
#'       TableName = "string"
#'     )
#'   ),
#'   Location = list(
#'     Jdbc = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     S3 = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     DynamoDB = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_mapping
glue_get_mapping <- function(Source, Sinks = NULL, Location = NULL) {
  op <- new_operation(
    name = "GetMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_mapping_input(Source = Source, Sinks = Sinks, Location = Location)
  output <- .glue$get_mapping_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_mapping <- glue_get_mapping

#' Retrieves information about a specified partition
#'
#' Retrieves information about a specified partition.
#'
#' @usage
#' glue_get_partition(CatalogId, DatabaseName, TableName, PartitionValues)
#'
#' @param CatalogId The ID of the Data Catalog where the partition in question resides. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partition resides.
#' @param TableName &#91;required&#93; The name of the partition\'s table.
#' @param PartitionValues &#91;required&#93; The values that define the partition.
#'
#' @section Request syntax:
#' ```
#' svc$get_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_partition
glue_get_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValues) {
  op <- new_operation(
    name = "GetPartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValues = PartitionValues)
  output <- .glue$get_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partition <- glue_get_partition

#' Retrieves information about the partitions in a table
#'
#' Retrieves information about the partitions in a table.
#'
#' @usage
#' glue_get_partitions(CatalogId, DatabaseName, TableName, Expression,
#'   NextToken, Segment, MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the partitions in question reside. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the partitions reside.
#' @param TableName &#91;required&#93; The name of the partitions\' table.
#' @param Expression An expression filtering the partitions to be returned.
#' 
#' The expression uses SQL syntax similar to the SQL `WHERE` filter clause.
#' The SQL statement parser
#' [JSQLParser](http://jsqlparser.sourceforge.net/home.php) parses the
#' expression.
#' 
#' *Operators*: The following are the operators that you can use in the
#' `Expression` API call:
#' 
#' =
#' 
#' :   Checks if the values of the two operands are equal or not; if yes,
#'     then the condition becomes true.
#' 
#'     Example: Assume \'variable a\' holds 10 and \'variable b\' holds 20.
#' 
#'     (a = b) is not true.
#' 
#' \\< \\>
#' 
#' :   Checks if the values of two operands are equal or not; if the values
#'     are not equal, then the condition becomes true.
#' 
#'     Example: (a \\< \\> b) is true.
#' 
#' \\>
#' 
#' :   Checks if the value of the left operand is greater than the value of
#'     the right operand; if yes, then the condition becomes true.
#' 
#'     Example: (a \\> b) is not true.
#' 
#' \\<
#' 
#' :   Checks if the value of the left operand is less than the value of
#'     the right operand; if yes, then the condition becomes true.
#' 
#'     Example: (a \\< b) is true.
#' 
#' \\>=
#' 
#' :   Checks if the value of the left operand is greater than or equal to
#'     the value of the right operand; if yes, then the condition becomes
#'     true.
#' 
#'     Example: (a \\>= b) is not true.
#' 
#' \\<=
#' 
#' :   Checks if the value of the left operand is less than or equal to the
#'     value of the right operand; if yes, then the condition becomes true.
#' 
#'     Example: (a \\<= b) is true.
#' 
#' AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL
#' 
#' :   Logical operators.
#' 
#' *Supported Partition Key Types*: The following are the the supported
#' partition keys.
#' 
#' -   `string`
#' 
#' -   `date`
#' 
#' -   `timestamp`
#' 
#' -   `int`
#' 
#' -   `bigint`
#' 
#' -   `long`
#' 
#' -   `tinyint`
#' 
#' -   `smallint`
#' 
#' -   `decimal`
#' 
#' If an invalid type is encountered, an exception is thrown.
#' 
#' The following list shows the valid operators on each type. When you
#' define a crawler, the `partitionKey` type is created as a `STRING`, to
#' be compatible with the catalog partitions.
#' 
#' *Sample API Call*:
#' @param NextToken A continuation token, if this is not the first call to retrieve these
#' partitions.
#' @param Segment The segment of the table\'s partitions to scan in this request.
#' @param MaxResults The maximum number of partitions to return in a single response.
#'
#' @section Request syntax:
#' ```
#' svc$get_partitions(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   Expression = "string",
#'   NextToken = "string",
#'   Segment = list(
#'     SegmentNumber = 123,
#'     TotalSegments = 123
#'   ),
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_partitions
glue_get_partitions <- function(CatalogId = NULL, DatabaseName, TableName, Expression = NULL, NextToken = NULL, Segment = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetPartitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_partitions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, Expression = Expression, NextToken = NextToken, Segment = Segment, MaxResults = MaxResults)
  output <- .glue$get_partitions_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_partitions <- glue_get_partitions

#' Gets code to perform a specified mapping
#'
#' Gets code to perform a specified mapping.
#'
#' @usage
#' glue_get_plan(Mapping, Source, Sinks, Location, Language)
#'
#' @param Mapping &#91;required&#93; The list of mappings from a source table to target tables.
#' @param Source &#91;required&#93; The source table.
#' @param Sinks The target tables.
#' @param Location Parameters for the mapping.
#' @param Language The programming language of the code to perform the mapping.
#'
#' @section Request syntax:
#' ```
#' svc$get_plan(
#'   Mapping = list(
#'     list(
#'       SourceTable = "string",
#'       SourcePath = "string",
#'       SourceType = "string",
#'       TargetTable = "string",
#'       TargetPath = "string",
#'       TargetType = "string"
#'     )
#'   ),
#'   Source = list(
#'     DatabaseName = "string",
#'     TableName = "string"
#'   ),
#'   Sinks = list(
#'     list(
#'       DatabaseName = "string",
#'       TableName = "string"
#'     )
#'   ),
#'   Location = list(
#'     Jdbc = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     S3 = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     ),
#'     DynamoDB = list(
#'       list(
#'         Name = "string",
#'         Value = "string",
#'         Param = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   Language = "PYTHON"|"SCALA"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_plan
glue_get_plan <- function(Mapping, Source, Sinks = NULL, Location = NULL, Language = NULL) {
  op <- new_operation(
    name = "GetPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_plan_input(Mapping = Mapping, Source = Source, Sinks = Sinks, Location = Location, Language = Language)
  output <- .glue$get_plan_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_plan <- glue_get_plan

#' Retrieves a specified resource policy
#'
#' Retrieves a specified resource policy.
#'
#' @usage
#' glue_get_resource_policy()
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_policy()
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_resource_policy
glue_get_resource_policy <- function() {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_resource_policy_input()
  output <- .glue$get_resource_policy_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_resource_policy <- glue_get_resource_policy

#' Retrieves a specified security configuration
#'
#' Retrieves a specified security configuration.
#'
#' @usage
#' glue_get_security_configuration(Name)
#'
#' @param Name &#91;required&#93; The name of the security configuration to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_security_configuration(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_security_configuration
glue_get_security_configuration <- function(Name) {
  op <- new_operation(
    name = "GetSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_security_configuration_input(Name = Name)
  output <- .glue$get_security_configuration_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_security_configuration <- glue_get_security_configuration

#' Retrieves a list of all security configurations
#'
#' Retrieves a list of all security configurations.
#'
#' @usage
#' glue_get_security_configurations(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of results to return.
#' @param NextToken A continuation token, if this is a continuation call.
#'
#' @section Request syntax:
#' ```
#' svc$get_security_configurations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_security_configurations
glue_get_security_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetSecurityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_security_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .glue$get_security_configurations_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_security_configurations <- glue_get_security_configurations

#' Retrieves the Table definition in a Data Catalog for a specified table
#'
#' Retrieves the `Table` definition in a Data Catalog for a specified
#' table.
#'
#' @usage
#' glue_get_table(CatalogId, DatabaseName, Name)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the database in the catalog in which the table resides. For
#' Hive compatibility, this name is entirely lowercase.
#' @param Name &#91;required&#93; The name of the table for which to retrieve the definition. For Hive
#' compatibility, this name is entirely lowercase.
#'
#' @section Request syntax:
#' ```
#' svc$get_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_table
glue_get_table <- function(CatalogId = NULL, DatabaseName, Name) {
  op <- new_operation(
    name = "GetTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Name = Name)
  output <- .glue$get_table_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table <- glue_get_table

#' Retrieves a specified version of a table
#'
#' Retrieves a specified version of a table.
#'
#' @usage
#' glue_get_table_version(CatalogId, DatabaseName, TableName, VersionId)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param VersionId The ID value of the table version to be retrieved. A `VersionID` is a
#' string representation of an integer. Each version is incremented by 1.
#'
#' @section Request syntax:
#' ```
#' svc$get_table_version(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_table_version
glue_get_table_version <- function(CatalogId = NULL, DatabaseName, TableName, VersionId = NULL) {
  op <- new_operation(
    name = "GetTableVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_version_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, VersionId = VersionId)
  output <- .glue$get_table_version_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_version <- glue_get_table_version

#' Retrieves a list of strings that identify available versions of a
#' specified table
#'
#' Retrieves a list of strings that identify available versions of a
#' specified table.
#'
#' @usage
#' glue_get_table_versions(CatalogId, DatabaseName, TableName, NextToken,
#'   MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableName &#91;required&#93; The name of the table. For Hive compatibility, this name is entirely
#' lowercase.
#' @param NextToken A continuation token, if this is not the first call.
#' @param MaxResults The maximum number of table versions to return in one response.
#'
#' @section Request syntax:
#' ```
#' svc$get_table_versions(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_table_versions
glue_get_table_versions <- function(CatalogId = NULL, DatabaseName, TableName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTableVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_table_versions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_table_versions_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_table_versions <- glue_get_table_versions

#' Retrieves the definitions of some or all of the tables in a given
#' Database
#'
#' Retrieves the definitions of some or all of the tables in a given
#' `Database`.
#'
#' @usage
#' glue_get_tables(CatalogId, DatabaseName, Expression, NextToken,
#'   MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the tables reside. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The database in the catalog whose tables to list. For Hive
#' compatibility, this name is entirely lowercase.
#' @param Expression A regular expression pattern. If present, only those tables whose names
#' match the pattern are returned.
#' @param NextToken A continuation token, included if this is a continuation call.
#' @param MaxResults The maximum number of tables to return in a single response.
#'
#' @section Request syntax:
#' ```
#' svc$get_tables(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Expression = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_tables
glue_get_tables <- function(CatalogId = NULL, DatabaseName, Expression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_tables_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Expression = Expression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_tables_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_tables <- glue_get_tables

#' Retrieves a list of tags associated with a resource
#'
#' Retrieves a list of tags associated with a resource.
#'
#' @usage
#' glue_get_tags(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon ARN of the resource for which to retrieve tags.
#'
#' @section Request syntax:
#' ```
#' svc$get_tags(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_tags
glue_get_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_tags_input(ResourceArn = ResourceArn)
  output <- .glue$get_tags_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_tags <- glue_get_tags

#' Retrieves the definition of a trigger
#'
#' Retrieves the definition of a trigger.
#'
#' @usage
#' glue_get_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_trigger
glue_get_trigger <- function(Name) {
  op <- new_operation(
    name = "GetTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_trigger_input(Name = Name)
  output <- .glue$get_trigger_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_trigger <- glue_get_trigger

#' Gets all the triggers associated with a job
#'
#' Gets all the triggers associated with a job.
#'
#' @usage
#' glue_get_triggers(NextToken, DependentJobName, MaxResults)
#'
#' @param NextToken A continuation token, if this is a continuation call.
#' @param DependentJobName The name of the job for which to retrieve triggers. The trigger that can
#' start this job will be returned, and if there is no such trigger, all
#' triggers will be returned.
#' @param MaxResults The maximum size of the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_triggers(
#'   NextToken = "string",
#'   DependentJobName = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_triggers
glue_get_triggers <- function(NextToken = NULL, DependentJobName = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_triggers_input(NextToken = NextToken, DependentJobName = DependentJobName, MaxResults = MaxResults)
  output <- .glue$get_triggers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_triggers <- glue_get_triggers

#' Retrieves a specified function definition from the Data Catalog
#'
#' Retrieves a specified function definition from the Data Catalog.
#'
#' @usage
#' glue_get_user_defined_function(CatalogId, DatabaseName, FunctionName)
#'
#' @param CatalogId The ID of the Data Catalog where the function to be retrieved is
#' located. If none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function is located.
#' @param FunctionName &#91;required&#93; The name of the function.
#'
#' @section Request syntax:
#' ```
#' svc$get_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_user_defined_function
glue_get_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName) {
  op <- new_operation(
    name = "GetUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName)
  output <- .glue$get_user_defined_function_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_user_defined_function <- glue_get_user_defined_function

#' Retrieves a multiple function definitions from the Data Catalog
#'
#' Retrieves a multiple function definitions from the Data Catalog.
#'
#' @usage
#' glue_get_user_defined_functions(CatalogId, DatabaseName, Pattern,
#'   NextToken, MaxResults)
#'
#' @param CatalogId The ID of the Data Catalog where the functions to be retrieved are
#' located. If none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the functions are located.
#' @param Pattern &#91;required&#93; An optional function-name pattern string that filters the function
#' definitions returned.
#' @param NextToken A continuation token, if this is a continuation call.
#' @param MaxResults The maximum number of functions to return in one response.
#'
#' @section Request syntax:
#' ```
#' svc$get_user_defined_functions(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   Pattern = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_get_user_defined_functions
glue_get_user_defined_functions <- function(CatalogId = NULL, DatabaseName, Pattern, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetUserDefinedFunctions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$get_user_defined_functions_input(CatalogId = CatalogId, DatabaseName = DatabaseName, Pattern = Pattern, NextToken = NextToken, MaxResults = MaxResults)
  output <- .glue$get_user_defined_functions_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$get_user_defined_functions <- glue_get_user_defined_functions

#' Imports an existing Athena Data Catalog to AWS Glue
#'
#' Imports an existing Athena Data Catalog to AWS Glue
#'
#' @usage
#' glue_import_catalog_to_glue(CatalogId)
#'
#' @param CatalogId The ID of the catalog to import. Currently, this should be the AWS
#' account ID.
#'
#' @section Request syntax:
#' ```
#' svc$import_catalog_to_glue(
#'   CatalogId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_import_catalog_to_glue
glue_import_catalog_to_glue <- function(CatalogId = NULL) {
  op <- new_operation(
    name = "ImportCatalogToGlue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$import_catalog_to_glue_input(CatalogId = CatalogId)
  output <- .glue$import_catalog_to_glue_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$import_catalog_to_glue <- glue_import_catalog_to_glue

#' Retrieves the names of all crawler resources in this AWS account, or the
#' resources with the specified tag
#'
#' Retrieves the names of all crawler resources in this AWS account, or the
#' resources with the specified tag. This operation allows you to see which
#' resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' will be retrieved.
#'
#' @usage
#' glue_list_crawlers(MaxResults, NextToken, Tags)
#'
#' @param MaxResults The maximum size of a list to return.
#' @param NextToken A continuation token, if this is a continuation request.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @section Request syntax:
#' ```
#' svc$list_crawlers(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_crawlers
glue_list_crawlers <- function(MaxResults = NULL, NextToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListCrawlers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_crawlers_input(MaxResults = MaxResults, NextToken = NextToken, Tags = Tags)
  output <- .glue$list_crawlers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_crawlers <- glue_list_crawlers

#' Retrieves the names of all DevEndpoint resources in this AWS account, or
#' the resources with the specified tag
#'
#' Retrieves the names of all DevEndpoint resources in this AWS account, or
#' the resources with the specified tag. This operation allows you to see
#' which resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' will be retrieved.
#'
#' @usage
#' glue_list_dev_endpoints(NextToken, MaxResults, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @section Request syntax:
#' ```
#' svc$list_dev_endpoints(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_dev_endpoints
glue_list_dev_endpoints <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListDevEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_dev_endpoints_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_dev_endpoints_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_dev_endpoints <- glue_list_dev_endpoints

#' Retrieves the names of all job resources in this AWS account, or the
#' resources with the specified tag
#'
#' Retrieves the names of all job resources in this AWS account, or the
#' resources with the specified tag. This operation allows you to see which
#' resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' will be retrieved.
#'
#' @usage
#' glue_list_jobs(NextToken, MaxResults, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @section Request syntax:
#' ```
#' svc$list_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_jobs
glue_list_jobs <- function(NextToken = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_jobs_input(NextToken = NextToken, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_jobs_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_jobs <- glue_list_jobs

#' Retrieves the names of all trigger resources in this AWS account, or the
#' resources with the specified tag
#'
#' Retrieves the names of all trigger resources in this AWS account, or the
#' resources with the specified tag. This operation allows you to see which
#' resources are available in your account, and their names.
#' 
#' This operation takes the optional `Tags` field which you can use as a
#' filter on the response so that tagged resources can be retrieved as a
#' group. If you choose to use tags filtering, only resources with the tag
#' will be retrieved.
#'
#' @usage
#' glue_list_triggers(NextToken, DependentJobName, MaxResults, Tags)
#'
#' @param NextToken A continuation token, if this is a continuation request.
#' @param DependentJobName The name of the job for which to retrieve triggers. The trigger that can
#' start this job will be returned, and if there is no such trigger, all
#' triggers will be returned.
#' @param MaxResults The maximum size of a list to return.
#' @param Tags Specifies to return only these tagged resources.
#'
#' @section Request syntax:
#' ```
#' svc$list_triggers(
#'   NextToken = "string",
#'   DependentJobName = "string",
#'   MaxResults = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_list_triggers
glue_list_triggers <- function(NextToken = NULL, DependentJobName = NULL, MaxResults = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ListTriggers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$list_triggers_input(NextToken = NextToken, DependentJobName = DependentJobName, MaxResults = MaxResults, Tags = Tags)
  output <- .glue$list_triggers_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$list_triggers <- glue_list_triggers

#' Sets the security configuration for a specified catalog
#'
#' Sets the security configuration for a specified catalog. After the
#' configuration has been set, the specified encryption is applied to every
#' catalog write thereafter.
#'
#' @usage
#' glue_put_data_catalog_encryption_settings(CatalogId,
#'   DataCatalogEncryptionSettings)
#'
#' @param CatalogId The ID of the Data Catalog for which to set the security configuration.
#' If none is provided, the AWS account ID is used by default.
#' @param DataCatalogEncryptionSettings &#91;required&#93; The security configuration to set.
#'
#' @section Request syntax:
#' ```
#' svc$put_data_catalog_encryption_settings(
#'   CatalogId = "string",
#'   DataCatalogEncryptionSettings = list(
#'     EncryptionAtRest = list(
#'       CatalogEncryptionMode = "DISABLED"|"SSE-KMS",
#'       SseAwsKmsKeyId = "string"
#'     ),
#'     ConnectionPasswordEncryption = list(
#'       ReturnConnectionPasswordEncrypted = TRUE|FALSE,
#'       AwsKmsKeyId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_put_data_catalog_encryption_settings
glue_put_data_catalog_encryption_settings <- function(CatalogId = NULL, DataCatalogEncryptionSettings) {
  op <- new_operation(
    name = "PutDataCatalogEncryptionSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_data_catalog_encryption_settings_input(CatalogId = CatalogId, DataCatalogEncryptionSettings = DataCatalogEncryptionSettings)
  output <- .glue$put_data_catalog_encryption_settings_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_data_catalog_encryption_settings <- glue_put_data_catalog_encryption_settings

#' Sets the Data Catalog resource policy for access control
#'
#' Sets the Data Catalog resource policy for access control.
#'
#' @usage
#' glue_put_resource_policy(PolicyInJson, PolicyHashCondition,
#'   PolicyExistsCondition)
#'
#' @param PolicyInJson &#91;required&#93; Contains the policy document to set, in JSON format.
#' @param PolicyHashCondition The hash value returned when the previous policy was set using
#' `PutResourcePolicy`. Its purpose is to prevent concurrent modifications
#' of a policy. Do not use this parameter if no previous policy has been
#' set.
#' @param PolicyExistsCondition A value of `MUST_EXIST` is used to update a policy. A value of
#' `NOT_EXIST` is used to create a new policy. If a value of `NONE` or a
#' null value is used, the call will not depend on the existence of a
#' policy.
#'
#' @section Request syntax:
#' ```
#' svc$put_resource_policy(
#'   PolicyInJson = "string",
#'   PolicyHashCondition = "string",
#'   PolicyExistsCondition = "MUST_EXIST"|"NOT_EXIST"|"NONE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_put_resource_policy
glue_put_resource_policy <- function(PolicyInJson, PolicyHashCondition = NULL, PolicyExistsCondition = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$put_resource_policy_input(PolicyInJson = PolicyInJson, PolicyHashCondition = PolicyHashCondition, PolicyExistsCondition = PolicyExistsCondition)
  output <- .glue$put_resource_policy_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$put_resource_policy <- glue_put_resource_policy

#' Resets a bookmark entry
#'
#' Resets a bookmark entry.
#'
#' @usage
#' glue_reset_job_bookmark(JobName)
#'
#' @param JobName &#91;required&#93; The name of the job in question.
#'
#' @section Request syntax:
#' ```
#' svc$reset_job_bookmark(
#'   JobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_reset_job_bookmark
glue_reset_job_bookmark <- function(JobName) {
  op <- new_operation(
    name = "ResetJobBookmark",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$reset_job_bookmark_input(JobName = JobName)
  output <- .glue$reset_job_bookmark_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$reset_job_bookmark <- glue_reset_job_bookmark

#' Starts a crawl using the specified crawler, regardless of what is
#' scheduled
#'
#' Starts a crawl using the specified crawler, regardless of what is
#' scheduled. If the crawler is already running, returns a
#' [CrawlerRunningException](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-exceptions.html#aws-glue-api-exceptions-CrawlerRunningException).
#'
#' @usage
#' glue_start_crawler(Name)
#'
#' @param Name &#91;required&#93; Name of the crawler to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_crawler
glue_start_crawler <- function(Name) {
  op <- new_operation(
    name = "StartCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_crawler_input(Name = Name)
  output <- .glue$start_crawler_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_crawler <- glue_start_crawler

#' Changes the schedule state of the specified crawler to SCHEDULED, unless
#' the crawler is already running or the schedule state is already
#' SCHEDULED
#'
#' Changes the schedule state of the specified crawler to `SCHEDULED`,
#' unless the crawler is already running or the schedule state is already
#' `SCHEDULED`.
#'
#' @usage
#' glue_start_crawler_schedule(CrawlerName)
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler to schedule.
#'
#' @section Request syntax:
#' ```
#' svc$start_crawler_schedule(
#'   CrawlerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_crawler_schedule
glue_start_crawler_schedule <- function(CrawlerName) {
  op <- new_operation(
    name = "StartCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_crawler_schedule_input(CrawlerName = CrawlerName)
  output <- .glue$start_crawler_schedule_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_crawler_schedule <- glue_start_crawler_schedule

#' Starts a job run using a job definition
#'
#' Starts a job run using a job definition.
#'
#' @usage
#' glue_start_job_run(JobName, JobRunId, Arguments, AllocatedCapacity,
#'   Timeout, MaxCapacity, NotificationProperty, SecurityConfiguration)
#'
#' @param JobName &#91;required&#93; The name of the job definition to use.
#' @param JobRunId The ID of a previous JobRun to retry.
#' @param Arguments The job arguments specifically for this run. For this job run, they
#' replace the default arguments set in the job definition itself.
#' 
#' You can specify arguments here that your own job-execution script
#' consumes, as well as arguments that AWS Glue itself consumes.
#' 
#' For information about how to specify and consume your own Job arguments,
#' see the [Calling AWS Glue APIs in
#' Python](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
#' topic in the developer guide.
#' 
#' For information about the key-value pairs that AWS Glue consumes to set
#' up your job, see the [Special Parameters Used by AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
#' topic in the developer guide.
#' @param AllocatedCapacity This field is deprecated, use `MaxCapacity` instead.
#' 
#' The number of AWS Glue data processing units (DPUs) to allocate to this
#' JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is
#' a relative measure of processing power that consists of 4 vCPUs of
#' compute capacity and 16 GB of memory. For more information, see the [AWS
#' Glue pricing page](https://aws.amazon.com/glue/pricing/).
#' @param Timeout The JobRun timeout in minutes. This is the maximum time that a job run
#' can consume resources before it is terminated and enters `TIMEOUT`
#' status. The default is 2,880 minutes (48 hours). This overrides the
#' timeout value set in the parent job.
#' @param MaxCapacity The number of AWS Glue data processing units (DPUs) that can be
#' allocated when this job runs. A DPU is a relative measure of processing
#' power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
#' For more information, see the [AWS Glue pricing
#' page](https://aws.amazon.com/glue/pricing/).
#' 
#' The value that can be allocated for `MaxCapacity` depends on whether you
#' are running a python shell job, or an Apache Spark ETL job:
#' 
#' -   When you specify a python shell job
#'     (`JobCommand.Name`=\"pythonshell\"), you can allocate either 0.0625
#'     or 1 DPU. The default is 0.0625 DPU.
#' 
#' -   When you specify an Apache Spark ETL job
#'     (`JobCommand.Name`=\"glueetl\"), you can allocate from 2 to 100
#'     DPUs. The default is 10 DPUs. This job type cannot have a fractional
#'     DPU allocation.
#' @param NotificationProperty Specifies configuration properties of a job run notification.
#' @param SecurityConfiguration The name of the SecurityConfiguration structure to be used with this job
#' run.
#'
#' @section Request syntax:
#' ```
#' svc$start_job_run(
#'   JobName = "string",
#'   JobRunId = "string",
#'   Arguments = list(
#'     "string"
#'   ),
#'   AllocatedCapacity = 123,
#'   Timeout = 123,
#'   MaxCapacity = 123.0,
#'   NotificationProperty = list(
#'     NotifyDelayAfter = 123
#'   ),
#'   SecurityConfiguration = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_job_run
glue_start_job_run <- function(JobName, JobRunId = NULL, Arguments = NULL, AllocatedCapacity = NULL, Timeout = NULL, MaxCapacity = NULL, NotificationProperty = NULL, SecurityConfiguration = NULL) {
  op <- new_operation(
    name = "StartJobRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_job_run_input(JobName = JobName, JobRunId = JobRunId, Arguments = Arguments, AllocatedCapacity = AllocatedCapacity, Timeout = Timeout, MaxCapacity = MaxCapacity, NotificationProperty = NotificationProperty, SecurityConfiguration = SecurityConfiguration)
  output <- .glue$start_job_run_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_job_run <- glue_start_job_run

#' Starts an existing trigger
#'
#' Starts an existing trigger. See [Triggering
#' Jobs](http://docs.aws.amazon.com/glue/latest/dg/trigger-job.html) for
#' information about how different types of trigger are started.
#'
#' @usage
#' glue_start_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_start_trigger
glue_start_trigger <- function(Name) {
  op <- new_operation(
    name = "StartTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$start_trigger_input(Name = Name)
  output <- .glue$start_trigger_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$start_trigger <- glue_start_trigger

#' If the specified crawler is running, stops the crawl
#'
#' If the specified crawler is running, stops the crawl.
#'
#' @usage
#' glue_stop_crawler(Name)
#'
#' @param Name &#91;required&#93; Name of the crawler to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_crawler(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_crawler
glue_stop_crawler <- function(Name) {
  op <- new_operation(
    name = "StopCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_crawler_input(Name = Name)
  output <- .glue$stop_crawler_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_crawler <- glue_stop_crawler

#' Sets the schedule state of the specified crawler to NOT_SCHEDULED, but
#' does not stop the crawler if it is already running
#'
#' Sets the schedule state of the specified crawler to `NOT_SCHEDULED`, but
#' does not stop the crawler if it is already running.
#'
#' @usage
#' glue_stop_crawler_schedule(CrawlerName)
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler whose schedule state to set.
#'
#' @section Request syntax:
#' ```
#' svc$stop_crawler_schedule(
#'   CrawlerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_crawler_schedule
glue_stop_crawler_schedule <- function(CrawlerName) {
  op <- new_operation(
    name = "StopCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_crawler_schedule_input(CrawlerName = CrawlerName)
  output <- .glue$stop_crawler_schedule_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_crawler_schedule <- glue_stop_crawler_schedule

#' Stops a specified trigger
#'
#' Stops a specified trigger.
#'
#' @usage
#' glue_stop_trigger(Name)
#'
#' @param Name &#91;required&#93; The name of the trigger to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_trigger(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_stop_trigger
glue_stop_trigger <- function(Name) {
  op <- new_operation(
    name = "StopTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$stop_trigger_input(Name = Name)
  output <- .glue$stop_trigger_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$stop_trigger <- glue_stop_trigger

#' Adds tags to a resource
#'
#' Adds tags to a resource. A tag is a label you can assign to an AWS
#' resource. In AWS Glue, you can tag only certain resources. For
#' information about what resources you can tag, see [AWS Tags in AWS
#' Glue](http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html).
#'
#' @usage
#' glue_tag_resource(ResourceArn, TagsToAdd)
#'
#' @param ResourceArn &#91;required&#93; The ARN of the AWS Glue resource to which to add the tags. For more
#' information about AWS Glue resource ARNs, see the [AWS Glue ARN string
#' pattern](http://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id).
#' @param TagsToAdd &#91;required&#93; Tags to add to this resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   TagsToAdd = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_tag_resource
glue_tag_resource <- function(ResourceArn, TagsToAdd) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$tag_resource_input(ResourceArn = ResourceArn, TagsToAdd = TagsToAdd)
  output <- .glue$tag_resource_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$tag_resource <- glue_tag_resource

#' Removes tags from a resource
#'
#' Removes tags from a resource.
#'
#' @usage
#' glue_untag_resource(ResourceArn, TagsToRemove)
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource from which to remove the tags.
#' @param TagsToRemove &#91;required&#93; Tags to remove from this resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagsToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_untag_resource
glue_untag_resource <- function(ResourceArn, TagsToRemove) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$untag_resource_input(ResourceArn = ResourceArn, TagsToRemove = TagsToRemove)
  output <- .glue$untag_resource_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$untag_resource <- glue_untag_resource

#' Modifies an existing classifier (a GrokClassifier, an XMLClassifier, a
#' JsonClassifier, or a CsvClassifier, depending on which field is present)
#'
#' Modifies an existing classifier (a `GrokClassifier`, an `XMLClassifier`,
#' a `JsonClassifier`, or a `CsvClassifier`, depending on which field is
#' present).
#'
#' @usage
#' glue_update_classifier(GrokClassifier, XMLClassifier, JsonClassifier,
#'   CsvClassifier)
#'
#' @param GrokClassifier A `GrokClassifier` object with updated fields.
#' @param XMLClassifier An `XMLClassifier` object with updated fields.
#' @param JsonClassifier A `JsonClassifier` object with updated fields.
#' @param CsvClassifier A `CsvClassifier` object with updated fields.
#'
#' @section Request syntax:
#' ```
#' svc$update_classifier(
#'   GrokClassifier = list(
#'     Name = "string",
#'     Classification = "string",
#'     GrokPattern = "string",
#'     CustomPatterns = "string"
#'   ),
#'   XMLClassifier = list(
#'     Name = "string",
#'     Classification = "string",
#'     RowTag = "string"
#'   ),
#'   JsonClassifier = list(
#'     Name = "string",
#'     JsonPath = "string"
#'   ),
#'   CsvClassifier = list(
#'     Name = "string",
#'     Delimiter = "string",
#'     QuoteSymbol = "string",
#'     ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
#'     Header = list(
#'       "string"
#'     ),
#'     DisableValueTrimming = TRUE|FALSE,
#'     AllowSingleColumn = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_classifier
glue_update_classifier <- function(GrokClassifier = NULL, XMLClassifier = NULL, JsonClassifier = NULL, CsvClassifier = NULL) {
  op <- new_operation(
    name = "UpdateClassifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_classifier_input(GrokClassifier = GrokClassifier, XMLClassifier = XMLClassifier, JsonClassifier = JsonClassifier, CsvClassifier = CsvClassifier)
  output <- .glue$update_classifier_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_classifier <- glue_update_classifier

#' Updates a connection definition in the Data Catalog
#'
#' Updates a connection definition in the Data Catalog.
#'
#' @usage
#' glue_update_connection(CatalogId, Name, ConnectionInput)
#'
#' @param CatalogId The ID of the Data Catalog in which the connection resides. If none is
#' provided, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the connection definition to update.
#' @param ConnectionInput &#91;required&#93; A `ConnectionInput` object that redefines the connection in question.
#'
#' @section Request syntax:
#' ```
#' svc$update_connection(
#'   CatalogId = "string",
#'   Name = "string",
#'   ConnectionInput = list(
#'     Name = "string",
#'     Description = "string",
#'     ConnectionType = "JDBC"|"SFTP",
#'     MatchCriteria = list(
#'       "string"
#'     ),
#'     ConnectionProperties = list(
#'       "string"
#'     ),
#'     PhysicalConnectionRequirements = list(
#'       SubnetId = "string",
#'       SecurityGroupIdList = list(
#'         "string"
#'       ),
#'       AvailabilityZone = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_connection
glue_update_connection <- function(CatalogId = NULL, Name, ConnectionInput) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_connection_input(CatalogId = CatalogId, Name = Name, ConnectionInput = ConnectionInput)
  output <- .glue$update_connection_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_connection <- glue_update_connection

#' Updates a crawler
#'
#' Updates a crawler. If a crawler is running, you must stop it using
#' `StopCrawler` before updating it.
#'
#' @usage
#' glue_update_crawler(Name, Role, DatabaseName, Description, Targets,
#'   Schedule, Classifiers, TablePrefix, SchemaChangePolicy, Configuration,
#'   CrawlerSecurityConfiguration)
#'
#' @param Name &#91;required&#93; Name of the new crawler.
#' @param Role The IAM role (or ARN of an IAM role) used by the new crawler to access
#' customer resources.
#' @param DatabaseName The AWS Glue database where results are stored, such as:
#' `arn:aws:daylight:us-east-1::database/sometable/*`.
#' @param Description A description of the new crawler.
#' @param Targets A list of targets to crawl.
#' @param Schedule A `cron` expression used to specify the schedule (see [Time-Based
#' Schedules for Jobs and
#' Crawlers](http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#' @param Classifiers A list of custom classifiers that the user has registered. By default,
#' all built-in classifiers are included in a crawl, but these custom
#' classifiers always override the default classifiers for a given
#' classification.
#' @param TablePrefix The table prefix used for catalog tables that are created.
#' @param SchemaChangePolicy Policy for the crawler\'s update and deletion behavior.
#' @param Configuration Crawler configuration information. This versioned JSON string allows
#' users to specify aspects of a crawler\'s behavior. For more information,
#' see [Configuring a
#' Crawler](http://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
#' @param CrawlerSecurityConfiguration The name of the SecurityConfiguration structure to be used by this
#' Crawler.
#'
#' @section Request syntax:
#' ```
#' svc$update_crawler(
#'   Name = "string",
#'   Role = "string",
#'   DatabaseName = "string",
#'   Description = "string",
#'   Targets = list(
#'     S3Targets = list(
#'       list(
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     JdbcTargets = list(
#'       list(
#'         ConnectionName = "string",
#'         Path = "string",
#'         Exclusions = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     DynamoDBTargets = list(
#'       list(
#'         Path = "string"
#'       )
#'     )
#'   ),
#'   Schedule = "string",
#'   Classifiers = list(
#'     "string"
#'   ),
#'   TablePrefix = "string",
#'   SchemaChangePolicy = list(
#'     UpdateBehavior = "LOG"|"UPDATE_IN_DATABASE",
#'     DeleteBehavior = "LOG"|"DELETE_FROM_DATABASE"|"DEPRECATE_IN_DATABASE"
#'   ),
#'   Configuration = "string",
#'   CrawlerSecurityConfiguration = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_crawler
glue_update_crawler <- function(Name, Role = NULL, DatabaseName = NULL, Description = NULL, Targets = NULL, Schedule = NULL, Classifiers = NULL, TablePrefix = NULL, SchemaChangePolicy = NULL, Configuration = NULL, CrawlerSecurityConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateCrawler",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_crawler_input(Name = Name, Role = Role, DatabaseName = DatabaseName, Description = Description, Targets = Targets, Schedule = Schedule, Classifiers = Classifiers, TablePrefix = TablePrefix, SchemaChangePolicy = SchemaChangePolicy, Configuration = Configuration, CrawlerSecurityConfiguration = CrawlerSecurityConfiguration)
  output <- .glue$update_crawler_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_crawler <- glue_update_crawler

#' Updates the schedule of a crawler using a cron expression
#'
#' Updates the schedule of a crawler using a `cron` expression.
#'
#' @usage
#' glue_update_crawler_schedule(CrawlerName, Schedule)
#'
#' @param CrawlerName &#91;required&#93; Name of the crawler whose schedule to update.
#' @param Schedule The updated `cron` expression used to specify the schedule (see
#' [Time-Based Schedules for Jobs and
#' Crawlers](http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
#' For example, to run something every day at 12:15 UTC, you would specify:
#' `cron(15 12 * * ? *)`.
#'
#' @section Request syntax:
#' ```
#' svc$update_crawler_schedule(
#'   CrawlerName = "string",
#'   Schedule = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_crawler_schedule
glue_update_crawler_schedule <- function(CrawlerName, Schedule = NULL) {
  op <- new_operation(
    name = "UpdateCrawlerSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_crawler_schedule_input(CrawlerName = CrawlerName, Schedule = Schedule)
  output <- .glue$update_crawler_schedule_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_crawler_schedule <- glue_update_crawler_schedule

#' Updates an existing database definition in a Data Catalog
#'
#' Updates an existing database definition in a Data Catalog.
#'
#' @usage
#' glue_update_database(CatalogId, Name, DatabaseInput)
#'
#' @param CatalogId The ID of the Data Catalog in which the metadata database resides. If
#' none is supplied, the AWS account ID is used by default.
#' @param Name &#91;required&#93; The name of the database to update in the catalog. For Hive
#' compatibility, this is folded to lowercase.
#' @param DatabaseInput &#91;required&#93; A `DatabaseInput` object specifying the new definition of the metadata
#' database in the catalog.
#'
#' @section Request syntax:
#' ```
#' svc$update_database(
#'   CatalogId = "string",
#'   Name = "string",
#'   DatabaseInput = list(
#'     Name = "string",
#'     Description = "string",
#'     LocationUri = "string",
#'     Parameters = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_database
glue_update_database <- function(CatalogId = NULL, Name, DatabaseInput) {
  op <- new_operation(
    name = "UpdateDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_database_input(CatalogId = CatalogId, Name = Name, DatabaseInput = DatabaseInput)
  output <- .glue$update_database_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_database <- glue_update_database

#' Updates a specified DevEndpoint
#'
#' Updates a specified DevEndpoint.
#'
#' @usage
#' glue_update_dev_endpoint(EndpointName, PublicKey, AddPublicKeys,
#'   DeletePublicKeys, CustomLibraries, UpdateEtlLibraries, DeleteArguments,
#'   AddArguments)
#'
#' @param EndpointName &#91;required&#93; The name of the DevEndpoint to be updated.
#' @param PublicKey The public key for the DevEndpoint to use.
#' @param AddPublicKeys The list of public keys for the DevEndpoint to use.
#' @param DeletePublicKeys The list of public keys to be deleted from the DevEndpoint.
#' @param CustomLibraries Custom Python or Java libraries to be loaded in the DevEndpoint.
#' @param UpdateEtlLibraries True if the list of custom libraries to be loaded in the development
#' endpoint needs to be updated, or False otherwise.
#' @param DeleteArguments The list of argument keys to be deleted from the map of arguments used
#' to configure the DevEndpoint.
#' @param AddArguments The map of arguments to add the map of arguments used to configure the
#' DevEndpoint.
#'
#' @section Request syntax:
#' ```
#' svc$update_dev_endpoint(
#'   EndpointName = "string",
#'   PublicKey = "string",
#'   AddPublicKeys = list(
#'     "string"
#'   ),
#'   DeletePublicKeys = list(
#'     "string"
#'   ),
#'   CustomLibraries = list(
#'     ExtraPythonLibsS3Path = "string",
#'     ExtraJarsS3Path = "string"
#'   ),
#'   UpdateEtlLibraries = TRUE|FALSE,
#'   DeleteArguments = list(
#'     "string"
#'   ),
#'   AddArguments = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_dev_endpoint
glue_update_dev_endpoint <- function(EndpointName, PublicKey = NULL, AddPublicKeys = NULL, DeletePublicKeys = NULL, CustomLibraries = NULL, UpdateEtlLibraries = NULL, DeleteArguments = NULL, AddArguments = NULL) {
  op <- new_operation(
    name = "UpdateDevEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_dev_endpoint_input(EndpointName = EndpointName, PublicKey = PublicKey, AddPublicKeys = AddPublicKeys, DeletePublicKeys = DeletePublicKeys, CustomLibraries = CustomLibraries, UpdateEtlLibraries = UpdateEtlLibraries, DeleteArguments = DeleteArguments, AddArguments = AddArguments)
  output <- .glue$update_dev_endpoint_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_dev_endpoint <- glue_update_dev_endpoint

#' Updates an existing job definition
#'
#' Updates an existing job definition.
#'
#' @usage
#' glue_update_job(JobName, JobUpdate)
#'
#' @param JobName &#91;required&#93; Name of the job definition to update.
#' @param JobUpdate &#91;required&#93; Specifies the values with which to update the job definition.
#'
#' @section Request syntax:
#' ```
#' svc$update_job(
#'   JobName = "string",
#'   JobUpdate = list(
#'     Description = "string",
#'     LogUri = "string",
#'     Role = "string",
#'     ExecutionProperty = list(
#'       MaxConcurrentRuns = 123
#'     ),
#'     Command = list(
#'       Name = "string",
#'       ScriptLocation = "string"
#'     ),
#'     DefaultArguments = list(
#'       "string"
#'     ),
#'     Connections = list(
#'       Connections = list(
#'         "string"
#'       )
#'     ),
#'     MaxRetries = 123,
#'     AllocatedCapacity = 123,
#'     Timeout = 123,
#'     MaxCapacity = 123.0,
#'     NotificationProperty = list(
#'       NotifyDelayAfter = 123
#'     ),
#'     SecurityConfiguration = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_job
glue_update_job <- function(JobName, JobUpdate) {
  op <- new_operation(
    name = "UpdateJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_job_input(JobName = JobName, JobUpdate = JobUpdate)
  output <- .glue$update_job_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_job <- glue_update_job

#' Updates a partition
#'
#' Updates a partition.
#'
#' @usage
#' glue_update_partition(CatalogId, DatabaseName, TableName,
#'   PartitionValueList, PartitionInput)
#'
#' @param CatalogId The ID of the Data Catalog where the partition to be updated resides. If
#' none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table in question resides.
#' @param TableName &#91;required&#93; The name of the table where the partition to be updated is located.
#' @param PartitionValueList &#91;required&#93; A list of the values defining the partition.
#' @param PartitionInput &#91;required&#93; The new partition object to which to update the partition.
#'
#' @section Request syntax:
#' ```
#' svc$update_partition(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableName = "string",
#'   PartitionValueList = list(
#'     "string"
#'   ),
#'   PartitionInput = list(
#'     Values = list(
#'       "string"
#'     ),
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string"
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE
#'     ),
#'     Parameters = list(
#'       "string"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_partition
glue_update_partition <- function(CatalogId = NULL, DatabaseName, TableName, PartitionValueList, PartitionInput) {
  op <- new_operation(
    name = "UpdatePartition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_partition_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableName = TableName, PartitionValueList = PartitionValueList, PartitionInput = PartitionInput)
  output <- .glue$update_partition_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_partition <- glue_update_partition

#' Updates a metadata table in the Data Catalog
#'
#' Updates a metadata table in the Data Catalog.
#'
#' @usage
#' glue_update_table(CatalogId, DatabaseName, TableInput, SkipArchive)
#'
#' @param CatalogId The ID of the Data Catalog where the table resides. If none is supplied,
#' the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database in which the table resides. For Hive
#' compatibility, this name is entirely lowercase.
#' @param TableInput &#91;required&#93; An updated `TableInput` object to define the metadata table in the
#' catalog.
#' @param SkipArchive By default, `UpdateTable` always creates an archived version of the
#' table before updating it. If `skipArchive` is set to true, however,
#' `UpdateTable` does not create the archived version.
#'
#' @section Request syntax:
#' ```
#' svc$update_table(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   TableInput = list(
#'     Name = "string",
#'     Description = "string",
#'     Owner = "string",
#'     LastAccessTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastAnalyzedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Retention = 123,
#'     StorageDescriptor = list(
#'       Columns = list(
#'         list(
#'           Name = "string",
#'           Type = "string",
#'           Comment = "string"
#'         )
#'       ),
#'       Location = "string",
#'       InputFormat = "string",
#'       OutputFormat = "string",
#'       Compressed = TRUE|FALSE,
#'       NumberOfBuckets = 123,
#'       SerdeInfo = list(
#'         Name = "string",
#'         SerializationLibrary = "string",
#'         Parameters = list(
#'           "string"
#'         )
#'       ),
#'       BucketColumns = list(
#'         "string"
#'       ),
#'       SortColumns = list(
#'         list(
#'           Column = "string",
#'           SortOrder = 123
#'         )
#'       ),
#'       Parameters = list(
#'         "string"
#'       ),
#'       SkewedInfo = list(
#'         SkewedColumnNames = list(
#'           "string"
#'         ),
#'         SkewedColumnValues = list(
#'           "string"
#'         ),
#'         SkewedColumnValueLocationMaps = list(
#'           "string"
#'         )
#'       ),
#'       StoredAsSubDirectories = TRUE|FALSE
#'     ),
#'     PartitionKeys = list(
#'       list(
#'         Name = "string",
#'         Type = "string",
#'         Comment = "string"
#'       )
#'     ),
#'     ViewOriginalText = "string",
#'     ViewExpandedText = "string",
#'     TableType = "string",
#'     Parameters = list(
#'       "string"
#'     )
#'   ),
#'   SkipArchive = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_table
glue_update_table <- function(CatalogId = NULL, DatabaseName, TableInput, SkipArchive = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_table_input(CatalogId = CatalogId, DatabaseName = DatabaseName, TableInput = TableInput, SkipArchive = SkipArchive)
  output <- .glue$update_table_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_table <- glue_update_table

#' Updates a trigger definition
#'
#' Updates a trigger definition.
#'
#' @usage
#' glue_update_trigger(Name, TriggerUpdate)
#'
#' @param Name &#91;required&#93; The name of the trigger to update.
#' @param TriggerUpdate &#91;required&#93; The new values with which to update the trigger.
#'
#' @section Request syntax:
#' ```
#' svc$update_trigger(
#'   Name = "string",
#'   TriggerUpdate = list(
#'     Name = "string",
#'     Description = "string",
#'     Schedule = "string",
#'     Actions = list(
#'       list(
#'         JobName = "string",
#'         Arguments = list(
#'           "string"
#'         ),
#'         Timeout = 123,
#'         NotificationProperty = list(
#'           NotifyDelayAfter = 123
#'         ),
#'         SecurityConfiguration = "string"
#'       )
#'     ),
#'     Predicate = list(
#'       Logical = "AND"|"ANY",
#'       Conditions = list(
#'         list(
#'           LogicalOperator = "EQUALS",
#'           JobName = "string",
#'           State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_trigger
glue_update_trigger <- function(Name, TriggerUpdate) {
  op <- new_operation(
    name = "UpdateTrigger",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_trigger_input(Name = Name, TriggerUpdate = TriggerUpdate)
  output <- .glue$update_trigger_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_trigger <- glue_update_trigger

#' Updates an existing function definition in the Data Catalog
#'
#' Updates an existing function definition in the Data Catalog.
#'
#' @usage
#' glue_update_user_defined_function(CatalogId, DatabaseName, FunctionName,
#'   FunctionInput)
#'
#' @param CatalogId The ID of the Data Catalog where the function to be updated is located.
#' If none is supplied, the AWS account ID is used by default.
#' @param DatabaseName &#91;required&#93; The name of the catalog database where the function to be updated is
#' located.
#' @param FunctionName &#91;required&#93; The name of the function.
#' @param FunctionInput &#91;required&#93; A `FunctionInput` object that re-defines the function in the Data
#' Catalog.
#'
#' @section Request syntax:
#' ```
#' svc$update_user_defined_function(
#'   CatalogId = "string",
#'   DatabaseName = "string",
#'   FunctionName = "string",
#'   FunctionInput = list(
#'     FunctionName = "string",
#'     ClassName = "string",
#'     OwnerName = "string",
#'     OwnerType = "USER"|"ROLE"|"GROUP",
#'     ResourceUris = list(
#'       list(
#'         ResourceType = "JAR"|"FILE"|"ARCHIVE",
#'         Uri = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname glue_update_user_defined_function
glue_update_user_defined_function <- function(CatalogId = NULL, DatabaseName, FunctionName, FunctionInput) {
  op <- new_operation(
    name = "UpdateUserDefinedFunction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .glue$update_user_defined_function_input(CatalogId = CatalogId, DatabaseName = DatabaseName, FunctionName = FunctionName, FunctionInput = FunctionInput)
  output <- .glue$update_user_defined_function_output()
  svc <- .glue$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glue$operations$update_user_defined_function <- glue_update_user_defined_function
