% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trispace.R
\name{trispace}
\alias{trispace}
\title{Trichromatic colour space}
\usage{
trispace(vismodeldata)
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link{vismodel}} or independently calculated data (in the form of a data frame
with three columns named 's', 'm', 'l', representing a trichromatic viewer).}
}
\value{
A data frame of class \code{colspace} consisting of the following columns:

\code{s}, \code{m}, \code{l}: the quantum catch data used to calculate
 the remaining variables.

\code{x}, \code{y}: cartesian coordinates for the points in the
 Maxwell triangle.

\code{h.theta}: angle theta, in radians, determining the hue of the color.

\code{r.vec}: the r vector (saturation, distance from the center).
}
\description{
Calculates coordinates and colorimetric variables that represent reflectance spectra
in a trichromatic chromaticity space.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, visual = 'apis', achro = 'l')
tri.flowers <- colspace(vis.flowers, space = 'tri')
}

}
\references{
Maxwell JC. (1970). On color vision. In: Macadam, D. L. (ed)
 Sources of Color Science. Cambridge, MIT Press, 1872 - 1873.

Kelber A, Vorobyev M, Osorio D. (2003). Animal colour vision -
 behavioural tests and physiological concepts. Biological Reviews, 78,
 81 - 118.

MacLeod DIA, Boynton RM. (1979). Chromaticity diagram showing
 cone excitation by stimuli of equal luminance. Journal of the Optical
 Society of America, 69, 1183-1186.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
