% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patLanK.R
\name{patLanK}
\alias{patLanK}
\title{Aligns images usings transformations obtained from fixed landmarks and extracts colors using
k-means clustering.}
\usage{
patLanK(sampleList, landList, k = 3, resampleFactor = NULL,
  crop = FALSE, cropOffset = c(0, 0, 0, 0), res = 300,
  transformRef = "meanshape", transformType = "tps",
  removebgK = NULL, adjustCoords = FALSE, plot = FALSE,
  focal = FALSE, sigma = 3)
}
\arguments{
\item{sampleList}{List of RasterStack objects.}

\item{landList}{Landmark list as returned by \code{\link[patternize]{makeList}}.}

\item{k}{Integere for defining number of k-means clusters (default = 3).}

\item{resampleFactor}{Integer for downsampling used by \code{\link{redRes}}.}

\item{crop}{Whether to use the landmarks range to crop the image. This can significantly speed
up the analysis (default = FALSE).}

\item{cropOffset}{Vector c(xmin, xmax, ymin, ymax) that specifies the number of pixels you
want the cropping to be offset from the landmarks (in case the landmarks do not surround
the entire color pattern). The values specified should present the percentage of the maximum
landmark value along the x and y axis.}

\item{res}{Resolution for color pattern raster (default = 300). This should be reduced if the
number of pixels in the image is lower than th raster.}

\item{transformRef}{ID of reference sample for shape to which color patterns will be transformed
to. Can be 'meanshape' for transforming to mean shape of Procrustes analysis.}

\item{transformType}{Transformation type as used by \code{\link[Morpho]{computeTransform}}
(default ='tps').}

\item{removebgK}{Integer indicating the range RGB treshold to remove from image (e.g. 100
removes pixels with average RGB > 100; default = NULL) for k-means analysis. This works only
to remove a white background.}

\item{adjustCoords}{Adjust landmark coordinates in case they are reversed compared to pixel
coordinates (default = FALSE).}

\item{plot}{Whether to plot transformed color patterns while processing (default = FALSE).}

\item{focal}{Whether to perform Gaussian blurring (default = FALSE).}

\item{sigma}{Size of sigma for Gaussian blurring (default = 3).}
}
\value{
List of summed raster for each k-means cluster objects.
}
\description{
Aligns images usings transformations obtained from fixed landmarks and extracts colors using
k-means clustering.
}
\examples{
\dontrun{
IDlist <- c('BC0077','BC0071','BC0050','BC0049','BC0004')
prepath <- system.file("extdata",  package = 'patternize')
extension <- '_landmarks_LFW.txt'
landmarkList <- makeList(IDlist, 'landmark', prepath, extension)

extension <- '.jpg'
imageList <- makeList(IDlist, 'image', prepath, extension)
# Note that this example only aligns two images with the target,
# remove [1:2] to run a full examples.
rasterList_lanK <- patLanK(imageList[1:2], landmarkList[1:2], k = 4, crop = TRUE,
res = 100, removebgK = 100, adjustCoords = TRUE, plot = TRUE)
}

}
