% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_createSubjectProfileReport.R
\name{subjectProfileExport}
\alias{subjectProfileExport}
\title{Create report}
\usage{
subjectProfileExport(
  listPlotsSubject,
  outputFile = "subjectProfile.pdf",
  index = NULL,
  formatReport = subjectProfileReportFormat(),
  shiny = FALSE,
  verbose = FALSE,
  nCores = NULL,
  exportFigures = FALSE
)
}
\arguments{
\item{listPlotsSubject}{List of plots for each subject}

\item{outputFile}{string, path to the output report}

\item{index}{Index, output from \code{\link{defineIndex}}}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{shiny}{logical, set to TRUE (FALSE by default) 
if the report is generated from a Shiny application.
Messages during report creation will be included in the Shiny interface,
and it will be mentioned at the end of the report.
In this case, the \code{shiny} package should be available.}

\item{verbose}{logical, if TRUE print messages during execution}

\item{nCores}{Integer containing the number of cores used for the computation
(1 by default). If more than 1, computation is parallelized, in this case
the package \code{parallel} is required.}

\item{exportFigures}{Logical, if TRUE (FALSE by default) the 
subject profile figures are also exported
in pdf format in a 'figures' folder.\cr
Figures are named as \code{[subjectID]-[page].pdf}}
}
\value{
No returned value, the plots are exported to \code{outputDir}
}
\description{
Create report
}
\author{
Laure Cougnaud
}
