% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{pathling_read_datasets}
\alias{pathling_read_datasets}
\title{Create a data source from datasets}
\usage{
pathling_read_datasets(pc, resources)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{resources}{A name list of Spark datasets, where the keys are resource type codes
and the values are the data frames containing the resource data.}
}
\value{
A DataSource object that can be used to run queries against the data.
}
\description{
Creates an immutable, ad-hoc data source from a named list of Spark datasets indexed with
resource type codes.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()
patient_df <- pc \%>\% pathling_example_resource('Patient')
condition_df <- pc \%>\% pathling_example_resource('Condition')
data_source <- pc \%>\% pathling_read_datasets(list(Patient = patient_df, Condition = condition_df))
data_source \%>\% ds_read('Patient') \%>\% sparklyr::sdf_nrow()
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/fhirpath-query#datasets}{Pathling documentation - Reading datasets}

Other data source functions: 
\code{\link{pathling_read_bundles}()},
\code{\link{pathling_read_delta}()},
\code{\link{pathling_read_ndjson}()},
\code{\link{pathling_read_parquet}()},
\code{\link{pathling_read_tables}()}
}
\concept{data source functions}
