% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{input_processing}
\alias{input_processing}
\title{Process Input}
\usage{
input_processing(
  input,
  p_val_threshold = 0.05,
  pin_name_path = "Biogrid",
  convert2alias = TRUE
)
}
\arguments{
\item{input}{the input data that pathfindR uses. The input must be a data
  frame with three columns: \enumerate{
  \item Gene Symbol (Gene Symbol)
  \item Change value, e.g. log(fold change) (OPTIONAL)
  \item p value, e.g. adjusted p value associated with differential expression
}}

\item{p_val_threshold}{the p value threshold to use when filtering
the input data frame. Must a numeric value between 0 and 1. (default = 0.05)}

\item{pin_name_path}{Name of the chosen PIN or absolute/path/to/PIN.sif. If PIN name,
must be one of c('Biogrid', 'STRING', 'GeneMania', 'IntAct', 'KEGG', 'mmu_STRING'). If
path/to/PIN.sif, the file must comply with the PIN specifications. (Default = 'Biogrid')}

\item{convert2alias}{boolean to indicate whether or not to convert gene symbols
in the input that are not found in the PIN to an alias symbol found in the PIN
(default = TRUE) IMPORTANT NOTE: the conversion uses human gene symbols/alias symbols.}
}
\value{
This function first filters the input so that all p values are less
  than or equal to the threshold. Next, gene symbols that are not found in
  the PIN are identified. If aliases of these gene symbols are found in the
  PIN, the symbols are converted to the corresponding aliases. The
  resulting data frame containing the original gene symbols, the updated
  symbols, change values and p values is then returned.
}
\description{
Process Input
}
\examples{
processed_df <- input_processing(
  input = example_pathfindR_input[1:5, ],
  pin_name_path = 'KEGG'
)
processed_df <- input_processing(
  input = example_pathfindR_input[1:10, ],
  pin_name_path = 'KEGG',
  convert2alias = FALSE
)
}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR workflow
}
