/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchAlgorithms;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchMisc.ScoreCalculations;
import ActiveSubnetworkSearchMisc.Subnetwork;
import Application.Parameters;
import Network.Network;
import Network.Node;
import Network.SubnetworkFinder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class SimulatedAnnealing {
    public ArrayList<Subnetwork> simulatedAnnealing() {
        Network network = ActiveSubnetworkSearch.network;
        ScoreCalculations scoreCalculations = ActiveSubnetworkSearch.scoreCalculations;
        ArrayList<Node> nodeList = ActiveSubnetworkSearch.networkNodeList;
        HashSet<Node> nodesOnSet = new HashSet<Node>();
        HashSet<Node> nodesOffSet = new HashSet<Node>(nodeList);
        if (Parameters.startWithAllPositiveZScoreNodes) {
            for (Node node : nodesOffSet) {
                if (!(scoreCalculations.getZScore(node) > 0.0)) continue;
                nodesOnSet.add(node);
            }
        } else {
            for (Node node : nodesOffSet) {
                if (!(Math.random() < Parameters.geneInitialAdditionProbability)) continue;
                nodesOnSet.add(node);
            }
        }
        nodesOffSet.removeAll(nodesOnSet);
        SubnetworkFinder subnetworkFinder = new SubnetworkFinder();
        ArrayList<Subnetwork> subnetworkList = subnetworkFinder.findSubnetworksDFS(nodesOnSet);
        Collections.sort(subnetworkList, Collections.reverseOrder());
        for (int i = 0; i < subnetworkList.size(); ++i) {
            if (subnetworkList.get(i).numberOfNodes() <= 1) continue;
            System.out.print(subnetworkList.get(i).numberOfNodes() + " " + new DecimalFormat("###.##").format(subnetworkList.get(i).getScore()) + ", ");
        }
        System.out.println("");
        double initialTemperature = Parameters.sa_initialTemperature;
        double finalTemperature = Parameters.sa_finalTemperature;
        int totalIterations = Parameters.sa_totalIterations;
        double T = initialTemperature;
        double temp_step = 1.0 - Math.pow(finalTemperature / initialTemperature, 1.0 / (double)totalIterations);
        Random rand = new Random();
        System.out.println("Percentage of finished job, node number and score of modules that have more than one node are as follows:");
        int percent = 0;
        System.out.println("0%");
        for (int iteration = 0; iteration < totalIterations; ++iteration) {
            int newPercent = 100 * iteration / totalIterations;
            if (newPercent > percent) {
                percent = newPercent;
                System.out.println(percent + "% ");
                this.printSituation(subnetworkList);
            }
            Node node = nodeList.get(rand.nextInt(nodeList.size()));
            this.toggleNodeState(nodesOnSet, nodesOffSet, node);
            ArrayList<Subnetwork> newSubnetworkList = subnetworkFinder.findSubnetworksDFS(nodesOnSet);
            Collections.sort(newSubnetworkList, Collections.reverseOrder());
            boolean decision = false;
            boolean keep = false;
            Iterator<Subnetwork> oldIt = subnetworkList.iterator();
            Iterator<Subnetwork> newIt = newSubnetworkList.iterator();
            while (!decision && newIt.hasNext() && oldIt.hasNext()) {
                Subnetwork subnetworkOld = oldIt.next();
                Subnetwork subnetworkNew = newIt.next();
                double delta = subnetworkNew.getScore() - subnetworkOld.getScore();
                if (delta > 0.001) {
                    keep = true;
                    decision = true;
                    continue;
                }
                if (!(rand.nextDouble() > Math.exp(delta / T))) continue;
                keep = false;
                decision = true;
            }
            if (keep) {
                subnetworkList = newSubnetworkList;
            } else {
                this.toggleNodeState(nodesOnSet, nodesOffSet, node);
            }
            T *= 1.0 - temp_step;
        }
        System.out.println("100%");
        this.printSituation(subnetworkList);
        return subnetworkList;
    }

    public void toggleNodeState(HashSet<Node> nodesOnSet, HashSet<Node> nodesOffSet, Node node) {
        if (nodesOnSet.contains(node)) {
            nodesOnSet.remove(node);
            nodesOffSet.add(node);
        } else {
            nodesOffSet.remove(node);
            nodesOnSet.add(node);
        }
    }

    public void printSituation(ArrayList<Subnetwork> subnetworkList) {
        for (int i = 0; i < subnetworkList.size(); ++i) {
            if (subnetworkList.get(i).numberOfNodes() <= 1) continue;
            System.out.print(subnetworkList.get(i).numberOfNodes() + " " + new DecimalFormat("###.##").format(subnetworkList.get(i).getScore()) + ", ");
        }
        System.out.println("");
    }
}

