% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{visualize_pws}
\alias{visualize_pws}
\title{Create Pathway Diagrams}
\usage{
visualize_pws(result_df, input_processed = NULL, gene_sets = "KEGG",
  pin_name_path = "Biogrid")
}
\arguments{
\item{result_df}{Data frame of enrichment results. Must-have columns for
KEGG human pathway diagrams are: "ID" and "Pathway".
Must-have columns for the rest are: "Pathway", "Up_regulated" and "Down_regulated"}

\item{input_processed}{input data processed via `input_processing`, not necessary for
visualizations other than KEGG human pathway diagrams.}

\item{gene_sets}{the gene sets used for enrichment analysis. Possible gene sets
are KEGG, Reactome, BioCarta, GO-All, GO-BP, GO-CC, GO-MF or Custom (Default = "KEGG").}

\item{pin_name_path}{Name of the chosen PIN or path/to/PIN.sif. If PIN name,
must be one of c("Biogrid", "GeneMania", "IntAct", "KEGG"). If
path/to/PIN.sif, the file must comply with the PIN specifications. Defaults
to Biogrid.}
}
\value{
Depending of `gene_sets`, creates visualization of interactions of genes
involved in the list of pathways in `result_df` and saves them in the folder
"pathway_visualizations" under the current working directory.
}
\description{
Create Pathway Diagrams
}
\details{
For `gene_sets == "KEGG"`, KEGG human pathway diagrams are created,
affected nodes colored by up/down regulation status.
For the rest of `gene_sets`, interactions of affected genes are determined (via a shortest-path
algorithm) and are visualized (colored by change status) using igraph.
}
\examples{
\dontrun{
visualize_pws(result_df, input_processed)
visualize_pws(result_df, gene_sets = "GO-BP", pin_name_path = "IntAct")
}
}
\seealso{
See \code{\link{visualize_hsa_KEGG}} for the visualization function
of human KEGG diagrams. See \code{\link{visualize_pw_interactions}} for the
visualization function that generates diagrams showing the interactions of
input genes in the PIN. See \code{\link{run_pathfindR}} for the wrapper
function of the pathfindR workflow. \code{\link[pathview]{pathview}} for
KEGG pathway-based data integration and visualization.
}
