% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{spec_is_possible}
\alias{spec_is_possible}
\alias{spec_is_loaded}
\alias{prompt_missing_implementation}
\title{Model Specification Checking:}
\usage{
spec_is_possible(
  spec,
  engine = spec$engine,
  user_specified_engine = spec$user_specified_engine,
  mode = spec$mode,
  user_specified_mode = spec$user_specified_mode
)

spec_is_loaded(
  spec,
  engine = spec$engine,
  user_specified_engine = spec$user_specified_engine,
  mode = spec$mode,
  user_specified_mode = spec$user_specified_mode
)

prompt_missing_implementation(
  spec,
  engine = spec$engine,
  user_specified_engine = spec$user_specified_engine,
  mode = spec$mode,
  user_specified_mode = spec$user_specified_mode,
  prompt,
  ...
)
}
\description{
The helpers \code{spec_is_possible()}, \code{spec_is_loaded()}, and
\code{prompt_missing_implementation()} provide tooling for checking
model specifications. In addition to the \code{spec}, \code{engine}, and \code{mode}
arguments, the functions take arguments \code{user_specified_engine} and
\code{user_specified_mode}, denoting whether the user themselves has
specified the engine or mode, respectively.
}
\details{
\code{spec_is_possible()} checks against the union of
\itemize{
\item the current parsnip model environment and
\item the \code{model_info_table} of "pre-registered" model specifications
}

to determine whether a model is well-specified. See
\code{parsnip:::model_info_table} for this table.

\code{spec_is_loaded()} checks only against the current parsnip model environment.

\code{spec_is_possible()} is executed automatically on \code{new_model_spec()},
\code{set_mode()}, and \code{set_engine()}, and \code{spec_is_loaded()} is executed
automatically in \code{print.model_spec()}, among other places. \code{spec_is_possible()}
should be used when a model specification is still "in progress" of being
specified, while \code{spec_is_loaded} should only be called when parsnip or an
extension receives some indication that the user is "done" specifying a model
specification: at print, fit, addition to a workflow, or \verb{extract_*()}, for
example.

When \code{spec_is_loaded()} is \code{FALSE}, the \code{prompt_missing_implementation()}
helper will construct an informative message to prompt users to load or
install needed packages. It's \code{prompt} argument refers to the prompting
function to use, usually \link[cli:cli_abort]{cli::cli_inform} or \link[cli:cli_abort]{cli::cli_abort}, and the
ellipses are passed to that function.
}
\keyword{internal}
