% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_quad_sparsediscrim.R
\name{details_discrim_quad_sparsediscrim}
\alias{details_discrim_quad_sparsediscrim}
\title{Quadratic discriminant analysis via regularization}
\description{
Functions in the \pkg{sparsediscrim} package fit different types of quadratic
discriminant analysis model that regularize the estimates (like the mean or
covariance).
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 1 tuning parameter:
\itemize{
\item \code{regularization_method}: Regularization Method (type: character,
default: ‘diagonal’)
}

The possible values of this parameter, and the functions that they
execute, are:
\itemize{
\item \code{"diagonal"}: \code{\link[sparsediscrim:qda_diag]{sparsediscrim::qda_diag()}}
\item \code{"shrink_mean"}:
\code{\link[sparsediscrim:qda_shrink_mean]{sparsediscrim::qda_shrink_mean()}}
\item \code{"shrink_cov"}:
\code{\link[sparsediscrim:qda_shrink_cov]{sparsediscrim::qda_shrink_cov()}}
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{discrim} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(discrim)

discrim_quad(regularization_method = character(0)) \%>\% 
  set_engine("sparsediscrim") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Quadratic Discriminant Model Specification (classification)
## 
## Main Arguments:
##   regularization_method = character(0)
## 
## Computational engine: sparsediscrim 
## 
## Model fit template:
## discrim::fit_regularized_quad(x = missing_arg(), y = missing_arg(), 
##     method = character(0))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Variance calculations are used in these computations within each outcome
class. For this reason, \emph{zero-variance} predictors (i.e., with a single
unique value) within each class should be eliminated before fitting the
model.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item \code{qda_diag()}: Dudoit, Fridlyand and Speed (2002) Comparison of
Discrimination Methods for the Classification of Tumors Using Gene
Expression Data, \emph{Journal of the American Statistical Association},
97:457, 77-87.
\item \code{qda_shrink_mean()}: Tong, Chen, Zhao, Improved mean estimation and
its application to diagonal discriminant analysis, \emph{Bioinformatics},
Volume 28, Issue 4, 15 February 2012, Pages 531-537.
\item \code{qda_shrink_cov()}: Pang, Tong and Zhao (2009), Shrinkage-based
Diagonal Discriminant Analysis and Its Applications in
High-Dimensional Data. \emph{Biometrics}, 65, 1021-1029.
}
}
}
\keyword{internal}
