% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_quad_MASS.R
\name{details_discrim_quad_MASS}
\alias{details_discrim_quad_MASS}
\title{Quadratic discriminant analysis via MASS}
\description{
\code{\link[MASS:qda]{MASS::qda()}} fits a model that estimates a multivariate
distribution for the predictors separately for the data in each class
(Gaussian with separate covariance matrices). Bayes' theorem is used
to compute the probability of each class, given the predictor values.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This engine has no tuning parameters.
}

\subsection{Translation from parsnip to the original package}{

The \strong{discrim} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(discrim)

discrim_quad() \%>\% 
  set_engine("MASS") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Quadratic Discriminant Model Specification (classification)
## 
## Computational engine: MASS 
## 
## Model fit template:
## MASS::qda(formula = missing_arg(), data = missing_arg())
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Variance calculations are used in these computations within each outcome
class. For this reason, \emph{zero-variance} predictors (i.e., with a single
unique value) within each class should be eliminated before fitting the
model.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
