% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_brulee.R
\name{details_mlp_brulee}
\alias{details_mlp_brulee}
\title{Multilayer perceptron via brulee}
\description{
\code{\link[brulee:brulee_mlp]{brulee::brulee_mlp()}} fits a neural network.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 7 tuning parameters:
\itemize{
\item \code{hidden_units}: # Hidden Units (type: integer, default: 3L)
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
\item \code{epochs}: # Epochs (type: integer, default: 0.01)
\item \code{dropout}: Dropout Rate (type: double, default: 0.0)
\item \code{learn_rate}: Learning Rate (type: double, default: 100L)
\item \code{activation}: Activation Function (type: character, default: ‘relu’)
\item \code{mixture}: Proportion of Lasso Penalty (type: double, default: 0.0)
}

The use of the L1 penalty (a.k.a. the lasso penalty) does \emph{not} force
parameters to be strictly zero (as it does in packages such as glmnet).
The zeroing out of parameters is a specific feature the optimization
method used in those packages.

Both \code{penalty} and \code{dropout} should be not be used in the same model.

Other engine arguments of interest:
\itemize{
\item \code{momentum()}: A number used to use historical gradient infomration
during optimization.
\item \code{batch_size()}: An integer for the number of training set points in
each batch.
\item \code{class_weights()}: Numeric class weights. See
\code{\link[brulee:brulee_mlp]{brulee::brulee_mlp()}}.
\item \code{stop_iter()}: A non-negative integer for how many iterations with
no improvement before stopping. (default: 5L).
}
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mlp(
  hidden_units = integer(1),
  penalty = double(1),
  dropout = double(1),
  epochs = integer(1),
  learn_rate = double(1),
  activation = character(1)
) \%>\%  
  set_engine("brulee") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Single Layer Neural Network Model Specification (regression)
## 
## Main Arguments:
##   hidden_units = integer(1)
##   penalty = double(1)
##   dropout = double(1)
##   epochs = integer(1)
##   activation = character(1)
##   learn_rate = double(1)
## 
## Computational engine: brulee 
## 
## Model fit template:
## brulee::brulee_mlp(x = missing_arg(), y = missing_arg(), hidden_units = integer(1), 
##     penalty = double(1), dropout = double(1), epochs = integer(1), 
##     activation = character(1), learn_rate = double(1))
}\if{html}{\out{</div>}}

Note that parsnip automatically sets linear activation in the last
layer.
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mlp(
  hidden_units = integer(1),
  penalty = double(1),
  dropout = double(1),
  epochs = integer(1),
  learn_rate = double(1),
  activation = character(1)
) \%>\% 
  set_engine("brulee") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Single Layer Neural Network Model Specification (classification)
## 
## Main Arguments:
##   hidden_units = integer(1)
##   penalty = double(1)
##   dropout = double(1)
##   epochs = integer(1)
##   activation = character(1)
##   learn_rate = double(1)
## 
## Computational engine: brulee 
## 
## Model fit template:
## brulee::brulee_mlp(x = missing_arg(), y = missing_arg(), hidden_units = integer(1), 
##     penalty = double(1), dropout = double(1), epochs = integer(1), 
##     activation = character(1), learn_rate = double(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
