% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg.R
\name{poisson_reg}
\alias{poisson_reg}
\title{Poisson regression models}
\usage{
poisson_reg(
  mode = "regression",
  penalty = NULL,
  mixture = NULL,
  engine = "glm"
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{penalty}{A non-negative number representing the total
amount of regularization (\code{glmnet} only).}

\item{mixture}{A number between zero and one (inclusive) that is the
proportion of L1 regularization (i.e. lasso) in the model. When
\code{mixture = 1}, it is a pure lasso model while \code{mixture = 0} indicates that
ridge regression is being used. (\code{glmnet} and \code{spark} only).}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{poisson_reg()} defines a generalized linear model for count data that follow
a Poisson distribution. This function can fit regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("poisson_reg")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("poisson_reg")}
}
