% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_reg.R
\name{survival_reg}
\alias{survival_reg}
\title{General Interface for Parametric Survival Models}
\usage{
survival_reg(mode = "censored regression", dist = NULL)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "censored regression".}

\item{dist}{A character string for the outcome distribution. "weibull" is
the default.}
}
\description{
\code{survival_reg()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
R. The main argument for the
model is:
\itemize{
\item \code{dist}: The probability distribution of the outcome.
}
This argument is converted to its specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to its default
here (\code{NULL}), the value is taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{survival_reg()},the
mode will always be "censored regression".

Since survival models typically involve censoring (and require the use of
\code{\link[survival:Surv]{survival::Surv()}} objects), the \code{\link[=fit]{fit()}} function will require that the
survival model be specified via the formula interface.
}
\examples{
survival_reg()
# Parameters can be represented by a placeholder:
survival_reg(dist = varying())
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[survival:Surv]{survival::Surv()}}, \code{\link[=set_engine]{set_engine()}}, \code{\link[=update]{update()}}
}
\keyword{internal}
