% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree.R
\name{xgb_train}
\alias{xgb_train}
\title{Boosted trees via xgboost}
\usage{
xgb_train(x, y, max_depth = 6, nrounds = 15, eta = 0.3,
  colsample_bytree = 1, min_child_weight = 1, gamma = 0,
  subsample = 1, ...)
}
\arguments{
\item{x}{A data frame or matrix of predictors}

\item{y}{A vector (factor or numeric) or matrix (numeric) of outcome data.}

\item{max_depth}{An integer for the maximum depth of the tree.}

\item{nrounds}{An integer for the number of boosting iterations.}

\item{eta}{A numeric value between zero and one to control the learning rate.}

\item{colsample_bytree}{Subsampling proportion of columns.}

\item{min_child_weight}{A numeric value for the minimum sum of instance
weights needed in a child to continue to split.}

\item{gamma}{An number for the minimum loss reduction required to make a
further partition on a leaf node of the tree}

\item{subsample}{Subsampling proportion of rows.}

\item{...}{Other options to pass to \code{xgb.train}.}
}
\value{
A fitted \code{xgboost} object.
}
\description{
\code{xgb_train} is a wrapper for \code{xgboost} tree-based models
where all of the model arguments are in the main function.
}
