% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_notes.R
\encoding{UTF-8}
\name{export_notes}
\alias{export_notes}
\title{Exports free text notes to individual text files.}
\usage{
export_notes(d, folder, code, name1 = "ID_MERGE", name2)
}
\arguments{
\item{d}{data.table, database containing notes loaded using the \emph{load_notes} function. Theoretically any other data.table can be given
and the contents of the specified cell will be exported into the corresponding files. In case of notes, it is advised to load them
with \emph{format_orig = TRUE}, as then the output will retain the original format of the report making it easier to read.}

\item{folder}{string, full folder path to folder where the files should be exported. If folder does not exist, the function stops.}

\item{code}{string vector, column name containing the data that should be exported. Generally should be \emph{"abc_rep_txt"}, where \emph{abc} stands for the three letter abbreviation of the given type of note.}

\item{name1}{string, the first part of the file names. Defaults to \emph{ID_MERGE}.}

\item{name2}{string, the second part of the file names. name1 and name2 will be separated using "_".
Generally should be \emph{"abc_rep_num"}, where \emph{abc} stands for the three letter abbreviation of the given type of note.}
}
\value{
NULL, files are exported to given folder.
}
\description{
Exports out the contents of a given cell per row into individual text files. Can be used to export out
reports into individual text files for further analyses.
}
\examples{
\dontrun{
#Output all cardiology notes to given folder
d <- load_notes("Car.txt", type = "car", nThread = 2, format_orig = TRUE)
export_notes(d, folder = "/Users/Test/Notes/", code = "car_rep_txt",
name1 = "ID_MERGE", name2 = "car_rep_num")
}
}
