% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcm_db.R
\encoding{UTF-8}
\name{dcm_db}
\alias{dcm_db}
\title{Internal function to create a database of DICOM headers.}
\usage{
dcm_db(path, ext, all, keywords, nThread, pydicom)
}
\arguments{
\item{path}{string vector, full folder path to folder that contains the images.}

\item{ext}{string array, possible file extensions to parse.}

\item{all}{boolean, whether all files in a series should be parsed, or only the first one.}

\item{keywords}{string array, of valid DICOM keywords.}

\item{nThread}{integer, number of threads to use for parsing data.}

\item{pydicom}{package, pydicom package initiated from parent enviroment.}
}
\value{
data.table, with  DICOM header information. This is then used by \emph{create_img_db} which formats the output.
}
\description{
The function creates a database of DICOM headers present in a folder structure. Each series should be in its own folder,
but they can be in a nested folder structure. Files where there are also folder present next to them at the same level will not be parsed.
That is the folder structure needs to comply with the DICOM standard.
Be aware that the function requires \href{https://www.python.org}{python} and \href{https://pydicom.github.io}{pydicom} to be installed!
The function cycles through all folders present in the provided path and recursively goes through them,
every subfolder, and extracts the DICOM header information from the files using the
\href{https://pydicom.github.io/pydicom/dev/reference/generated/pydicom.filereader.dcmread.html}{dcmread}
function of the \href{https://pydicom.github.io}{pydicom} package.
The extension of the files can be provided by the \emph{ext} argument,
as DICOM files may have different extensions then that of .dcm. Also, using the \emph{all} boolean argument, you can specify whether
the function provides output for each file, or only for the first file, which is beneficial if you are analyzing multi-slice series,
as all instances have almost all the same header information. Furthermore, using the \emph{keywords} argument you can manually specify
which DICOM keywords you wish to extract. These need to be a valid keyword specified in the
\href{https://dicom.nema.org/medical/dicom/current/output/chtml/part06/chapter_6.html}{DICOM standard}.
}
\keyword{internal}
