% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkres.R
\name{linkres}
\alias{linkres}
\alias{print.linkres}
\alias{summary.linkres}
\alias{plot.linkres}
\alias{points.linkres}
\title{S3 methods for class 'linkres'.}
\usage{
\method{print}{linkres}(x, ...)

\method{summary}{linkres}(object, ...)

\method{plot}{linkres}(
  x,
  chrom = NULL,
  type = "l",
  lwd = NA,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)

\method{points}{linkres}(x, chrom = NULL, type = "l", lwd = NA, ...)
}
\arguments{
\item{x, object}{A \code{linkres} object (normally produced by \code{\link[=lod]{lod()}} or
\code{\link[=merlinLod]{merlinLod()}}).}

\item{\dots}{further arguments.}

\item{chrom}{(Optional) A numeric indicating which chromosomes to be included
in the plot.}

\item{lwd, type, ylim}{Graphical parameters passed on to \code{plot()}.}

\item{xlab, ylab}{Axis labels.}
}
\value{
These functions are called for their side effects.
}
\description{
Functions for printing, summarizing and plotting the results of a linkage
analysis.
}
\examples{

# Pedigree with 5 simulated SNP markers
x = nuclearPed(3)

x = setMarkers(x, alleleMatrix = cbind(
  m1 = c("1/1", "1/2", "1/2", "1/2", "1/2"),
  m2 = c("1/2", "1/2", "1/2", "1/2", "1/2"),
  m3 = c("1/1", "1/2", "1/2", "1/2", "1/1")), sep="/")

# Mother and all children affected
aff = c(1, 2, 2, 2, 2)

# LOD scores under autosomal dominant model
lods = lod(x, aff, model = diseaseModel(model = "AD"))

summary(lods)
as.data.frame(lods)
plot(lods)

}
\seealso{
\code{\link[=lod]{lod()}}, \code{\link[=merlinLod]{merlinLod()}}, \code{\link[=lodPeaks]{lodPeaks()}}
}
