% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessModelStability.R
\name{assessModelStability}
\alias{assessModelStability}
\title{Bootstrapping procedure to determine PARAFAC model stability for a given number of components.}
\usage{
assessModelStability(
  dataset,
  minNumComponents = 1,
  maxNumComponents = 5,
  numFolds = dim(dataset$data)[1],
  considerGroups = FALSE,
  groupVariable = "",
  colourCols = NULL,
  legendTitles = NULL,
  xLabels = NULL,
  legendColNums = NULL,
  arrangeModes = NULL,
  method = "als",
  ctol = 1e-06,
  maxit = 2500,
  max_fn = 10000,
  rel_tol = 1e-08,
  abs_tol = 1e-08,
  grad_tol = 1e-08,
  numCores = 1
)
}
\arguments{
\item{dataset}{See \link{Fujita2023}, \link{Shao2019} or \link{vanderPloeg2024}.}

\item{minNumComponents}{Minimum number of components (default 1).}

\item{maxNumComponents}{Maximum number of components (default 5).}

\item{numFolds}{Number of bootstrapped models to create.}

\item{considerGroups}{Consider subject groups in calculating sparsity (default FALSE)}

\item{groupVariable}{Column name in dataset$mode1 that should be used to consider groups (default "")}

\item{colourCols}{Vector of strings stating which column names should be factorized for colours per mode.}

\item{legendTitles}{Vector of strings stating the legend title per mode.}

\item{xLabels}{Vector of strings stating the x-axis labels per mode.}

\item{legendColNums}{Vector of integers stating the desired number of columns for the legends per mode.}

\item{arrangeModes}{Vector of boolean values per mode, stating if the loadings should be arranged according to colourCols (TRUE) or not (FALSE).}

\item{method}{Use ALS algorithm ("als", default) or use all-at-once optimization ("opt"). The all-at-once optimization is based on a nonlinear conjugate gradient method with Hestenes-Stiefel updates and the More-Thuente line search algorithm.}

\item{ctol}{Relative change in loss tolerated to call the algorithm converged in the ALS case (default 1e-4).}

\item{maxit}{Maximum number of iterations allowed without convergence in the ALS case (default 500).}

\item{max_fn}{Maximum number of function evaluations allowed without convergence in the OPT case (default 10000).}

\item{rel_tol}{Relative change in loss tolerated to call the algorithm converged in the OPT case (default 1e-8).}

\item{abs_tol}{Absolute loss tolerated to call the algorithm converged in the OPT case (default 1e-8).}

\item{grad_tol}{Tolerance on the two-norm of the gradient divided over the number of elements in the gradient in the OPT case (default 1e-8).}

\item{numCores}{Number of cores to use. If set larger than 1, it will run the job in parallel (default 1)}
}
\value{
A list containing the following:
\itemize{
\item models: All stabilized sign-flipped bootstrapped PARAFAC models.
\item modelPlots: A list of plots of the median model with error bars for each number of components.
\item FMSplot: A bar plot showing the Factor Match Scores per number of components (see Li et al., 2024).
\item FMS: FMS values that the FMS plot is based on.
}
}
\description{
Bootstrapping procedure to determine PARAFAC model stability for a given number of components.
}
\examples{
processedFujita = processDataCube(Fujita2023, sparsityThreshold=0.99, centerMode=1, scaleMode=2)
modelStability = assessModelStability(processedFujita,
                                      minNumComponents=1,
                                      maxNumComponents=2,
                                      ctol=1e-4,
                                      maxit=250)
}
