% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamSetCollection.R
\name{ParamSetCollection}
\alias{ParamSetCollection}
\title{ParamSetCollection}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link{ParamSet}.
}
\description{
A collection of multiple \link{ParamSet} objects.
\itemize{
\item The collection is basically a light-weight wrapper / container around references to multiple sets.
\item In order to ensure unique param names, every param in the collection is referred to with
"<set_id>.<param_id>". Parameters from ParamSets with empty (i.e. \code{""}) \verb{$set_id} are referenced
directly. Multiple ParamSets with \verb{$set_id} \code{""} can be combined, but their parameter names
must be unique.
\item Operation \code{subset} is currently not allowed.
\item Operation \code{add} currently only works when adding complete sets not single params.
\item When you either ask for 'values' or set them, the operation is delegated to the individual,
contained param set references. The collection itself does not maintain a \code{values} state.
This also implies that if you directly change \code{values} in one of the referenced sets,
this change is reflected in the collection.
\item Dependencies: It is possible to currently handle dependencies
\itemize{
\item regarding parameters inside of the same set - in this case simply
add the dependency to the set, best before adding the set to the collection
\item across sets, where a param from one set depends on the state
of a param from another set - in this case add call \code{add_dep} on the collection.
}

If you call \code{deps} on the collection, you are returned a complete table of dependencies, from sets and across sets.
}
}
\section{Construction}{
\preformatted{ParamSetCollection$new(sets)
}
\itemize{
\item \code{sets} :: list of \link{ParamSet}\cr
Parameter objects are cloned.
}
}

\section{Methods}{

\itemize{
\item remove_sets(ids)\cr
\code{character()} -> \code{self} \cr
Removes sets of given ids from collection.
}
}

